/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.core;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.encrypt.utils.EncryptUtils;
import cn.smarthse.framework.core.utils.ObjectUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.core.EncryptContext;
import cn.smarthse.framework.encrypt.core.IEncryptor;
import cn.smarthse.framework.encrypt.enumd.AlgorithmType;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.ibatis.io.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.util.ClassUtils;

public class EncryptorManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptorManager.class);
    private final Map<Integer, IEncryptor> encryptorMap = new ConcurrentHashMap<Integer, IEncryptor>();
    private final Map<Class<?>, Set<Field>> fieldCache = new ConcurrentHashMap();
    private ScheduledExecutorService scheduledExecutorService;

    public EncryptorManager(String typeAliasesPackage, ScheduledExecutorService scheduledExecutorService) {
        this.scanEncryptClasses(typeAliasesPackage);
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public Set<Field> getFieldCache(Class<?> sourceClazz) {
        return (Set)ObjectUtils.notNullGetter(this.fieldCache, f -> (Set)f.get(sourceClazz));
    }

    public IEncryptor registerAndGetEncryptor(EncryptContext encryptContext) {
        int key = encryptContext.hashCode();
        if (this.encryptorMap.containsKey(key)) {
            return this.encryptorMap.get(key);
        }
        IEncryptor encryptor = (IEncryptor)ReflectUtil.newInstance(encryptContext.getAlgorithm().getClazz(), (Object[])new Object[]{encryptContext});
        this.encryptorMap.put(key, encryptor);
        return encryptor;
    }

    public void removeEncryptor(EncryptContext encryptContext) {
        this.encryptorMap.remove(encryptContext.hashCode());
    }

    public String encrypt(String value, EncryptContext encryptContext) {
        String version;
        IEncryptor encryptor = this.registerAndGetEncryptor(encryptContext);
        String string = version = encryptContext.getAlgorithm() == AlgorithmType.WCSP_LIGHT_DATA_SERVICE ? EncryptUtils.getWcspVersion() : encryptContext.getVersion();
        if (encryptContext.getDataProcessingMethodsType() == DataProcessingMethodsType.ACCURATE) {
            Object ciphertext = null;
            boolean middlewareEnabled = Objects.equals(encryptContext.getMiddlewareEnabled(), Boolean.TRUE);
            String dataSm4 = null;
            if (middlewareEnabled) {
                try {
                    dataSm4 = EncryptUtils.encryptBySm4((String)value, (String)encryptContext.getPassword());
                    if (StrUtil.isNotBlank((CharSequence)dataSm4)) {
                        if (log.isDebugEnabled()) {
                            log.debug("[Encrypt] [\u4e2d\u95f4\u4ef6\u51c6\u5907] [success] [debug] [unknown] originalValue={} sm4Result={}", (Object)value, (Object)dataSm4);
                        }
                        ciphertext = SpringEncryptUtils.getEsEncryptService().getCiphertext(dataSm4);
                        if (log.isDebugEnabled()) {
                            log.debug("[Encrypt] [\u4e2d\u95f4\u4ef6\u5904\u7406] [success] [debug] [unknown] originalValue={} middlewareResult={}", (Object)value, ciphertext);
                        }
                    }
                }
                catch (Exception e) {
                    log.warn("[Encrypt] [\u4e2d\u95f4\u4ef6\u5f02\u5e38] [failure] [warn] [unknown] originalValue={} errorMsg={} exceptionClass={}", new Object[]{value, e.getMessage(), e.getClass().getSimpleName(), e});
                }
            }
            if (StrUtil.isNotBlank(ciphertext)) {
                return ciphertext;
            }
            ciphertext = version + encryptor.encrypt(value);
            if (log.isDebugEnabled()) {
                log.debug("[Encrypt] [\u672c\u5730\u5904\u7406] [success] [debug] [unknown] originalValue={} encryptedResult={}", (Object)value, ciphertext);
            }
            if (StrUtil.isBlank((CharSequence)ciphertext)) {
                return value;
            }
            if (middlewareEnabled && StrUtil.isNotBlank((CharSequence)dataSm4)) {
                Object finalCiphertext = ciphertext;
                String finalDataSm = dataSm4;
                CompletableFuture.runAsync(() -> EncryptorManager.lambda$encrypt$1(finalDataSm, (String)finalCiphertext), this.scheduledExecutorService);
            }
            return ciphertext;
        }
        StringBuilder sb = new StringBuilder();
        for (char originalChar : value.toCharArray()) {
            sb.append(encryptor.encrypt(Convert.toStr((Object)Character.valueOf(originalChar))));
        }
        return version + String.valueOf(sb);
    }

    public String decrypt(String value, EncryptContext encryptContext) {
        IEncryptor encryptor = this.registerAndGetEncryptor(encryptContext);
        if (encryptContext.getDataProcessingMethodsType() == DataProcessingMethodsType.ACCURATE) {
            String plaintext = null;
            boolean middlewareEnabled = Objects.equals(encryptContext.getMiddlewareEnabled(), Boolean.TRUE);
            String password = encryptContext.getPassword();
            if (middlewareEnabled) {
                try {
                    String dataSm4 = SpringEncryptUtils.getEsEncryptService().getPlaintext(value);
                    if (StrUtil.isNotBlank((CharSequence)dataSm4)) {
                        if (log.isDebugEnabled()) {
                            log.debug("[Decrypt] [\u4e2d\u95f4\u4ef6\u51c6\u5907] [success] [debug] [unknown] originalValue={} sm4Ciphertext={}", (Object)value, (Object)dataSm4);
                        }
                        plaintext = EncryptUtils.decryptBySm4((String)dataSm4, (String)password);
                        if (log.isDebugEnabled()) {
                            log.debug("[Decrypt] [\u4e2d\u95f4\u4ef6\u5904\u7406] [success] [debug] [unknown] originalValue={} decryptedResult={}", (Object)value, (Object)plaintext);
                        }
                    }
                }
                catch (Exception e) {
                    log.warn("[Decrypt] [\u4e2d\u95f4\u4ef6\u5f02\u5e38] [failure] [warn] [unknown] originalValue={} errorMsg={} exceptionClass={}", new Object[]{value, e.getMessage(), e.getClass().getSimpleName(), e});
                }
            }
            if (StrUtil.isNotBlank(plaintext)) {
                return plaintext;
            }
            plaintext = encryptor.decrypt(StrUtil.subSuf((CharSequence)value, (int)14));
            if (log.isDebugEnabled()) {
                log.debug("[Decrypt] [\u672c\u5730\u5904\u7406] [success] [debug] [unknown] originalValue={} decryptedResult={}", (Object)value, (Object)plaintext);
            }
            if (StrUtil.isBlank((CharSequence)plaintext)) {
                return value;
            }
            if (middlewareEnabled) {
                String finalPlaintext = plaintext;
                String finalValue = value;
                CompletableFuture.runAsync(() -> {
                    try {
                        SpringEncryptUtils.getEsEncryptService().addCiphertext(EncryptUtils.encryptBySm4((String)finalPlaintext, (String)password), finalValue);
                        if (log.isDebugEnabled()) {
                            log.debug("[Decrypt] [\u4e2d\u95f4\u4ef6\u540c\u6b65] [success] [debug] [unknown] plaintextValue={} middlewareCiphertext={}", (Object)finalPlaintext, (Object)finalValue);
                        }
                    }
                    catch (Exception e) {
                        log.warn("[Decrypt] [\u4e2d\u95f4\u4ef6\u5f02\u5e38] [failure] [warn] [unknown] plaintextValue={} ciphertext={} errorMsg={} exceptionClass={}", new Object[]{finalPlaintext, finalValue, e.getMessage(), e.getClass().getSimpleName(), e});
                    }
                }, this.scheduledExecutorService);
            }
            return plaintext;
        }
        value = StrUtil.subSuf((CharSequence)value, (int)14);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); i += 24) {
            String encryptedCharHash = value.substring(i, i + 24);
            String originalChar = encryptor.decrypt(encryptedCharHash);
            sb.append(originalChar);
        }
        return sb.toString();
    }

    public void scanEncryptClasses(String typeAliasesPackage) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory factory = new CachingMetadataReaderFactory();
        String[] packagePatternArray = StringUtils.splitPreserveAllTokens((String)typeAliasesPackage, (String)",; \t\n");
        String classpath = "classpath*:";
        try {
            for (String packagePattern : packagePatternArray) {
                Resource[] resources;
                String path = ClassUtils.convertClassNameToResourcePath((String)packagePattern);
                for (Resource resource : resources = resolver.getResources(classpath + path + "/*.class")) {
                    ClassMetadata classMetadata;
                    Class clazz;
                    Set<Field> encryptFieldSet;
                    if (resource.getFilename() != null && resource.getFilename().contains("module-info") || !CollUtil.isNotEmpty(encryptFieldSet = this.getEncryptFieldSetFromClazz(clazz = Resources.classForName((String)(classMetadata = factory.getMetadataReader(resource).getClassMetadata()).getClassName())))) continue;
                    this.fieldCache.put(clazz, encryptFieldSet);
                }
            }
        }
        catch (Exception e) {
            log.error("[Encrypt] [\u626b\u63cf\u7c7b] [failure] [error] [unknown] errorMsg={} exceptionClass={}", new Object[]{e.getMessage(), e.getClass().getSimpleName(), e});
        }
    }

    private Set<Field> getEncryptFieldSetFromClazz(Class<?> clazz) {
        Set<Field> fieldSet = new HashSet<Field>();
        if (clazz.isInterface() || clazz.isMemberClass() || clazz.isAnonymousClass()) {
            return fieldSet;
        }
        while (clazz != null) {
            Field[] fields = clazz.getDeclaredFields();
            fieldSet.addAll(Arrays.asList(fields));
            clazz = clazz.getSuperclass();
        }
        fieldSet = fieldSet.stream().filter(field -> field.isAnnotationPresent(EncryptField.class) && field.getType() == String.class).collect(Collectors.toSet());
        for (Field field2 : fieldSet) {
            field2.setAccessible(true);
        }
        return fieldSet;
    }

    @Generated
    public EncryptorManager() {
    }

    private static /* synthetic */ void lambda$encrypt$1(String finalDataSm, String finalCiphertext) {
        try {
            SpringEncryptUtils.getEsEncryptService().addCiphertext(finalDataSm, finalCiphertext);
            if (log.isDebugEnabled()) {
                log.debug("[Encrypt] [\u4e2d\u95f4\u4ef6\u540c\u6b65] [success] [debug] [unknown] sm4Value={} middlewareCiphertext={}", (Object)finalDataSm, (Object)finalCiphertext);
            }
        }
        catch (Exception e) {
            log.warn("[Encrypt] [\u4e2d\u95f4\u4ef6\u5f02\u5e38] [failure] [warn] [unknown] sm4Value={} ciphertext={} errorMsg={} exceptionClass={}", new Object[]{finalDataSm, finalCiphertext, e.getMessage(), e.getClass().getSimpleName(), e});
        }
    }
}

