/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.config;

import cn.smarthse.encrypt.spring.properties.FieldEncryptorProperties;
import cn.smarthse.encrypt.spring.properties.RocksDBConfig;
import cn.smarthse.encrypt.spring.service.EsEncryptService;
import cn.smarthse.encrypt.spring.service.RocksDBEncryptService;
import cn.smarthse.framework.encrypt.runner.FieldEncryptorMiddlewareRunner;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnProperty(value={"mybatis-encryptor.middleware-enabled"}, havingValue="true")
public class FieldEncryptorMiddlewareAutoConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldEncryptorMiddlewareAutoConfig.class);
    private final FieldEncryptorProperties fieldEncryptionProperties;

    @Bean
    @ConditionalOnProperty(value={"mybatis-encryptor.rocksDB.enabled"}, havingValue="true")
    public RocksDBConfig rocksDBConfig() {
        log.info("\u521b\u5efa RocksDBConfig Bean");
        return new RocksDBConfig(this.fieldEncryptionProperties.getRocksDB().getDataDir());
    }

    @Bean(value={"rocksDBEncryptService"})
    @ConditionalOnMissingBean(value={EsEncryptService.class})
    @ConditionalOnProperty(value={"mybatis-encryptor.rocksDB.enabled"}, havingValue="true")
    @ConditionalOnClass(name={"org.rocksdb.RocksDB"})
    public EsEncryptService rocksDBEncryptService(RocksDBConfig rocksDBConfig) {
        log.info("\u521d\u59cb\u5316 rocksDBEncryptService \u914d\u7f6e");
        return new RocksDBEncryptService(rocksDBConfig);
    }

    @Bean
    public FieldEncryptorMiddlewareRunner fieldEncryptorMiddlewareRunner() {
        return new FieldEncryptorMiddlewareRunner();
    }

    @Generated
    public FieldEncryptorMiddlewareAutoConfig(FieldEncryptorProperties fieldEncryptionProperties) {
        this.fieldEncryptionProperties = fieldEncryptionProperties;
    }
}

