/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.encrypt.spring.properties;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.rocksdb.CompressionType;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBConfig.class);
    private String dataDir;
    private RocksDB rocksDB;
    private Options options;

    public RocksDBConfig(String dataDir) {
        this.dataDir = dataDir;
    }

    @PostConstruct
    public void init() {
        try {
            RocksDB.loadLibrary();
            File dir = new File(this.dataDir);
            if (!dir.exists()) {
                boolean created = dir.mkdirs();
                log.info("RocksDB\u6570\u636e\u76ee\u5f55\u521b\u5efa{}", (Object)(created ? "\u6210\u529f" : "\u5931\u8d25"));
            }
            this.options = new Options();
            this.options.setCreateIfMissing(true);
            this.options.setMaxOpenFiles(10000);
            this.options.setWriteBufferSize(0x4000000L);
            this.options.setMaxWriteBufferNumber(4);
            this.options.setMinWriteBufferNumberToMerge(2);
            this.options.setTargetFileSizeBase(0x4000000L);
            this.options.setCompressionType(CompressionType.LZ4_COMPRESSION);
            this.options.setBottommostCompressionType(CompressionType.ZSTD_COMPRESSION);
            this.rocksDB = RocksDB.open((Options)this.options, (String)this.dataDir);
            log.info("RocksDB\u521d\u59cb\u5316\u6210\u529f\uff0c\u6570\u636e\u76ee\u5f55\uff1a{}", (Object)this.dataDir);
        }
        catch (Exception e) {
            log.error("RocksDB\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("RocksDB\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }

    public RocksDB getRocksDB() {
        if (this.rocksDB == null) {
            throw new IllegalStateException("RocksDB\u672a\u521d\u59cb\u5316");
        }
        return this.rocksDB;
    }

    @PreDestroy
    public void destroy() {
        if (this.rocksDB != null) {
            this.rocksDB.close();
            log.info("RocksDB\u5df2\u5173\u95ed");
        }
        if (this.options != null) {
            this.options.close();
        }
    }

    public static byte[] stringToBytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static String bytesToString(byte[] bytes) {
        return bytes != null ? new String(bytes, StandardCharsets.UTF_8) : null;
    }

    @Generated
    private RocksDBConfig() {
    }

    @Generated
    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    @Generated
    public String getDataDir() {
        return this.dataDir;
    }
}

