/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.dubbo.handler;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order(value=0x7FFFFFFE)
@RestControllerAdvice
public class DubboExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DubboExceptionHandler.class);

    @ExceptionHandler(value={RpcException.class})
    public ResponseData<Object> dealException(RpcException e, HttpServletRequest request) {
        if (!Objects.nonNull(request)) {
            log.error("[Dubbo] [RPC\u5f02\u5e38] [failure] [error] [non-web] exceptionClass={} message={}", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
            return null;
        }
        log.error("[Dubbo] [RPC\u5f02\u5e38] [failure] [error] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage(), e});
        ResponseData r = new ResponseData();
        switch (e.getCode()) {
            case 3: {
                r.setState(ResponseStateEnum.fail.getValue());
                r.setMessage(e.getMessage() != null ? e.getMessage() : ResponseStateEnum.fail.getName());
                return r;
            }
            case 12: {
                r.setState(ResponseStateEnum.BAD_REQUEST.getValue());
                r.setMessage(e.getMessage() != null ? e.getMessage() : ResponseStateEnum.BAD_REQUEST.getName());
                return r;
            }
            case 1: 
            case 6: 
            case 9: {
                r.setState(ResponseStateEnum.SERVICE_UNAVAILABLE.getValue());
                r.setMessage(ResponseStateEnum.SERVICE_UNAVAILABLE.getName());
                return r;
            }
            case 2: 
            case 8: {
                r.setState(ResponseStateEnum.SERVICE_TIMEOUT.getValue());
                r.setMessage(ResponseStateEnum.SERVICE_TIMEOUT.getName());
                return r;
            }
            case 4: 
            case 13: {
                String msg = e.getMessage();
                if (msg != null && msg.contains("No provider available")) {
                    r.setState(ResponseStateEnum.SERVICE_UNAVAILABLE.getValue());
                    r.setMessage(ResponseStateEnum.SERVICE_UNAVAILABLE.getName());
                } else {
                    r.setState(ResponseStateEnum.FORBIDDEN.getValue());
                    r.setMessage(ResponseStateEnum.FORBIDDEN.getName());
                }
                return r;
            }
        }
        r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
        r.setMessage(ResponseStateEnum.INTERNAL_SERVER_ERROR.getName());
        return r;
    }
}

