/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.doc.config;

import cn.smarthse.framework.core.factory.YmlPropertySourceFactory;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.doc.config.properties.SpringDocProperties;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Set;
import lombok.Generated;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;

@AutoConfiguration(before={SpringDocConfiguration.class})
@EnableConfigurationProperties(value={SpringDocProperties.class})
@ConditionalOnProperty(name={"knife4j.enable"}, havingValue="true")
@PropertySource(value={"classpath:common-doc.yml"}, factory=YmlPropertySourceFactory.class)
public class SpringDocAutoConfig {
    private final ServerProperties serverProperties;

    @Bean
    @ConditionalOnMissingBean(value={OpenAPI.class})
    public OpenAPI openApi(SpringDocProperties properties) {
        OpenAPI openApi = new OpenAPI();
        SpringDocProperties.InfoProperties infoProperties = properties.getInfo();
        Info info = this.convertInfo(infoProperties);
        openApi.info(info);
        openApi.externalDocs(properties.getExternalDocs());
        openApi.tags(properties.getTags());
        openApi.paths(properties.getPaths());
        openApi.components(properties.getComponents());
        Set keySet = properties.getComponents().getSecuritySchemes().keySet();
        ArrayList<SecurityRequirement> list = new ArrayList<SecurityRequirement>();
        SecurityRequirement securityRequirement = new SecurityRequirement();
        keySet.forEach(arg_0 -> ((SecurityRequirement)securityRequirement).addList(arg_0));
        list.add(securityRequirement);
        openApi.security(list);
        return openApi;
    }

    private Info convertInfo(SpringDocProperties.InfoProperties infoProperties) {
        Info info = new Info();
        info.setTitle(infoProperties.getTitle());
        info.setDescription(infoProperties.getDescription());
        info.setContact(infoProperties.getContact());
        info.setLicense(infoProperties.getLicense());
        info.setVersion(infoProperties.getVersion());
        return info;
    }

    @Bean
    public OpenApiCustomizer openApiCustomizer() {
        String contextPath = this.serverProperties.getServlet().getContextPath();
        String finalContextPath = StringUtils.isBlank((CharSequence)contextPath) || "/".equals(contextPath) ? "" : contextPath;
        return openApi -> {
            Paths oldPaths = openApi.getPaths();
            if (oldPaths instanceof PlusPaths) {
                return;
            }
            PlusPaths newPaths = new PlusPaths();
            oldPaths.forEach((k, v) -> newPaths.addPathItem(finalContextPath + k, (PathItem)v));
            openApi.setPaths((Paths)newPaths);
        };
    }

    @Generated
    public SpringDocAutoConfig(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    static class PlusPaths
    extends Paths {
    }
}

