/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.core.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.extra.servlet.JakartaServletUtil;
import cn.smarthse.framework.core.utils.StringUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtils
extends JakartaServletUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServletUtils.class);

    public static String getParameter(String name) {
        return ServletUtils.getRequest().getParameter(name);
    }

    public static String getParameter(String name, String defaultValue) {
        return Convert.toStr((Object)ServletUtils.getRequest().getParameter(name), (String)defaultValue);
    }

    public static Integer getParameterToInt(String name) {
        return Convert.toInt((Object)ServletUtils.getRequest().getParameter(name));
    }

    public static Integer getParameterToInt(String name, Integer defaultValue) {
        return Convert.toInt((Object)ServletUtils.getRequest().getParameter(name), (Integer)defaultValue);
    }

    public static Boolean getParameterToBool(String name) {
        return Convert.toBool((Object)ServletUtils.getRequest().getParameter(name));
    }

    public static Boolean getParameterToBool(String name, Boolean defaultValue) {
        return Convert.toBool((Object)ServletUtils.getRequest().getParameter(name), (Boolean)defaultValue);
    }

    public static Map<String, String[]> getParams(ServletRequest request) {
        Map map = request.getParameterMap();
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, String> getParamMap(ServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : ServletUtils.getParams(request).entrySet()) {
            params.put(entry.getKey(), StringUtils.joinComma(entry.getValue()));
        }
        return params;
    }

    public static HttpServletRequest getRequest() {
        try {
            return ServletUtils.getRequestAttributes().getRequest();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static HttpServletResponse getResponse() {
        try {
            return ServletUtils.getRequestAttributes().getResponse();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static HttpSession getSession() {
        return ServletUtils.getRequest().getSession();
    }

    public static ServletRequestAttributes getRequestAttributes() {
        try {
            RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
            return (ServletRequestAttributes)attributes;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getHeader(HttpServletRequest request, String name) {
        String value = request.getHeader(name);
        if (StringUtils.isEmpty(value)) {
            return "";
        }
        return ServletUtils.urlDecode(value);
    }

    public static Map<String, String> getHeaders(HttpServletRequest request) {
        LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap();
        Enumeration enumeration = request.getHeaderNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = request.getHeader(key);
                map.put(key, value);
            }
        }
        return map;
    }

    public static void renderString(HttpServletResponse response, String string) {
        try {
            response.setStatus(200);
            response.setContentType("application/json");
            response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
            response.getWriter().print(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String accept = request.getHeader("accept");
        if (accept != null && accept.contains("application/json")) {
            return true;
        }
        String xRequestedWith = request.getHeader("X-Requested-With");
        if (xRequestedWith != null && xRequestedWith.contains("XMLHttpRequest")) {
            return true;
        }
        String uri = request.getRequestURI();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)uri, (CharSequence[])new CharSequence[]{".json", ".xml"})) {
            return true;
        }
        String ajax = request.getParameter("__ajax");
        return StringUtils.equalsAnyIgnoreCase((CharSequence)ajax, (CharSequence[])new CharSequence[]{"json", "xml"});
    }

    public static String getClientIP() {
        return ServletUtils.getClientIP((HttpServletRequest)ServletUtils.getRequest(), (String[])new String[0]);
    }

    public static String urlEncode(String str) {
        return URLEncoder.encode(str, StandardCharsets.UTF_8);
    }

    public static String urlDecode(String str) {
        return URLDecoder.decode(str, StandardCharsets.UTF_8);
    }

    public static String getCtx(HttpServletRequest request) {
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
    }

    public static String getCtx() {
        HttpServletRequest request = ServletUtils.getRequest();
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
    }

    public static String getRequestUri(HttpServletRequest request) {
        return request != null ? request.getRequestURI() : "\u5b9a\u65f6\u4efb\u52a1\u6216\u975eHTTP\u4e0a\u4e0b\u6587";
    }

    public static String getUserAgent(HttpServletRequest request) {
        if (request != null) {
            String ua = request.getHeader("User-Agent");
            return ua != null ? ua : "";
        }
        return "\u5b9a\u65f6\u4efb\u52a1\u6216\u975eHTTP\u4e0a\u4e0b\u6587";
    }

    @Generated
    private ServletUtils() {
    }
}

