/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.core.utils;

import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.net.NetUtil;
import cn.smarthse.framework.core.utils.regex.RegexUtils;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils
extends NetUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetUtils.class);

    public static boolean isIPv6(String ip) {
        try {
            return InetAddress.getByName(ip) instanceof Inet6Address;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static boolean isInnerIPv6(String ip) {
        try {
            Inet6Address inet6Address;
            InetAddress inetAddress = InetAddress.getByName(ip);
            if (inetAddress instanceof Inet6Address && ((inet6Address = (Inet6Address)inetAddress).isAnyLocalAddress() || inet6Address.isLinkLocalAddress() || inet6Address.isLoopbackAddress() || inet6Address.isSiteLocalAddress())) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IPv6 address!", e);
        }
        return false;
    }

    public static boolean isIPv4(String ip) {
        return RegexUtils.isMatch((Pattern)PatternPool.IPV4, (CharSequence)ip);
    }

    @Generated
    private NetUtils() {
    }
}

