/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.core.config;

import jakarta.validation.Validator;
import java.util.Properties;
import org.hibernate.validator.HibernateValidator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.validation.ValidationAutoConfiguration;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@AutoConfiguration(before={ValidationAutoConfiguration.class})
public class ValidatorAutoConfig {
    @Bean
    public Validator validator(MessageSource messageSource) {
        try (LocalValidatorFactoryBean factoryBean = new LocalValidatorFactoryBean();){
            factoryBean.setValidationMessageSource(messageSource);
            factoryBean.setProviderClass(HibernateValidator.class);
            Properties properties = new Properties();
            properties.setProperty("hibernate.validator.fail_fast", "false");
            factoryBean.setValidationProperties(properties);
            factoryBean.afterPropertiesSet();
            Validator validator = factoryBean.getValidator();
            return validator;
        }
    }
}

