/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.core.utils.ip;

import cn.hutool.http.HtmlUtil;
import cn.smarthse.framework.core.utils.NetUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddressUtils.class);
    public static final String UNKNOWN_IP = "XX XX";
    public static final String LOCAL_ADDRESS = "\u5185\u7f51IP";

    public static String getRealAddressByIP(String ip) {
        ip = HtmlUtil.cleanHtmlTag((String)StringUtils.blankToDefault(ip, ""));
        boolean isIPv4 = NetUtils.isIPv4(ip);
        boolean isIPv6 = NetUtils.isIPv6(ip);
        if (!isIPv4 && !isIPv6) {
            return UNKNOWN_IP;
        }
        if (isIPv4 && NetUtils.isInnerIP((String)ip) || isIPv6 && NetUtils.isInnerIPv6(ip)) {
            return LOCAL_ADDRESS;
        }
        return null;
    }

    @Generated
    private AddressUtils() {
    }
}

