/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.check;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;

public class CompiledClassDateChecker {
    private static final Logger logger = LoggerFactory.getLogger(CompiledClassDateChecker.class);
    private static final String TARGET_PACKAGE = "cn.smarthse.sandao.modules";
    private static final String DATE_CLASS = "java.util.Date";

    public boolean checkDateUsage() {
        try {
            HashSet<String> classesWithDate = new HashSet<String>();
            PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
            CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourceResolver);
            String packagePath = TARGET_PACKAGE.replace('.', '/');
            Resource[] resources = resourceResolver.getResources("classpath*:" + packagePath + "/**/*.class");
            for (Resource resource : resources) {
                if (!resource.isReadable()) continue;
                try {
                    MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
                    String className = metadataReader.getClassMetadata().getClassName();
                    if (!this.hasClassDateUsage(metadataReader)) continue;
                    classesWithDate.add(className);
                }
                catch (Exception e) {
                    logger.debug("\u65e0\u6cd5\u8bfb\u53d6\u7c7b\u5143\u6570\u636e: {}", (Object)resource.getFilename(), (Object)e);
                }
            }
            if (!classesWithDate.isEmpty()) {
                logger.error("\u274c \u7f16\u8bd1\u7c7b\u68c0\u67e5\u53d1\u73b0\u4ee5\u4e0b\u7c7b\u975e\u6cd5\u4f7f\u7528java.util.Date:");
                for (String className : classesWithDate) {
                    logger.error("   - {}", (Object)className);
                }
                return false;
            }
            logger.info("\u2705 \u7f16\u8bd1\u7c7bDate\u4f7f\u7528\u68c0\u67e5\u901a\u8fc7");
            return true;
        }
        catch (IOException e) {
            logger.error("\u626b\u63cf\u7c7b\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: ", (Throwable)e);
            return true;
        }
    }

    private boolean hasClassDateUsage(MetadataReader metadataReader) {
        try {
            String[] memberClassNames;
            String[] classNames;
            for (String name : classNames = metadataReader.getClassMetadata().getInterfaceNames()) {
                if (!DATE_CLASS.equals(name)) continue;
                return true;
            }
            String superClassName = metadataReader.getClassMetadata().getSuperClassName();
            if (DATE_CLASS.equals(superClassName)) {
                return true;
            }
            for (String name : memberClassNames = metadataReader.getClassMetadata().getMemberClassNames()) {
                if (!DATE_CLASS.equals(name)) continue;
                return true;
            }
            Set annotationTypes = metadataReader.getAnnotationMetadata().getAnnotationTypes();
            for (String annotationType : annotationTypes) {
                if (!DATE_CLASS.equals(annotationType)) continue;
                return true;
            }
            String className = metadataReader.getClassMetadata().getClassName();
            return this.hasClassDateUsage(className);
        }
        catch (Exception e) {
            logger.debug("\u68c0\u67e5\u7c7b\u5143\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)metadataReader.getClassMetadata().getClassName(), (Object)e);
            return false;
        }
    }

    private boolean hasClassDateUsage(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            for (Field field : clazz.getDeclaredFields()) {
                if (!this.isDateType(field.getType())) continue;
                return true;
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (this.isDateType(((Method)accessibleObject).getReturnType())) {
                    return true;
                }
                for (Class<?> paramType : ((Method)accessibleObject).getParameterTypes()) {
                    if (!this.isDateType(paramType)) continue;
                    return true;
                }
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredConstructors()) {
                for (Class<?> paramType : ((Constructor)accessibleObject).getParameterTypes()) {
                    if (!this.isDateType(paramType)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            logger.debug("\u7c7b\u52a0\u8f7d\u5931\u8d25: {}", (Object)className, (Object)e);
            return false;
        }
        catch (Exception e) {
            logger.debug("\u68c0\u67e5\u7c7b\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)className, (Object)e);
            return false;
        }
    }

    private boolean isDateType(Class<?> type) {
        return type != null && DATE_CLASS.equals(type.getName());
    }
}

