/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.check;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SourceFileDateChecker {
    private static final Logger logger = LoggerFactory.getLogger(SourceFileDateChecker.class);
    private static final String TARGET_PACKAGE = "cn.smarthse.sandao.modules";
    private static final Pattern DATE_IMPORT_PATTERN = Pattern.compile("import\\s+java\\.util\\.Date;");
    private static final Pattern DATE_FIELD_PATTERN = Pattern.compile("(private|protected|public)?\\s*Date\\s+\\w+");
    private static final Pattern DATE_NEW_PATTERN = Pattern.compile("new\\s+Date\\(.*\\)");
    private static final Pattern DATE_FULL_NEW_PATTERN = Pattern.compile("new\\s+java\\.util\\.Date\\(.*\\)");

    public boolean checkDateUsageInSourceCode() {
        try {
            if (!this.checkFromFileSystem()) {
                logger.debug("\u6587\u4ef6\u7cfb\u7edf\u626b\u63cf\u53d1\u73b0\u8fdd\u89c4\u4f7f\u7528Date");
                return false;
            }
            if (!this.checkFromClasspath()) {
                logger.debug("\u7c7b\u8def\u5f84\u626b\u63cf\u53d1\u73b0\u8fdd\u89c4\u4f7f\u7528Date");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.error("\u626b\u63cf\u6e90\u7801\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: ", (Throwable)e);
            return false;
        }
    }

    private boolean checkFromClasspath() throws IOException {
        ArrayList<String> violations = new ArrayList<String>();
        if (this.checkFromStandardSourceDirectory(violations)) {
            return this.processViolations(violations, "\u7c7b\u8def\u5f84\u626b\u63cf");
        }
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
        String packagePath = TARGET_PACKAGE.replace('.', '/');
        try {
            Resource[] resources;
            for (Resource resource : resources = resourceResolver.getResources("classpath*:" + packagePath + "/**/*.java")) {
                if (!resource.isReadable()) continue;
                this.checkResourceForDateUsage(resource, violations);
            }
            return this.processViolations(violations, "\u7c7b\u8def\u5f84\u626b\u63cf");
        }
        catch (IOException e) {
            logger.debug("\u4ece\u7c7b\u8def\u5f84\u626b\u63cf\u6e90\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return true;
        }
    }

    private boolean checkFromStandardSourceDirectory(List<String> violations) {
        try {
            String packagePath;
            Path packageDir;
            String userDir = System.getProperty("user.dir");
            Path projectRoot = Paths.get(userDir, new String[0]);
            Path srcPath = projectRoot.resolve("src/main/java");
            if (Files.exists(srcPath, new LinkOption[0]) && Files.exists(packageDir = srcPath.resolve(packagePath = TARGET_PACKAGE.replace('.', '/')), new LinkOption[0])) {
                Files.walk(packageDir, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".java")).forEach(path -> this.checkFileForDateUsage((Path)path, violations));
                return true;
            }
            return false;
        }
        catch (IOException e) {
            logger.debug("\u4ece\u6807\u51c6\u6e90\u7801\u76ee\u5f55\u626b\u63cf\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private boolean processViolations(List<String> violations, String scanType) {
        if (!violations.isEmpty()) {
            logger.error("\u274c \u6e90\u7801\u68c0\u67e5({})\u53d1\u73b0\u4ee5\u4e0b\u6587\u4ef6\u975e\u6cd5\u4f7f\u7528\u4e86java.util.Date:", (Object)scanType);
            for (String violation : violations) {
                logger.error("   - {}", (Object)violation);
            }
            return false;
        }
        logger.info("\u2705 \u6e90\u7801\u68c0\u67e5({})\u901a\u8fc7\uff0c\u5305 {} \u4e0b\u7684\u7c7b\u672a\u53d1\u73b0\u975e\u6cd5\u4f7f\u7528java.util.Date", (Object)scanType, (Object)TARGET_PACKAGE);
        return true;
    }

    private boolean checkFromFileSystem() {
        try {
            String packagePath;
            Path packageDir;
            ArrayList violations = new ArrayList();
            String userDir = System.getProperty("user.dir");
            Path projectRoot = Paths.get(userDir, new String[0]);
            Path srcPath = projectRoot.resolve("src/main/java");
            if (Files.exists(srcPath, new LinkOption[0]) && Files.exists(packageDir = srcPath.resolve(packagePath = TARGET_PACKAGE.replace('.', '/')), new LinkOption[0])) {
                Files.walk(packageDir, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".java")).forEach(path -> this.checkFileForDateUsage((Path)path, violations));
            }
            if (!violations.isEmpty()) {
                logger.error("\u274c \u6e90\u7801\u68c0\u67e5\u53d1\u73b0\u4ee5\u4e0b\u6587\u4ef6\u975e\u6cd5\u4f7f\u7528\u4e86java.util.Date:");
                for (String violation : violations) {
                    logger.error("   - {}", (Object)violation);
                }
                return false;
            }
            logger.info("\u2705 \u6e90\u7801\u68c0\u67e5\u901a\u8fc7\uff0c\u5305 {} \u4e0b\u7684\u7c7b\u672a\u53d1\u73b0\u975e\u6cd5\u4f7f\u7528java.util.Date", (Object)TARGET_PACKAGE);
            return true;
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u7cfb\u7edf\u626b\u63cf\u53d1\u751f\u9519\u8bef: ", (Throwable)e);
            return false;
        }
    }

    private void checkFileForDateUsage(Path filePath, List<String> violations) {
        try {
            String className = this.getClassNameFromPath(filePath);
            List<String> lines = Files.readAllLines(filePath);
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                if (!this.containsDateUsage(line)) continue;
                violations.add(String.format("%s:%d: %s", className, i + 1, line.trim()));
            }
        }
        catch (IOException e) {
            logger.debug("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25: {}", (Object)filePath.toString(), (Object)e);
        }
    }

    private String getClassNameFromPath(Path path) {
        try {
            String relativePath;
            String pathStr = path.toString();
            int srcIndex = pathStr.indexOf("src" + File.separator + "main" + File.separator + "java");
            if (srcIndex != -1 && (relativePath = pathStr.substring(srcIndex + 14)).endsWith(".java")) {
                return relativePath.substring(0, relativePath.length() - 5).replace(File.separator, ".");
            }
        }
        catch (Exception e) {
            logger.debug("\u65e0\u6cd5\u4ece\u8def\u5f84\u83b7\u53d6\u7c7b\u540d: {}", (Object)path.toString(), (Object)e);
        }
        return "Unknown";
    }

    private void checkResourceForDateUsage(Resource resource, List<String> violations) {
        try (InputStream is = resource.getInputStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line;
            String className = this.getClassNameFromResourcePath(resource.getURI().toString());
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if (!this.containsDateUsage(line)) continue;
                violations.add(String.format("%s:%d: %s", className, lineNumber, line.trim()));
            }
        }
        catch (IOException e) {
            logger.debug("\u8bfb\u53d6\u8d44\u6e90\u6587\u4ef6\u5931\u8d25: {}", (Object)resource.getFilename(), (Object)e);
        }
    }

    private String getClassNameFromResourcePath(String resourcePath) {
        try {
            String classPath;
            String relativePath;
            if (resourcePath.contains("!/")) {
                resourcePath = resourcePath.substring(resourcePath.indexOf("!/") + 2);
            }
            if (resourcePath.startsWith("jar:") || resourcePath.contains(".jar!")) {
                String pathInJar;
                int jarIndex = resourcePath.lastIndexOf("!/");
                if (jarIndex != -1 && (pathInJar = resourcePath.substring(jarIndex + 2)).endsWith(".java")) {
                    return pathInJar.substring(0, pathInJar.length() - 5).replace('/', '.');
                }
                return "Unknown";
            }
            int srcMainJavaIndex = resourcePath.indexOf("src/main/java/");
            if (srcMainJavaIndex != -1 && (relativePath = resourcePath.substring(srcMainJavaIndex + 14)).endsWith(".java")) {
                return relativePath.substring(0, relativePath.length() - 5).replace('/', '.');
            }
            int targetClassesIndex = resourcePath.indexOf("/target/classes/");
            if (targetClassesIndex != -1 && (classPath = resourcePath.substring(targetClassesIndex + 16)).endsWith(".java")) {
                return classPath.substring(0, classPath.length() - 5).replace('/', '.');
            }
            int lastSlash = resourcePath.lastIndexOf(47);
            int lastDot = resourcePath.lastIndexOf(46);
            if (lastSlash != -1 && lastDot > lastSlash) {
                String fileName = resourcePath.substring(lastSlash + 1, lastDot);
                return fileName;
            }
        }
        catch (Exception e) {
            logger.debug("\u65e0\u6cd5\u4ece\u8d44\u6e90\u8def\u5f84\u83b7\u53d6\u7c7b\u540d: {}", (Object)resourcePath, (Object)e);
        }
        return "Unknown";
    }

    private boolean containsDateUsage(String line) {
        if (line == null) {
            return false;
        }
        String trimmedLine = line.trim();
        if (trimmedLine.startsWith("//") || trimmedLine.startsWith("/*") || trimmedLine.startsWith("*")) {
            return false;
        }
        if (trimmedLine.startsWith("import") && trimmedLine.contains("java.util.Date") && !trimmedLine.contains("LocalDate")) {
            return true;
        }
        if (trimmedLine.contains("java.util.Date") && !trimmedLine.contains("LocalDate")) {
            return true;
        }
        if (DATE_NEW_PATTERN.matcher(trimmedLine).find() || DATE_FULL_NEW_PATTERN.matcher(trimmedLine).find()) {
            return true;
        }
        if (DATE_FIELD_PATTERN.matcher(trimmedLine).find() && !trimmedLine.contains("LocalDate") && !trimmedLine.contains("LocalDateTime")) {
            return true;
        }
        return trimmedLine.contains("Date") && (trimmedLine.contains("public") || trimmedLine.contains("private") || trimmedLine.contains("protected") || trimmedLine.contains(")") || trimmedLine.contains("=")) && !trimmedLine.contains("LocalDate") && !trimmedLine.contains("LocalDateTime");
    }
}

