/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.check;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

public class RuntimeClassDateChecker {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeClassDateChecker.class);
    private static final String TARGET_PACKAGE = "cn.smarthse.sandao.modules";

    public boolean checkLoadedClassesForDateUsage() {
        try {
            boolean hasViolations = false;
            if (!this.checkSpringBeansForDateUsage()) {
                hasViolations = true;
            }
            if (!this.checkAllClassesForDateUsage()) {
                hasViolations = true;
            }
            if (!hasViolations) {
                logger.info("\u2705 \u8fd0\u884c\u65f6Date\u68c0\u67e5\u901a\u8fc7\uff0c\u672a\u53d1\u73b0\u5df2\u52a0\u8f7d\u7684\u7c7b\u4f7f\u7528java.util.Date");
            }
            return !hasViolations;
        }
        catch (Exception e) {
            logger.error("\u8fd0\u884c\u65f6\u68c0\u67e5\u53d1\u751f\u9519\u8bef: ", (Throwable)e);
            return false;
        }
    }

    private boolean checkSpringBeansForDateUsage() {
        try {
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(RestController.class));
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Controller.class));
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Service.class));
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Component.class));
            Set beans = scanner.findCandidateComponents(TARGET_PACKAGE);
            boolean hasViolations = false;
            for (BeanDefinition bean : beans) {
                String className = bean.getBeanClassName();
                if (className == null || !this.isClassUsingDate(className)) continue;
                logger.error("\u274c Spring Bean\u7c7b {} \u4f7f\u7528\u4e86\u975e\u6cd5\u7684java.util.Date", (Object)className);
                hasViolations = true;
            }
            return !hasViolations;
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5Spring Bean\u4e2d\u7684Date\u4f7f\u7528\u60c5\u51b5\u65f6\u53d1\u751f\u9519\u8bef: ", (Throwable)e);
            return true;
        }
    }

    private boolean checkAllClassesForDateUsage() {
        try {
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
            scanner.addIncludeFilter((metadataReader, metadataReaderFactory) -> true);
            Set beans = scanner.findCandidateComponents(TARGET_PACKAGE);
            boolean hasViolations = false;
            for (BeanDefinition bean : beans) {
                String className = bean.getBeanClassName();
                if (className == null || !this.isClassUsingDate(className)) continue;
                logger.error("\u274c \u7c7b {} \u4f7f\u7528\u4e86\u975e\u6cd5\u7684java.util.Date", (Object)className);
                hasViolations = true;
            }
            return !hasViolations;
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5\u6240\u6709\u7c7b\u4e2d\u7684Date\u4f7f\u7528\u60c5\u51b5\u65f6\u53d1\u751f\u9519\u8bef: ", (Throwable)e);
            return true;
        }
    }

    private boolean isClassUsingDate(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            for (Field field : clazz.getDeclaredFields()) {
                if (!this.isDateType(field.getType())) continue;
                return true;
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (this.isDateType(((Method)accessibleObject).getReturnType())) {
                    return true;
                }
                for (AnnotatedElement annotatedElement : ((Executable)accessibleObject).getParameters()) {
                    if (!this.isDateType(((Parameter)annotatedElement).getType())) continue;
                    return true;
                }
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredConstructors()) {
                for (AnnotatedElement annotatedElement : ((Constructor)accessibleObject).getParameterTypes()) {
                    if (!this.isDateType((Class<?>)annotatedElement)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            logger.debug("\u7c7b\u672a\u627e\u5230: {}", (Object)className);
            return false;
        }
        catch (NoClassDefFoundError e) {
            logger.debug("\u7c7b\u5b9a\u4e49\u672a\u627e\u5230: {}", (Object)className);
            return false;
        }
        catch (Exception e) {
            logger.debug("\u68c0\u67e5\u7c7b\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)className, (Object)e);
            return false;
        }
    }

    private boolean isDateType(Class<?> type) {
        return type != null && Date.class.equals(type);
    }
}

