/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.check;

import cn.smarthse.framework.check.CompiledClassDateChecker;
import cn.smarthse.framework.check.RuntimeClassDateChecker;
import cn.smarthse.framework.check.SourceFileDateChecker;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Service;

@Service
public class DateCheckService
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(DateCheckService.class);
    private final CompiledClassDateChecker compiledClassChecker;
    private final RuntimeClassDateChecker runtimeClassChecker;
    private final SourceFileDateChecker sourceFileChecker;

    public boolean performAllDateChecks() {
        logger.info("\u5f00\u59cb\u6267\u884cDate\u4f7f\u7528\u68c0\u67e5...");
        ArrayList allViolations = new ArrayList();
        boolean hasViolations = false;
        logger.info("1. \u5f00\u59cb\u68c0\u67e5\u7f16\u8bd1\u540e\u7684\u7c7b\u6587\u4ef6...");
        if (!this.compiledClassChecker.checkDateUsage()) {
            hasViolations = true;
            logger.warn("\u7f16\u8bd1\u540e\u7c7b\u6587\u4ef6\u68c0\u67e5\u53d1\u73b0\u8fdd\u89c4\u4f7f\u7528Date");
        }
        logger.info("2. \u5f00\u59cb\u68c0\u67e5\u8fd0\u884c\u65f6\u5df2\u52a0\u8f7d\u7684\u7c7b...");
        if (!this.runtimeClassChecker.checkLoadedClassesForDateUsage()) {
            hasViolations = true;
            logger.warn("\u8fd0\u884c\u65f6\u7c7b\u68c0\u67e5\u53d1\u73b0\u8fdd\u89c4\u4f7f\u7528Date");
        }
        logger.info("3. \u5f00\u59cb\u68c0\u67e5\u6e90\u4ee3\u7801\u6587\u4ef6...");
        if (!this.sourceFileChecker.checkDateUsageInSourceCode()) {
            hasViolations = true;
            logger.warn("\u6e90\u4ee3\u7801\u68c0\u67e5\u53d1\u73b0\u8fdd\u89c4\u4f7f\u7528Date");
        }
        if (hasViolations) {
            logger.error("\u274c Date\u4f7f\u7528\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u53d1\u73b0\u975e\u6cd5\u4f7f\u7528java.util.Date\u7684\u60c5\u51b5");
            return false;
        }
        logger.info("\u2705 \u6240\u6709Date\u4f7f\u7528\u68c0\u67e5\u901a\u8fc7\uff0c\u672a\u53d1\u73b0\u975e\u6cd5\u4f7f\u7528java.util.Date");
        return true;
    }

    public void run(String ... args) throws Exception {
        this.performAllDateChecks();
    }

    @Generated
    public DateCheckService(CompiledClassDateChecker compiledClassChecker, RuntimeClassDateChecker runtimeClassChecker, SourceFileDateChecker sourceFileChecker) {
        this.compiledClassChecker = compiledClassChecker;
        this.runtimeClassChecker = runtimeClassChecker;
        this.sourceFileChecker = sourceFileChecker;
    }
}

