/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.aws.factory;

import cn.smarthse.framework.aws.core.OssClient;
import cn.smarthse.framework.aws.exception.OssException;
import cn.smarthse.framework.aws.properties.OssProperties;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.json.utils.JsonUtils;
import cn.smarthse.framework.redis.utils.RedisUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OssFactory.class);
    private static final Map<String, OssClient> CLIENT_CACHE = new ConcurrentHashMap<String, OssClient>();
    private static final ReentrantLock LOCK = new ReentrantLock();

    public static OssClient instance() {
        String configKey = (String)RedisUtils.getCacheObject((String)"global:sys_oss:default_config");
        if (StringUtils.isEmpty((String)configKey)) {
            throw new OssException("\u6587\u4ef6\u5b58\u50a8\u670d\u52a1\u7c7b\u578b\u65e0\u6cd5\u627e\u5230!");
        }
        return OssFactory.instance(configKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OssClient instance(String configKey) {
        String json = (String)RedisUtils.getCacheObject((String)("global:sys_oss_config:" + configKey));
        if (json == null) {
            throw new OssException("\u7cfb\u7edf\u5f02\u5e38, '" + configKey + "'\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        OssProperties properties = (OssProperties)JsonUtils.parseObject((String)json, OssProperties.class);
        OssClient client = CLIENT_CACHE.get(configKey);
        if (client == null || !client.checkPropertiesSame(properties)) {
            LOCK.lock();
            try {
                client = CLIENT_CACHE.get(configKey);
                if (client == null || !client.checkPropertiesSame(properties)) {
                    CLIENT_CACHE.put(configKey, new OssClient(configKey, properties));
                    log.info("\u521b\u5efaOSS\u5b9e\u4f8b key => {}", (Object)configKey);
                    OssClient ossClient = CLIENT_CACHE.get(configKey);
                    return ossClient;
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return client;
    }
}

