/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.satoken.config;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.interceptor.SaInterceptor;
import cn.dev33.satoken.jwt.StpLogicJwtForSimple;
import cn.dev33.satoken.router.SaRouter;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.smarthse.framework.core.factory.YmlPropertySourceFactory;
import cn.smarthse.framework.satoken.config.properties.SmarthseSecurityProperties;
import cn.smarthse.framework.satoken.core.dao.PlusSaTokenDao;
import cn.smarthse.framework.satoken.handler.SaTokenExceptionHandler;
import lombok.Generated;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@EnableConfigurationProperties(value={SmarthseSecurityProperties.class})
@PropertySource(value={"classpath:common-satoken.yml"}, factory=YmlPropertySourceFactory.class)
public class SaTokenAutoConfig
implements WebMvcConfigurer {
    private final SmarthseSecurityProperties smarthseSecurityProperties;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)SpringUtil.getBean(SaInterceptor.class)).addPathPatterns(new String[]{"/**"}).excludePathPatterns(this.smarthseSecurityProperties.getExcludes()).order(-2147483448);
    }

    @Bean
    @ConditionalOnMissingBean
    public StpLogic stpLogic() {
        return new StpLogicJwtForSimple();
    }

    @Bean
    @ConditionalOnMissingBean
    public SaInterceptor saInterceptor() {
        return new SaInterceptor(handle -> SaRouter.match((String[])new String[]{"/**"}).check(r -> StpUtil.checkLogin()));
    }

    @Bean
    public SaTokenDao saTokenDao() {
        return new PlusSaTokenDao();
    }

    @Bean
    public SaTokenExceptionHandler saTokenExceptionHandler() {
        return new SaTokenExceptionHandler();
    }

    @Generated
    public SaTokenAutoConfig(SmarthseSecurityProperties smarthseSecurityProperties) {
        this.smarthseSecurityProperties = smarthseSecurityProperties;
    }
}

