/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class StringTool {
    public static byte[] stringToByteArray(String strHexValue) {
        String[] strAryHex = strHexValue.split(" ");
        byte[] btAryHex = new byte[strAryHex.length];
        try {
            int nIndex = 0;
            String[] stringArray = strAryHex;
            int n = strAryHex.length;
            int n2 = 0;
            while (n2 < n) {
                String strTemp = stringArray[n2];
                btAryHex[nIndex] = (byte)Integer.parseInt(strTemp, 16);
                ++nIndex;
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return btAryHex;
    }

    public static byte[] stringArrayToByteArray(String[] strAryHex, int nLen) {
        if (strAryHex == null) {
            return null;
        }
        if (strAryHex.length < nLen) {
            nLen = strAryHex.length;
        }
        byte[] btAryHex = new byte[nLen];
        try {
            int i = 0;
            while (i < nLen) {
                btAryHex[i] = (byte)Integer.parseInt(strAryHex[i], 16);
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return btAryHex;
    }

    public static String byteArrayToString(byte[] btAryHex, int nIndex, int nLen) {
        if (nIndex + nLen > btAryHex.length) {
            nLen = btAryHex.length - nIndex;
        }
        String strResult = String.format("%02X", btAryHex[nIndex]);
        int nloop = nIndex + 1;
        while (nloop < nIndex + nLen) {
            String strTemp = String.format(" %02X", btAryHex[nloop]);
            strResult = String.valueOf(strResult) + strTemp;
            ++nloop;
        }
        return strResult;
    }

    public static String[] stringToStringArray(String strValue, int nLen) {
        String[] strAryResult = null;
        if (strValue != null && !strValue.equals("")) {
            ArrayList<String> strListResult = new ArrayList<String>();
            String strTemp = "";
            int nTemp = 0;
            int nloop = 0;
            while (nloop < strValue.length()) {
                if (strValue.charAt(nloop) != ' ') {
                    ++nTemp;
                    if (!Pattern.compile("^(([A-F])*([a-f])*(\\d)*)$").matcher(strValue.substring(nloop, nloop + 1)).matches()) {
                        return strAryResult;
                    }
                    strTemp = String.valueOf(strTemp) + strValue.substring(nloop, nloop + 1);
                    if (nTemp == nLen || nloop == strValue.length() - 1 && strTemp != null && !strTemp.equals("")) {
                        strListResult.add(strTemp);
                        nTemp = 0;
                        strTemp = "";
                    }
                }
                ++nloop;
            }
            if (strListResult.size() > 0) {
                strAryResult = new String[strListResult.size()];
                int i = 0;
                while (i < strAryResult.length) {
                    strAryResult[i] = (String)strListResult.get(i);
                    ++i;
                }
            }
        }
        return strAryResult;
    }

    @Deprecated
    public static char[] getChars(byte[] bytes, String encoding) {
        Charset cs = Charset.forName(encoding);
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        bb.put(bytes);
        bb.flip();
        CharBuffer cb = cs.decode(bb);
        return cb.array();
    }

    @Deprecated
    public static String toASCIIString(String hexString) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < hexString.length()) {
            stringBuilder.append((char)Integer.parseInt(hexString.substring(i, i + 2), 16));
            i += 2;
        }
        return stringBuilder.toString();
    }

    public static String hexStringToASCIIString(String hexString) {
        StringBuilder stringBuilder = new StringBuilder();
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        int i = 0;
        while (i < hexString.length()) {
            char high = hexString.charAt(i);
            char low = hexString.charAt(i + 1);
            char no = (char)(StringTool.charToInt(high) * 16 + StringTool.charToInt(low));
            stringBuilder.append(no);
            i += 2;
        }
        return stringBuilder.toString();
    }

    private static int charToInt(char c) {
        int num = -1;
        num = "0123456789ABCDEF".indexOf(String.valueOf(c));
        if (num < 0) {
            num = "0123456789abcdef".indexOf(String.valueOf(c));
        }
        return num;
    }

    public static byte[] subBytes(byte[] bytes, int start, int end) {
        byte[] subBytes = new byte[end - start];
        System.arraycopy(bytes, start, subBytes, 0, end - start);
        return subBytes;
    }

    public static int subBytesContains(byte[] parentBytes, byte[] childBytes, int startPosition) {
        if (parentBytes.length < childBytes.length) {
            return -1;
        }
        int i = startPosition;
        while (i < parentBytes.length) {
            int j = 0;
            while (j < childBytes.length) {
                if (parentBytes[i + j] != childBytes[j]) break;
                if (j == childBytes.length - 1) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public static byte[] hexStringToBytes(String hexString) {
        byte[] bytes = new byte[hexString.length() / 2];
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        int i = 0;
        while (i < hexString.length()) {
            char high = hexString.charAt(i);
            char low = hexString.charAt(i + 1);
            bytes[i / 2] = (byte)(StringTool.charToInt(high) * 16 + StringTool.charToInt(low));
            i += 2;
        }
        return bytes;
    }

    public static boolean compareBytes(byte[] first, byte[] second) {
        if (first.length != second.length) {
            return false;
        }
        int i = 0;
        while (i < first.length) {
            if (first[i] != second[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] asciiStringToBytes(String string) {
        byte[] result = new byte[string.length()];
        int i = 0;
        while (i < string.length()) {
            result[i] = (byte)string.charAt(i);
            ++i;
        }
        return result;
    }
}

