/*
 * Decompiled with CFR 0.152.
 */
package com.rfid;

import com.module.interaction.ReaderHelper;
import com.rfid.bean.MessageTran;
import com.util.Converter;

public class RFIDReaderHelper
extends ReaderHelper {
    RFIDReaderHelper() {
    }

    private int sendMessage(byte btReadId, byte btCmd) {
        MessageTran msgTran = new MessageTran(btReadId, btCmd);
        return this.sendCommand(msgTran.getAryTranData());
    }

    private int sendMessage(byte btReadId, byte btCmd, byte[] btAryData) {
        MessageTran msgTran = new MessageTran(btReadId, btCmd, btAryData);
        return this.sendCommand(msgTran.getAryTranData());
    }

    public final int reset(byte btReadId) {
        byte btCmd = 112;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int setUartBaudrate(byte btReadId, byte nIndexBaudrate) {
        byte btCmd = 113;
        byte[] btAryData = new byte[]{nIndexBaudrate};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getFirmwareVersion(byte btReadId) {
        byte btCmd = 114;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int setReaderAddress(byte btReadId, byte btNewReadId) {
        byte btCmd = 115;
        byte[] btAryData = new byte[]{btNewReadId};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setWorkAntenna(byte btReadId, byte btWorkAntenna) {
        byte btCmd = 116;
        byte[] btAryData = new byte[]{btWorkAntenna};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getWorkAntenna(byte btReadId) {
        byte btCmd = 117;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int setOutputPower(byte btReadId, byte btOutputPower) {
        byte btCmd = 118;
        byte[] btAryData = new byte[]{btOutputPower};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setOutputPower(byte btReadId, byte btPower1, byte btPower2, byte btPower3, byte btPower4) {
        byte btCmd = 118;
        byte[] btAryData = new byte[]{btPower1, btPower2, btPower3, btPower4};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setOutputPower(byte btReadId, byte btPower1, byte btPower2, byte btPower3, byte btPower4, byte btPower5, byte btPower6, byte btPower7, byte btPower8) {
        byte btCmd = 118;
        byte[] btAryData = new byte[]{btPower1, btPower2, btPower3, btPower4, btPower5, btPower6, btPower7, btPower8};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setOutputPower(byte btReadId, byte btPower1, byte btPower2, byte btPower3, byte btPower4, byte btPower5, byte btPower6, byte btPower7, byte btPower8, byte btPower9, byte btPower10, byte btPower11, byte btPower12, byte btPower13, byte btPower14, byte btPower15, byte btPower16) {
        byte btCmd = 118;
        byte[] btAryData = new byte[]{btPower1, btPower2, btPower3, btPower4, btPower5, btPower6, btPower7, btPower8, btPower9, btPower10, btPower11, btPower12, btPower13, btPower14, btPower15, btPower16};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getOutputPower(byte btReadId) {
        byte btCmd = 119;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int getOutputPowerEight(byte btReadId) {
        byte btCmd = -105;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int GetAntConnectionStatus(byte btReadId, byte btPort) {
        byte btCmd = 83;
        byte[] btAryData = new byte[]{btPort};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public int SetAntennaGroup(byte btReadId, byte btGroupId) {
        byte btCmd = 108;
        byte[] btAryData = new byte[]{btGroupId};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setFrequencyRegion(byte btReadId, byte btRegion, byte btStartRegion, byte btEndRegion) {
        byte btCmd = 120;
        byte[] btAryData = new byte[]{btRegion, btStartRegion, btEndRegion};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setUserDefineFrequency(byte btReadId, byte btFreqInterval, byte btChannelQuantity, int nStartFreq) {
        byte btCmd = 120;
        byte[] btAryFreq = new byte[3];
        byte[] btAryData = new byte[6];
        btAryFreq = Converter.getBytes(nStartFreq, 1);
        btAryData[0] = 4;
        btAryData[1] = btFreqInterval;
        btAryData[2] = btChannelQuantity;
        btAryData[3] = btAryFreq[2];
        btAryData[4] = btAryFreq[1];
        btAryData[5] = btAryFreq[0];
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getFrequencyRegion(byte btReadId) {
        byte btCmd = 121;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int setBeeperMode(byte btReadId, byte btMode) {
        byte btCmd = 122;
        byte[] btAryData = new byte[]{btMode};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getReaderTemperature(byte btReadId) {
        byte btCmd = 123;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int readGpioValue(byte btReadId) {
        byte btCmd = 96;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int writeGpioValue(byte btReadId, byte btChooseGpio, byte btGpioValue) {
        byte btCmd = 97;
        byte[] btAryData = new byte[]{btChooseGpio, btGpioValue};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setAntConnectionDetector(byte btReadId, byte btDetectorStatus) {
        byte btCmd = 98;
        byte[] btAryData = new byte[]{btDetectorStatus};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getAntConnectionDetector(byte btReadId) {
        byte btCmd = 99;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int setTemporaryOutputPower(byte btReadId, byte btRfPower) {
        byte btCmd = 102;
        byte[] btAryData = new byte[]{btRfPower};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setReaderIdentifier(byte btReadId, byte[] btAryIdentifier) {
        byte btCmd = 103;
        int nResult = this.sendMessage(btReadId, btCmd, btAryIdentifier);
        return nResult;
    }

    public final int getReaderIdentifier(byte btReadId) {
        byte btCmd = 104;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int setRfLinkProfile(byte btReadId, byte btProfile) {
        byte btCmd = 105;
        byte[] btAryData = new byte[]{btProfile};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getRfLinkProfile(byte btReadId) {
        byte btCmd = 106;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int getRfPortReturnLoss(byte btReadId, byte btFrequency) {
        byte btCmd = 126;
        byte[] btAryData = new byte[]{btFrequency};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int inventory(byte btReadId, byte btRepeat) {
        byte btCmd = -128;
        byte[] btAryData = new byte[]{btRepeat};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int readTag(byte btReadId, byte btMemBank, byte btWordAdd, byte btWordCnt, byte[] btAryPassWord) {
        byte btCmd = -127;
        byte[] btAryData = null;
        if (btAryPassWord == null || btAryPassWord.length < 4) {
            btAryPassWord = null;
            btAryData = new byte[3];
        } else {
            btAryData = new byte[7];
        }
        btAryData[0] = btMemBank;
        btAryData[1] = btWordAdd;
        btAryData[2] = btWordCnt;
        if (btAryPassWord != null) {
            System.arraycopy(btAryPassWord, 0, btAryData, 3, btAryPassWord.length);
        }
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int ReadTagTID(byte btReadId, byte btTidAdd, byte btTidLen, byte[] btPassword, byte btSession, byte btReadMode) {
        byte btCmd = -127;
        byte[] btAryData = btPassword != null ? new byte[10 + btPassword.length] : new byte[3];
        btAryData[0] = 0;
        btAryData[1] = 0;
        btAryData[2] = btTidAdd;
        btAryData[3] = btTidLen;
        btAryData[4] = 0;
        btAryData[5] = 0;
        if (btPassword != null) {
            System.arraycopy(btPassword, 0, btAryData, 6, btPassword.length);
        }
        btAryData[6 + btPassword.length] = btSession;
        btAryData[6 + btPassword.length + 1] = 0;
        btAryData[6 + btPassword.length + 2] = btReadMode;
        btAryData[6 + btPassword.length + 3] = 5;
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int writeTag(byte btReadId, byte[] btAryPassWord, byte btMemBank, byte btWordAdd, byte btWordCnt, byte[] btAryData) {
        byte btCmd = -126;
        byte[] btAryBuffer = new byte[btAryData.length + 7];
        System.arraycopy(btAryPassWord, 0, btAryBuffer, 0, btAryPassWord.length);
        btAryBuffer[4] = btMemBank;
        btAryBuffer[5] = btWordAdd;
        btAryBuffer[6] = btWordCnt;
        System.arraycopy(btAryData, 0, btAryBuffer, 7, btAryData.length);
        int nResult = this.sendMessage(btReadId, btCmd, btAryBuffer);
        return nResult;
    }

    public final int lockTag(byte btReadId, byte[] btAryPassWord, byte btMemBank, byte btLockType) {
        byte btCmd = -125;
        byte[] btAryData = new byte[6];
        System.arraycopy(btAryPassWord, 0, btAryData, 0, btAryPassWord.length);
        btAryData[4] = btMemBank;
        btAryData[5] = btLockType;
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int killTag(byte btReadId, byte[] btAryPassWord) {
        byte btCmd = -124;
        byte[] btAryData = new byte[4];
        System.arraycopy(btAryPassWord, 0, btAryData, 0, btAryPassWord.length);
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setAccessEpcMatch(byte btReadId, byte btEpcLen, byte[] btAryEpc) {
        byte btCmd = -123;
        int nLen = (btEpcLen & 0xFF) + 2;
        byte[] btAryData = new byte[nLen];
        btAryData[0] = 0;
        btAryData[1] = btEpcLen;
        System.arraycopy(btAryEpc, 0, btAryData, 2, btAryEpc.length);
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int cancelAccessEpcMatch(byte btReadId) {
        byte btCmd = -123;
        byte[] btAryData = new byte[]{1};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getAccessEpcMatch(byte btReadId) {
        byte btCmd = -122;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int realTimeInventory(byte btReadId, byte btRepeat) {
        byte btCmd = -119;
        byte[] btAryData = new byte[]{btRepeat};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int fastSwitchAntInventory(byte btReadId, byte btA, byte btStayA, byte btB, byte btStayB, byte btC, byte btStayC, byte btD, byte btStayD, byte btInterval, byte btRepeat) {
        byte btCmd = -118;
        byte[] btAryData = new byte[]{btA, btStayA, btB, btStayB, btC, btStayC, btD, btStayD, btInterval, btRepeat};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int fastSwitchAntInventory(byte btReadId, byte btA, byte btStayA, byte btB, byte btStayB, byte btC, byte btStayC, byte btD, byte btStayD, byte btE, byte btStayE, byte btF, byte btStayF, byte btG, byte btStayG, byte btH, byte btStayH, byte btInterval, byte btRepeat) {
        byte btCmd = -118;
        byte[] btAryData = new byte[]{btA, btStayA, btB, btStayB, btC, btStayC, btD, btStayD, btE, btStayE, btF, btStayF, btG, btStayG, btH, btStayH, btInterval, btRepeat};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int fastSwitchAntInventory(byte btReadId, byte btA, byte btStayA, byte btB, byte btStayB, byte btC, byte btStayC, byte btD, byte btStayD, byte btE, byte btStayE, byte btF, byte btStayF, byte btG, byte btStayG, byte btH, byte btStayH, byte bt9, byte btStay9, byte bt10, byte btStay10, byte bt11, byte btStay11, byte bt12, byte btStay12, byte bt13, byte btStay13, byte bt14, byte btStay14, byte bt15, byte btStay15, byte bt16, byte btStay16, byte btInterval, byte btRepeat) {
        byte btCmd = -118;
        byte[] btAryData = new byte[]{btA, btStayA, btB, btStayB, btC, btStayC, btD, btStayD, btE, btStayE, btF, btStayF, btG, btStayG, btH, btStayH, bt9, btStay9, bt10, btStay10, bt11, btStay11, bt12, btStay12, bt13, btStay13, bt14, btStay14, bt15, btStay15, bt16, btStay16, btInterval, btRepeat};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int customizedSessionTargetInventory(byte btReadId, byte btSession, byte btTarget, byte btRepeat) {
        byte btCmd = -117;
        byte[] btAryData = new byte[]{btSession, btTarget, btRepeat};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setImpinjFastTid(byte btReadId, boolean blnOpen, boolean blnSave) {
        byte btCmd = blnSave ? (byte)-115 : -116;
        byte[] btAryData = new byte[]{(byte)(blnOpen ? 141 : 0)};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getImpinjFastTid(byte btReadId) {
        byte btCmd = -114;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int iso180006BInventory(byte btReadId) {
        byte btCmd = -80;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int iso180006BReadTag(byte btReadId, byte[] btAryUID, byte btWordAdd, byte btWordCnt) {
        byte btCmd = -79;
        int nLen = btAryUID.length + 2;
        byte[] btAryData = new byte[nLen];
        System.arraycopy(btAryUID, 0, btAryData, 0, btAryUID.length);
        btAryData[nLen - 2] = btWordAdd;
        btAryData[nLen - 1] = btWordCnt;
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int iso180006BWriteTag(byte btReadId, byte[] btAryUID, byte btWordAdd, byte btWordCnt, byte[] btAryBuffer) {
        byte btCmd = -78;
        int nLen = btAryUID.length + 2 + btAryBuffer.length;
        byte[] btAryData = new byte[nLen];
        System.arraycopy(btAryUID, 0, btAryData, 0, btAryUID.length);
        btAryData[btAryUID.length] = btWordAdd;
        btAryData[btAryUID.length + 1] = btWordCnt;
        System.arraycopy(btAryBuffer, 0, btAryData, btAryUID.length + 2, btAryBuffer.length);
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int iso180006BLockTag(byte btReadId, byte[] btAryUID, byte btWordAdd) {
        byte btCmd = -77;
        int nLen = btAryUID.length + 1;
        byte[] btAryData = new byte[nLen];
        System.arraycopy(btAryUID, 0, btAryData, 0, btAryUID.length);
        btAryData[nLen - 1] = btWordAdd;
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int iso180006BQueryLockTag(byte btReadId, byte[] btAryUID, byte btWordAdd) {
        byte btCmd = -76;
        int nLen = btAryUID.length + 1;
        byte[] btAryData = new byte[nLen];
        System.arraycopy(btAryUID, 0, btAryData, 0, btAryUID.length);
        btAryData[nLen - 1] = btWordAdd;
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getInventoryBuffer(byte btReadId) {
        byte btCmd = -112;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int getAndResetInventoryBuffer(byte btReadId) {
        byte btCmd = -111;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int getInventoryBufferTagCount(byte btReadId) {
        byte btCmd = -110;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int resetInventoryBuffer(byte btReadId) {
        byte btCmd = -109;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int setTagMask(byte btReadId, byte btMaskNo, byte btTarget, byte btAction, byte btMembank, byte btStartAdd, byte btMaskLen, byte[] maskValue) {
        byte[] btAryData = new byte[7 + maskValue.length];
        btAryData[0] = btMaskNo;
        btAryData[1] = btTarget;
        btAryData[2] = btAction;
        btAryData[3] = btMembank;
        btAryData[4] = btStartAdd;
        btAryData[5] = btMaskLen;
        System.arraycopy(maskValue, 0, btAryData, 6, maskValue.length);
        btAryData[btAryData.length - 1] = 0;
        int nResult = this.sendMessage(btReadId, (byte)-104, btAryData);
        return nResult;
    }

    public final int getTagMask(byte btReadId) {
        byte[] btAryData = new byte[]{32};
        int nResult = this.sendMessage(btReadId, (byte)-104, btAryData);
        return nResult;
    }

    public final int clearTagMask(byte btReadId, byte btMaskNo) {
        byte[] btAryData = new byte[]{btMaskNo};
        int nResult = this.sendMessage(btReadId, (byte)-104, btAryData);
        return nResult;
    }
}

