/*
 * Decompiled with CFR 0.152.
 */
package com.module.interaction;

import com.module.interaction.DataPackageParser;
import com.module.interaction.DataPackageProcess;
import com.module.interaction.RXTXListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Observer;

public abstract class ReaderHelper {
    protected ReaderBase mReader;
    protected RXTXListener mListener;

    public void setReader(InputStream in, OutputStream out, DataPackageParser parser, DataPackageProcess process) throws Exception {
        if (in == null || out == null) {
            throw new NullPointerException("in Or out is NULL!");
        }
        if (this.mReader == null) {
            this.mReader = new ReaderBase(this, in, out, parser, process){

                @Override
                public void onLostConnect() {
                    this.onLostConnect();
                }

                @Override
                public void reciveData(byte[] btAryReceiveData) {
                    this.reciveData(btAryReceiveData);
                }

                @Override
                public void sendData(byte[] btArySendData) {
                    this.sendData(btArySendData);
                }
            };
        }
    }

    public void registerObserver(Observer observer) {
        if (this.mReader == null) {
            throw new NullPointerException("The observable is null!");
        }
        this.mReader.registerObserver(observer);
    }

    public void unRegisterObserver(Observer observer) {
        if (this.mReader == null) {
            throw new NullPointerException("The observable is null!");
        }
        this.mReader.unRegisterObserver(observer);
    }

    public void unRegisterObservers() {
        if (this.mReader == null) {
            throw new NullPointerException("The observable is null!");
        }
        this.mReader.unRegisterObservers();
    }

    public boolean isAlive() {
        if (this.mReader == null) {
            return false;
        }
        return this.mReader.IsAlive();
    }

    public void startWith() {
        if (this.mReader == null) {
            throw new NullPointerException("Reader is null!");
        }
        if (!this.mReader.IsAlive()) {
            this.mReader.StartWait();
        }
    }

    public void signOut() {
        if (this.mReader != null) {
            this.mReader.signOut();
            this.mReader = null;
        }
        this.mListener = null;
    }

    public void setRXTXListener(RXTXListener listener) {
        this.mListener = listener;
    }

    private void reciveData(byte[] btAryReceiveData) {
        if (this.mListener != null) {
            this.mListener.reciveData(btAryReceiveData);
        }
    }

    private void sendData(byte[] btArySendData) {
        if (this.mListener != null) {
            this.mListener.sendData(btArySendData);
        }
    }

    private void onLostConnect() {
        if (this.mListener != null) {
            this.mListener.onLostConnect();
        }
    }

    public int sendCommand(byte[] btCMDPackage) {
        return this.mReader.sendBuffer(btCMDPackage);
    }

    abstract class ReaderBase {
        private WaitThread mWaitThread = null;
        private InputStream mInStream = null;
        private OutputStream mOutStream = null;
        private DataPackageParser mPackageParser;
        private DataPackageProcess mPackageProcess;

        public abstract void onLostConnect();

        public ReaderBase(InputStream in, OutputStream out, DataPackageParser parser, DataPackageProcess process) throws Exception {
            this.mInStream = in;
            this.mOutStream = out;
            if (parser == null || process == null) {
                throw new Exception("DataPackageParser && DataPackageProcess are null exception!");
            }
            this.mPackageParser = parser;
            this.mPackageProcess = process;
            this.StartWait();
        }

        public boolean IsAlive() {
            return this.mWaitThread != null && this.mWaitThread.isAlive();
        }

        public void StartWait() {
            this.mWaitThread = new WaitThread();
            this.mWaitThread.start();
        }

        public final void signOut() {
            if (this.mWaitThread != null) {
                this.mWaitThread.signOut();
                this.mWaitThread = null;
            }
            try {
                if (this.mInStream != null) {
                    this.mInStream.close();
                    this.mInStream = null;
                }
                if (this.mOutStream != null) {
                    this.mOutStream.close();
                    this.mOutStream = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.mInStream = null;
                this.mOutStream = null;
            }
            this.unRegisterObservers();
            this.mPackageParser = null;
            this.mPackageProcess = null;
        }

        public void registerObserver(Observer observer) {
            this.mPackageProcess.addObserver(observer);
        }

        public void unRegisterObserver(Observer observer) {
            this.mPackageProcess.deleteObserver(observer);
        }

        public void unRegisterObservers() {
            this.mPackageProcess.deleteObservers();
        }

        public void reciveData(byte[] btAryReceiveData) {
        }

        public void sendData(byte[] btArySendData) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int sendMessage(byte[] btArySenderData) {
            try {
                OutputStream outputStream = this.mOutStream;
                synchronized (outputStream) {
                    this.mOutStream.write(btArySenderData);
                }
            }
            catch (IOException e) {
                this.onLostConnect();
                return -1;
            }
            catch (Exception e) {
                return -1;
            }
            this.sendData(btArySenderData);
            return 0;
        }

        public final int sendBuffer(byte[] completeCMD) {
            int nResult = this.sendMessage(completeCMD);
            return nResult;
        }

        private class WaitThread
        extends Thread {
            private boolean mShouldRunning = true;

            @Override
            public void run() {
                byte[] btAryBuffer = new byte[4096];
                while (this.mShouldRunning) {
                    try {
                        int nLenRead = ReaderBase.this.mInStream.read(btAryBuffer);
                        if (nLenRead <= 0) continue;
                        byte[] btAryReceiveData = new byte[nLenRead];
                        System.arraycopy(btAryBuffer, 0, btAryReceiveData, 0, nLenRead);
                        ReaderBase.this.reciveData(btAryReceiveData);
                        ReaderBase.this.mPackageParser.runReceiveDataCallback(btAryReceiveData, ReaderBase.this.mPackageProcess);
                    }
                    catch (IOException e) {
                        ReaderBase.this.onLostConnect();
                        return;
                    }
                    catch (Exception e) {
                        ReaderBase.this.onLostConnect();
                        return;
                    }
                }
            }

            public void signOut() {
                this.mShouldRunning = false;
                this.interrupt();
            }
        }
    }
}

