/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.syn.task;

import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.township.manage.entity.manage.TmPatrolItem;
import cn.smarthse.township.manage.framework.RedisKey;
import cn.smarthse.township.syn.service.ISynPatrolService;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
public class SynTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SynTask.class);
    private final RedisTemplate<String, Object> redisTemplate;
    private final ISynPatrolService synPatrolService;

    @XxlJob(value="SynTask-initReferenceData")
    public void initReferenceData() {
        String key = XxlJobHelper.getJobParam();
        log.info("SynTask-initReferenceData begin key\uff1a{}", (Object)key);
        Set keys = StringUtils.isBlank((CharSequence)key) ? this.redisTemplate.keys((Object)"syn:referenceData:*") : this.redisTemplate.keys((Object)key);
        if (keys != null) {
            keys.forEach(cid -> {
                Long cidLong = Long.parseLong(cid);
                TmPatrolItem referenceData = this.synPatrolService.getItemReferenceData(cidLong);
                Long itemId = (Long)this.redisTemplate.opsForValue().get((Object)RedisKey.synReferenceData(cidLong));
                referenceData.setId(itemId);
                this.synPatrolService.updateReferenceData(referenceData);
                this.redisTemplate.delete((Object)RedisKey.synReferenceData(cidLong));
                log.info("SynTask-initReferenceData cid\uff1a{}, itemId:{}", cid, (Object)itemId);
            });
        }
        log.info("SynTask-initReferenceData end");
    }

    @Generated
    public SynTask(RedisTemplate<String, Object> redisTemplate, ISynPatrolService synPatrolService) {
        this.redisTemplate = redisTemplate;
        this.synPatrolService = synPatrolService;
    }
}

