/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.syn.task;

import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.township.syn.dto.BxPatrolInfoDto;
import cn.smarthse.township.syn.param.BxSearchPatrolParam;
import cn.smarthse.township.syn.service.ISynPatrolService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.text.ParseException;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BxPatrolDataTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BxPatrolDataTask.class);
    private final ISynPatrolService synPatrolService;

    @XxlJob(value="SynTask-obtainBxPatrolData")
    public void obtainBxPatrolData() throws ParseException, JsonProcessingException {
        String jsonParam = XxlJobHelper.getJobParam();
        BxSearchPatrolParam param = new BxSearchPatrolParam();
        ObjectMapper mapper = new ObjectMapper();
        log.info("SynTask-obtainBxPatrolData =====begin===== param\uff1a{}", (Object)jsonParam);
        try {
            param = (BxSearchPatrolParam)mapper.readValue(jsonParam, BxSearchPatrolParam.class);
        }
        catch (Exception e) {
            XxlJobHelper.log((String)("\u53c2\u6570\u89e3\u6790\u5931\u8d25: " + e.getMessage()), (Object[])new Object[0]);
            throw new ServiceException("xxljob\u53c2\u6570\u89e3\u6790\u5931\u8d25");
        }
        String bxToken = this.synPatrolService.getBxToken();
        if (StringUtils.isBlank((CharSequence)bxToken)) {
            throw new ServiceException("\u83b7\u53d6\u6807\u73batoken\u5931\u8d25");
        }
        param.setToken(bxToken);
        List<BxPatrolInfoDto> bxPatrolList = this.synPatrolService.getBxPatrolInfoList(param);
        XxlJobHelper.log((String)"\u6807\u73ba\u5de1\u67e5\u6570\u636e\u603b\u6570\uff1a{}", (Object[])new Object[]{bxPatrolList.size()});
        XxlJobHelper.log((String)"\u6253\u5370\u83b7\u53d6\u5230\u7684\u6807\u73ba\u5de1\u67e5\u6570\u636e:{} ", (Object[])new Object[]{bxPatrolList.toString()});
        this.synPatrolService.addPatrolFromBx(bxPatrolList);
        log.info("SynTask-obtainBxPatrolData =====end=====");
    }

    @XxlJob(value="SynTask-reStorageBxData")
    public void reStorageBxData() throws JsonProcessingException, ParseException {
        String jsonParam = XxlJobHelper.getJobParam();
        List param = null;
        ObjectMapper mapper = new ObjectMapper();
        log.info("SynTask-reStorageBxData =====begin===== param\uff1a{}", (Object)jsonParam);
        try {
            param = (List)mapper.readValue(jsonParam, List.class);
        }
        catch (Exception e) {
            XxlJobHelper.log((String)("\u53c2\u6570\u89e3\u6790\u5931\u8d25: " + e.getMessage()), (Object[])new Object[0]);
        }
        this.synPatrolService.reStorageBxData(param);
        log.info("SynTask-reStorageBxData =====begin===== param\uff1a{}", (Object)jsonParam);
    }

    @Generated
    public BxPatrolDataTask(ISynPatrolService synPatrolService) {
        this.synPatrolService = synPatrolService;
    }
}

