/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.syn.service.impl;

import cn.hutool.core.util.URLUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import cn.smarthse.common.util.MD5Utils;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.service.work.reform.IReformItemAcceptanceRecordService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.vo.work.reform.ReformAddParam;
import cn.smarthse.modules.health.vo.work.reform.RiskTypeVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.township.manage.dao.dynamic.bigdata.CompanyMapper;
import cn.smarthse.township.manage.dao.dynamic.company.TmXzxgSecretMapper;
import cn.smarthse.township.manage.dao.manager.TmExternalSourceDataMapper;
import cn.smarthse.township.manage.dao.reform.ReformItemBasicMapper;
import cn.smarthse.township.manage.entity.manage.TmExternalSourceData;
import cn.smarthse.township.manage.entity.manage.TmPatrolInfo;
import cn.smarthse.township.manage.entity.manage.TmPatrolItem;
import cn.smarthse.township.manage.enums.manage.PatrolSourceTypeEnums;
import cn.smarthse.township.manage.enums.manage.PatrolStatusEnums;
import cn.smarthse.township.manage.framework.RedisKey;
import cn.smarthse.township.manage.manage.IPatrolManage;
import cn.smarthse.township.manage.manage.IReformManage;
import cn.smarthse.township.manage.model.vo.PatrolItemReferenceDataVo;
import cn.smarthse.township.manage.model.vo.ReformListVo;
import cn.smarthse.township.manage.model.vo.api.patrol.XzxgSecretVo;
import cn.smarthse.township.manage.service.manage.ITmExternalSourceDataService;
import cn.smarthse.township.manage.service.manage.ITmPatrolInfoService;
import cn.smarthse.township.manage.service.manage.ITmPatrolItemService;
import cn.smarthse.township.syn.converter.SynPatrolConverter;
import cn.smarthse.township.syn.dto.BxPatrolInfoDto;
import cn.smarthse.township.syn.dto.PatrolResponseBodyDataDto;
import cn.smarthse.township.syn.dto.PatrolResponseBodyDto;
import cn.smarthse.township.syn.model.dto.CompanyInfoDto;
import cn.smarthse.township.syn.model.param.PatrolAddParam;
import cn.smarthse.township.syn.model.param.PatrolItemParam;
import cn.smarthse.township.syn.model.param.PatrolParam;
import cn.smarthse.township.syn.model.param.ReformItemAcceptanceRecordParam;
import cn.smarthse.township.syn.model.param.ReformItemBasicAddParam;
import cn.smarthse.township.syn.model.param.ReformItemBasicParam;
import cn.smarthse.township.syn.param.BxSearchPatrolParam;
import cn.smarthse.township.syn.param.DyPatrolAddParam;
import cn.smarthse.township.syn.param.DyPatrolInfoParam;
import cn.smarthse.township.syn.param.DyPatrolItemParam;
import cn.smarthse.township.syn.param.FileParam;
import cn.smarthse.township.syn.service.ISynPatrolService;
import cn.smarthse.township.syn.service.UploadOssUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xxl.job.core.context.XxlJobHelper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SynPatrolServiceImpl
implements ISynPatrolService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SynPatrolServiceImpl.class);
    private final IPatrolManage patrolManage;
    private final ITmPatrolInfoService patrolInfoService;
    private final ITmPatrolItemService patrolItemService;
    private final ITmExternalSourceDataService externalSourceDataService;
    private final TmXzxgSecretMapper xzxgSecretMapper;
    private final CompanyMapper companyMapper;
    private final SynPatrolConverter patrolConverter;
    private final UploadOssUtil uploadOssUtil;
    private final ReformItemBasicMapper reformItemBasicMapper;
    private final RedisTemplate redisTemplate;
    private final TmExternalSourceDataMapper tmpExternalSourceDataMapper;
    @DubboReference
    private IReformItemBasicNewService itemBasicNewService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private IReformItemAcceptanceRecordService reformItemAcceptanceRecordService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @Autowired
    private IReformManage reformManage;
    @Value(value="${bx.tokenUrl}")
    private String tokenUrl;
    @Value(value="${bx.callBackUrl}")
    private String callBackUrl;
    @Value(value="${bx.pageUrl}")
    private String pageUrl;
    @Value(value="${bx.appId}")
    private String bxAppId;
    @Value(value="${bx.appSecret}")
    private String bxAppSecret;

    @Override
    public boolean checkPermission(String appId, Long cid) {
        XzxgSecretVo xzxgSecret = this.xzxgSecretMapper.getSecretByAppId(appId);
        if (xzxgSecret == null) {
            return false;
        }
        Set<Long> areaIdSet = this.xzxgSecretMapper.getSecretAreaId(xzxgSecret.getId());
        if (CollectionUtils.isEmpty(areaIdSet)) {
            return false;
        }
        Long companyAreaId = this.companyMapper.selectCompanyAreaId(cid);
        if (companyAreaId == null) {
            return false;
        }
        AreaModel companyArea = this.sysAreaProvideService.getAreaById(companyAreaId);
        for (Long areaId : areaIdSet) {
            AreaModel area = this.sysAreaProvideService.getAreaById(areaId);
            if (area == null) continue;
            switch (area.getLevel()) {
                case 1: {
                    if (!area.getProvinceId().equals(companyArea.getProvinceId())) break;
                    return true;
                }
                case 2: {
                    if (!area.getCityId().equals(companyArea.getCityId())) break;
                    return true;
                }
                case 3: {
                    if (!area.getAreaId().equals(companyArea.getAreaId())) break;
                    return true;
                }
                case 4: {
                    if (!area.getStreetId().equals(companyArea.getStreetId())) break;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Long getCid(String companyName, String unifiedCreditCode) {
        return this.companyMapper.getCid(companyName, unifiedCreditCode);
    }

    @Override
    public XzxgSecretVo getSecretByAppId(String appId) {
        return this.xzxgSecretMapper.getSecretByAppId(appId);
    }

    @Override
    public Set<Long> getSecretAreaId(Long secretId) {
        return this.xzxgSecretMapper.getSecretAreaId(secretId);
    }

    @Override
    public Long addPatrol(PatrolAddParam param) {
        PatrolParam patrol = param.getPatrol();
        PatrolItemParam patrolItem = param.getPatrolItem();
        if (this.isExistsPatrol(patrol.getCid(), patrol.getPatrolName(), patrol.getYear())) {
            log.error(String.format("\u201c%s\u201d\u5df2\u7ecf\u5b58\u5728\u6807\u8bb0\u4e3a%s\u5e74\u5de1\u67e5\u540d\u4e3a\u201c%s\u201d\u7684\u5de1\u67e5", patrol.getUnitName(), patrol.getYear(), patrol.getPatrolName()));
            return -1L;
        }
        TmPatrolInfo tmPatrolInfo = this.patrolConverter.PatrolParam2TmPatrolInfo(patrol);
        this.initPatrol(tmPatrolInfo, patrol);
        this.patrolInfoService.save(tmPatrolInfo);
        TmPatrolItem tmPatrolItem = this.patrolConverter.PatrolItemParam2TmPatrolItem(patrolItem);
        this.initPatrolItem(tmPatrolItem, tmPatrolInfo);
        this.patrolItemService.save(tmPatrolItem);
        this.addPatrolAfter(tmPatrolInfo.getCid(), tmPatrolItem.getId());
        return tmPatrolInfo.getId();
    }

    private void addPatrolAfter(Long cid, Long itemId) {
        this.redisTemplate.opsForValue().set((Object)RedisKey.synReferenceData(cid), (Object)itemId);
    }

    @Override
    public Long addReformItemBasic(ReformItemBasicAddParam param) {
        ReformItemBasicParam reform = param.getReform();
        List<ReformItemAcceptanceRecordParam> reformRecordList = param.getReformRecordList();
        if (this.isExistsReformItemSn(reform.getReformItemSn())) {
            log.error(String.format("\u5df2\u7ecf\u5b58\u5728\u6574\u6539\u9879\u7f16\u53f7\u4e3a\u201c%s\u201d\u7684\u98ce\u9669", reform.getReformItemSn()));
            return -1L;
        }
        ReformItemBasic reformItemBasic = this.patrolConverter.ReformItemBasicParam2ReformItemBasic(reform);
        this.initReform(reformItemBasic, reform);
        ReformItemBasic add = (ReformItemBasic)this.reformItemBasicService.add((Object)reformItemBasic);
        List<ReformItemAcceptanceRecord> reformItemAcceptanceRecordList = this.initReformRecord(reformRecordList, add);
        reformItemAcceptanceRecordList.forEach(arg_0 -> ((IReformItemAcceptanceRecordService)this.reformItemAcceptanceRecordService).add(arg_0));
        return add.getId();
    }

    @Override
    public void initPatrol(TmPatrolInfo patrolInfo, PatrolParam param) {
        if (patrolInfo == null || param == null) {
            return;
        }
        patrolInfo.setPatrolStatus(PatrolStatusEnums.PATROLLING.getCode());
        CompanyInfoDto company = this.companyMapper.selectCompanyInfo(param.getCid());
        if (company == null) {
            return;
        }
        patrolInfo.setUnitName(company.getName());
        patrolInfo.setUnitStatus(company.getBusinessState());
        patrolInfo.setManager(company.getManager());
        patrolInfo.setTel(company.getTel());
        patrolInfo.setHseManager(company.getHseManager());
        patrolInfo.setHesTel(company.getHesTel());
        patrolInfo.setAreaId(company.getAreaId());
        patrolInfo.setAreaId1(company.getAreaId1());
        patrolInfo.setAreaId2(company.getAreaId2());
        patrolInfo.setAreaId3(company.getAreaId3());
        patrolInfo.setAreaId4(company.getAreaId4());
        patrolInfo.setAddress(company.getAreaName());
        patrolInfo.setWorkAddress(company.getWorkAddress());
        patrolInfo.setIndustryCode(company.getIndustryCategory() != null ? company.getIndustryCategory().toString() : null);
        patrolInfo.setIndustryName(company.getIndustryCategoryName());
        patrolInfo.setScaleCode(company.getScale() != null ? company.getScale().toString() : null);
        patrolInfo.setEconomyCode(company.getRegisterType() != null ? company.getRegisterType().toString() : null);
        patrolInfo.setEconomyName(company.getRegisterTypeName());
        patrolInfo.setPatrolFile(this.uploadOssUtil.uplod2Oss(param.getPatrolFileList()));
        patrolInfo.setUnitManageSign(Long.valueOf(this.uploadOssUtil.uplod2Oss(param.getUnitManageSignFile())));
        patrolInfo.setCreateBy(Long.valueOf(1L));
        patrolInfo.setCreateDate(new Date());
        patrolInfo.setUpdateBy(Long.valueOf(1L));
        patrolInfo.setUpdateDate(patrolInfo.getCreateDate());
        patrolInfo.setIsValid(Boolean.valueOf(true));
    }

    @Override
    public void updateReferenceData(TmPatrolItem referenceData) {
        this.patrolItemService.updateById(referenceData);
    }

    @Override
    public TmPatrolItem getItemReferenceData(Long cid) {
        PatrolItemReferenceDataVo referenceData = this.patrolManage.getItemReferenceData(cid);
        return this.patrolConverter.PatrolItemReferenceDataVo2TmPatrolItem(referenceData);
    }

    @Override
    @Transactional
    public Long addPatrolForDy(DyPatrolAddParam param) {
        DyPatrolInfoParam patrolInfo = param.getPatrolInfo();
        DyPatrolItemParam patrolItem = param.getPatrolItem();
        Long transformCid = this.companyMapper.getTransformCid(patrolInfo.getExternalSystemCompanyId());
        patrolInfo.setCid(transformCid);
        if (this.isExistsPatrolForDy(patrolInfo.getCid(), patrolInfo.getSourceId(), patrolInfo.getYear())) {
            log.error(String.format("\u5df2\u5b58\u5728\u5bfc\u5165id\u4e3a\u201c%s\u201d\u7684\u5de1\u67e5", patrolInfo.getSourceId()));
            return -1L;
        }
        TmPatrolInfo tmPatrolInfo = this.patrolConverter.DyPatrolParam2TmPatrolInfo(patrolInfo);
        Long r = this.initPatrolForDy(tmPatrolInfo, patrolInfo);
        if (r != null) {
            return r;
        }
        this.patrolInfoService.save(tmPatrolInfo);
        TmPatrolItem tmPatrolItem = this.patrolConverter.DyPatrolItemParam2TmPatrolItem(patrolItem);
        this.initPatrolItem(tmPatrolItem, tmPatrolInfo);
        this.patrolItemService.save(tmPatrolItem);
        this.genReform(tmPatrolInfo, tmPatrolItem);
        return tmPatrolInfo.getId();
    }

    @Override
    @Transactional
    public void addPatrolFromBx(List<BxPatrolInfoDto> patrolInfoDtoList) throws ParseException, JsonProcessingException {
        if (patrolInfoDtoList == null) {
            return;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        for (BxPatrolInfoDto bxInfo : patrolInfoDtoList) {
            if (bxInfo == null) continue;
            if (this.existsPatrolBySourceId(bxInfo.getTaskCode())) {
                XxlJobHelper.log((String)"\u6807\u73ba\u5de1\u67e5\u6570\u636eid\u91cd\u590d\uff1a{}", (Object[])new Object[]{bxInfo.getTaskCode()});
                continue;
            }
            if (!StringUtils.hasLength((String)bxInfo.getJdSourceCode()) || bxInfo.getJdSourceCode().matches(".*[^0-9].*")) {
                String jsonString = objectMapper.writeValueAsString((Object)bxInfo);
                this.tmpExternalSourceDataMapper.insert(new TmExternalSourceData(jsonString, PatrolSourceTypeEnums.BX.getCode(), Integer.valueOf(2)));
                continue;
            }
            CompanyInfoDto company = this.companyMapper.selectCompanyInfo(Long.valueOf(bxInfo.getJdSourceCode()));
            if (company == null) {
                String jsonString = objectMapper.writeValueAsString((Object)bxInfo);
                this.tmpExternalSourceDataMapper.insert(new TmExternalSourceData(jsonString, PatrolSourceTypeEnums.BX.getCode()));
                continue;
            }
            TmPatrolInfo tmPatrolInfo = new TmPatrolInfo();
            TmPatrolItem tmPatrolItem = new TmPatrolItem();
            this.initPatrolForBx(company, bxInfo, tmPatrolInfo, tmPatrolItem);
        }
    }

    @Transactional
    public void initPatrolForBx(CompanyInfoDto company, BxPatrolInfoDto bxInfo, TmPatrolInfo tmPatrolInfo, TmPatrolItem tmPatrolItem) throws ParseException {
        tmPatrolInfo.setId(Long.valueOf(IdWorker.getId()));
        tmPatrolInfo.setUserId(null);
        tmPatrolInfo.setCid(company.getId());
        tmPatrolInfo.setUnitName(company.getName());
        tmPatrolInfo.setUnitStatus(company.getBusinessState());
        tmPatrolInfo.setManager(company.getManager());
        tmPatrolInfo.setTel(company.getTel());
        tmPatrolInfo.setHseManager(company.getHseManager());
        tmPatrolInfo.setHesTel(company.getHesTel());
        tmPatrolInfo.setAreaId(company.getAreaId());
        tmPatrolInfo.setAreaId1(company.getAreaId1());
        tmPatrolInfo.setAreaId2(company.getAreaId2());
        tmPatrolInfo.setAreaId3(company.getAreaId3());
        tmPatrolInfo.setAreaId4(company.getAreaId4());
        tmPatrolInfo.setAddress(company.getAreaName());
        tmPatrolInfo.setWorkAddress(company.getWorkAddress());
        tmPatrolInfo.setIndustryCode(company.getIndustryCategory() != null ? company.getIndustryCategory().toString() : null);
        tmPatrolInfo.setIndustryName(company.getIndustryCategoryName());
        tmPatrolInfo.setScaleCode(company.getScale() != null ? company.getScale().toString() : null);
        tmPatrolInfo.setEconomyCode(company.getRegisterType() != null ? company.getRegisterType().toString() : null);
        tmPatrolInfo.setEconomyName(company.getRegisterTypeName());
        tmPatrolInfo.setPatrolName(bxInfo.getTaskName());
        tmPatrolInfo.setYear(bxInfo.getYearNo());
        tmPatrolInfo.setPatrolPeople(bxInfo.getReportUserName());
        tmPatrolInfo.setPatrolTime(DateUtils.parseDate((String)bxInfo.getReportTime(), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
        tmPatrolInfo.setPatrolFile(this.handlePatrolFile(bxInfo.getTaskName(), bxInfo.getPicUrlList()));
        tmPatrolInfo.setPatrolStatus(PatrolStatusEnums.DONE.getCode());
        tmPatrolInfo.setDoneType(Integer.valueOf(0));
        tmPatrolInfo.setStopType(StopTypeEnums.NONE.getCode());
        tmPatrolInfo.setSourceType(PatrolSourceTypeEnums.BX.getCode());
        tmPatrolInfo.setSourceId(bxInfo.getTaskCode());
        tmPatrolInfo.setAcquisitionTime(new Date());
        this.patrolInfoService.save(tmPatrolInfo);
        tmPatrolItem.setId(Long.valueOf(IdWorker.getId()));
        tmPatrolItem.setCid(company.getId());
        tmPatrolItem.setPatrolId(tmPatrolInfo.getId());
        if (!CollectionUtils.isEmpty((Collection)bxInfo.getItemDTOS())) {
            bxInfo.getItemDTOS().forEach(item -> {
                String isProblem = item.getIsSelected();
                if (item.getItemCode() != null) {
                    switch (item.getItemCode()) {
                        case "4001": {
                            tmPatrolItem.setIfExistsDeclare(Integer.valueOf("1".equals(isProblem) ? 0 : 1));
                            break;
                        }
                        case "4002": {
                            tmPatrolItem.setIfExistsCheck(Integer.valueOf("1".equals(isProblem) ? 0 : 1));
                            break;
                        }
                        case "4003": {
                            tmPatrolItem.setIfExistsHealth(Integer.valueOf("1".equals(isProblem) ? 0 : 1));
                            break;
                        }
                        case "4004": {
                            tmPatrolItem.setIfExistsHseFile(Integer.valueOf("1".equals(isProblem) ? 0 : 1));
                            break;
                        }
                        case "4005": {
                            tmPatrolItem.setIfExistsTrain(Integer.valueOf("1".equals(isProblem) ? 0 : 1));
                            break;
                        }
                        case "4006": {
                            if ("1".equals(isProblem)) {
                                tmPatrolItem.setIfExistsThree(Integer.valueOf(0));
                                break;
                            }
                            if ("0".equals(isProblem)) {
                                tmPatrolItem.setIfExistsThree(Integer.valueOf(1));
                                break;
                            }
                            if (!"2".equals(isProblem)) break;
                            tmPatrolItem.setIfExistsThree(Integer.valueOf(2));
                            break;
                        }
                        case "4007": {
                            tmPatrolItem.setIfExistsPpe(Integer.valueOf("1".equals(isProblem) ? 0 : 1));
                            break;
                        }
                        case "4008": {
                            tmPatrolItem.setIfExistsWarning(Integer.valueOf("1".equals(isProblem) ? 0 : 1));
                            break;
                        }
                    }
                }
            });
        }
        this.patrolItemService.save(tmPatrolItem);
    }

    public Long initPatrolForDy(TmPatrolInfo patrolInfo, DyPatrolInfoParam param) {
        if (patrolInfo == null || param == null) {
            return null;
        }
        CompanyInfoDto company = this.companyMapper.selectCompanyInfo(param.getCid());
        if (company == null) {
            log.error("\u6ca1\u6709\u5f53\u524d\u4f01\u4e1a\u7684\u57fa\u7840\u4fe1\u606f\uff0c\u65e0\u6cd5\u5bfc\u5165\u5de1\u67e5\u6570\u636e");
            return -3L;
        }
        Integer patrolTotalNum = this.patrolInfoService.getPatrolTotalNum(param.getCid());
        patrolInfo.setPatrolName("\u7b2c" + (patrolTotalNum + 1) + "\u6b21-" + company.getName() + "\u5e2e\u6276");
        patrolInfo.setUnitName(company.getName());
        patrolInfo.setUnitStatus(company.getBusinessState());
        patrolInfo.setManager(company.getManager());
        patrolInfo.setTel(company.getTel());
        patrolInfo.setHseManager(company.getHseManager());
        patrolInfo.setHesTel(company.getHesTel());
        patrolInfo.setAreaId(company.getAreaId());
        patrolInfo.setAreaId1(company.getAreaId1());
        patrolInfo.setAreaId2(company.getAreaId2());
        patrolInfo.setAreaId3(company.getAreaId3());
        patrolInfo.setAreaId4(company.getAreaId4());
        patrolInfo.setAddress(company.getAreaName());
        patrolInfo.setWorkAddress(company.getWorkAddress());
        patrolInfo.setIndustryCode(company.getIndustryCategory() != null ? company.getIndustryCategory().toString() : null);
        patrolInfo.setIndustryName(company.getIndustryCategoryName());
        patrolInfo.setScaleCode(company.getScale() != null ? company.getScale().toString() : null);
        patrolInfo.setEconomyCode(company.getRegisterType() != null ? company.getRegisterType().toString() : null);
        patrolInfo.setEconomyName(company.getRegisterTypeName());
        patrolInfo.setPatrolFile(this.uploadOssUtil.uplod2Oss(param.getPatrolFileList()));
        String unitManageSignFileId = this.uploadOssUtil.uplod2Oss(param.getUnitManageSignFile());
        patrolInfo.setUnitManageSign(StringUtils.hasLength((String)unitManageSignFileId) && !unitManageSignFileId.equals("null") ? Long.valueOf(unitManageSignFileId) : null);
        patrolInfo.setSourceType(Integer.valueOf(2));
        patrolInfo.setCreateBy(Long.valueOf(1L));
        patrolInfo.setCreateDate(new Date());
        patrolInfo.setUpdateBy(Long.valueOf(1L));
        patrolInfo.setUpdateDate(patrolInfo.getCreateDate());
        patrolInfo.setIsValid(Boolean.valueOf(true));
        return null;
    }

    private void genReform(TmPatrolInfo info, TmPatrolItem item) {
        List<ReformListVo> reformVoList = this.transformItemForDy(info, item);
        Date date = new Date();
        ArrayList addParamList = new ArrayList();
        reformVoList.stream().forEach(reformVo -> {
            ReformAddParam basic = new ReformAddParam();
            basic.setCid(info.getCid());
            basic.setFinderName(info.getPatrolPeople());
            basic.setFindTime(date);
            basic.setName(reformVo.getReformName());
            basic.setReformItemSource(ReformSourceLiteEnum.TOWNSHIP_MANAGE.getValue());
            basic.setReformItemSourceId(info.getId());
            basic.setGenerationSource(reformVo.getReformGenerationSource());
            basic.setReformMeasure(reformVo.getReformMeasure());
            basic.setDescription(reformVo.getReformName());
            basic.setCreateBy(info.getUserId());
            addParamList.add(basic);
        });
        this.itemBasicNewService.generateReform(addParamList);
    }

    private List<ReformListVo> transformItemForDy(TmPatrolInfo info, TmPatrolItem item) {
        if (item == null) {
            return null;
        }
        String patrolName = info.getPatrolName();
        Integer year = info.getYear();
        List<RiskTypeVo> riskTypeList = this.reformManage.getRiskTypeList(info.getCid());
        ArrayList<ReformListVo> list = new ArrayList<ReformListVo>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(riskTypeList)) {
            for (RiskTypeVo risk : riskTypeList) {
                String riskCode = risk.getRiskTypeCode();
                String riskStatus = risk.getRiskTypeStatus();
                switch (riskCode) {
                    case "declare_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3") || item.getIfExistsDeclare() != 0) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5", "\u767b\u5f55\u201c\u6d59\u6c5f\u653f\u52a1\u670d\u52a1\u7f51\u201d\uff08https://www.zjzwfw.gov.cn/\uff09\uff0c\u641c\u7d22\u201c\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\u201d\u540e\uff0c\u5b8c\u6210\u76f8\u5e94\u5de5\u4f5c\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.DECLARE.getValue()));
                        break;
                    }
                    case "physicalExamination_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3") || item.getIfExistsHealth() != 0) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5", "\u59d4\u6258\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0\u673a\u6784\u5f00\u5c55\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\uff0c\u5e76\u53ca\u65f6\u5c06\u68c0\u67e5\u7ed3\u679c\u53ca\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u673a\u6784\u7684\u5efa\u8bae\u4ee5\u4e66\u9762\u5f62\u5f0f\u5982\u5b9e\u544a\u77e5\u52b3\u52a8\u8005\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.TJ.getValue()));
                        break;
                    }
                    case "detection_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3") || item.getIfExistsCheck() != 0) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7", "\u59d4\u6258\u6709\u8d44\u8d28\u7684\u804c\u4e1a\u536b\u751f\u6280\u672f\u670d\u52a1\u673a\u6784\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.DETECTION.getValue()));
                        break;
                    }
                    case "training_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3") || item.getIfExistsTrain() != 0) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u4e0e\u7ba1\u7406\u4eba\u5458\u5747\u672a\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad", "\u4f01\u4e1a\u4e3b\u8981\u8d1f\u8d23\u4eba\u548c\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458\u53ef\u901a\u8fc7\u201c\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u201d\uff08https://ohonline.wsjkw.zj.gov.cn/login\uff09-\u7528\u4eba\u5355\u4f4d\u7aef-\u5728\u7ebf\u57f9\u8bad\u6a21\u5757\u6216\u5176\u4ed6\u536b\u751f\u5065\u5eb7\u76d1\u7763\u6267\u6cd5\u673a\u6784\u8ba4\u53ef\u65b9\u5f0f\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.TRAIN.getValue()));
                        break;
                    }
                    case "threeTime_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3") || item.getIfExistsThree() == null || item.getIfExistsThree() != 0) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u5efa\u8bbe\u9879\u76ee\u201d\u4e09\u540c\u65f6\u201c", "\u4f9d\u636e\u300a\u5efa\u8bbe\u9879\u76ee\u804c\u4e1a\u75c5\u9632\u62a4\u8bbe\u65bd\u201c\u4e09\u540c\u65f6\u201d\u76d1\u7763\u7ba1\u7406\u529e\u6cd5\u300b\uff08\u539f\u56fd\u5bb6\u5b89\u5168\u751f\u4ea7\u76d1\u7763\u7ba1\u7406\u603b\u5c40\u4ee4\u7b2c90\u53f7\uff09\u7684\u8981\u6c42\u5f00\u5c55\u5efa\u8bbe\u9879\u76ee\u201c\u4e09\u540c\u65f6\u201d\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.THREE_TIME.getValue()));
                        break;
                    }
                    case "protective_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3") || item.getIfExistsPpe() == null || item.getIfExistsPpe() != 0) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u914d\u5907\u4e2a\u4eba\u9632\u62a4\u7528\u54c1", "\u4e3a\u52b3\u52a8\u8005\u63d0\u4f9b\u7b26\u5408\u56fd\u5bb6\u6807\u51c6\u6216\u8005\u884c\u4e1a\u6807\u51c6\u7684\u52b3\u52a8\u9632\u62a4\u7528\u54c1\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.PROTECTION.getValue()));
                        break;
                    }
                    case "warningMark_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3") || item.getIfExistsWarning() == null || item.getIfExistsWarning() != 0) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u8bbe\u7f6e\u8b66\u793a\u6807\u8bc6", "\u6839\u636e\u300a\u5de5\u4f5c\u573a\u6240\u804c\u4e1a\u75c5\u5371\u5bb3\u8b66\u793a\u6807\u8bc6\u300b\uff08GBZ158\uff09\u548c\u300a\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u75c5\u5371\u5bb3\u544a\u77e5\u4e0e\u8b66\u793a\u6807\u8bc6\u7ba1\u7406\u89c4\u8303\u300b\uff08\u5b89\u76d1\u603b\u5385\u5b89\u5065[2014]111\u53f7\uff09\u7b49\u6807\u51c6\u89c4\u8303\u8981\u6c42\u8bbe\u7f6e\u8b66\u793a\u6807\u8bc6\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.WARNING_SIGNS.getValue()));
                        break;
                    }
                    case "healthArchive_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3") || item.getIfExistsHseFile() == null || item.getIfExistsHseFile() != 0) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u5efa\u7acb\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u6863\u6848", "\u53ef\u53c2\u8003\u201c\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u201d\uff08https://ohonline.wsjkw.zj.gov.cn/login\uff09-\u7528\u4eba\u5355\u4f4d\u7aef-\u6863\u6848\u7ba1\u7406\u6a21\u5757\u529f\u80fd\uff0c\u5efa\u7acb\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u6863\u6848\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.ARCHIVES.getValue()));
                    }
                }
            }
        }
        return list;
    }

    private void initPatrolItem(TmPatrolItem patrolItem, TmPatrolInfo patrolInfo) {
        if (patrolItem == null) {
            return;
        }
        patrolItem.setPatrolId(patrolInfo.getId());
        patrolItem.setCid(patrolInfo.getCid());
        patrolItem.setCreateBy(Long.valueOf(1L));
        patrolItem.setCreateDate(new Date());
        patrolItem.setUpdateBy(Long.valueOf(1L));
        patrolItem.setUpdateDate(patrolItem.getCreateDate());
        patrolItem.setIsValid(Boolean.valueOf(true));
    }

    private void initReform(ReformItemBasic reformItemBasic, ReformItemBasicParam param) {
        if (reformItemBasic == null || param == null) {
            return;
        }
        CompanyInfoDto company = this.companyMapper.selectCompanyInfo(param.getCid());
        if (company == null) {
            return;
        }
        reformItemBasic.setAreaId(company.getAreaId());
        reformItemBasic.setAreaId1(company.getAreaId1());
        reformItemBasic.setAreaId2(company.getAreaId2());
        reformItemBasic.setAreaId3(company.getAreaId3());
        reformItemBasic.setAreaId4(company.getAreaId4());
        reformItemBasic.setReformItemSource(ReformSourceLiteEnum.TOWNSHIP_MANAGE.getValue());
        reformItemBasic.setAcceptanceObject(Byte.valueOf((byte)2));
        reformItemBasic.setDescription(param.getName());
        reformItemBasic.setCreateBy(param.getCid());
        reformItemBasic.setCreateDate(new Date());
        reformItemBasic.setUpdateBy(Long.valueOf(1L));
        reformItemBasic.setUpdateDate(reformItemBasic.getCreateDate());
        reformItemBasic.setIsValid(Boolean.valueOf(true));
        this.initReformOther(reformItemBasic);
    }

    private List<ReformItemAcceptanceRecord> initReformRecord(List<ReformItemAcceptanceRecordParam> reformRecordList, ReformItemBasic reformItemBasic) {
        if (reformRecordList == null) {
            return null;
        }
        ArrayList<ReformItemAcceptanceRecord> reformItemAcceptanceRecordList = new ArrayList<ReformItemAcceptanceRecord>();
        reformRecordList.forEach(param -> {
            ReformItemAcceptanceRecord record = this.patrolConverter.ReformItemAcceptanceRecordParam2ReformItemAcceptanceRecord((ReformItemAcceptanceRecordParam)param);
            record.setCid(reformItemBasic.getCid());
            record.setReformItemId(reformItemBasic.getId());
            record.setReformNotification(this.uploadOssUtil.uplod2Oss(param.getReformNotification()));
            record.setReformFinishedFiles(this.uploadOssUtil.uplod2Oss(param.getReformFinishedFiles()));
            record.setAcceptanceFiles(this.uploadOssUtil.uplod2Oss(param.getAcceptanceFiles()));
            record.setCreateBy(Long.valueOf(1L));
            record.setCreateDate(new Date());
            record.setUpdateBy(Long.valueOf(1L));
            record.setUpdateDate(reformItemBasic.getCreateDate());
            record.setIsValid(Boolean.valueOf(true));
            reformItemAcceptanceRecordList.add(record);
        });
        return reformItemAcceptanceRecordList;
    }

    private void initReformOther(ReformItemBasic basic) {
        basic.setDataSource(Byte.valueOf((byte)3));
        ReformItemBasic lastBasic = this.reformItemBasicMapper.selectNewBasicForAdd(basic.getCid(), (int)basic.getGenerationSource());
        if (lastBasic == null) {
            basic.setIsShowInReformModular(Boolean.valueOf(true));
            basic.setBatchNum(Integer.valueOf(1));
        } else if (Objects.equals(lastBasic.getStatus(), ReformStatusEnum.WC.getValue())) {
            basic.setIsShowInReformModular(Boolean.valueOf(true));
            basic.setBatchNum(this.reformItemBasicMapper.selectMaxBatchNum(basic.getCid(), (int)basic.getGenerationSource()));
        } else {
            basic.setIsShowInReformModular(Boolean.valueOf(false));
            basic.setBatchNum(lastBasic.getBatchNum());
        }
    }

    private boolean isExistsPatrol(Long cid, String patrolName, Integer year) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(TmPatrolInfo.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TmPatrolInfo::getCid, (Object)cid)).eq(TmPatrolInfo::getYear, (Object)year)).eq(TmPatrolInfo::getPatrolName, (Object)patrolName)).eq(TmPatrolInfo::getIsValid, (Object)1)).last("limit 1")).select(new SFunction[]{TmPatrolInfo::getId});
        return this.patrolInfoService.getOne((Wrapper)wrapper) != null;
    }

    private boolean isExistsPatrolForDy(Long cid, String sourceId, Integer year) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(TmPatrolInfo.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TmPatrolInfo::getCid, (Object)cid)).eq(TmPatrolInfo::getYear, (Object)year)).eq(TmPatrolInfo::getSourceId, (Object)sourceId)).eq(TmPatrolInfo::getSourceType, (Object)2)).eq(TmPatrolInfo::getIsValid, (Object)1)).last("limit 1")).select(new SFunction[]{TmPatrolInfo::getId});
        return this.patrolInfoService.getOne((Wrapper)wrapper) != null;
    }

    private boolean existsPatrolBySourceId(String sourceId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(TmPatrolInfo.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TmPatrolInfo::getSourceId, (Object)sourceId)).eq(TmPatrolInfo::getIsValid, (Object)1)).last("limit 1")).select(new SFunction[]{TmPatrolInfo::getId});
        return this.patrolInfoService.getOne((Wrapper)wrapper) != null;
    }

    private boolean isExistsReformItemSn(String reformItemSn) {
        return this.reformItemBasicMapper.getByReformItemSn(reformItemSn) != null;
    }

    private String handlePatrolFile(String patrolName, List<String> picUrlList) {
        if (CollectionUtils.isEmpty(picUrlList)) {
            return null;
        }
        ArrayList<FileParam> fileParamList = new ArrayList<FileParam>();
        for (int i = 0; i < picUrlList.size(); ++i) {
            FileParam fileParam = new FileParam();
            fileParam.setFileUrl(picUrlList.get(i));
            fileParam.setFileName(patrolName + "_" + i);
            fileParamList.add(fileParam);
        }
        return this.uploadOssUtil.uplod2Oss(fileParamList);
    }

    private Date getLastAcquisitionDateForBx() {
        return this.patrolInfoService.getLastAcquisitionDateBySourceType(PatrolSourceTypeEnums.BX.getCode());
    }

    @Override
    public String getBxToken() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String appId = this.bxAppId;
        String appSecret = this.bxAppSecret;
        String dateTimeString = sdf.format(new Date());
        String sign = MD5Utils.getMD5String((String)(appId + appSecret + dateTimeString));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appId", appId);
        param.put("sign", sign);
        param.put("requestTime", dateTimeString);
        String body = JSONUtil.toJsonStr(param);
        HttpResponse response = ((HttpRequest)HttpRequest.post((String)this.tokenUrl).body(body).header("Content-Type", "application/json")).execute();
        Map map = (Map)JSONUtil.toBean((String)response.body(), HashMap.class);
        if (response.getStatus() != 200 || !map.get("code").toString().equals("10200")) {
            log.error("\u6807\u73ba\u83b7\u53d6token\u5931\u8d25\uff0curl:{},body:{},response:{}", new Object[]{this.tokenUrl, body, response});
            return null;
        }
        return (String)map.get("data");
    }

    @Override
    public List<BxPatrolInfoDto> getBxPatrolInfoList(BxSearchPatrolParam param) {
        ArrayList<BxPatrolInfoDto> rst = new ArrayList<BxPatrolInfoDto>();
        if (param.getPageSize() == null) {
            param.setPageSize(Integer.valueOf(10));
        }
        if (param.getReportStartDay() == null) {
            Date lastAcquisitionDate = this.patrolInfoService.getLastAcquisitionDateBySourceType(PatrolSourceTypeEnums.BX.getCode());
            if (lastAcquisitionDate == null) {
                param.setReportStartDay(null);
                param.setReportEndDay(null);
            } else {
                param.setReportStartDay(lastAcquisitionDate);
                param.setReportEndDay(new Date());
            }
        }
        HashMap<String, Object> httpParams = new HashMap<String, Object>();
        httpParams.put("areaCode", param.getAreaCode());
        httpParams.put("xqAreaCodeRightLike", param.getXqAreaCodeRightLike());
        httpParams.put("yearNo", param.getYearNo());
        httpParams.put("timeType", param.getTimeType());
        httpParams.put("taskCode", param.getTaskCode());
        httpParams.put("jdSourceId", param.getJdSourceId());
        httpParams.put("reportStartDay", param.getReportStartDay() != null ? DateFormatUtils.format((Date)param.getReportStartDay(), (String)"yyyy-MM-dd HH:mm:ss") : null);
        httpParams.put("reportEndDay", param.getReportEndDay() != null ? DateFormatUtils.format((Date)param.getReportEndDay(), (String)"yyyy-MM-dd HH:mm:ss") : null);
        httpParams.put("pageIndex", param.getPageIndex());
        httpParams.put("pageSize", param.getPageSize());
        Map<String, Object> filteredParams = httpParams.entrySet().stream().filter(entry -> entry.getValue() != null && (!(entry.getValue() instanceof String) || !((String)entry.getValue()).isEmpty())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String query = URLUtil.buildQuery(filteredParams, (Charset)StandardCharsets.UTF_8);
        XxlJobHelper.log((String)("\u6253\u5370\u83b7\u53d6\u5de1\u67e5\u6570\u636e\u7684\u8bf7\u6c42\u53c2\u6570: " + query), (Object[])new Object[0]);
        HttpRequest request = (HttpRequest)HttpRequest.get((String)this.pageUrl).body(query).header("token", param.getToken());
        HttpResponse response = request.execute();
        ObjectMapper mapper = new ObjectMapper();
        try {
            PatrolResponseBodyDto responseBodyDto = (PatrolResponseBodyDto)mapper.readValue(response.body(), PatrolResponseBodyDto.class);
            if (response.getStatus() != 200 || !responseBodyDto.getCode().equals("10200")) {
                log.error("\u6807\u73ba\u83b7\u53d6\u5de1\u67e5\u6570\u636e\u5931\u8d25\uff0curl:{},body:{},response:{}", new Object[]{this.pageUrl, query, response});
                XxlJobHelper.log((String)"\u6807\u73ba\u83b7\u53d6\u5de1\u67e5\u6570\u636e\u5931\u8d25\uff0curl:{},body:{},response:{}", (Object[])new Object[]{this.pageUrl, query, response});
                return null;
            }
            PatrolResponseBodyDataDto responseBodyData = responseBodyDto.getData();
            Integer pages = responseBodyData.getPages();
            rst.addAll(responseBodyData.getRecords());
            XxlJobHelper.log((String)"\u67e5\u8be2\u603b\u6570:{}, \u603b\u9875\u6570:{}", (Object[])new Object[]{responseBodyData.getTotal(), pages});
            if (pages > 1) {
                for (int i = 2; i <= pages; ++i) {
                    httpParams.put("pageIndex", i);
                    filteredParams = httpParams.entrySet().stream().filter(entry -> entry.getValue() != null && (!(entry.getValue() instanceof String) || !((String)entry.getValue()).isEmpty())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    query = URLUtil.buildQuery(filteredParams, (Charset)StandardCharsets.UTF_8);
                    request = (HttpRequest)HttpRequest.get((String)this.pageUrl).body(query).header("token", param.getToken());
                    response = request.execute();
                    responseBodyDto = (PatrolResponseBodyDto)mapper.readValue(response.body(), PatrolResponseBodyDto.class);
                    if (response.getStatus() != 200 || !responseBodyDto.getCode().equals("10200")) {
                        log.error("\u6807\u73ba\u83b7\u53d6\u5de1\u67e5\u6570\u636e\u5931\u8d25\uff0curl:{},body:{},response:{}", new Object[]{this.pageUrl, query, response});
                        XxlJobHelper.log((String)"\u6807\u73ba\u83b7\u53d6\u5de1\u67e5\u6570\u636e\u5931\u8d25\uff0curl:{},body:{},response:{}", (Object[])new Object[]{this.pageUrl, query, response});
                        return null;
                    }
                    rst.addAll(responseBodyDto.getData().getRecords());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rst;
    }

    @Override
    @Transactional
    public void reStorageBxData(List<Long> idList) throws JsonProcessingException, ParseException {
        List<TmExternalSourceData> sourceDataList = this.tmpExternalSourceDataMapper.listAllDataById(idList);
        ObjectMapper mapper = new ObjectMapper();
        for (TmExternalSourceData sourceData2 : sourceDataList) {
            BxPatrolInfoDto bxInfo = (BxPatrolInfoDto)mapper.readValue(sourceData2.getSourceData(), BxPatrolInfoDto.class);
            if (this.existsPatrolBySourceId(bxInfo.getTaskCode())) {
                sourceData2.setIsProcessed(Integer.valueOf(1));
                continue;
            }
            if (!StringUtils.hasLength((String)bxInfo.getJdSourceCode()) || bxInfo.getJdSourceCode().matches(".*[^0-9].*")) {
                sourceData2.setType(Integer.valueOf(2));
                continue;
            }
            CompanyInfoDto company = this.companyMapper.selectCompanyInfo(Long.valueOf(bxInfo.getJdSourceCode()));
            if (company == null) continue;
            TmPatrolInfo tmPatrolInfo = new TmPatrolInfo();
            TmPatrolItem tmPatrolItem = new TmPatrolItem();
            this.initPatrolForBx(company, bxInfo, tmPatrolInfo, tmPatrolItem);
            this.patrolInfoService.save(tmPatrolInfo);
            this.patrolItemService.save(tmPatrolItem);
            sourceData2.setIsProcessed(Integer.valueOf(1));
        }
        List collect = sourceDataList.stream().filter(sourceData -> sourceData.getIsProcessed() == 1).collect(Collectors.toList());
        this.externalSourceDataService.updateBatchById(collect);
    }

    @Generated
    public SynPatrolServiceImpl(IPatrolManage patrolManage, ITmPatrolInfoService patrolInfoService, ITmPatrolItemService patrolItemService, ITmExternalSourceDataService externalSourceDataService, TmXzxgSecretMapper xzxgSecretMapper, CompanyMapper companyMapper, SynPatrolConverter patrolConverter, UploadOssUtil uploadOssUtil, ReformItemBasicMapper reformItemBasicMapper, RedisTemplate redisTemplate, TmExternalSourceDataMapper tmpExternalSourceDataMapper) {
        this.patrolManage = patrolManage;
        this.patrolInfoService = patrolInfoService;
        this.patrolItemService = patrolItemService;
        this.externalSourceDataService = externalSourceDataService;
        this.xzxgSecretMapper = xzxgSecretMapper;
        this.companyMapper = companyMapper;
        this.patrolConverter = patrolConverter;
        this.uploadOssUtil = uploadOssUtil;
        this.reformItemBasicMapper = reformItemBasicMapper;
        this.redisTemplate = redisTemplate;
        this.tmpExternalSourceDataMapper = tmpExternalSourceDataMapper;
    }
}

