/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.syn.service;

import cn.smarthse.framework.core.utils.StringUtils;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import lombok.Generated;

public abstract class JwtUtil {
    public static String getAppId(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("appId").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean verify(String token, String secret) {
        if (StringUtils.isBlank((CharSequence)secret)) {
            return false;
        }
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("appId", JwtUtil.getAppId(token)).build();
            verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException exception) {
            return false;
        }
    }

    public static boolean verify(String token, String tokenSecret, String audience) {
        if (StringUtils.isBlank((CharSequence)tokenSecret)) {
            return false;
        }
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)tokenSecret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("appId", JwtUtil.getAppId(token)).withAudience(new String[]{audience}).build();
            verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException exception) {
            return false;
        }
    }

    @Generated
    public JwtUtil() {
    }
}

