/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.syn.provider;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.PhoneUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.dy.dy.dto.api.SendOrdinarySmsDto;
import cn.smarthse.dy.dy.entity.DyOrganizationUser;
import cn.smarthse.dy.dy.entity.DyServiceGuidanceRecords;
import cn.smarthse.dy.dy.entity.DySmsTemplate;
import cn.smarthse.dy.dy.enums.DySmsTemplateTypeEnum;
import cn.smarthse.dy.dy.provider.IDyOrganizationUserProviderService;
import cn.smarthse.dy.dy.provider.IDyServiceGuidanceRecordsProviderService;
import cn.smarthse.dy.dy.provider.IDySmsTemplateProviderService;
import cn.smarthse.dy.dy.provider.IMasProviderService;
import cn.smarthse.modules.datacentre.entity.CompanyProposedChange;
import cn.smarthse.modules.datacentre.enums.StopDataSourceEnums;
import cn.smarthse.modules.datacentre.enums.StopStatusEnums;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeClueLastParam;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProposedChangeProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.vo.work.reform.ReformAddParam;
import cn.smarthse.modules.health.vo.work.reform.RiskTypeVo;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.township.manage.dao.dynamic.bigdata.CompanyMapper;
import cn.smarthse.township.manage.dao.manager.TmPatrolInfoMapper;
import cn.smarthse.township.manage.entity.manage.TmPatrolInfo;
import cn.smarthse.township.manage.entity.manage.TmPatrolItem;
import cn.smarthse.township.manage.manage.IReformManage;
import cn.smarthse.township.manage.model.vo.ReformListVo;
import cn.smarthse.township.manage.service.manage.ITmPatrolInfoService;
import cn.smarthse.township.manage.service.manage.ITmPatrolItemService;
import cn.smarthse.township.syn.converter.SynPatrolConverter;
import cn.smarthse.township.syn.model.dto.CompanyInfoDto;
import cn.smarthse.township.syn.param.DyPatrolAddParam;
import cn.smarthse.township.syn.param.DyPatrolInfoParam;
import cn.smarthse.township.syn.param.DyPatrolItemParam;
import cn.smarthse.township.syn.provider.ISynPatrolServiceProvider;
import cn.smarthse.township.syn.service.ISynPatrolService;
import cn.smarthse.township.syn.service.UploadOssUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@DubboService
@Transactional(readOnly=true)
public class ISynPatrolServiceProviderImpl
implements ISynPatrolServiceProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ISynPatrolServiceProviderImpl.class);
    private final ISynPatrolService iSynPatrolService;
    private final CompanyMapper companyMapper;
    private final TmPatrolInfoMapper tmPatrolInfoMapper;
    private final ITmPatrolInfoService patrolInfoService;
    private final ITmPatrolItemService patrolItemService;
    private final SynPatrolConverter patrolConverter;
    private final UploadOssUtil uploadOssUtil;
    @DubboReference
    private IReformItemBasicNewService itemBasicNewService;
    @Autowired
    private IReformManage reformManage;
    @DubboReference
    private IMasProviderService masService;
    @DubboReference
    private IDySmsTemplateProviderService dySmsTemplateService;
    @DubboReference
    private IDyOrganizationUserProviderService dyOrganizationUserService;
    @DubboReference
    private IDyServiceGuidanceRecordsProviderService dyServiceGuidanceRecordsService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    private ICompanyProposedChangeProviderService companyProposedChangeProviderService;

    @Transactional
    public Long addPatrolForDy(DyPatrolAddParam param) {
        DyPatrolInfoParam patrolInfo = param.getPatrolInfo();
        DyPatrolItemParam patrolItem = param.getPatrolItem();
        DyOrganizationUser dyUser = this.dyOrganizationUserService.getOneByDataSourceId(patrolInfo.getDataSourceId());
        if (dyUser == null) {
            return -2L;
        }
        Long transformCid = this.companyMapper.getTransformCid(patrolInfo.getExternalSystemCompanyId());
        patrolInfo.setCid(transformCid);
        CompanyInfoDto company = this.companyMapper.selectCompanyInfo(patrolInfo.getCid());
        if (company == null) {
            log.error("\u6ca1\u6709\u5f53\u524d\u4f01\u4e1a\u7684\u57fa\u7840\u4fe1\u606f\uff0c\u65e0\u6cd5\u5bfc\u5165\u5de1\u67e5\u6570\u636e");
            return -3L;
        }
        if (this.isExistsPatrolForDy(patrolInfo.getCid(), patrolInfo.getSourceId(), patrolInfo.getYear())) {
            log.error(String.format("\u5df2\u5b58\u5728\u5bfc\u5165id\u4e3a\u201c%s\u201d\u7684\u5de1\u67e5", patrolInfo.getSourceId()));
            return -1L;
        }
        TmPatrolInfo tmPatrolInfo = this.patrolConverter.DyPatrolParam2TmPatrolInfo(patrolInfo);
        Long r = this.initPatrolForDy(company, dyUser, tmPatrolInfo, patrolInfo);
        if (r != null) {
            return r;
        }
        this.patrolInfoService.save(tmPatrolInfo);
        TmPatrolItem tmPatrolItem = this.patrolConverter.DyPatrolItemParam2TmPatrolItem(patrolItem);
        this.initPatrolItemForDy(tmPatrolItem, tmPatrolInfo);
        this.patrolItemService.save(tmPatrolItem);
        List<SendOrdinarySmsDto> smsList = this.judgeSmsTypeForCompany(company, param, tmPatrolInfo, tmPatrolItem);
        this.genReform(tmPatrolInfo, tmPatrolItem);
        if (!CollectionUtils.isEmpty(smsList)) {
            for (SendOrdinarySmsDto sms : smsList) {
                this.sendOrdinarySmsByType(sms);
            }
        }
        return tmPatrolInfo.getId();
    }

    private boolean isExistsPatrolForDy(Long cid, String sourceId, Integer year) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(TmPatrolInfo.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TmPatrolInfo::getSourceId, (Object)sourceId)).eq(TmPatrolInfo::getSourceType, (Object)2)).eq(TmPatrolInfo::getIsValid, (Object)1)).last("limit 1")).select(new SFunction[]{TmPatrolInfo::getId});
        return this.patrolInfoService.getOne((Wrapper)wrapper) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Long initPatrolForDy(CompanyInfoDto company, DyOrganizationUser dyUser, TmPatrolInfo patrolInfo, DyPatrolInfoParam param) {
        block10: {
            CompanyProposedChange entity;
            block13: {
                Boolean historicalData;
                LocalDateTime now;
                Long cid;
                Long userId;
                Long sourceId;
                Integer stopType;
                block11: {
                    List clueList;
                    block12: {
                        if (patrolInfo == null || param == null) {
                            return null;
                        }
                        patrolInfo.setId(Long.valueOf(IdWorker.getId()));
                        Integer patrolTotalNum = this.patrolInfoService.getPatrolTotalNum(param.getCid());
                        patrolInfo.setPatrolName("\u7b2c" + (patrolTotalNum + 1) + "\u6b21-" + company.getName() + "\u5e2e\u6276");
                        patrolInfo.setUserId(dyUser.getId());
                        patrolInfo.setUnitName(company.getName());
                        patrolInfo.setManager(company.getManager());
                        patrolInfo.setTel(company.getTel());
                        patrolInfo.setHseManager(company.getHseManager());
                        patrolInfo.setHesTel(company.getHesTel());
                        patrolInfo.setAreaId(company.getAreaId());
                        patrolInfo.setAreaId1(company.getAreaId1());
                        patrolInfo.setAreaId2(company.getAreaId2());
                        patrolInfo.setAreaId3(company.getAreaId3());
                        patrolInfo.setAreaId4(company.getAreaId4());
                        patrolInfo.setAddress(company.getAreaName());
                        patrolInfo.setWorkAddress(company.getWorkAddress());
                        patrolInfo.setIndustryCode(company.getIndustryCategory() != null ? company.getIndustryCategory().toString() : null);
                        patrolInfo.setIndustryName(company.getIndustryCategoryName());
                        patrolInfo.setScaleCode(company.getScale() != null ? company.getScale().toString() : null);
                        patrolInfo.setEconomyCode(company.getRegisterType() != null ? company.getRegisterType().toString() : null);
                        patrolInfo.setEconomyName(company.getRegisterTypeName());
                        patrolInfo.setPatrolFile(this.uploadOssUtil.uplod2Oss(param.getPatrolFileList()));
                        String unitManageSignFileId = this.uploadOssUtil.uplod2Oss(param.getUnitManageSignFile());
                        patrolInfo.setUnitManageSign(StringUtils.hasLength((String)unitManageSignFileId) && !unitManageSignFileId.equals("null") ? Long.valueOf(unitManageSignFileId) : null);
                        patrolInfo.setSourceType(Integer.valueOf(2));
                        patrolInfo.setCreateBy(Long.valueOf(1L));
                        patrolInfo.setCreateDate(new Date());
                        patrolInfo.setUpdateBy(Long.valueOf(1L));
                        patrolInfo.setUpdateDate(patrolInfo.getCreateDate());
                        patrolInfo.setIsValid(Boolean.valueOf(true));
                        if (param.getUnitStatus() == company.getBusinessState()) break block10;
                        stopType = StopTypeEnums.PAUSE.getCode();
                        if (param.getUnitStatus() != 0) break block10;
                        sourceId = patrolInfo.getId();
                        userId = -1L;
                        cid = company.getId();
                        now = LocalDateTime.now();
                        historicalData = false;
                        stopType = StopTypeEnums.CLOSE.getCode();
                        CompanyProposedChangeClueLastParam clueLastParam = new CompanyProposedChangeClueLastParam();
                        clueLastParam.setStopDataSource(StopDataSourceEnums.XZXG.getCode());
                        clueLastParam.setCid(param.getCid());
                        if (StopTypeEnums.CLOSE.getCode().equals(stopType) || StopTypeEnums.NORMAL.getCode().equals(stopType)) {
                            clueLastParam.setStopTypeList(Arrays.asList(StopTypeEnums.CLOSE.getCode(), StopTypeEnums.NORMAL.getCode()));
                        } else {
                            clueLastParam.setStopTypeList(Arrays.asList(StopTypeEnums.CHANGECROSS.getCode(), StopTypeEnums.CHANGEWITHIN.getCode(), StopTypeEnums.CHANGEDISTRICTWITHIN.getCode()));
                        }
                        clueList = this.companyProposedChangeProviderService.getClueList(clueLastParam);
                        clueList = clueList.stream().filter(i -> StopStatusEnums.PENDING_CONFIRMATION.getCode().equals(i.getStatus()) || StopStatusEnums.PROCESS.getCode().equals(i.getStatus())).collect(Collectors.toList());
                        if (!CollUtil.isNotEmpty(clueList)) break block11;
                        Map<String, CompanyProposedChange> clueMap = clueList.stream().collect(Collectors.toMap(CompanyProposedChange::getSourceId, companyProposedChange -> companyProposedChange, (v1, v2) -> v2));
                        entity = clueMap.get(sourceId);
                        if (!Objects.nonNull(entity)) break block12;
                        if (Objects.equals(entity.getSourceId(), sourceId)) {
                            if (!StopStatusEnums.PENDING_CONFIRMATION.getCode().equals(entity.getStatus())) {
                                log.warn(String.format("\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u7ebf\u7d22\u72b6\u6001\u662f %s", StopStatusEnums.getName((Integer)entity.getStatus())));
                                return null;
                            }
                            entity.setStopType(stopType);
                            entity.setConfirmTime(null);
                            entity.setUpdateBy(userId);
                            entity.setUpdateDate(now);
                            entity.setHistoricalData(historicalData);
                            break block13;
                        } else if (StopTypeEnums.CLOSE.getCode().equals(stopType)) {
                            if (!StopStatusEnums.PENDING_CONFIRMATION.getCode().equals(entity.getStatus())) {
                                log.warn(String.format("\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u7ebf\u7d22\u72b6\u6001\u662f %s\uff0c\u65e0\u6cd5\u65b0\u589e", StopStatusEnums.getName((Integer)entity.getStatus())));
                                return null;
                            }
                            entity = new CompanyProposedChange();
                            entity.setStopDataSource(StopDataSourceEnums.XZXG.getCode());
                            entity.setSourceId(String.valueOf(sourceId));
                            entity.setCid(cid);
                            entity.setStopType(stopType);
                            entity.setStatus(StopStatusEnums.PENDING_CONFIRMATION.getCode());
                            entity.setConfirmTime(null);
                            entity.setCreateBy(userId);
                            entity.setCreateDate(now);
                            entity.setUpdateBy(userId);
                            entity.setUpdateDate(now);
                            entity.setIsValid(Boolean.valueOf(true));
                            entity.setHistoricalData(historicalData);
                        }
                        break block13;
                    }
                    if (StopTypeEnums.CLOSE.getCode().equals(stopType)) {
                        for (CompanyProposedChange existing : clueList) {
                            if (!stopType.equals(existing.getStopType())) continue;
                            log.warn(String.format("\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u65e0\u6cd5\u65b0\u589e", new Object[0]));
                            return null;
                        }
                    }
                    entity = new CompanyProposedChange();
                    entity.setStopDataSource(StopDataSourceEnums.XZXG.getCode());
                    entity.setSourceId(String.valueOf(sourceId));
                    entity.setCid(cid);
                    entity.setStopType(stopType);
                    entity.setStatus(StopStatusEnums.PENDING_CONFIRMATION.getCode());
                    entity.setConfirmTime(null);
                    entity.setCreateBy(userId);
                    entity.setCreateDate(now);
                    entity.setUpdateBy(userId);
                    entity.setUpdateDate(now);
                    entity.setIsValid(Boolean.valueOf(true));
                    entity.setHistoricalData(historicalData);
                    break block13;
                }
                entity = new CompanyProposedChange();
                entity.setStopDataSource(StopDataSourceEnums.XZXG.getCode());
                entity.setSourceId(String.valueOf(sourceId));
                entity.setCid(cid);
                entity.setStopType(stopType);
                entity.setStatus(StopStatusEnums.PENDING_CONFIRMATION.getCode());
                entity.setConfirmTime(null);
                entity.setCreateBy(userId);
                entity.setCreateDate(now);
                entity.setUpdateBy(userId);
                entity.setUpdateDate(now);
                entity.setIsValid(Boolean.valueOf(true));
                entity.setHistoricalData(historicalData);
            }
            entity.setBeforeAreaId(company.getAreaId());
            entity.setBeforeBusinessState(company.getBusinessState());
            this.companyProposedChangeProviderService.saveOrUpdate(entity);
        }
        return null;
    }

    private void initPatrolItemForDy(TmPatrolItem patrolItem, TmPatrolInfo patrolInfo) {
        if (patrolItem == null) {
            return;
        }
        patrolItem.setPatrolId(patrolInfo.getId());
        patrolItem.setCid(patrolInfo.getCid());
        patrolItem.setCreateBy(Long.valueOf(1L));
        patrolItem.setCreateDate(new Date());
        patrolItem.setUpdateBy(Long.valueOf(1L));
        patrolItem.setUpdateDate(patrolItem.getCreateDate());
        patrolItem.setIsValid(Boolean.valueOf(true));
    }

    private void genReform(TmPatrolInfo info, TmPatrolItem item) {
        List<ReformListVo> reformVoList = this.transformItemForDy(info, item);
        Date date = new Date();
        ArrayList addParamList = new ArrayList();
        reformVoList.stream().forEach(reformVo -> {
            ReformAddParam basic = new ReformAddParam();
            basic.setCid(info.getCid());
            basic.setFinderName(info.getPatrolPeople());
            basic.setFindTime(date);
            basic.setName(reformVo.getReformName());
            basic.setReformItemSource(ReformSourceLiteEnum.TOWNSHIP_MANAGE.getValue());
            basic.setReformItemSourceId(info.getId());
            basic.setGenerationSource(reformVo.getReformGenerationSource());
            basic.setReformMeasure(reformVo.getReformMeasure());
            basic.setDescription(reformVo.getReformName());
            basic.setCreateBy(info.getUserId());
            addParamList.add(basic);
        });
        this.itemBasicNewService.generateReform(addParamList);
    }

    private List<ReformListVo> transformItemForDy(TmPatrolInfo info, TmPatrolItem item) {
        if (item == null) {
            return null;
        }
        String patrolName = info.getPatrolName();
        Integer year = info.getYear();
        List<RiskTypeVo> riskTypeList = this.reformManage.getRiskTypeList(info.getCid());
        ArrayList<ReformListVo> list = new ArrayList<ReformListVo>();
        if (!CollectionUtils.isEmpty(riskTypeList)) {
            for (RiskTypeVo risk : riskTypeList) {
                String riskCode = risk.getRiskTypeCode();
                String riskStatus = risk.getRiskTypeStatus();
                switch (riskCode) {
                    case "declare_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3")) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5", "\u767b\u5f55\u201c\u6d59\u6c5f\u653f\u52a1\u670d\u52a1\u7f51\u201d\uff08https://www.zjzwfw.gov.cn/\uff09\uff0c\u641c\u7d22\u201c\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\u201d\u540e\uff0c\u5b8c\u6210\u76f8\u5e94\u5de5\u4f5c\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.DECLARE.getValue()));
                        break;
                    }
                    case "physicalExamination_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3")) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5", "\u59d4\u6258\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0\u673a\u6784\u5f00\u5c55\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\uff0c\u5e76\u53ca\u65f6\u5c06\u68c0\u67e5\u7ed3\u679c\u53ca\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u673a\u6784\u7684\u5efa\u8bae\u4ee5\u4e66\u9762\u5f62\u5f0f\u5982\u5b9e\u544a\u77e5\u52b3\u52a8\u8005\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.TJ.getValue()));
                        break;
                    }
                    case "detection_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3")) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7", "\u59d4\u6258\u6709\u8d44\u8d28\u7684\u804c\u4e1a\u536b\u751f\u6280\u672f\u670d\u52a1\u673a\u6784\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.DETECTION.getValue()));
                        break;
                    }
                    case "training_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3")) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u4e0e\u7ba1\u7406\u4eba\u5458\u5747\u672a\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad", "\u4f01\u4e1a\u4e3b\u8981\u8d1f\u8d23\u4eba\u548c\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458\u53ef\u901a\u8fc7\u201c\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u201d\uff08https://ohonline.wsjkw.zj.gov.cn/login\uff09-\u7528\u4eba\u5355\u4f4d\u7aef-\u5728\u7ebf\u57f9\u8bad\u6a21\u5757\u6216\u5176\u4ed6\u536b\u751f\u5065\u5eb7\u76d1\u7763\u6267\u6cd5\u673a\u6784\u8ba4\u53ef\u65b9\u5f0f\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.TRAIN.getValue()));
                        break;
                    }
                    case "threeTime_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3")) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u5efa\u8bbe\u9879\u76ee\u201d\u4e09\u540c\u65f6\u201c", "\u4f9d\u636e\u300a\u5efa\u8bbe\u9879\u76ee\u804c\u4e1a\u75c5\u9632\u62a4\u8bbe\u65bd\u201c\u4e09\u540c\u65f6\u201d\u76d1\u7763\u7ba1\u7406\u529e\u6cd5\u300b\uff08\u539f\u56fd\u5bb6\u5b89\u5168\u751f\u4ea7\u76d1\u7763\u7ba1\u7406\u603b\u5c40\u4ee4\u7b2c90\u53f7\uff09\u7684\u8981\u6c42\u5f00\u5c55\u5efa\u8bbe\u9879\u76ee\u201c\u4e09\u540c\u65f6\u201d\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.THREE_TIME.getValue()));
                        break;
                    }
                    case "protective_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3")) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u914d\u5907\u4e2a\u4eba\u9632\u62a4\u7528\u54c1", "\u4e3a\u52b3\u52a8\u8005\u63d0\u4f9b\u7b26\u5408\u56fd\u5bb6\u6807\u51c6\u6216\u8005\u884c\u4e1a\u6807\u51c6\u7684\u52b3\u52a8\u9632\u62a4\u7528\u54c1\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.PROTECTION.getValue()));
                        break;
                    }
                    case "warningMark_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3")) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u8bbe\u7f6e\u8b66\u793a\u6807\u8bc6", "\u6839\u636e\u300a\u5de5\u4f5c\u573a\u6240\u804c\u4e1a\u75c5\u5371\u5bb3\u8b66\u793a\u6807\u8bc6\u300b\uff08GBZ158\uff09\u548c\u300a\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u75c5\u5371\u5bb3\u544a\u77e5\u4e0e\u8b66\u793a\u6807\u8bc6\u7ba1\u7406\u89c4\u8303\u300b\uff08\u5b89\u76d1\u603b\u5385\u5b89\u5065[2014]111\u53f7\uff09\u7b49\u6807\u51c6\u89c4\u8303\u8981\u6c42\u8bbe\u7f6e\u8b66\u793a\u6807\u8bc6\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.WARNING_SIGNS.getValue()));
                        break;
                    }
                    case "healthArchive_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3")) break;
                        list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u5efa\u7acb\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u6863\u6848", "\u53ef\u53c2\u8003\u201c\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u201d\uff08https://ohonline.wsjkw.zj.gov.cn/login\uff09-\u7528\u4eba\u5355\u4f4d\u7aef-\u6863\u6848\u7ba1\u7406\u6a21\u5757\u529f\u80fd\uff0c\u5efa\u7acb\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u6863\u6848\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.ARCHIVES.getValue()));
                    }
                }
            }
        }
        return list;
    }

    private List<SendOrdinarySmsDto> judgeSmsTypeForCompany(CompanyInfoDto company, DyPatrolAddParam param, TmPatrolInfo info, TmPatrolItem item) {
        ArrayList<SendOrdinarySmsDto> list = new ArrayList<SendOrdinarySmsDto>();
        SendOrdinarySmsDto smsDto = new SendOrdinarySmsDto();
        List<RiskTypeVo> riskTypeList = this.reformManage.getRiskTypeList(info.getCid());
        if (company.getIsRegulationVisible() == 1) {
            boolean hasRisk = false;
            if (!CollectionUtils.isEmpty(riskTypeList)) {
                for (RiskTypeVo risk : riskTypeList) {
                    String riskCode = risk.getRiskTypeCode();
                    String riskStatus = risk.getRiskTypeStatus();
                    if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3")) continue;
                    hasRisk = true;
                    break;
                }
            }
            if (hasRisk) {
                smsDto = new SendOrdinarySmsDto();
                smsDto.setCid(param.getPatrolInfo().getExternalSystemCompanyId());
                smsDto.setSenderId(param.getPatrolInfo().getDataSourceId());
                smsDto.setType(DySmsTemplateTypeEnum.GO_TO_HSE.getValue());
                list.add(smsDto);
            }
        } else if (!CollectionUtils.isEmpty(riskTypeList)) {
            for (RiskTypeVo risk : riskTypeList) {
                String riskCode = risk.getRiskTypeCode();
                String riskStatus = risk.getRiskTypeStatus();
                smsDto = new SendOrdinarySmsDto();
                smsDto.setCid(param.getPatrolInfo().getExternalSystemCompanyId());
                smsDto.setSenderId(param.getPatrolInfo().getDataSourceId());
                switch (riskCode) {
                    case "physicalExamination_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3")) break;
                        smsDto.setType(DySmsTemplateTypeEnum.PHYSICAL_EXAMINATION.getValue());
                        list.add(smsDto);
                        break;
                    }
                    case "detection_riskType": {
                        if (!riskStatus.equals("\u6709\u98ce\u9669") && !riskStatus.contains("\u672a\u5316\u89e3")) break;
                        smsDto.setType(DySmsTemplateTypeEnum.CHECK.getValue());
                        list.add(smsDto);
                    }
                }
            }
        }
        return list;
    }

    public Boolean sendOrdinarySmsByType(SendOrdinarySmsDto dto) {
        if (Objects.isNull(DySmsTemplateTypeEnum.getName((Integer)dto.getType()))) {
            throw new ServiceException("\u975e\u6cd5\u77ed\u4fe1\u6a21\u677f\u7c7b\u578b");
        }
        DySmsTemplate template = this.dySmsTemplateService.getOneByType(dto.getType());
        if (Objects.isNull(template)) {
            throw new ServiceException("\u8be5\u77ed\u4fe1\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        Object templateContent = template.getContent();
        if (StrUtil.isBlank((CharSequence)templateContent)) {
            throw new ServiceException("\u77ed\u4fe1\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a");
        }
        List companyInfoList = this.companyProvideBySuperviseService.getOnlyCompanyByDataSourceDyIdExcludeDelete(Collections.singletonList(dto.getCid()));
        if (CollUtil.isEmpty((Collection)companyInfoList)) {
            throw new ServiceException("\u8be5\u4f01\u4e1a\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u540c\u6b65");
        }
        CompanySuperviseModel companyInfo = (CompanySuperviseModel)companyInfoList.get(0);
        if (!PhoneUtil.isMobile((CharSequence)companyInfo.getOccManagerTel())) {
            log.error("\u8be5\u4f01\u4e1a\u7684\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u8054\u7cfb\u4eba\u7535\u8bdd\u4e0d\u5b58\u5728\uff0cid\uff1a{}\uff0cname\uff1a{}", (Object)companyInfo.getId(), (Object)companyInfo.getName());
            throw new ServiceException("\u8be5\u4f01\u4e1a\u7684\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u8054\u7cfb\u4eba\u7535\u8bdd\u4e0d\u5b58\u5728");
        }
        DyOrganizationUser dyOrganizationUser = this.dyOrganizationUserService.getOneByDataSourceId(dto.getSenderId());
        if (Objects.isNull(dyOrganizationUser)) {
            log.error("\u5f53\u524d\u53d1\u9001\u8005\u4eba\u5458\u4fe1\u606f\u4e0d\u5b58\u5728\uff0cdataSourceId\uff1a{}", (Object)dto.getCid());
            throw new ServiceException("\u5f53\u524d\u53d1\u9001\u8005\u4eba\u5458\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u540c\u6b65");
        }
        if (DySmsTemplateTypeEnum.NONE.getValue().equals(dto.getType())) {
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
            templateContent = "\u622a\u6b62" + formatter.format(now) + "\uff0c" + (String)templateContent;
        }
        SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(companyInfo.getAreaDetailId());
        Date now = new Date();
        DyServiceGuidanceRecords entity = new DyServiceGuidanceRecords();
        entity.setId(Long.valueOf(IdWorker.getId()));
        entity.setNo(Long.valueOf(IdWorker.getId()));
        entity.setCid(companyInfo.getId());
        entity.setCompanyName(companyInfo.getName());
        entity.setCreditCode(companyInfo.getUnifiedSocialCc());
        entity.setDetailAreaId(companyInfo.getAreaDetailId());
        entity.setProvinceId(area.getProvinceId());
        entity.setProvinceName(area.getProvinceName());
        entity.setCityId(area.getCityId());
        entity.setCityName(area.getCityName());
        entity.setAreaId(area.getAreaId());
        entity.setAreaName(area.getAreaName());
        entity.setStreetId(area.getStreetId());
        entity.setStreetName(area.getStreetName());
        entity.setReceiverTel(companyInfo.getOccManagerTel());
        entity.setSenderId(dyOrganizationUser.getId());
        entity.setSenderName(dyOrganizationUser.getFullName());
        entity.setSendYear(Integer.valueOf(DateUtil.getYear()));
        entity.setSendTime(now);
        entity.setSmsTemplateId(template.getId());
        entity.setSendContent((String)templateContent);
        entity.setIsValid(Boolean.valueOf(true));
        entity.setCreateBy(dyOrganizationUser.getId());
        entity.setCreateDate(now);
        entity.setUpdateBy(dyOrganizationUser.getId());
        entity.setUpdateDate(now);
        Boolean b = this.masService.sendOrdinaryMsg(companyInfo.getOccManagerTel(), (String)templateContent);
        if (b.booleanValue()) {
            this.dyServiceGuidanceRecordsService.save(entity);
        }
        return b;
    }

    @Generated
    public ISynPatrolServiceProviderImpl(ISynPatrolService iSynPatrolService, CompanyMapper companyMapper, TmPatrolInfoMapper tmPatrolInfoMapper, ITmPatrolInfoService patrolInfoService, ITmPatrolItemService patrolItemService, SynPatrolConverter patrolConverter, UploadOssUtil uploadOssUtil) {
        this.iSynPatrolService = iSynPatrolService;
        this.companyMapper = companyMapper;
        this.tmPatrolInfoMapper = tmPatrolInfoMapper;
        this.patrolInfoService = patrolInfoService;
        this.patrolItemService = patrolItemService;
        this.patrolConverter = patrolConverter;
        this.uploadOssUtil = uploadOssUtil;
    }
}

