/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.syn.controller;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.township.manage.bootstrap.properties.JwtProperties;
import cn.smarthse.township.manage.model.vo.api.patrol.XzxgSecretVo;
import cn.smarthse.township.syn.model.param.AppKeyParam;
import cn.smarthse.township.syn.model.param.CompanyParam;
import cn.smarthse.township.syn.model.param.PatrolAddParam;
import cn.smarthse.township.syn.model.param.ReformItemBasicAddParam;
import cn.smarthse.township.syn.service.ISynPatrolService;
import cn.smarthse.township.syn.service.JwtUtil;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import jakarta.validation.Valid;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/patrol"})
@Validated
public class ApiPatrolController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiPatrolController.class);
    private final ISynPatrolService synPatrolService;
    private final JwtProperties jwtProperties;
    private static final String token = "patrol_token";

    @PostMapping(value={"/getToken"})
    public ResponseData<String> getToken(@Valid @RequestBody AppKeyParam param) {
        XzxgSecretVo xzxgSecret = this.synPatrolService.getSecretByAppId(param.getAppId());
        if (xzxgSecret == null) {
            return ResponseData.fail((String)"appId\u4e0d\u5b58\u5728\uff01");
        }
        if (!Objects.equals(xzxgSecret.getAppSecret(), param.getAppSecret())) {
            return ResponseData.fail((String)"APPSecret\u9519\u8bef\uff01");
        }
        Set<Long> areaIdList = this.synPatrolService.getSecretAreaId(xzxgSecret.getId());
        JWTCreator.Builder builder = JWT.create().withAudience(new String[]{this.jwtProperties.getAudience()}).withIssuer(this.jwtProperties.getIssuer()).withExpiresAt(DateUtils.addWeeks((Date)new Date(), (int)1)).withClaim("appId", param.getAppId()).withClaim("areaIds", StringUtils.join(areaIdList, (String)","));
        String token = builder.sign(Algorithm.HMAC256((String)this.jwtProperties.getThirdSecret()));
        return ResponseData.success((String)"\u64cd\u4f5c\u6210\u529f", (Object)token);
    }

    @PostMapping(value={"/getCid"})
    public ResponseData<Long> getCid(@Valid @RequestBody CompanyParam param) {
        String patrol_token = ServletUtils.getRequest().getHeader(token);
        if (patrol_token == null) {
            return ResponseData.fail((String)"\u672a\u6388\u6743\uff01");
        }
        if (!JwtUtil.verify(patrol_token, this.jwtProperties.getThirdSecret(), this.jwtProperties.getAudience())) {
            return ResponseData.fail((String)"\u975e\u6cd5token\uff01");
        }
        Long cid = this.synPatrolService.getCid(param.getCompanyName(), param.getUnifiedCreditCode());
        if (cid == null) {
            return ResponseData.fail((String)"\u5355\u4f4d\u4e0d\u5b58\u5728\uff01");
        }
        log.debug("\u83b7\u53d6\u5355\u4f4did: appId: {}, param: {}, result: {}", new Object[]{JwtUtil.getAppId(patrol_token), param, cid});
        return ResponseData.success((String)"\u64cd\u4f5c\u6210\u529f", (Object)cid);
    }

    @PostMapping(value={"/addPatrol"})
    public ResponseData<Long> addPatrol(@Valid @RequestBody PatrolAddParam param) {
        String patrol_token = ServletUtils.getRequest().getHeader(token);
        if (patrol_token == null) {
            return ResponseData.fail((String)"\u672a\u6388\u6743\uff01");
        }
        if (!JwtUtil.verify(patrol_token, this.jwtProperties.getThirdSecret(), this.jwtProperties.getAudience())) {
            return ResponseData.fail((String)"\u975e\u6cd5token\uff01");
        }
        String appId = JwtUtil.getAppId(patrol_token);
        if (!this.synPatrolService.checkPermission(appId, param.getPatrol().getCid())) {
            return ResponseData.fail((String)"\u65e0\u6743\u9650\u6dfb\u52a0\u8be5\u4f01\u4e1a\u7684\u5de1\u67e5\u4fe1\u606f\uff01");
        }
        log.info("\u6dfb\u52a0\u5de1\u67e5: appId: {}, param: {}", (Object)appId, (Object)JSONObject.toJSONString((Object)param, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        Long result = this.synPatrolService.addPatrol(param);
        log.info("\u6dfb\u52a0\u5de1\u67e5: appId: {}, result: {} end", (Object)appId, (Object)result);
        if (result > 0L) {
            return ResponseData.success((String)"\u5f00\u53d1\u4e2d", (Object)result);
        }
        if (result == -1L) {
            return ResponseData.fail((String)String.format("\u201c%s\u201d\u5df2\u7ecf\u5b58\u5728\u6807\u8bb0\u4e3a%s\u5e74\u5de1\u67e5\u540d\u4e3a\u201c%s\u201d\u7684\u5de1\u67e5", param.getPatrol().getUnitName(), param.getPatrol().getYear(), param.getPatrol().getPatrolName()));
        }
        return ResponseData.fail((String)"\u9519\u8bef");
    }

    @PostMapping(value={"/addReformItemBasic"})
    public ResponseData<Long> addReformItemBasic(@Valid @RequestBody ReformItemBasicAddParam param) {
        String patrol_token = ServletUtils.getRequest().getHeader(token);
        if (patrol_token == null) {
            return ResponseData.fail((String)"\u672a\u6388\u6743\uff01");
        }
        if (!JwtUtil.verify(patrol_token, this.jwtProperties.getThirdSecret(), this.jwtProperties.getAudience())) {
            return ResponseData.fail((String)"\u975e\u6cd5token\uff01");
        }
        String appId = JwtUtil.getAppId(patrol_token);
        if (!this.synPatrolService.checkPermission(appId, param.getReform().getCid())) {
            return ResponseData.fail((String)"\u65e0\u6743\u9650\u6dfb\u52a0\u8be5\u4f01\u4e1a\u7684\u5de1\u67e5\u4fe1\u606f\uff01");
        }
        log.info("\u6dfb\u52a0\u98ce\u9669\u6574\u6539\u9a8c\u6536\u6570\u636e: appId: {}, param: {}", (Object)appId, (Object)JSONObject.toJSONString((Object)param, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        Long result = this.synPatrolService.addReformItemBasic(param);
        log.info("\u6dfb\u52a0\u98ce\u9669\u6574\u6539\u9a8c\u6536\u6570\u636e: appId: {}, result: {} end", (Object)appId, (Object)result);
        if (result > 0L) {
            return ResponseData.success((String)"\u5f00\u53d1\u4e2d");
        }
        if (result == -1L) {
            return ResponseData.fail((String)String.format("\u5df2\u7ecf\u5b58\u5728\u6574\u6539\u9879\u7f16\u53f7\u4e3a\u201c%s\u201d\u7684\u98ce\u9669", param.getReform().getReformItemSn()));
        }
        return ResponseData.fail((String)"\u9519\u8bef");
    }

    @Generated
    public ApiPatrolController(ISynPatrolService synPatrolService, JwtProperties jwtProperties) {
        this.synPatrolService = synPatrolService;
        this.jwtProperties = jwtProperties;
    }
}

