/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.task;

import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.township.manage.bootstrap.properties.ZwddProperties;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.xxpt.gateway.shared.api.request.OapiMoziEmployeeGetByMobileRequest;
import com.alibaba.xxpt.gateway.shared.api.response.OapiMoziEmployeeGetByMobileResponse;
import com.alibaba.xxpt.gateway.shared.client.http.ExecutableClient;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentGetClient;
import com.alibaba.xxpt.gateway.shared.client.http.api.OapiRequest;
import com.alibaba.xxpt.gateway.shared.client.http.api.OapiSpResultContent;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
public class OrganizationUserTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrganizationUserTask.class);
    @DubboReference
    private IOrganizationUserService organizationUserService;
    private final ZwddProperties zwddProperties;
    private final ExecutableClient executableClient;

    @XxlJob(value="OrganizationUserTask-bindAccountId")
    public void bindAccountId() {
        log.info("OrganizationUserTask-bindAccountId begin");
        List list = this.organizationUserService.getWithOutAccountIdList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(record -> {
                Long accountId = this.getAccountId(record.getTel());
                if (accountId != null) {
                    log.info("OrganizationUserTask-bindAccountId\uff1a\u7ed1\u5b9a\u6d59\u653f\u9489\u8d26\u53f7\uff1aid\uff1a{}\uff0ctel\uff1a{}\uff0caccountId\uff1a{}", new Object[]{record.getId(), record.getTel(), accountId});
                    this.organizationUserService.bindAccountId(record.getId(), accountId);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        log.info("OrganizationUserTask-bindAccountId end");
    }

    private Long getAccountId(String tel) {
        try {
            IntelligentGetClient intelligentGetClient = this.executableClient.newIntelligentGetClient("/mozi/employee/get_by_mobile");
            OapiMoziEmployeeGetByMobileRequest oapiMoziEmployeeGetByMobileRequest = new OapiMoziEmployeeGetByMobileRequest();
            oapiMoziEmployeeGetByMobileRequest.setAreaCode("86");
            oapiMoziEmployeeGetByMobileRequest.setTenantId(this.zwddProperties.getTenantId());
            oapiMoziEmployeeGetByMobileRequest.setNamespace("local");
            oapiMoziEmployeeGetByMobileRequest.setMobile(tel);
            OapiMoziEmployeeGetByMobileResponse apiResult = (OapiMoziEmployeeGetByMobileResponse)intelligentGetClient.get((OapiRequest)oapiMoziEmployeeGetByMobileRequest);
            OapiSpResultContent content = apiResult.getContent();
            log.info("get_by_mobile-data:tel\uff1a{}-code\uff1a{}-message\uff1a{}-data\uff1a{}", new Object[]{tel, content.getResponseCode(), content.getResponseMessage(), content.getData()});
            if (!content.getSuccess().booleanValue()) {
                return null;
            }
            JSONObject dataObject = JSONObject.parseObject((String)content.getData());
            return (Long)dataObject.getObject("accountId", Long.class, new JSONReader.Feature[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Generated
    public OrganizationUserTask(ZwddProperties zwddProperties, ExecutableClient executableClient) {
        this.zwddProperties = zwddProperties;
        this.executableClient = executableClient;
    }
}

