/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.service.sys.impl;

import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.entity.sys.SysArea;
import cn.smarthse.modules.health.supervise.enums.sys.UserRolesEnum;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.township.manage.bootstrap.security.model.vo.LoginOrganizationUser;
import cn.smarthse.township.manage.service.sys.ISysUserService;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

@Service
public class SysUserServiceImpl
implements ISysUserService {
    @DubboReference
    private IOrganizationUserService organizationUserService;
    @DubboReference
    private IOrganizationService organizationService;
    @DubboReference
    private ISysFileProvideService fileProvideService;

    @Override
    public LoginOrganizationUser getUserByUsername(String username) {
        OrganizationUser organizationUser = this.organizationUserService.getUserByuserame(username);
        if (organizationUser != null) {
            Organization organization = this.organizationService.getOrgById(organizationUser.getOid());
            organizationUser.setOrganization(organization);
        }
        return this.toggleSysUser(organizationUser);
    }

    @Override
    public LoginOrganizationUser getUserById(Long id) {
        return this.toggleSysUser(this.organizationUserService.getUserInfoById(id));
    }

    @Override
    public boolean checkUsername(String username, Long userId) {
        LoginOrganizationUser user = this.getUserByUsername(username);
        return user == null || user.getId().equals(userId);
    }

    @Override
    public LoginOrganizationUser getByUserId(Long userId) {
        return this.getUserById(userId);
    }

    @Override
    public LoginOrganizationUser getByAccoundId(Long accoundId) {
        return this.toggleSysUser(this.organizationUserService.getUserByAccoundId(accoundId, UserRolesEnum.townshipCoordinator.getValue().toString()));
    }

    @Override
    public void bindAccountId(Long userId, Long accountId) {
        if (!this.isExistsAccountId(accountId)) {
            this.organizationUserService.bindAccountId(userId, accountId);
        }
    }

    @Override
    public boolean isExistsAccountId(Long accountId) {
        return this.organizationUserService.getUserByAccoundId(accountId, UserRolesEnum.townshipCoordinator.getValue().toString()) != null;
    }

    @Override
    public void modifyPassword(Long userId, String newPassword) {
        this.organizationUserService.modifyPassword(userId, newPassword);
        OrganizationUser user = (OrganizationUser)this.organizationUserService.getById(userId);
    }

    @Override
    public Integer getStreetUserCount(Long areaId, Byte level) {
        return this.organizationUserService.getStreetUserCount16(areaId, Integer.valueOf(level.intValue()));
    }

    private LoginOrganizationUser toggleSysUser(OrganizationUser orgUser) {
        if (orgUser == null) {
            return null;
        }
        LoginOrganizationUser sysUser = new LoginOrganizationUser();
        sysUser.setId(orgUser.getId()).setUsername(orgUser.getUsername()).setOid(orgUser.getOid()).setName(orgUser.getFullName()).setPassword(orgUser.getPassword()).setSalt(orgUser.getSalt()).setFaceUrl(this.fileProvideService.getFileUrl(orgUser.getFaceId())).setTel(orgUser.getTel()).setDepartment(orgUser.getDepartment()).setPost(orgUser.getPost()).setIsForbidden(orgUser.getIsForbidden() == null || orgUser.getIsForbidden() == false ? 0 : 1).setRole(orgUser.getRole()).setIsDefaultPwd(orgUser.getIsDefaultPwd()).setPwdUpdateTime(orgUser.getPwdUpdateTime()).setAccoundId(orgUser.getAccountId());
        Organization organization = orgUser.getOrganization();
        if (organization != null) {
            sysUser.setAreaId(organization.getAreaId());
            sysUser.setOrg(organization.getName());
            SysArea sysArea = organization.getSysArea();
            if (sysArea != null) {
                StringBuilder address = new StringBuilder();
                if (sysArea.getLevel() == 1) {
                    address.append(sysArea.getProvinceName());
                }
                if (sysArea.getLevel() == 2) {
                    address.append(sysArea.getProvinceName());
                    address.append(sysArea.getCityName());
                }
                if (sysArea.getLevel() == 3) {
                    address.append(sysArea.getProvinceName());
                    address.append(sysArea.getCityName());
                    address.append(sysArea.getAreaName());
                }
                if (sysArea.getLevel() == 4) {
                    address.append(sysArea.getAreaName());
                    address.append(sysArea.getStreetName());
                }
                sysUser.setAddress(address.toString());
            }
        }
        return sysUser;
    }

    @Generated
    public SysUserServiceImpl() {
    }
}

