/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.service.manage.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.township.manage.converter.TownshipWorkFileConverter;
import cn.smarthse.township.manage.dao.manager.TownshipWorkFileMapper;
import cn.smarthse.township.manage.entity.manage.TownshipWorkFile;
import cn.smarthse.township.manage.enums.manage.WorkFileBatchCodeEnums;
import cn.smarthse.township.manage.framework.Constant;
import cn.smarthse.township.manage.model.param.AdminPatrolStatisticsParam;
import cn.smarthse.township.manage.model.param.WorkFileHistoryPageParam;
import cn.smarthse.township.manage.model.vo.admin.AdminPatrolStatisticsVo;
import cn.smarthse.township.manage.model.vo.admin.WorkFileHistoryStorageProgressVo;
import cn.smarthse.township.manage.model.vo.admin.WorkFileHistoryVo;
import cn.smarthse.township.manage.service.manage.ITmPatrolInfoBackupService;
import cn.smarthse.township.manage.service.manage.ITownshipWorkFileService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TownshipWorkFileServiceImpl
extends ServiceImpl<TownshipWorkFileMapper, TownshipWorkFile>
implements ITownshipWorkFileService {
    public static final String BATCH_CODE_20240301 = WorkFileBatchCodeEnums.BATCH_CODE_20240301.getValue();
    public static final String WORK_FILE_PROGRESS_PROVINCE = "WORK:FILE:PROGRESS:PROVINCE";
    public static final String WORK_FILE_PROGRESS_CITY_DIRECT = "WORK:FILE:PROGRESS:CITY:DIRECT";
    public static final String WORK_FILE_PROGRESS_CITY = "WORK:FILE:PROGRESS:CITY";
    public static final String WORK_FILE_PROGRESS_AREA = "WORK:FILE:PROGRESS:AREA";
    public static final String WORK_FILE_PROGRESS_STREET = "WORK:FILE:PROGRESS:STREET";
    public static final String WORK_FILE_TOTAL_PROVINCE = "WORK:FILE:TOTAL:PROVINCE";
    public static final String WORK_FILE_TOTAL_CITY_DIRECT = "WORK:FILE:TOTAL:CITY:DIRECT";
    public static final String WORK_FILE_TOTAL_CITY = "WORK:FILE:TOTAL:CITY";
    public static final String WORK_FILE_TOTAL_AREA = "WORK:FILE:TOTAL:AREA";
    public static final String WORK_FILE_TOTAL_STREET = "WORK:FILE:TOTAL:STREET";
    @Autowired(required=false)
    private RedissonClient redissonClient;
    @Autowired(required=false)
    private RedisTemplate redisTemplate;
    @Autowired
    private ITmPatrolInfoBackupService tmPatrolInfoBackupService;
    @Autowired
    private TownshipWorkFileConverter converter;

    @Override
    @Transactional
    public void addWorkFile20240301() {
        this.addWorkFileForProvince20240301();
        this.addWorkFileForCity20240301();
        this.addWorkFileForArea20240301();
        this.addWorkFileForStreet20240301();
    }

    @Override
    @Transactional
    public void addWorkFileForProvince20240301() {
        this.redisTemplate.opsForValue().set((Object)WORK_FILE_PROGRESS_PROVINCE, (Object)1);
        this.redisTemplate.opsForValue().set((Object)WORK_FILE_TOTAL_PROVINCE, (Object)0);
        Long parentAreaId = 0L;
        Integer workFileBelongType = -1;
        AdminPatrolStatisticsParam param = new AdminPatrolStatisticsParam();
        param.setYear(Integer.valueOf(2023));
        param.setAreaId(Long.valueOf(330000000000L));
        param.setAreaLevel(Integer.valueOf(1));
        param.setIsCached(Integer.valueOf(0));
        if (this.hasData(param.getAreaId(), BATCH_CODE_20240301, workFileBelongType).booleanValue()) {
            return;
        }
        AdminPatrolStatisticsVo result = this.tmPatrolInfoBackupService.getPatrolStatisticsTotalBySingleThread(param);
        TownshipWorkFile townshipWorkFile = this.converter.adminPatrolStatisticsVo2Entity(result);
        townshipWorkFile.setParentId(parentAreaId);
        townshipWorkFile.setBatchCode(BATCH_CODE_20240301);
        townshipWorkFile.setYear(Integer.valueOf(2023));
        townshipWorkFile.setDeadline(new Date());
        townshipWorkFile.setEntryTime(new Date());
        townshipWorkFile.setBelongType(workFileBelongType);
        this.save(townshipWorkFile);
        this.redisTemplate.opsForValue().set((Object)WORK_FILE_TOTAL_PROVINCE, (Object)1);
    }

    @Override
    @Transactional
    public void addWorkFileForCity20240301() {
        this.addWorkFileForAllCity20240301();
        this.addWorkFileForDirectCity20240301();
    }

    @Override
    @Transactional
    public void addWorkFileForAllCity20240301() {
        Long provinceId = 330000000000L;
        Integer workFileBelongType = -1;
        List<AreaModel> cityList = this.getWorkFileCityList(provinceId);
        AdminPatrolStatisticsParam param = new AdminPatrolStatisticsParam();
        param.setYear(Integer.valueOf(2023));
        param.setIsCached(Integer.valueOf(0));
        ArrayList<TownshipWorkFile> resultList = new ArrayList<TownshipWorkFile>();
        this.redisTemplate.opsForValue().set((Object)WORK_FILE_PROGRESS_CITY, (Object)cityList.size());
        this.redisTemplate.opsForValue().set((Object)WORK_FILE_TOTAL_CITY, (Object)0);
        for (int i = 0; i < cityList.size(); ++i) {
            AreaModel area = cityList.get(i);
            param.setAreaId(area.getId());
            param.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
            if (this.hasData(param.getAreaId(), BATCH_CODE_20240301, workFileBelongType).booleanValue()) {
                return;
            }
            AdminPatrolStatisticsVo result = this.tmPatrolInfoBackupService.getPatrolStatisticsTotalBySingleThread(param);
            TownshipWorkFile townshipWorkFile = this.converter.adminPatrolStatisticsVo2Entity(result);
            townshipWorkFile.setParentId(area.getParentId());
            townshipWorkFile.setBatchCode(BATCH_CODE_20240301);
            townshipWorkFile.setYear(Integer.valueOf(2023));
            townshipWorkFile.setDeadline(new Date());
            townshipWorkFile.setEntryTime(new Date());
            townshipWorkFile.setBelongType(workFileBelongType);
            resultList.add(townshipWorkFile);
            this.redisTemplate.opsForValue().set((Object)WORK_FILE_TOTAL_CITY, (Object)(i + 1));
        }
        this.saveBatch(resultList);
    }

    @Override
    @Transactional
    public void addWorkFileForDirectCity20240301() {
        Long provinceId = 330000000000L;
        Integer belongType = 2;
        Integer workFileBelongType = 2;
        List<AreaModel> cityList = this.getWorkFileCityList(provinceId);
        AdminPatrolStatisticsParam param = new AdminPatrolStatisticsParam();
        param.setYear(Integer.valueOf(2023));
        param.setIsCached(Integer.valueOf(0));
        param.setBelongType(belongType);
        ArrayList<TownshipWorkFile> resultList = new ArrayList<TownshipWorkFile>();
        this.redisTemplate.opsForValue().set((Object)WORK_FILE_PROGRESS_CITY_DIRECT, (Object)cityList.size());
        this.redisTemplate.opsForValue().set((Object)WORK_FILE_TOTAL_CITY_DIRECT, (Object)0);
        for (int i = 0; i < cityList.size(); ++i) {
            AreaModel area = cityList.get(i);
            param.setAreaId(area.getId());
            param.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
            if (this.hasData(param.getAreaId(), BATCH_CODE_20240301, workFileBelongType).booleanValue()) {
                return;
            }
            AdminPatrolStatisticsVo result = this.tmPatrolInfoBackupService.getPatrolStatisticsTotalBySingleThread(param);
            TownshipWorkFile townshipWorkFile = this.converter.adminPatrolStatisticsVo2Entity(result);
            townshipWorkFile.setParentId(area.getParentId());
            townshipWorkFile.setBatchCode(BATCH_CODE_20240301);
            townshipWorkFile.setYear(Integer.valueOf(2023));
            townshipWorkFile.setDeadline(new Date());
            townshipWorkFile.setEntryTime(new Date());
            townshipWorkFile.setBelongType(workFileBelongType);
            resultList.add(townshipWorkFile);
            this.redisTemplate.opsForValue().set((Object)WORK_FILE_TOTAL_CITY_DIRECT, (Object)(i + 1));
        }
        this.saveBatch(resultList);
    }

    @Override
    @Transactional
    public void addWorkFileForArea20240301() {
        Long provinceId = 330000000000L;
        Integer workFileBelongType = 0;
        Integer belongType = 0;
        List<AreaModel> areaList = this.getWorkFileAreaList(provinceId);
        AdminPatrolStatisticsParam param = new AdminPatrolStatisticsParam();
        param.setYear(Integer.valueOf(2023));
        param.setIsCached(Integer.valueOf(0));
        param.setBelongType(belongType);
        ArrayList<TownshipWorkFile> resultList = new ArrayList<TownshipWorkFile>();
        this.redisTemplate.opsForValue().set((Object)WORK_FILE_PROGRESS_AREA, (Object)areaList.size());
        this.redisTemplate.opsForValue().set((Object)WORK_FILE_TOTAL_AREA, (Object)0);
        for (int i = 0; i < areaList.size(); ++i) {
            AreaModel area = areaList.get(i);
            param.setAreaId(area.getId());
            param.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
            if (this.hasData(param.getAreaId(), BATCH_CODE_20240301, workFileBelongType).booleanValue()) {
                return;
            }
            AdminPatrolStatisticsVo result = this.tmPatrolInfoBackupService.getPatrolStatisticsTotalBySingleThread(param);
            TownshipWorkFile townshipWorkFile = this.converter.adminPatrolStatisticsVo2Entity(result);
            townshipWorkFile.setParentId(area.getParentId());
            townshipWorkFile.setBatchCode(BATCH_CODE_20240301);
            townshipWorkFile.setYear(Integer.valueOf(2023));
            townshipWorkFile.setDeadline(new Date());
            townshipWorkFile.setEntryTime(new Date());
            townshipWorkFile.setBelongType(workFileBelongType);
            resultList.add(townshipWorkFile);
            this.redisTemplate.opsForValue().set((Object)WORK_FILE_TOTAL_AREA, (Object)(i + 1));
        }
        this.saveBatch(resultList);
    }

    @Override
    @Transactional
    public void addWorkFileForStreet20240301() {
        Long provinceId = 330000000000L;
        Integer workFileBelongType = 0;
        Integer belongType = 0;
        List<AreaModel> streetList = this.getWorkFileStreetList(provinceId);
        AdminPatrolStatisticsParam param = new AdminPatrolStatisticsParam();
        param.setYear(Integer.valueOf(2023));
        param.setIsCached(Integer.valueOf(0));
        param.setBelongType(belongType);
        ArrayList<TownshipWorkFile> resultList = new ArrayList<TownshipWorkFile>();
        this.redisTemplate.opsForValue().set((Object)WORK_FILE_PROGRESS_STREET, (Object)streetList.size());
        this.redisTemplate.opsForValue().set((Object)WORK_FILE_TOTAL_STREET, (Object)0);
        for (int i = 0; i < streetList.size(); ++i) {
            AreaModel area = streetList.get(i);
            this.redisTemplate.opsForValue().set((Object)"addFileProgress", (Object)i);
            param.setAreaId(area.getId());
            param.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
            if (this.hasData(param.getAreaId(), BATCH_CODE_20240301, workFileBelongType).booleanValue()) {
                return;
            }
            AdminPatrolStatisticsVo result = this.tmPatrolInfoBackupService.getPatrolStatisticsTotalBySingleThread(param);
            TownshipWorkFile townshipWorkFile = this.converter.adminPatrolStatisticsVo2Entity(result);
            townshipWorkFile.setParentId(area.getParentId());
            townshipWorkFile.setBatchCode(BATCH_CODE_20240301);
            townshipWorkFile.setYear(Integer.valueOf(2023));
            townshipWorkFile.setDeadline(new Date());
            townshipWorkFile.setEntryTime(new Date());
            townshipWorkFile.setBelongType(workFileBelongType);
            resultList.add(townshipWorkFile);
            this.redisTemplate.opsForValue().set((Object)WORK_FILE_TOTAL_STREET, (Object)(i + 1));
        }
        this.saveBatch(resultList);
    }

    @Override
    public WorkFileHistoryVo getTotal(WorkFileHistoryPageParam param) {
        return ((TownshipWorkFileMapper)this.baseMapper).getTotal(param);
    }

    @Override
    public List<WorkFileHistoryVo> getList(WorkFileHistoryPageParam param) {
        return ((TownshipWorkFileMapper)this.baseMapper).getList(param);
    }

    @Override
    public WorkFileHistoryStorageProgressVo getProgress() {
        WorkFileHistoryStorageProgressVo vo = new WorkFileHistoryStorageProgressVo();
        Object a = this.redisTemplate.opsForValue().get((Object)WORK_FILE_PROGRESS_PROVINCE);
        Object b = this.redisTemplate.opsForValue().get((Object)WORK_FILE_TOTAL_PROVINCE);
        Integer provinceProgress = (Integer)a;
        Integer provinceTotal = (Integer)b;
        vo.setProvinceProgress(provinceProgress);
        vo.setProvinceTotal(provinceTotal);
        Object c = this.redisTemplate.opsForValue().get((Object)WORK_FILE_PROGRESS_CITY);
        Object d = this.redisTemplate.opsForValue().get((Object)WORK_FILE_TOTAL_CITY);
        Integer cityProgress = (Integer)c;
        Integer cityTotal = (Integer)d;
        vo.setCityProgress(cityProgress);
        vo.setCityTotal(cityTotal);
        Object e = this.redisTemplate.opsForValue().get((Object)WORK_FILE_PROGRESS_CITY_DIRECT);
        Object f = this.redisTemplate.opsForValue().get((Object)WORK_FILE_TOTAL_CITY_DIRECT);
        Integer cityDirectProgress = (Integer)e;
        Integer cityDirectTotal = (Integer)f;
        vo.setCityDirectProgress(cityDirectProgress);
        vo.setCityDirectTotal(cityDirectTotal);
        Object g = this.redisTemplate.opsForValue().get((Object)WORK_FILE_PROGRESS_AREA);
        Object h = this.redisTemplate.opsForValue().get((Object)WORK_FILE_TOTAL_AREA);
        Integer areaDirectProgress = (Integer)g;
        Integer areaDirectTotal = (Integer)h;
        vo.setAreaProgress(areaDirectProgress);
        vo.setAreaTotal(areaDirectTotal);
        Object i = this.redisTemplate.opsForValue().get((Object)WORK_FILE_PROGRESS_STREET);
        Object j = this.redisTemplate.opsForValue().get((Object)WORK_FILE_TOTAL_STREET);
        Integer streetDirectProgress = (Integer)i;
        Integer streetDirectTotal = (Integer)j;
        vo.setStreetProgress(streetDirectProgress);
        vo.setStreetTotal(streetDirectTotal);
        return vo;
    }

    @Override
    public void delProgress() {
        this.redisTemplate.delete((Object)WORK_FILE_PROGRESS_PROVINCE);
        this.redisTemplate.delete((Object)WORK_FILE_TOTAL_PROVINCE);
        this.redisTemplate.delete((Object)WORK_FILE_PROGRESS_CITY);
        this.redisTemplate.delete((Object)WORK_FILE_TOTAL_CITY);
        this.redisTemplate.delete((Object)WORK_FILE_PROGRESS_CITY_DIRECT);
        this.redisTemplate.delete((Object)WORK_FILE_TOTAL_CITY_DIRECT);
        this.redisTemplate.delete((Object)WORK_FILE_PROGRESS_AREA);
        this.redisTemplate.delete((Object)WORK_FILE_TOTAL_AREA);
        this.redisTemplate.delete((Object)WORK_FILE_PROGRESS_STREET);
        this.redisTemplate.delete((Object)WORK_FILE_TOTAL_STREET);
    }

    public TownshipWorkFile getByAreaIdAndBatchCode(Long areaId, String batchCode, Integer belongType) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(TownshipWorkFile::getAreaId, (Object)areaId)).eq(TownshipWorkFile::getBatchCode, (Object)batchCode)).eq(TownshipWorkFile::getIsValid, (Object)Constant.TRUE)).eq(TownshipWorkFile::getBelongType, (Object)belongType);
        return (TownshipWorkFile)this.getOne((Wrapper)wrapper);
    }

    public Boolean hasData(Long areaId, String batchCode, Integer belongType) {
        return this.getByAreaIdAndBatchCode(areaId, batchCode, belongType) != null;
    }

    public List<AreaModel> getWorkFileCityList(Long provinceId) {
        return ((TownshipWorkFileMapper)this.baseMapper).getWorkFileCityAreaList(provinceId);
    }

    public List<AreaModel> getWorkFileAreaList(Long provinceId) {
        return ((TownshipWorkFileMapper)this.baseMapper).getWorkFileAreaList(provinceId);
    }

    public List<AreaModel> getWorkFileStreetList(Long provinceId) {
        return ((TownshipWorkFileMapper)this.baseMapper).getWorkFileStreetList(provinceId);
    }
}

