/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.service.manage.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.enums.StopDataSourceEnums;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.model.grade.GradeV3CollectAreaModel;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.township.manage.bootstrap.security.ShiroUtil;
import cn.smarthse.township.manage.dao.manager.TmPatrolInfoBackupMapper;
import cn.smarthse.township.manage.entity.manage.TmPatrolInfo;
import cn.smarthse.township.manage.entity.manage.TmPatrolItem;
import cn.smarthse.township.manage.enums.manage.PatrolStatusEnums;
import cn.smarthse.township.manage.framework.Constant;
import cn.smarthse.township.manage.model.param.AdminPatrolStatisticsParam;
import cn.smarthse.township.manage.model.param.CompanyListParam;
import cn.smarthse.township.manage.model.param.PatrolInfoCurrencyStatisticsParam;
import cn.smarthse.township.manage.model.param.PatrolRecordParam;
import cn.smarthse.township.manage.model.param.StreetCompanyStatisticsParam;
import cn.smarthse.township.manage.model.vo.CompanyInfoVo;
import cn.smarthse.township.manage.model.vo.HomeData;
import cn.smarthse.township.manage.model.vo.PatrolNumVo;
import cn.smarthse.township.manage.model.vo.PatrolRecordVo;
import cn.smarthse.township.manage.model.vo.admin.AdminPatrolStatisticsVo;
import cn.smarthse.township.manage.model.vo.admin.AreaPatrolStatisticsCollection;
import cn.smarthse.township.manage.model.vo.admin.AreaStaffingStatisticsVo;
import cn.smarthse.township.manage.model.vo.admin.EnterpriseRiskDistributionVo;
import cn.smarthse.township.manage.model.vo.admin.OverdueNotAcceptedStatistiicsVo;
import cn.smarthse.township.manage.model.vo.admin.StreetCompanyStatisticsTotalVo;
import cn.smarthse.township.manage.model.vo.admin.StreetCompanyStatisticslVo;
import cn.smarthse.township.manage.model.vo.company.CompanyPatrolIndexDataVo;
import cn.smarthse.township.manage.service.manage.ITmPatrolInfoBackupService;
import cn.smarthse.township.manage.service.manage.ITmPatrolItemService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.pagehelper.PageInfo;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TmPatrolInfoServiceBackupImpl
extends ServiceImpl<TmPatrolInfoBackupMapper, TmPatrolInfo>
implements ITmPatrolInfoBackupService {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private ICompanyGradeV3Service companyGradeV3Service;
    @Autowired
    private ITmPatrolItemService patrolItemService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Override
    public int getPatrolCompanyNum(Long areaId, Integer year, Integer belongType) {
        CompanyListParam param = new CompanyListParam();
        param.setStatus(Integer.valueOf(2));
        param.setYear(year);
        param.setAreaId(areaId);
        param.setBelongType(belongType);
        AreaModel area = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(areaId);
        param.setLevel(area != null ? area.getLevel() : null);
        return ((TmPatrolInfoBackupMapper)this.baseMapper).selectBatchCompanyByArea_COUNT(param).intValue();
    }

    @Override
    public StreetCompanyStatisticsTotalVo getPatrolCompanyNum(CompanyListParam param) {
        AreaModel area = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(param.getAreaId());
        param.setLevel(area != null ? area.getLevel() : null);
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolCompanyNum(param);
    }

    @Override
    public int getUnPatrolCompanyNum(Long areaId, Integer year, Integer belongType) {
        CompanyListParam param = new CompanyListParam();
        param.setStatus(Integer.valueOf(1));
        param.setYear(year);
        param.setAreaId(areaId);
        param.setBelongType(belongType);
        AreaModel area = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(areaId);
        param.setLevel(area != null ? area.getLevel() : null);
        return ((TmPatrolInfoBackupMapper)this.baseMapper).selectBatchCompanyByArea_COUNT(param).intValue();
    }

    @Override
    public StreetCompanyStatisticsTotalVo getUnPatrolCompanyNum(CompanyListParam param) {
        AreaModel area = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(param.getAreaId());
        param.setLevel(area != null ? area.getLevel() : null);
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getUnPatrolCompanyNum(param);
    }

    @Override
    public HomeData getUnPatrolCompanyNum2(Long areaId, Integer year, Integer belongType) {
        CompanyListParam param = new CompanyListParam();
        param.setStatus(Integer.valueOf(1));
        param.setYear(year);
        param.setAreaId(areaId);
        param.setBelongType(belongType);
        AreaModel area = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(areaId);
        param.setLevel(area != null ? area.getLevel() : null);
        return ((TmPatrolInfoBackupMapper)this.baseMapper).selectBatchCompanyByArea_COUNT2(param);
    }

    @Override
    public Map getUnPatrolCompanyNumByAreaPid(Long areaId, Integer areaLevel) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getUnPatrolCompanyNumByAreaPid(areaId, areaLevel);
    }

    @Override
    public Long getLastPatrol(Long cid, int year) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getLastPatrol(cid, year);
    }

    @Override
    public Date getLastPatrolDate(Long userId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(TmPatrolInfo.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TmPatrolInfo::getUserId, (Object)userId)).eq(TmPatrolInfo::getIsValid, (Object)Constant.YES)).orderByDesc(TmPatrolInfo::getId)).last("limit 1")).select(new SFunction[]{TmPatrolInfo::getCreateDate});
        TmPatrolInfo record = (TmPatrolInfo)this.getOne((Wrapper)wrapper);
        return record != null ? record.getCreateDate() : null;
    }

    @Override
    public Date getLastPatrolDateByCid(Long cid) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(TmPatrolInfo.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TmPatrolInfo::getCid, (Object)cid)).eq(TmPatrolInfo::getIsValid, (Object)Constant.YES)).in(TmPatrolInfo::getPatrolStatus, new Object[]{"2", "3"})).orderByDesc(TmPatrolInfo::getId)).last("limit 1")).select(new SFunction[]{TmPatrolInfo::getPatrolTime});
        TmPatrolInfo record = (TmPatrolInfo)this.getOne((Wrapper)wrapper);
        return record != null ? record.getPatrolTime() : null;
    }

    @Override
    public Date getLastPatrolDateByAreaId(Long areaId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(TmPatrolInfo.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TmPatrolInfo::getIsValid, (Object)Constant.YES)).in(TmPatrolInfo::getPatrolStatus, new Object[]{"2", "3"})).orderByDesc(TmPatrolInfo::getId)).last("limit 1")).select(new SFunction[]{TmPatrolInfo::getPatrolTime});
        AreaModel area = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(areaId);
        if (area.getLevel() == 1) {
            wrapper.eq(TmPatrolInfo::getAreaId1, (Object)areaId);
        } else if (area.getLevel() == 2) {
            wrapper.eq(TmPatrolInfo::getAreaId2, (Object)areaId);
        } else if (area.getLevel() == 3) {
            wrapper.eq(TmPatrolInfo::getAreaId3, (Object)areaId);
        } else if (area.getLevel() == 4) {
            wrapper.eq(TmPatrolInfo::getAreaId4, (Object)areaId);
        }
        TmPatrolInfo record = (TmPatrolInfo)this.getOne((Wrapper)wrapper);
        return record != null ? record.getPatrolTime() : null;
    }

    @Override
    public List<AdminPatrolStatisticsVo> getPatrolStatisticsListWithLastTime(AdminPatrolStatisticsParam param) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolStatisticsListWithLastTime(param);
    }

    @Override
    public Date getPatrolStatisticsTotalWithLastTime(AdminPatrolStatisticsParam param) {
        List<AdminPatrolStatisticsVo> list = ((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolStatisticsListWithLastTime(param);
        return CollectionUtil.isEmpty(list) ? null : list.get(0).getLastPatrolTime();
    }

    @Override
    public List<PatrolNumVo> listPatrolNum(Long cid) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).selectBatchPatrolNum(cid);
    }

    @Override
    public JqGridData<AdminPatrolStatisticsVo> getPatrolStatisticsList(AdminPatrolStatisticsParam param) {
        TmPatrolInfoServiceBackupImpl bean = (TmPatrolInfoServiceBackupImpl)SpringUtils.getBean(this.getClass());
        return bean.getSubAreaPatrolStatisticsList(param);
    }

    @Override
    public JqGridData<AdminPatrolStatisticsVo> getSubAreaPatrolStatisticsList(AdminPatrolStatisticsParam param) {
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AreaModel area = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(param.getAreaId());
        if (area.getLevel() <= 1) {
            return this.getSubAreaPatrolStatisticsListByMultiThread(param);
        }
        return this.getSubAreaPatrolStatisticsListBySingleThread(param);
    }

    public JqGridData<AdminPatrolStatisticsVo> getSubAreaPatrolStatisticsListBySingleThread(AdminPatrolStatisticsParam param) {
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ITmPatrolInfoBackupService self = (ITmPatrolInfoBackupService)SpringUtils.getBean(ITmPatrolInfoBackupService.class);
        AreaModel area = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(param.getAreaId());
        param.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
        List<AdminPatrolStatisticsVo> scopeList = self.getPatrolStatisticsListWithArea(param);
        List<AdminPatrolStatisticsVo> riskList = ((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolStatisticsListWithRisk(param);
        Map<Long, AdminPatrolStatisticsVo> riskNumMap = CollectionUtil.isEmpty(riskList) ? null : riskList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        Map<Long, AreaStaffingStatisticsVo> streetNumMap = ((TmPatrolInfoBackupMapper)this.baseMapper).getHasStaffingStreetNum(param.getAreaId(), param.getAreaLevel());
        TmPatrolInfoServiceBackupImpl bean = (TmPatrolInfoServiceBackupImpl)SpringUtils.getBean(this.getClass());
        Map<Long, String> selfInspectionRateMap = bean.getSelfInspectionRateMap(param);
        List<AdminPatrolStatisticsVo> companyNumList = ((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolStatisticsListWithCompany(param);
        Map<Long, AdminPatrolStatisticsVo> companyNumMap = CollectionUtil.isEmpty(companyNumList) ? null : companyNumList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        List<AdminPatrolStatisticsVo> rectificationRateList = self.getPatrolStatisticsListWithRectificationRate(param);
        Map<Long, AdminPatrolStatisticsVo> rectificationRateMap = CollectionUtil.isEmpty(rectificationRateList) ? null : rectificationRateList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        List<AdminPatrolStatisticsVo> lastTimeList = this.getPatrolStatisticsListWithLastTime(param);
        Map<Long, AdminPatrolStatisticsVo> lastTimeMap = CollectionUtil.isEmpty(lastTimeList) ? null : lastTimeList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        for (AdminPatrolStatisticsVo vo : scopeList) {
            vo.setBelongType(param.getBelongType());
            if (riskNumMap != null && riskNumMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsVo riskVo = riskNumMap.get(vo.getAreaId());
                vo.setLastPatrolTime(riskVo.getLastPatrolTime());
                vo.setLastUpdateTime(riskVo.getLastPatrolTime());
                vo.setRiskNum(riskVo.getRiskNum());
                vo.setToBeRectifiedNum(riskVo.getToBeRectifiedNum());
                vo.setToBeAccepted(riskVo.getToBeAccepted());
                vo.setRedAlertNum(riskVo.getRedAlertNum());
                vo.setStartEnforcementNum(riskVo.getStartEnforcementNum());
            }
            if (streetNumMap != null && streetNumMap.containsKey(vo.getAreaId())) {
                AreaStaffingStatisticsVo tempVo = streetNumMap.get(vo.getAreaId());
                vo.setHasStaffAreaNum(tempVo.getNum());
                vo.setSubAreaNum(tempVo.getTotalNum());
            }
            if (selfInspectionRateMap != null && selfInspectionRateMap.containsKey(String.valueOf(vo.getAreaId()))) {
                vo.setSelfInspectionRate(selfInspectionRateMap.get(String.valueOf(vo.getAreaId())));
            } else if (selfInspectionRateMap != null && selfInspectionRateMap.containsKey(vo.getAreaId())) {
                vo.setSelfInspectionRate(selfInspectionRateMap.get(vo.getAreaId()));
            }
            if (companyNumMap != null && companyNumMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsVo companyNum = companyNumMap.get(vo.getAreaId());
                vo.setCompanyNum(companyNum.getCompanyNum());
                vo.setNormalCompanyNum(companyNum.getNormalCompanyNum());
                vo.setSuspensionCompanyNum(companyNum.getSuspensionCompanyNum());
                vo.setAllCompanyNum(companyNum.getAllCompanyNum());
                vo.setAllNormalCompanyNum(companyNum.getAllNormalCompanyNum());
                vo.setAllSuspensionCompanyNum(companyNum.getAllSuspensionCompanyNum());
            }
            if (rectificationRateMap != null && rectificationRateMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsVo rectificationRate = rectificationRateMap.get(vo.getAreaId());
                vo.setRectificationRate1(rectificationRate.getRectificationRate1());
                vo.setRectificationRate2(rectificationRate.getRectificationRate2());
            }
            if (lastTimeMap == null || !lastTimeMap.containsKey(vo.getAreaId())) continue;
            AdminPatrolStatisticsVo lastTime = lastTimeMap.get(vo.getAreaId());
            vo.setLastUpdateTime(lastTime.getLastUpdateTime());
            vo.setLastPatrolTime(lastTime.getLastPatrolTime());
        }
        if (param.getIncludeBelongType() != null && param.getIncludeBelongType().equals(CompanyBelongTypeEnum.SHI.getValue())) {
            ArrayList<AdminPatrolStatisticsVo> result = new ArrayList<AdminPatrolStatisticsVo>();
            param.setBelongType(CompanyBelongTypeEnum.SHI.getValue());
            AdminPatrolStatisticsVo shiVo = this.getPatrolStatisticsTotal(param);
            shiVo.setAreaName(shiVo.getAreaName() + "\u5e02\u672c\u7ea7");
            shiVo.setBelongType(param.getBelongType());
            result.add(shiVo);
            result.addAll(scopeList);
            return new JqGridData(new PageInfo(result), (JqGridParam)param);
        }
        return new JqGridData(new PageInfo(scopeList), (JqGridParam)param);
    }

    public JqGridData<AdminPatrolStatisticsVo> getSubAreaPatrolStatisticsListByMultiThread(AdminPatrolStatisticsParam param) {
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ITmPatrolInfoBackupService self = (ITmPatrolInfoBackupService)SpringUtils.getBean(ITmPatrolInfoBackupService.class);
        AreaModel area = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(param.getAreaId());
        param.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
        List<AdminPatrolStatisticsVo> scopeList = self.getPatrolStatisticsListWithArea(param);
        CountDownLatch countDownLatch = new CountDownLatch(5);
        AreaPatrolStatisticsCollection result = new AreaPatrolStatisticsCollection();
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                result.setRiskList(((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolStatisticsListWithRisk(param));
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                TmPatrolInfoServiceBackupImpl bean = (TmPatrolInfoServiceBackupImpl)SpringUtils.getBean(this.getClass());
                Map<Long, String> selfInspectionRateMap = bean.getSelfInspectionRateMap(param);
                result.setSelfInspectionRateMap(selfInspectionRateMap);
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                result.setCompanyNumList(((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolStatisticsListWithCompany(param));
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                result.setRectificationRateList(self.getPatrolStatisticsListWithRectificationRate(param));
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                Map<Long, AreaStaffingStatisticsVo> streetNumMap = ((TmPatrolInfoBackupMapper)this.baseMapper).getHasStaffingStreetNum(param.getAreaId(), param.getAreaLevel());
                result.setStreetNumMap(streetNumMap);
                List<AdminPatrolStatisticsVo> lastTimeList = this.getPatrolStatisticsListWithLastTime(param);
                result.setLastTimeList(lastTimeList);
            }
            finally {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new ServiceException(e.getMessage());
        }
        List riskList = result.getRiskList();
        Map<Long, AdminPatrolStatisticsVo> riskNumMap = CollectionUtil.isEmpty((Collection)riskList) ? null : riskList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        Map selfInspectionRateMap = result.getSelfInspectionRateMap();
        List companyNumList = result.getCompanyNumList();
        Map<Long, AdminPatrolStatisticsVo> companyNumMap = CollectionUtil.isEmpty((Collection)companyNumList) ? null : companyNumList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        List rectificationRateList = result.getRectificationRateList();
        Map<Long, AdminPatrolStatisticsVo> rectificationRateMap = CollectionUtil.isEmpty((Collection)rectificationRateList) ? null : rectificationRateList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        Map streetNumMap = result.getStreetNumMap();
        List lastTimeList = result.getLastTimeList();
        Map<Long, AdminPatrolStatisticsVo> lastTimeMap = CollectionUtil.isEmpty((Collection)lastTimeList) ? null : lastTimeList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        for (AdminPatrolStatisticsVo vo : scopeList) {
            vo.setBelongType(param.getBelongType());
            if (riskNumMap != null && riskNumMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsVo riskVo = riskNumMap.get(vo.getAreaId());
                vo.setLastPatrolTime(riskVo.getLastPatrolTime());
                vo.setLastUpdateTime(riskVo.getLastPatrolTime());
                vo.setRiskNum(riskVo.getRiskNum());
                vo.setToBeRectifiedNum(riskVo.getToBeRectifiedNum());
                vo.setToBeAccepted(riskVo.getToBeAccepted());
                vo.setRedAlertNum(riskVo.getRedAlertNum());
                vo.setStartEnforcementNum(riskVo.getStartEnforcementNum());
            }
            if (streetNumMap != null && streetNumMap.containsKey(vo.getAreaId())) {
                tempVo = (AreaStaffingStatisticsVo)streetNumMap.get(vo.getAreaId());
                vo.setHasStaffAreaNum(tempVo.getNum());
                vo.setSubAreaNum(tempVo.getTotalNum());
            } else if (streetNumMap != null && streetNumMap.containsKey(String.valueOf(vo.getAreaId()))) {
                tempVo = (AreaStaffingStatisticsVo)streetNumMap.get(String.valueOf(vo.getAreaId()));
                vo.setHasStaffAreaNum(tempVo.getNum());
                vo.setSubAreaNum(tempVo.getTotalNum());
            }
            if (selfInspectionRateMap != null && selfInspectionRateMap.containsKey(String.valueOf(vo.getAreaId()))) {
                vo.setSelfInspectionRate((String)selfInspectionRateMap.get(String.valueOf(vo.getAreaId())));
            } else if (selfInspectionRateMap != null && selfInspectionRateMap.containsKey(vo.getAreaId())) {
                vo.setSelfInspectionRate((String)selfInspectionRateMap.get(vo.getAreaId()));
            }
            if (rectificationRateMap != null && rectificationRateMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsVo rectificationRate = rectificationRateMap.get(vo.getAreaId());
                vo.setRectificationRate1(rectificationRate.getRectificationRate1());
                vo.setRectificationRate2(rectificationRate.getRectificationRate2());
            }
            if (companyNumMap != null && companyNumMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsVo companyNum = companyNumMap.get(vo.getAreaId());
                vo.setCompanyNum(companyNum.getCompanyNum());
                vo.setNormalCompanyNum(companyNum.getNormalCompanyNum());
                vo.setSuspensionCompanyNum(companyNum.getSuspensionCompanyNum());
                vo.setAllCompanyNum(companyNum.getAllCompanyNum());
                vo.setAllNormalCompanyNum(companyNum.getAllNormalCompanyNum());
                vo.setAllSuspensionCompanyNum(companyNum.getAllSuspensionCompanyNum());
            }
            if (lastTimeMap == null || !lastTimeMap.containsKey(vo.getAreaId())) continue;
            AdminPatrolStatisticsVo lastTime = lastTimeMap.get(vo.getAreaId());
            vo.setLastUpdateTime(lastTime.getLastUpdateTime());
            vo.setLastPatrolTime(lastTime.getLastPatrolTime());
        }
        if (param.getIncludeBelongType() != null && param.getIncludeBelongType().equals(CompanyBelongTypeEnum.SHI.getValue())) {
            ArrayList<AdminPatrolStatisticsVo> resultVo = new ArrayList<AdminPatrolStatisticsVo>();
            param.setBelongType(CompanyBelongTypeEnum.SHI.getValue());
            AdminPatrolStatisticsVo shiVo = this.getPatrolStatisticsTotal(param);
            shiVo.setAreaName(shiVo.getAreaName() + "\u5e02\u672c\u7ea7");
            shiVo.setBelongType(param.getBelongType());
            resultVo.add(shiVo);
            resultVo.addAll(scopeList);
            return new JqGridData(new PageInfo(resultVo), (JqGridParam)param);
        }
        return new JqGridData(new PageInfo(scopeList), (JqGridParam)param);
    }

    @Override
    public JqGridData<AdminPatrolStatisticsVo> getStreetPatrolStatisticsList(AdminPatrolStatisticsParam param) {
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AreaModel area = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(param.getAreaId());
        param.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
        if (param.getAreaLevel() != 2) {
            throw new ServiceException("\u5f53\u524d\u7248\u672c\u4e0d\u652f\u6301\u5176\u4ed6\u76f4\u5c5e\u4f01\u4e1a\u7684\u5e02\u672c\u7ea7\u8857\u9053\u7edf\u8ba1");
        }
        List<AdminPatrolStatisticsVo> streetCompanyNumList = ((TmPatrolInfoBackupMapper)this.baseMapper).getStreetPatrolStatisticsListWithStreetCompany(param);
        if (CollectionUtil.isEmpty(streetCompanyNumList)) {
            return new JqGridData(new PageInfo(streetCompanyNumList), (JqGridParam)param);
        }
        List streetIdList = CollectionUtil.isEmpty(streetCompanyNumList) ? null : streetCompanyNumList.stream().map(v -> v.getAreaId()).collect(Collectors.toList());
        param.setAreaIdList(streetIdList);
        List<AdminPatrolStatisticsVo> riskNumList = ((TmPatrolInfoBackupMapper)this.baseMapper).getStreetPatrolStatisticsListWithRisk(param);
        Map<Long, AdminPatrolStatisticsVo> riskNumMap = CollectionUtil.isEmpty(riskNumList) ? null : riskNumList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        PatrolInfoCurrencyStatisticsParam patrolInfoCurrencyStatisticsParam = new PatrolInfoCurrencyStatisticsParam();
        patrolInfoCurrencyStatisticsParam.setAreaId(param.getAreaId()).setAreaLevel(param.getAreaLevel()).setYear(param.getYear()).setBelongType(param.getBelongType()).setStreetIdList(streetIdList);
        List<OverdueNotAcceptedStatistiicsVo> streetOverdueNotAcceptedNum = this.getStreetOverdueNotAcceptedNum(patrolInfoCurrencyStatisticsParam);
        Map<Long, OverdueNotAcceptedStatistiicsVo> overdueNotAcceptedNumMap = CollectionUtil.isEmpty(streetOverdueNotAcceptedNum) ? null : streetOverdueNotAcceptedNum.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        TmPatrolInfoServiceBackupImpl bean = (TmPatrolInfoServiceBackupImpl)SpringUtils.getBean(this.getClass());
        Map<Long, GradeV3CollectAreaModel> selfInspectionRateMap = bean.getStreetGradeCaseSelfInfo(param);
        for (AdminPatrolStatisticsVo vo : streetCompanyNumList) {
            vo.setBelongType(param.getBelongType());
            if (selfInspectionRateMap != null && selfInspectionRateMap.containsKey(String.valueOf(vo.getAreaId()))) {
                gradeV3CollectAreaModel = selfInspectionRateMap.get(String.valueOf(vo.getAreaId()));
                vo.setSelfInspectionRate(gradeV3CollectAreaModel.getValue());
            } else if (selfInspectionRateMap != null && selfInspectionRateMap.containsKey(vo.getAreaId())) {
                gradeV3CollectAreaModel = selfInspectionRateMap.get(vo.getAreaId());
                vo.setSelfInspectionRate(gradeV3CollectAreaModel.getValue());
            }
            if (riskNumMap != null && riskNumMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsVo riskVo = riskNumMap.get(vo.getAreaId());
                vo.setLastPatrolTime(riskVo.getLastPatrolTime());
                vo.setLastUpdateTime(riskVo.getLastPatrolTime());
                vo.setToBeRectifiedNum(riskVo.getToBeRectifiedNum());
                vo.setOverdueNotRectifiedNum(riskVo.getOverdueNotRectifiedNum());
            }
            if (overdueNotAcceptedNumMap == null || !overdueNotAcceptedNumMap.containsKey(vo.getAreaId())) continue;
            OverdueNotAcceptedStatistiicsVo overdueNotAcceptedStatistiicsVo = overdueNotAcceptedNumMap.get(vo.getAreaId());
            vo.setOverdueNotAcceptedNum(overdueNotAcceptedStatistiicsVo.getOverdueNotAcceptedNum());
        }
        return new JqGridData(new PageInfo(streetCompanyNumList), (JqGridParam)param);
    }

    @Override
    public AdminPatrolStatisticsVo getPatrolStatisticsTotal(AdminPatrolStatisticsParam param) {
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AreaModel area = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(param.getAreaId());
        if (area.getLevel() <= 1) {
            return this.getPatrolStatisticsTotalByMultiThread(param);
        }
        return this.getPatrolStatisticsTotalBySingleThread(param);
    }

    @Override
    public AdminPatrolStatisticsVo getPatrolStatisticsTotalBySingleThread(AdminPatrolStatisticsParam param) {
        AdminPatrolStatisticsVo rectificationRate;
        AdminPatrolStatisticsVo patroledCompanyVo;
        AdminPatrolStatisticsVo totalWithCompany;
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AreaModel area = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(param.getAreaId());
        param.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
        AdminPatrolStatisticsVo vo = new AdminPatrolStatisticsVo();
        vo.setAreaName(area.getName());
        vo.setAreaId(area.getId());
        vo.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
        AdminPatrolStatisticsVo areaRiskVo = this.getPatrolStatisticsTotalWithRisk(param);
        if (areaRiskVo != null) {
            vo.setRectifiedNum(areaRiskVo.getRectifiedNum());
            vo.setRiskNum(areaRiskVo.getRiskNum());
            vo.setToBeRectifiedNum(areaRiskVo.getToBeRectifiedNum());
            vo.setToBeAccepted(areaRiskVo.getToBeAccepted());
            vo.setRedAlertNum(areaRiskVo.getRedAlertNum());
            vo.setStartEnforcementNum(areaRiskVo.getStartEnforcementNum());
        }
        if (param.getBelongType() == null || !param.getBelongType().equals(CompanyBelongTypeEnum.SHI.getValue())) {
            AdminPatrolStatisticsVo hasStaffingStreetTotalNum = this.getHasStaffingStreetTotalNum(param);
            vo.setHasStaffAreaNum(hasStaffingStreetTotalNum.getHasStaffAreaNum());
            vo.setSubAreaNum(hasStaffingStreetTotalNum.getSubAreaNum());
        }
        if ((totalWithCompany = this.getPatrolStatisticsTotalWithCompany(param)) != null) {
            vo.setCompanyNum(totalWithCompany.getCompanyNum());
            vo.setNormalCompanyNum(totalWithCompany.getNormalCompanyNum());
            vo.setSuspensionCompanyNum(totalWithCompany.getSuspensionCompanyNum());
            vo.setAllLT4AreaCompanyNum(totalWithCompany.getAllLT4AreaCompanyNum());
            vo.setAllCompanyNum(totalWithCompany.getAllCompanyNum());
            vo.setAllNormalCompanyNum(totalWithCompany.getAllNormalCompanyNum());
            vo.setAllSuspensionCompanyNum(totalWithCompany.getAllSuspensionCompanyNum());
        }
        if ((patroledCompanyVo = ((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolStatisticsListWithPatroledCompany(param)) != null) {
            vo.setPatroledCompanyNum(patroledCompanyVo.getPatroledCompanyNum());
            vo.setPatroledNormalCompanyNum(patroledCompanyVo.getPatroledNormalCompanyNum());
            vo.setPatroledSuspensionCompanyNum(patroledCompanyVo.getPatroledSuspensionCompanyNum());
        }
        if ((rectificationRate = this.getPatrolStatisticsTotalWithRectificationRate(param)) != null) {
            vo.setRectificationRate1(rectificationRate.getRectificationRate1());
            vo.setRectificationRate2(rectificationRate.getRectificationRate2());
        }
        TmPatrolInfoServiceBackupImpl bean = (TmPatrolInfoServiceBackupImpl)SpringUtils.getBean(this.getClass());
        String selfInspectionRate = bean.getSelfInspectionRate(param);
        vo.setSelfInspectionRate(selfInspectionRate);
        if (param.getAreaLevel() == 4) {
            Date lastTime = this.getPatrolStatisticsTotalWithLastTime(param);
            vo.setLastUpdateTime(lastTime);
            vo.setLastPatrolTime(lastTime);
        }
        return vo;
    }

    public AdminPatrolStatisticsVo getPatrolStatisticsTotalByMultiThread(AdminPatrolStatisticsParam param) {
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AreaModel area = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(param.getAreaId());
        param.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
        AdminPatrolStatisticsVo vo = new AdminPatrolStatisticsVo();
        vo.setAreaName(area.getName());
        vo.setAreaId(area.getId());
        vo.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
        CountDownLatch countDownLatch = new CountDownLatch(6);
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                AdminPatrolStatisticsVo areaRiskVo = this.getPatrolStatisticsTotalWithRisk(param);
                if (areaRiskVo != null) {
                    vo.setRectifiedNum(areaRiskVo.getRectifiedNum());
                    vo.setRiskNum(areaRiskVo.getRiskNum());
                    vo.setToBeRectifiedNum(areaRiskVo.getToBeRectifiedNum());
                    vo.setToBeAccepted(areaRiskVo.getToBeAccepted());
                    vo.setRedAlertNum(areaRiskVo.getRedAlertNum());
                    vo.setStartEnforcementNum(areaRiskVo.getStartEnforcementNum());
                }
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                AdminPatrolStatisticsVo patroledCompanyVo = ((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolStatisticsListWithPatroledCompany(param);
                if (patroledCompanyVo != null) {
                    vo.setPatroledCompanyNum(patroledCompanyVo.getPatroledCompanyNum());
                    vo.setPatroledNormalCompanyNum(patroledCompanyVo.getPatroledNormalCompanyNum());
                    vo.setPatroledSuspensionCompanyNum(patroledCompanyVo.getPatroledSuspensionCompanyNum());
                }
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                AdminPatrolStatisticsVo totalWithCompany = this.getPatrolStatisticsTotalWithCompany(param);
                if (totalWithCompany != null) {
                    vo.setCompanyNum(totalWithCompany.getCompanyNum());
                    vo.setNormalCompanyNum(totalWithCompany.getNormalCompanyNum());
                    vo.setSuspensionCompanyNum(totalWithCompany.getSuspensionCompanyNum());
                    vo.setAllLT4AreaCompanyNum(totalWithCompany.getAllLT4AreaCompanyNum());
                    vo.setAllCompanyNum(totalWithCompany.getAllCompanyNum());
                    vo.setAllNormalCompanyNum(totalWithCompany.getAllNormalCompanyNum());
                    vo.setAllSuspensionCompanyNum(totalWithCompany.getAllSuspensionCompanyNum());
                }
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                AdminPatrolStatisticsVo rectificationRate = this.getPatrolStatisticsTotalWithRectificationRate(param);
                if (rectificationRate != null) {
                    vo.setRectificationRate1(rectificationRate.getRectificationRate1());
                    vo.setRectificationRate2(rectificationRate.getRectificationRate2());
                }
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                TmPatrolInfoServiceBackupImpl bean = (TmPatrolInfoServiceBackupImpl)SpringUtils.getBean(this.getClass());
                String selfInspectionRate = bean.getSelfInspectionRate(param);
                vo.setSelfInspectionRate(selfInspectionRate);
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                if (param.getBelongType() == null || !param.getBelongType().equals(CompanyBelongTypeEnum.SHI.getValue())) {
                    AdminPatrolStatisticsVo hasStaffingStreetTotalNum = this.getHasStaffingStreetTotalNum(param);
                    vo.setHasStaffAreaNum(hasStaffingStreetTotalNum.getHasStaffAreaNum());
                    vo.setSubAreaNum(hasStaffingStreetTotalNum.getSubAreaNum());
                }
                if (param.getAreaLevel() == 4) {
                    Date lastTime = this.getPatrolStatisticsTotalWithLastTime(param);
                    vo.setLastUpdateTime(lastTime);
                    vo.setLastPatrolTime(lastTime);
                }
            }
            finally {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new ServiceException(e.getMessage());
        }
        return vo;
    }

    @Override
    public String getSelfInspectionRate(AdminPatrolStatisticsParam param) {
        Boolean onlyThisLevel = param.getBelongType() == null ? null : Boolean.valueOf(!CompanyBelongTypeEnum.NO.getValue().equals(param.getBelongType()));
        AreaModel areaModel = this.getHistoryAreaByAreaId(param.getAreaId());
        return this.companyGradeV3Service.collectGradeCaseSelfInfoByAreaIdBackup(areaModel, param.getYear(), onlyThisLevel);
    }

    @Override
    public Map<Long, String> getSelfInspectionRateMap(AdminPatrolStatisticsParam param) {
        Boolean onlyThisLevel = param.getBelongType() == null ? null : Boolean.valueOf(!CompanyBelongTypeEnum.NO.getValue().equals(param.getBelongType()));
        AreaModel areaModel = this.getHistoryAreaByAreaId(param.getAreaId());
        return this.companyGradeV3Service.collectGradeCaseSelfInfoByParentIdBackup(areaModel, param.getYear(), onlyThisLevel);
    }

    @Override
    public Map<Long, GradeV3CollectAreaModel> getStreetGradeCaseSelfInfo(AdminPatrolStatisticsParam param) {
        Boolean onlyThisLevel = param.getBelongType() == null ? null : Boolean.valueOf(!CompanyBelongTypeEnum.NO.getValue().equals(param.getBelongType()));
        AreaModel areaModel = this.getHistoryAreaByAreaId(param.getAreaId());
        List gradeV3CollectAreaModelList = this.companyGradeV3Service.collectStreetGradeCaseSelfInfoBackup(areaModel, param.getYear(), onlyThisLevel, param.getAreaIdList());
        if (CollectionUtil.isEmpty((Collection)gradeV3CollectAreaModelList)) {
            return null;
        }
        return gradeV3CollectAreaModelList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
    }

    @Override
    @Deprecated
    public AdminPatrolStatisticsVo getPatrolStatisticsTotalWithIRCompany(AdminPatrolStatisticsParam param) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolStatisticsTotalWithIRCompany(param);
    }

    @Override
    public AdminPatrolStatisticsVo getPatrolStatisticsTotalWithCompany(AdminPatrolStatisticsParam param) {
        AdminPatrolStatisticsVo result = new AdminPatrolStatisticsVo();
        int companyNum = 0;
        int normalCompanyNum = 0;
        int suspensionCompanyNum = 0;
        int allLT4AreaCompanyNum = 0;
        int allCompanyNum = 0;
        int allNormalCompanyNum = 0;
        int allSuspensionCompanyNum = 0;
        List<AdminPatrolStatisticsVo> voList = ((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolStatisticsListWithCompany(param);
        for (AdminPatrolStatisticsVo vo : voList) {
            companyNum += vo.getCompanyNum().intValue();
            normalCompanyNum += vo.getNormalCompanyNum().intValue();
            suspensionCompanyNum += vo.getSuspensionCompanyNum().intValue();
            allLT4AreaCompanyNum += vo.getAllLT4AreaCompanyNum().intValue();
            allCompanyNum += vo.getAllCompanyNum().intValue();
            allNormalCompanyNum += vo.getAllNormalCompanyNum().intValue();
            allSuspensionCompanyNum += vo.getAllSuspensionCompanyNum().intValue();
        }
        result.setCompanyNum(Integer.valueOf(companyNum));
        result.setNormalCompanyNum(Integer.valueOf(normalCompanyNum));
        result.setSuspensionCompanyNum(Integer.valueOf(suspensionCompanyNum));
        result.setAllLT4AreaCompanyNum(Integer.valueOf(allLT4AreaCompanyNum));
        result.setAllCompanyNum(Integer.valueOf(allCompanyNum));
        result.setAllNormalCompanyNum(Integer.valueOf(allNormalCompanyNum));
        result.setAllSuspensionCompanyNum(Integer.valueOf(allSuspensionCompanyNum));
        return result;
    }

    @Override
    public List<OverdueNotAcceptedStatistiicsVo> getOverdueNotAcceptedNum(PatrolInfoCurrencyStatisticsParam param) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getOverdueNotAcceptedNum(param);
    }

    @Override
    public List<OverdueNotAcceptedStatistiicsVo> getStreetOverdueNotAcceptedNum(PatrolInfoCurrencyStatisticsParam param) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getStreetOverdueNotAcceptedNum(param);
    }

    @Override
    public AdminPatrolStatisticsVo getHasStaffingStreetTotalNum(AdminPatrolStatisticsParam param) {
        Map<Long, AreaStaffingStatisticsVo> streetNumMap = ((TmPatrolInfoBackupMapper)this.baseMapper).getHasStaffingStreetNum(param.getAreaId(), param.getAreaLevel());
        int totalStreetNum = 0;
        int hasStaffingStreetNum = 0;
        if (streetNumMap.size() > 0) {
            Collection<AreaStaffingStatisticsVo> values = streetNumMap.values();
            for (AreaStaffingStatisticsVo areaStaffingStatisticsVo : values) {
                totalStreetNum += areaStaffingStatisticsVo.getTotalNum().intValue();
                hasStaffingStreetNum += areaStaffingStatisticsVo.getNum().intValue();
            }
        }
        AdminPatrolStatisticsVo vo = new AdminPatrolStatisticsVo();
        vo.setHasStaffAreaNum(Integer.valueOf(hasStaffingStreetNum));
        vo.setSubAreaNum(Integer.valueOf(totalStreetNum));
        return vo;
    }

    @Override
    public Map<Long, OverdueNotAcceptedStatistiicsVo> getOverdueNotAcceptedNumMap(PatrolInfoCurrencyStatisticsParam param) {
        List<OverdueNotAcceptedStatistiicsVo> overdueNotAcceptedNum = this.getOverdueNotAcceptedNum(param);
        Map<Long, OverdueNotAcceptedStatistiicsVo> map = overdueNotAcceptedNum.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        return map;
    }

    @Override
    public AdminPatrolStatisticsVo getPatrolStatisticsTotalWithRisk(AdminPatrolStatisticsParam param) {
        AdminPatrolStatisticsVo total = new AdminPatrolStatisticsVo();
        int riskNum = 0;
        int toBeRectifiedNum = 0;
        int toBeAccepted = 0;
        int redAlertNum = 0;
        int startEnforcement = 0;
        List<AdminPatrolStatisticsVo> voList = ((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolStatisticsListWithRisk(param);
        for (AdminPatrolStatisticsVo vo : voList) {
            riskNum += vo.getRiskNum().intValue();
            toBeRectifiedNum += vo.getToBeRectifiedNum().intValue();
            toBeAccepted += vo.getToBeAccepted().intValue();
            redAlertNum += vo.getRedAlertNum().intValue();
            startEnforcement += vo.getStartEnforcementNum().intValue();
        }
        total.setRiskNum(Integer.valueOf(riskNum));
        total.setToBeRectifiedNum(Integer.valueOf(toBeRectifiedNum));
        total.setToBeAccepted(Integer.valueOf(toBeAccepted));
        total.setRedAlertNum(Integer.valueOf(redAlertNum));
        total.setStartEnforcementNum(Integer.valueOf(startEnforcement));
        return total;
    }

    @Override
    public AdminPatrolStatisticsVo getPatrolStatisticsTotalWithRectificationRate(AdminPatrolStatisticsParam param) {
        AdminPatrolStatisticsVo total = new AdminPatrolStatisticsVo();
        int rate1 = 0;
        int rate2 = 0;
        ITmPatrolInfoBackupService self = (ITmPatrolInfoBackupService)SpringUtils.getBean(ITmPatrolInfoBackupService.class);
        List<AdminPatrolStatisticsVo> voList = self.getPatrolStatisticsListWithRectificationRate(param);
        for (AdminPatrolStatisticsVo vo : voList) {
            rate1 += vo.getRectificationRate1().intValue();
            rate2 += vo.getRectificationRate2().intValue();
        }
        total.setRectificationRate1(Integer.valueOf(rate1));
        total.setRectificationRate2(Integer.valueOf(rate2));
        return total;
    }

    @Override
    public List<AdminPatrolStatisticsVo> getPatrolStatisticsListWithArea(AdminPatrolStatisticsParam param) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolStatisticsListWithArea(param);
    }

    @Override
    public List<AdminPatrolStatisticsVo> getPatrolStatisticsListWithRectificationRate(AdminPatrolStatisticsParam param) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolStatisticsListWithRectificationRate(param);
    }

    @Override
    public List<AdminPatrolStatisticsVo> getRectificationForVisualization(AdminPatrolStatisticsParam param) {
        ITmPatrolInfoBackupService self = (ITmPatrolInfoBackupService)SpringUtils.getBean(ITmPatrolInfoBackupService.class);
        List<Object> scopeList = self.getPatrolStatisticsListWithArea(param);
        List<AdminPatrolStatisticsVo> rectificationRateList = self.getPatrolStatisticsListWithRectificationRate(param);
        Map<Long, AdminPatrolStatisticsVo> rectificationRateMap = CollectionUtil.isEmpty(rectificationRateList) ? null : rectificationRateList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        for (AdminPatrolStatisticsVo vo : scopeList) {
            if (rectificationRateMap == null || !rectificationRateMap.containsKey(vo.getAreaId())) continue;
            AdminPatrolStatisticsVo rectificationRate = rectificationRateMap.get(vo.getAreaId());
            vo.setRectificationRate1(rectificationRate.getRectificationRate1());
            vo.setRectificationRate2(rectificationRate.getRectificationRate2());
        }
        scopeList = scopeList.stream().sorted(Comparator.comparing(v -> {
            Integer rectificationRate1 = v.getRectificationRate1();
            Integer rectificationRate2 = v.getRectificationRate2();
            if (rectificationRate1 == null || rectificationRate2 == null || rectificationRate2 == 0) {
                return -1.0;
            }
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            return (double)rectificationRate1.intValue() / (double)rectificationRate2.intValue();
        }, Comparator.reverseOrder())).collect(Collectors.toList());
        return scopeList;
    }

    @Override
    public Integer getPatrolStatisticsTotalWithOverdueNotAcceptedRisk(AdminPatrolStatisticsParam param) {
        PatrolInfoCurrencyStatisticsParam patrolInfoCurrencyStatisticsParam = new PatrolInfoCurrencyStatisticsParam();
        patrolInfoCurrencyStatisticsParam.setAreaId(param.getAreaId()).setAreaLevel(param.getAreaLevel()).setYear(param.getYear()).setBelongType(param.getBelongType());
        List<OverdueNotAcceptedStatistiicsVo> voList = this.getOverdueNotAcceptedNum(patrolInfoCurrencyStatisticsParam);
        int total = voList.stream().filter(v -> v.getOverdueNotAcceptedNum() != null).mapToInt(OverdueNotAcceptedStatistiicsVo::getOverdueNotAcceptedNum).sum();
        return total;
    }

    @Override
    public StreetCompanyStatisticsTotalVo getStreetCompanyStatisticsTotal(StreetCompanyStatisticsParam param) {
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StreetCompanyStatisticsTotalVo vo = new StreetCompanyStatisticsTotalVo();
        AdminPatrolStatisticsParam allCompanyParam = new AdminPatrolStatisticsParam();
        allCompanyParam.setAreaId(param.getAreaId());
        allCompanyParam.setAreaLevel(Integer.valueOf(param.getLevel().byteValue()));
        allCompanyParam.setBelongType(param.getBelongType());
        AdminPatrolStatisticsVo allCompanyVo = this.getPatrolStatisticsTotalWithCompany(allCompanyParam);
        vo.setTotalNum(Integer.valueOf(allCompanyVo == null ? 0 : allCompanyVo.getAllCompanyNum()));
        vo.setTotalNormalNum(Integer.valueOf(allCompanyVo == null ? 0 : allCompanyVo.getAllNormalCompanyNum()));
        vo.setTotalSuspensionNum(Integer.valueOf(allCompanyVo == null ? 0 : allCompanyVo.getAllSuspensionCompanyNum()));
        CompanyListParam companyListParam1 = new CompanyListParam().setAreaId(param.getAreaId()).setYear(Integer.valueOf(DateUtil.getYear())).setBelongType(param.getBelongType());
        StreetCompanyStatisticsTotalVo unPatrolCompanyNum = this.getUnPatrolCompanyNum(companyListParam1);
        vo.setNotPatroledNum(unPatrolCompanyNum.getNotPatroledNum());
        vo.setNotPatroledNormalNum(unPatrolCompanyNum.getNotPatroledNormalNum());
        vo.setNotPatroledSuspensionNum(unPatrolCompanyNum.getNotPatroledSuspensionNum());
        CompanyListParam companyListParam2 = new CompanyListParam().setAreaId(param.getAreaId()).setYear(Integer.valueOf(DateUtil.getYear())).setBelongType(param.getBelongType());
        StreetCompanyStatisticsTotalVo patrolCompanyNum = this.getPatrolCompanyNum(companyListParam2);
        vo.setPatroledNum(patrolCompanyNum.getPatroledNum());
        vo.setPatroledNormalNum(patrolCompanyNum.getPatroledNormalNum());
        vo.setPatroledSuspensionNum(patrolCompanyNum.getPatroledSuspensionNum());
        Date lastPatrolTime = this.getLastPatrolDateByAreaId(param.getAreaId());
        vo.setLastUpdateTime(lastPatrolTime);
        return vo;
    }

    @Override
    public JqGridData<StreetCompanyStatisticslVo> getStreetCompanyStatisticsList(StreetCompanyStatisticsParam param) {
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AreaModel area = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(param.getAreaId());
        param.setLevel(area.getLevel());
        param.setYear(Integer.valueOf(DateUtil.getYear()));
        String keyWord = param.getKeyWord();
        param.setKeyWord(null);
        TmPatrolInfoServiceBackupImpl bean = (TmPatrolInfoServiceBackupImpl)SpringUtils.getBean(this.getClass());
        List<Object> list = bean.getStreetCompanyStatisticsListCache(param);
        if (!StringUtils.isEmpty((CharSequence)keyWord)) {
            list = list.stream().filter(v -> v.getName() != null && v.getName().contains(keyWord) || v.getUnifiedSocialCc() != null && v.getUnifiedSocialCc().contains(keyWord)).collect(Collectors.toList());
        }
        JqGridData result = new JqGridData(list, (JqGridParam)param);
        for (Object row : result.getRows()) {
            StreetCompanyStatisticslVo vo = (StreetCompanyStatisticslVo)row;
            vo.setTownshipStopType(this.getCompanyStopTypeByCid(vo.getCid()));
        }
        return new JqGridData(list, (JqGridParam)param);
    }

    @Override
    public List<StreetCompanyStatisticslVo> getStreetCompanyStatisticsListCache(StreetCompanyStatisticsParam param) {
        List<StreetCompanyStatisticslVo> list = ((TmPatrolInfoBackupMapper)this.baseMapper).getStreetCompanyStatisticsList(param);
        List cidList = list.stream().map(StreetCompanyStatisticslVo::getCid).collect(Collectors.toList());
        PatrolInfoCurrencyStatisticsParam overdueNotAcceptedParam = new PatrolInfoCurrencyStatisticsParam();
        overdueNotAcceptedParam.setCidList(cidList);
        overdueNotAcceptedParam.setYear(param.getYear());
        return list;
    }

    private Integer getCompanyStopTypeByCid(Long cid) {
        Integer stopType = null;
        stopType = ((TmPatrolInfoBackupMapper)this.baseMapper).getCompanyStopTypeByCid(cid, StopDataSourceEnums.XZXG.getCode());
        if (stopType == null) {
            stopType = ((TmPatrolInfoBackupMapper)this.baseMapper).getCompanyStopTypeByCid(cid, StopDataSourceEnums.FWGJ.getCode());
        }
        return stopType;
    }

    @Override
    public Integer getPatrolNumByYear(Long cid) {
        List<PatrolNumVo> list = this.listPatrolNum(cid);
        if (list.isEmpty()) {
            return null;
        }
        int year = Calendar.getInstance().get(1);
        for (PatrolNumVo patrolYear : list) {
            if (!patrolYear.getYear().equals(year)) continue;
            return patrolYear.getNum();
        }
        return null;
    }

    @Override
    public List<PatrolRecordVo> listPatrolRecord(PatrolRecordParam param) {
        if (param.getCid() == null) {
            throw new ServiceException("\u516c\u53f8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CompanyInfoVo companyInfoVo = ((TmPatrolInfoBackupMapper)this.baseMapper).selectCompanyInfo(param.getCid());
        param.setAreaId(companyInfoVo.getAreaId());
        return ((TmPatrolInfoBackupMapper)this.baseMapper).selectBatchPatrolRecord(param);
    }

    @Override
    public Integer getPatrolTotalNum(Long cid) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).countPatrolNumByCid(cid);
    }

    @Override
    @Transactional
    public TmPatrolInfo getOrAddLastPatrol(Long cid) {
        int year = Calendar.getInstance().get(1);
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"cid", (Object)cid)).eq((Object)"year", (Object)year)).orderByDesc((Object)"create_date")).last("limit 1");
        TmPatrolInfo info = (TmPatrolInfo)this.getOne((Wrapper)wrapper);
        if (info == null) {
            Integer patrolTotalNum = this.getPatrolTotalNum(cid);
            CompanyInfoVo companyInfo = ((TmPatrolInfoBackupMapper)this.baseMapper).selectCompanyInfo(cid);
            if (companyInfo != null && companyInfo.getIsShowVictims() != null && companyInfo.getIsShowVictims() == 1) {
                return null;
            }
            info = new TmPatrolInfo();
            info.setPatrolName("\u7b2c" + (patrolTotalNum + 1) + "\u6b21-" + companyInfo.getName() + "\u5e2e\u6276");
            info.setPatrolStatus(PatrolStatusEnums.NOT_STARTED.getCode());
            info.setCid(cid);
            info.setYear(Integer.valueOf(year));
            info.setPatrolPeople(ShiroUtil.getLoginUserNickname());
            info.setUserId(ShiroUtil.getLoginUserId());
            info.setAreaId(companyInfo.getAreaId());
            AreaModel areaInfo = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(companyInfo.getAreaId());
            info.setAreaId1(areaInfo.getProvinceId());
            info.setAreaId2(areaInfo.getCityId());
            info.setAreaId3(areaInfo.getAreaId());
            info.setAreaId4(areaInfo.getStreetId());
            this.save(info);
            TmPatrolItem item = new TmPatrolItem();
            item.setPatrolId(info.getId());
            this.patrolItemService.save(item);
        }
        return info;
    }

    @Override
    @Transactional
    public TmPatrolInfo getOrAddLastPatrolWithAreaAndYear(Long cid) {
        int year = Calendar.getInstance().get(1);
        CompanyInfoVo companyInfo = ((TmPatrolInfoBackupMapper)this.baseMapper).selectCompanyInfo(cid);
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"cid", (Object)cid)).eq((Object)"year", (Object)year)).eq((Object)"area_id", (Object)companyInfo.getAreaId())).orderByDesc((Object)"create_date")).last("limit 1");
        TmPatrolInfo info = (TmPatrolInfo)this.getOne((Wrapper)wrapper);
        if (info == null) {
            if (companyInfo.getIsShowVictims() != null && (companyInfo.getIsShowVictims() == 1 || companyInfo.getIsShowVictims() == 2)) {
                return null;
            }
            Integer patrolTotalNum = this.getPatrolTotalNum(cid);
            info = new TmPatrolInfo();
            info.setPatrolName("\u7b2c" + (patrolTotalNum + 1) + "\u6b21-" + companyInfo.getName() + "\u5e2e\u6276");
            info.setPatrolStatus(PatrolStatusEnums.NOT_STARTED.getCode());
            info.setCid(cid);
            info.setYear(Integer.valueOf(year));
            info.setPatrolPeople(ShiroUtil.getLoginUserNickname());
            info.setUserId(ShiroUtil.getLoginUserId());
            info.setAreaId(companyInfo.getAreaId());
            AreaModel areaInfo = ((TmPatrolInfoBackupMapper)this.baseMapper).getAreaByAreaId(companyInfo.getAreaId());
            info.setAreaId1(areaInfo.getProvinceId());
            info.setAreaId2(areaInfo.getCityId());
            info.setAreaId3(areaInfo.getAreaId());
            info.setAreaId4(areaInfo.getStreetId());
            this.save(info);
            TmPatrolItem item = new TmPatrolItem();
            item.setPatrolId(info.getId());
            this.patrolItemService.save(item);
        }
        return info;
    }

    @Override
    public List<CompanyPatrolIndexDataVo> getCompanyPatrolIndexData(Long cid) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getCompanyPatrolIndexData(cid);
    }

    @Override
    public List<CompanyPatrolIndexDataVo> getCompanyPatrolAreaIndexData(Long cid, Long areaId, Integer areaLevel) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getCompanyPatrolAreaIndexData(cid, areaId, areaLevel);
    }

    @Override
    public AdminPatrolStatisticsVo getStreetStaffNum(Long areaId) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getStreetStaffNum(areaId);
    }

    @Override
    public Boolean isFinishedCurrYearPatrol(Long cid) {
        int finishedNum = ((TmPatrolInfoBackupMapper)this.baseMapper).getFinishedFinishedCurrYearPatrol(cid);
        return finishedNum > 0;
    }

    @Override
    public List<AreaStaffingStatisticsVo> getAreaStaffingData(Long areaId, Integer areaLevel) {
        if (areaId == null || areaLevel == null) {
            return null;
        }
        Map<Long, AreaStaffingStatisticsVo> staffingStreetNum = ((TmPatrolInfoBackupMapper)this.baseMapper).getHasStaffingStreetNum(areaId, areaLevel);
        if (staffingStreetNum.isEmpty()) {
            return null;
        }
        List<AreaStaffingStatisticsVo> result = staffingStreetNum.values().stream().map(areaStaffingStatisticsVo -> new AreaStaffingStatisticsVo(areaStaffingStatisticsVo.getAreaId(), areaStaffingStatisticsVo.getAreaName(), areaStaffingStatisticsVo.getNum(), areaStaffingStatisticsVo.getTotalNum(), areaStaffingStatisticsVo.getUserNum())).collect(Collectors.toList());
        result = result.stream().sorted(Comparator.comparing(AreaStaffingStatisticsVo::getNum).reversed()).collect(Collectors.toList());
        return result;
    }

    @Override
    public EnterpriseRiskDistributionVo getEnterpriseRiskDistribution(AdminPatrolStatisticsParam param) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getEnterpriseRiskDistribution2(param);
    }

    @Override
    public AdminPatrolStatisticsVo getPatrolStatisticsListWithPatroledCompany(AdminPatrolStatisticsParam param) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolStatisticsListWithPatroledCompany(param);
    }

    @Override
    public AdminPatrolStatisticsVo getPatrolCoverData(AdminPatrolStatisticsParam param) {
        AdminPatrolStatisticsVo totalWithCompany;
        AdminPatrolStatisticsVo vo = new AdminPatrolStatisticsVo();
        AdminPatrolStatisticsVo patrolledCompanyVo = ((TmPatrolInfoBackupMapper)this.baseMapper).getPatrolStatisticsListWithPatroledCompany(param);
        if (patrolledCompanyVo != null) {
            vo.setPatroledCompanyNum(patrolledCompanyVo.getPatroledCompanyNum());
            vo.setPatroledNormalCompanyNum(patrolledCompanyVo.getPatroledNormalCompanyNum());
            vo.setPatroledSuspensionCompanyNum(patrolledCompanyVo.getPatroledSuspensionCompanyNum());
        }
        if ((totalWithCompany = this.getPatrolStatisticsTotalWithCompany(param)) != null) {
            vo.setCompanyNum(totalWithCompany.getCompanyNum());
            vo.setNormalCompanyNum(totalWithCompany.getNormalCompanyNum());
            vo.setSuspensionCompanyNum(totalWithCompany.getSuspensionCompanyNum());
            vo.setAllLT4AreaCompanyNum(totalWithCompany.getAllLT4AreaCompanyNum());
            vo.setAllCompanyNum(totalWithCompany.getAllCompanyNum());
            vo.setAllNormalCompanyNum(totalWithCompany.getAllNormalCompanyNum());
            vo.setAllSuspensionCompanyNum(totalWithCompany.getAllSuspensionCompanyNum());
        }
        return vo;
    }

    @Override
    public List<AdminPatrolStatisticsVo> getStreetsPatrolCoverData(AdminPatrolStatisticsParam param) {
        ArrayList<AdminPatrolStatisticsVo> resultList = new ArrayList<AdminPatrolStatisticsVo>();
        List<AdminPatrolStatisticsVo> cNumList = ((TmPatrolInfoBackupMapper)this.baseMapper).getStreetsPatrolStatisticsListWithCompany(param);
        if (!CollectionUtil.isEmpty(cNumList)) {
            resultList.addAll(cNumList);
        }
        List<AdminPatrolStatisticsVo> patrolledNumList = ((TmPatrolInfoBackupMapper)this.baseMapper).getStreetsPatrolStatisticsListWithPatrolledCompany(param);
        if (!CollectionUtil.isEmpty(resultList) && !CollectionUtil.isEmpty(patrolledNumList)) {
            resultList.forEach(result -> patrolledNumList.stream().filter(patrolledNum -> patrolledNum.getAreaId() != null && result.getAreaId() != null && patrolledNum.getAreaId().equals(result.getAreaId())).findFirst().ifPresent(patrolledNum -> {
                result.setPatroledCompanyNum(patrolledNum.getPatroledCompanyNum());
                result.setPatroledNormalCompanyNum(patrolledNum.getPatroledNormalCompanyNum());
                result.setPatroledSuspensionCompanyNum(patrolledNum.getPatroledSuspensionCompanyNum());
            }));
        }
        return resultList;
    }

    public AreaModel getHistoryAreaByAreaId(Long areaId) {
        return ((TmPatrolInfoBackupMapper)this.baseMapper).getHistoryAreaByAreaId(areaId);
    }
}

