/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.service.manage.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.health.supervise.model.grade.GradeV3CollectAreaModel;
import cn.smarthse.modules.health.supervise.model.grade.GradeV3CollectAreaParam;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.sys.enumd.SystemDeploymentSourceEnum;
import cn.smarthse.township.manage.dao.manager.TmPatrolInfoBackup2024Mapper;
import cn.smarthse.township.manage.entity.manage.TmPatrolInfo2024;
import cn.smarthse.township.manage.model.ReformRateStatisticVo;
import cn.smarthse.township.manage.model.param.AdminPatrolStatisticsBackup20241231Param;
import cn.smarthse.township.manage.model.param.AdminPatrolStatisticsParam;
import cn.smarthse.township.manage.model.param.RiskSolveRateSearchParam;
import cn.smarthse.township.manage.model.param.SelfCommitRateSearchParam;
import cn.smarthse.township.manage.model.vo.admin.AdminPatrolStatisticsBackup20241231Vo;
import cn.smarthse.township.manage.model.vo.admin.AdminPatrolStatisticsVo;
import cn.smarthse.township.manage.model.vo.admin.AreaPatrolStatisticsCollectionBackup20241231;
import cn.smarthse.township.manage.model.vo.admin.AreaStaffingStatisticsVo;
import cn.smarthse.township.manage.model.vo.admin.SelfCommitRateAreaModel;
import cn.smarthse.township.manage.service.manage.ITmPatrolInfoBackup2024Service;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TmPatrolInfoServiceBackup2024Impl
extends ServiceImpl<TmPatrolInfoBackup2024Mapper, TmPatrolInfo2024>
implements ITmPatrolInfoBackup2024Service {
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Override
    public JqGridData<AdminPatrolStatisticsBackup20241231Vo> getPatrolStatisticsList(AdminPatrolStatisticsBackup20241231Param param) {
        TmPatrolInfoServiceBackup2024Impl bean = (TmPatrolInfoServiceBackup2024Impl)SpringUtils.getBean(this.getClass());
        return bean.getSubAreaPatrolStatisticsList(param);
    }

    @Override
    @Cacheable(value={"20241231:PATROL:STATISTICS:AREA:LIST"}, key="#param.getCacheKey()", unless="#result == null || #param.getNonCacheCondition()")
    public JqGridData<AdminPatrolStatisticsBackup20241231Vo> getSubAreaPatrolStatisticsList(AdminPatrolStatisticsBackup20241231Param param) {
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AreaModel area = this.getAreaById(param.getAreaId());
        if (area.getLevel() <= 1) {
            return this.getSubAreaPatrolStatisticsListByMultiThread(param);
        }
        return this.getSubAreaPatrolStatisticsListBySingleThread(param);
    }

    public JqGridData<AdminPatrolStatisticsBackup20241231Vo> getSubAreaPatrolStatisticsListBySingleThread(AdminPatrolStatisticsBackup20241231Param param) {
        List<AdminPatrolStatisticsBackup20241231Vo> companyNumList;
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ITmPatrolInfoBackup2024Service self = (ITmPatrolInfoBackup2024Service)SpringUtils.getBean(ITmPatrolInfoBackup2024Service.class);
        AreaModel area = this.getAreaById(param.getAreaId());
        param.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
        List<AdminPatrolStatisticsBackup20241231Vo> scopeList = self.getPatrolStatisticsListWithArea(param);
        List<AdminPatrolStatisticsBackup20241231Vo> riskList = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getPatrolStatisticsListWithRisk(param);
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> riskNumMap = CollectionUtil.isEmpty(riskList) ? null : riskList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        Map<Long, AreaStaffingStatisticsVo> streetNumMap = this.getHasStaffingStreetNum(param.getAreaId(), param.getAreaLevel(), param.getSystemDeploymentSource());
        TmPatrolInfoServiceBackup2024Impl bean = (TmPatrolInfoServiceBackup2024Impl)SpringUtils.getBean(this.getClass());
        Map<Long, String> selfInspectionRateMap = null;
        if (param.getSystemDeploymentSource() != null && param.getSystemDeploymentSource() == 0) {
            selfInspectionRateMap = bean.getSelfInspectionRateMap(param);
        }
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> companyNumMap = CollectionUtil.isEmpty(companyNumList = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getPatrolStatisticsListWithCompany(param)) ? null : companyNumList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        List<AdminPatrolStatisticsBackup20241231Vo> rectificationRateList = self.getPatrolStatisticsListWithRectificationRate(param);
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> rectificationRateMap = CollectionUtil.isEmpty(rectificationRateList) ? null : rectificationRateList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        List<AdminPatrolStatisticsBackup20241231Vo> patroledCompanyList = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getPatrolStatisticsListWithPatroledCompany(param);
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> patroledCompanyMap = CollectionUtil.isEmpty(patroledCompanyList) ? null : patroledCompanyList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        for (AdminPatrolStatisticsBackup20241231Vo vo : scopeList) {
            vo.setBelongType(param.getBelongType());
            if (riskNumMap != null && riskNumMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsBackup20241231Vo riskVo = riskNumMap.get(vo.getAreaId());
                vo.setLastPatrolTime(riskVo.getLastPatrolTime());
                vo.setLastUpdateTime(riskVo.getLastPatrolTime());
                vo.setRiskNum(riskVo.getRiskNum());
                vo.setToBeRectifiedNum(riskVo.getToBeRectifiedNum());
                vo.setToBeAccepted(riskVo.getToBeAccepted());
                vo.setRedAlertNum(riskVo.getRedAlertNum());
                vo.setStartEnforcementNum(riskVo.getStartEnforcementNum());
            }
            if (streetNumMap != null && streetNumMap.containsKey(vo.getAreaId())) {
                AreaStaffingStatisticsVo tempVo = streetNumMap.get(vo.getAreaId());
                vo.setHasStaffAreaNum(tempVo.getNum());
                vo.setHasStaffAreaNum17(tempVo.getNum17());
                vo.setHasStaffAreaNum18(tempVo.getNum18());
                vo.setSubAreaNum(tempVo.getTotalNum());
            }
            if (selfInspectionRateMap != null && selfInspectionRateMap.containsKey(String.valueOf(vo.getAreaId()))) {
                vo.setSelfInspectionRate(selfInspectionRateMap.get(String.valueOf(vo.getAreaId())));
            } else if (selfInspectionRateMap != null && selfInspectionRateMap.containsKey(vo.getAreaId())) {
                vo.setSelfInspectionRate(selfInspectionRateMap.get(vo.getAreaId()));
            }
            if (companyNumMap != null && companyNumMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsBackup20241231Vo companyNum = companyNumMap.get(vo.getAreaId());
                vo.setCompanyNum(companyNum.getCompanyNum());
                vo.setNormalCompanyNum(companyNum.getNormalCompanyNum());
                vo.setSuspensionCompanyNum(companyNum.getSuspensionCompanyNum());
                vo.setAllCompanyNum(companyNum.getAllCompanyNum());
                vo.setAllNormalCompanyNum(companyNum.getAllNormalCompanyNum());
                vo.setAllSuspensionCompanyNum(companyNum.getAllSuspensionCompanyNum());
            }
            if (rectificationRateMap != null && rectificationRateMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsBackup20241231Vo rectificationRate = rectificationRateMap.get(vo.getAreaId());
                vo.setRectificationRate1(rectificationRate.getRectificationRate1());
                vo.setRectificationRate2(rectificationRate.getRectificationRate2());
            }
            if (patroledCompanyMap == null || !patroledCompanyMap.containsKey(vo.getAreaId())) continue;
            AdminPatrolStatisticsBackup20241231Vo patroledCompany = patroledCompanyMap.get(vo.getAreaId());
            vo.setPatroledCompanyNum(patroledCompany.getPatroledCompanyNum());
            vo.setPatroledNormalCompanyNum(patroledCompany.getPatroledNormalCompanyNum());
            vo.setPatroledSuspensionCompanyNum(patroledCompany.getPatroledSuspensionCompanyNum());
        }
        if (param.getIncludeBelongType() != null && param.getIncludeBelongType().equals(CompanyBelongTypeEnum.SHI.getValue())) {
            ArrayList<AdminPatrolStatisticsBackup20241231Vo> result = new ArrayList<AdminPatrolStatisticsBackup20241231Vo>();
            param.setBelongType(CompanyBelongTypeEnum.SHI.getValue());
            AdminPatrolStatisticsBackup20241231Vo shiVo = this.getPatrolStatisticsTotal(param);
            shiVo.setAreaName(shiVo.getAreaName() + "\u5e02\u672c\u7ea7");
            shiVo.setBelongType(param.getBelongType());
            result.add(shiVo);
            result.addAll(scopeList);
            return new JqGridData(new PageInfo(result), (JqGridParam)param);
        }
        return new JqGridData(new PageInfo(scopeList), (JqGridParam)param);
    }

    public JqGridData<AdminPatrolStatisticsBackup20241231Vo> getSubAreaPatrolStatisticsListByMultiThread(AdminPatrolStatisticsBackup20241231Param param) {
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ITmPatrolInfoBackup2024Service self = (ITmPatrolInfoBackup2024Service)SpringUtils.getBean(ITmPatrolInfoBackup2024Service.class);
        AreaModel area = this.getAreaById(param.getAreaId());
        param.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
        List<AdminPatrolStatisticsBackup20241231Vo> scopeList = self.getPatrolStatisticsListWithArea(param);
        CountDownLatch countDownLatch = new CountDownLatch(6);
        AreaPatrolStatisticsCollectionBackup20241231 result = new AreaPatrolStatisticsCollectionBackup20241231();
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                result.setRiskList(((TmPatrolInfoBackup2024Mapper)this.baseMapper).getPatrolStatisticsListWithRisk(param));
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                result.setPatroledCompanyNumList(((TmPatrolInfoBackup2024Mapper)this.baseMapper).getPatrolStatisticsListWithPatroledCompany(param));
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                if (param.getSystemDeploymentSource() != null && param.getSystemDeploymentSource() == 0) {
                    TmPatrolInfoServiceBackup2024Impl bean = (TmPatrolInfoServiceBackup2024Impl)SpringUtils.getBean(this.getClass());
                    Map<Long, String> selfInspectionRateMap = bean.getSelfInspectionRateMap(param);
                    result.setSelfInspectionRateMap(selfInspectionRateMap);
                }
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                result.setCompanyNumList(((TmPatrolInfoBackup2024Mapper)this.baseMapper).getPatrolStatisticsListWithCompany(param));
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                result.setRectificationRateList(self.getPatrolStatisticsListWithRectificationRate(param));
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                Map<Long, AreaStaffingStatisticsVo> streetNumMap = this.getHasStaffingStreetNum(param.getAreaId(), param.getAreaLevel(), param.getSystemDeploymentSource());
                result.setStreetNumMap(streetNumMap);
            }
            finally {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new ServiceException(e.getMessage());
        }
        List riskList = result.getRiskList();
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> riskNumMap = CollectionUtil.isEmpty((Collection)riskList) ? null : riskList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        List patroledCompanyNumList = result.getPatroledCompanyNumList();
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> patroledCompanyMap = CollectionUtil.isEmpty((Collection)patroledCompanyNumList) ? null : patroledCompanyNumList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        Map selfInspectionRateMap = result.getSelfInspectionRateMap();
        List companyNumList = result.getCompanyNumList();
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> companyNumMap = CollectionUtil.isEmpty((Collection)companyNumList) ? null : companyNumList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        List rectificationRateList = result.getRectificationRateList();
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> rectificationRateMap = CollectionUtil.isEmpty((Collection)rectificationRateList) ? null : rectificationRateList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        Map streetNumMap = result.getStreetNumMap();
        for (AdminPatrolStatisticsBackup20241231Vo vo : scopeList) {
            vo.setBelongType(param.getBelongType());
            if (riskNumMap != null && riskNumMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsBackup20241231Vo riskVo = riskNumMap.get(vo.getAreaId());
                vo.setLastPatrolTime(riskVo.getLastPatrolTime());
                vo.setLastUpdateTime(riskVo.getLastPatrolTime());
                vo.setRiskNum(riskVo.getRiskNum());
                vo.setToBeRectifiedNum(riskVo.getToBeRectifiedNum());
                vo.setToBeAccepted(riskVo.getToBeAccepted());
                vo.setRedAlertNum(riskVo.getRedAlertNum());
                vo.setStartEnforcementNum(riskVo.getStartEnforcementNum());
            }
            if (patroledCompanyMap != null && patroledCompanyMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsBackup20241231Vo patroledCompany = patroledCompanyMap.get(vo.getAreaId());
                vo.setPatroledCompanyNum(patroledCompany.getPatroledCompanyNum());
                vo.setPatroledNormalCompanyNum(patroledCompany.getPatroledNormalCompanyNum());
                vo.setPatroledSuspensionCompanyNum(patroledCompany.getPatroledSuspensionCompanyNum());
            }
            if (streetNumMap != null && streetNumMap.containsKey(vo.getAreaId())) {
                tempVo = (AreaStaffingStatisticsVo)streetNumMap.get(vo.getAreaId());
                vo.setHasStaffAreaNum(tempVo.getNum());
                vo.setHasStaffAreaNum17(tempVo.getNum17());
                vo.setHasStaffAreaNum18(tempVo.getNum18());
                vo.setSubAreaNum(tempVo.getTotalNum());
            } else if (streetNumMap != null && streetNumMap.containsKey(String.valueOf(vo.getAreaId()))) {
                tempVo = (AreaStaffingStatisticsVo)streetNumMap.get(String.valueOf(vo.getAreaId()));
                vo.setHasStaffAreaNum(tempVo.getNum());
                vo.setHasStaffAreaNum17(tempVo.getNum17());
                vo.setHasStaffAreaNum18(tempVo.getNum18());
                vo.setSubAreaNum(tempVo.getTotalNum());
            }
            if (selfInspectionRateMap != null && selfInspectionRateMap.containsKey(String.valueOf(vo.getAreaId()))) {
                vo.setSelfInspectionRate((String)selfInspectionRateMap.get(String.valueOf(vo.getAreaId())));
            } else if (selfInspectionRateMap != null && selfInspectionRateMap.containsKey(vo.getAreaId())) {
                vo.setSelfInspectionRate((String)selfInspectionRateMap.get(vo.getAreaId()));
            }
            if (rectificationRateMap != null && rectificationRateMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsBackup20241231Vo rectificationRate = rectificationRateMap.get(vo.getAreaId());
                vo.setRectificationRate1(rectificationRate.getRectificationRate1());
                vo.setRectificationRate2(rectificationRate.getRectificationRate2());
            }
            if (companyNumMap == null || !companyNumMap.containsKey(vo.getAreaId())) continue;
            AdminPatrolStatisticsBackup20241231Vo companyNum = companyNumMap.get(vo.getAreaId());
            vo.setCompanyNum(companyNum.getCompanyNum());
            vo.setNormalCompanyNum(companyNum.getNormalCompanyNum());
            vo.setSuspensionCompanyNum(companyNum.getSuspensionCompanyNum());
            vo.setAllCompanyNum(companyNum.getAllCompanyNum());
            vo.setAllNormalCompanyNum(companyNum.getAllNormalCompanyNum());
            vo.setAllSuspensionCompanyNum(companyNum.getAllSuspensionCompanyNum());
        }
        if (param.getIncludeBelongType() != null && param.getIncludeBelongType().equals(CompanyBelongTypeEnum.SHI.getValue())) {
            ArrayList<AdminPatrolStatisticsBackup20241231Vo> resultVo = new ArrayList<AdminPatrolStatisticsBackup20241231Vo>();
            param.setBelongType(CompanyBelongTypeEnum.SHI.getValue());
            AdminPatrolStatisticsBackup20241231Vo shiVo = this.getPatrolStatisticsTotal(param);
            shiVo.setAreaName(shiVo.getAreaName() + "\u5e02\u672c\u7ea7");
            shiVo.setBelongType(param.getBelongType());
            resultVo.add(shiVo);
            resultVo.addAll(scopeList);
            return new JqGridData(new PageInfo(resultVo), (JqGridParam)param);
        }
        return new JqGridData(new PageInfo(scopeList), (JqGridParam)param);
    }

    Map<Long, AreaStaffingStatisticsVo> getHasStaffingStreetNum(Long areaId, Integer areaLevel, Byte system) {
        if (system != null && SystemDeploymentSourceEnum.DONG_YANG.getCode().equals(system)) {
            return ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getHasStaffingStreetNumForDY(areaId, areaLevel);
        }
        return ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getHasStaffingStreetNum(areaId, areaLevel);
    }

    @Override
    public JqGridData<AdminPatrolStatisticsBackup20241231Vo> getStreetAreaPatrolStatisticsList(AdminPatrolStatisticsBackup20241231Param param) {
        List<AdminPatrolStatisticsBackup20241231Vo> companyNumList;
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ITmPatrolInfoBackup2024Service self = (ITmPatrolInfoBackup2024Service)SpringUtils.getBean(ITmPatrolInfoBackup2024Service.class);
        AreaModel area = this.getAreaById(param.getAreaId());
        param.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<AdminPatrolStatisticsBackup20241231Vo> scopeList = self.getStreetPatrolStatisticsListWithArea(param);
        if (CollectionUtil.isEmpty(scopeList)) {
            return new JqGridData(new PageInfo(scopeList), (JqGridParam)param);
        }
        List areaList = scopeList.stream().map(v -> v.getAreaId()).collect(Collectors.toList());
        param.setAreaIdList(areaList);
        List<AdminPatrolStatisticsBackup20241231Vo> riskList = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getStreetPatrolStatisticsListWithRisk(param);
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> riskNumMap = CollectionUtil.isEmpty(riskList) ? null : riskList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        Map<Long, AreaStaffingStatisticsVo> streetNumMap = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getHasStaffingStreetNumForStreetList(param);
        TmPatrolInfoServiceBackup2024Impl bean = (TmPatrolInfoServiceBackup2024Impl)SpringUtils.getBean(this.getClass());
        Map<Long, GradeV3CollectAreaModel> selfInspectionRateMap = null;
        if (param.getSystemDeploymentSource() != null && param.getSystemDeploymentSource() == 0) {
            selfInspectionRateMap = bean.getStreetGradeCaseSelfInfo(param);
        }
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> companyNumMap = CollectionUtil.isEmpty(companyNumList = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getStreetPatrolStatisticsListWithCompany(param)) ? null : companyNumList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        List<AdminPatrolStatisticsBackup20241231Vo> rectificationRateList = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getStreetPatrolStatisticsListWithRectificationRate(param);
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> rectificationRateMap = CollectionUtil.isEmpty(rectificationRateList) ? null : rectificationRateList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        List<AdminPatrolStatisticsBackup20241231Vo> patroledCompanyList = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getStreetPatrolStatisticsListWithPatroledCompany(param);
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> patroledCompanyMap = CollectionUtil.isEmpty(patroledCompanyList) ? null : patroledCompanyList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        for (AdminPatrolStatisticsBackup20241231Vo vo : scopeList) {
            vo.setBelongType(param.getBelongType());
            if (riskNumMap != null && riskNumMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsBackup20241231Vo riskVo = riskNumMap.get(vo.getAreaId());
                vo.setLastPatrolTime(riskVo.getLastPatrolTime());
                vo.setLastUpdateTime(riskVo.getLastPatrolTime());
                vo.setRiskNum(riskVo.getRiskNum());
                vo.setToBeRectifiedNum(riskVo.getToBeRectifiedNum());
                vo.setToBeAccepted(riskVo.getToBeAccepted());
                vo.setRedAlertNum(riskVo.getRedAlertNum());
                vo.setStartEnforcementNum(riskVo.getStartEnforcementNum());
            }
            if (streetNumMap != null && streetNumMap.containsKey(vo.getAreaId())) {
                AreaStaffingStatisticsVo tempVo = streetNumMap.get(vo.getAreaId());
                vo.setHasStaffAreaNum(tempVo.getNum());
                vo.setHasStaffAreaNum17(tempVo.getNum17());
                vo.setHasStaffAreaNum18(tempVo.getNum18());
                vo.setSubAreaNum(tempVo.getTotalNum());
            }
            if (selfInspectionRateMap != null && selfInspectionRateMap.containsKey(String.valueOf(vo.getAreaId()))) {
                gradeV3CollectAreaModel = selfInspectionRateMap.get(String.valueOf(vo.getAreaId()));
                vo.setSelfInspectionRate(gradeV3CollectAreaModel == null ? null : gradeV3CollectAreaModel.getValue());
            } else if (selfInspectionRateMap != null && selfInspectionRateMap.containsKey(vo.getAreaId())) {
                gradeV3CollectAreaModel = selfInspectionRateMap.get(vo.getAreaId());
                vo.setSelfInspectionRate(gradeV3CollectAreaModel == null ? null : gradeV3CollectAreaModel.getValue());
            }
            if (companyNumMap != null && companyNumMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsBackup20241231Vo companyNum = companyNumMap.get(vo.getAreaId());
                vo.setCompanyNum(companyNum.getCompanyNum());
                vo.setNormalCompanyNum(companyNum.getNormalCompanyNum());
                vo.setSuspensionCompanyNum(companyNum.getSuspensionCompanyNum());
                vo.setAllCompanyNum(companyNum.getAllCompanyNum());
                vo.setAllNormalCompanyNum(companyNum.getAllNormalCompanyNum());
                vo.setAllSuspensionCompanyNum(companyNum.getAllSuspensionCompanyNum());
            }
            if (rectificationRateMap != null && rectificationRateMap.containsKey(vo.getAreaId())) {
                AdminPatrolStatisticsBackup20241231Vo rectificationRate = rectificationRateMap.get(vo.getAreaId());
                vo.setRectificationRate1(rectificationRate.getRectificationRate1());
                vo.setRectificationRate2(rectificationRate.getRectificationRate2());
            }
            if (patroledCompanyMap == null || !patroledCompanyMap.containsKey(vo.getAreaId())) continue;
            AdminPatrolStatisticsBackup20241231Vo patroledCompany = patroledCompanyMap.get(vo.getAreaId());
            vo.setPatroledCompanyNum(patroledCompany.getPatroledCompanyNum());
            vo.setPatroledNormalCompanyNum(patroledCompany.getPatroledNormalCompanyNum());
            vo.setPatroledSuspensionCompanyNum(patroledCompany.getPatroledSuspensionCompanyNum());
        }
        return new JqGridData(new PageInfo(scopeList), (JqGridParam)param);
    }

    @Override
    public JqGridData<AdminPatrolStatisticsBackup20241231Vo> getStreetAreaPatrolStatisticsListExNull(AdminPatrolStatisticsBackup20241231Param param) {
        List<AdminPatrolStatisticsBackup20241231Vo> rectificationRateList;
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ITmPatrolInfoBackup2024Service self = (ITmPatrolInfoBackup2024Service)SpringUtils.getBean(ITmPatrolInfoBackup2024Service.class);
        AreaModel area = this.getAreaById(param.getAreaId());
        param.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
        List<Object> scopeList = self.getStreetPatrolStatisticsListWithArea(param);
        if (CollectionUtil.isEmpty(scopeList)) {
            return new JqGridData(scopeList, (JqGridParam)param);
        }
        List<AdminPatrolStatisticsBackup20241231Vo> companyNumList = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getStreetPatrolStatisticsListWithCompany(param);
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> companyNumMap = CollectionUtil.isEmpty(companyNumList) ? null : companyNumList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        for (AdminPatrolStatisticsBackup20241231Vo adminPatrolStatisticsBackup20241231Vo : scopeList) {
            if (companyNumMap == null || !companyNumMap.containsKey(adminPatrolStatisticsBackup20241231Vo.getAreaId())) continue;
            AdminPatrolStatisticsBackup20241231Vo companyNum = companyNumMap.get(adminPatrolStatisticsBackup20241231Vo.getAreaId());
            adminPatrolStatisticsBackup20241231Vo.setCompanyNum(companyNum.getCompanyNum());
            adminPatrolStatisticsBackup20241231Vo.setNormalCompanyNum(companyNum.getNormalCompanyNum());
            adminPatrolStatisticsBackup20241231Vo.setSuspensionCompanyNum(companyNum.getSuspensionCompanyNum());
            adminPatrolStatisticsBackup20241231Vo.setAllCompanyNum(companyNum.getAllCompanyNum());
            adminPatrolStatisticsBackup20241231Vo.setAllNormalCompanyNum(companyNum.getAllNormalCompanyNum());
            adminPatrolStatisticsBackup20241231Vo.setAllSuspensionCompanyNum(companyNum.getAllSuspensionCompanyNum());
        }
        scopeList = scopeList.stream().filter(v -> v.getAllCompanyNum() > 0).collect(Collectors.toList());
        List areaList = scopeList.stream().map(v -> v.getAreaId()).collect(Collectors.toList());
        param.setAreaIdList(areaList);
        List<AdminPatrolStatisticsBackup20241231Vo> list = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getStreetPatrolStatisticsListWithRisk(param);
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> riskNumMap = CollectionUtil.isEmpty(list) ? null : list.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        Map<Long, AreaStaffingStatisticsVo> streetNumMap = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getHasStaffingStreetNumForStreetList(param);
        TmPatrolInfoServiceBackup2024Impl bean = (TmPatrolInfoServiceBackup2024Impl)SpringUtils.getBean(this.getClass());
        Map<Long, GradeV3CollectAreaModel> selfInspectionRateMap = null;
        if (param.getSystemDeploymentSource() != null && param.getSystemDeploymentSource() == 0) {
            selfInspectionRateMap = bean.getStreetGradeCaseSelfInfo(param);
        }
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> rectificationRateMap = CollectionUtil.isEmpty(rectificationRateList = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getStreetPatrolStatisticsListWithRectificationRate(param)) ? null : rectificationRateList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        List<AdminPatrolStatisticsBackup20241231Vo> patroledCompanyList = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getStreetPatrolStatisticsListWithPatroledCompany(param);
        Map<Long, AdminPatrolStatisticsBackup20241231Vo> patroledCompanyMap = CollectionUtil.isEmpty(patroledCompanyList) ? null : patroledCompanyList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        for (AdminPatrolStatisticsBackup20241231Vo adminPatrolStatisticsBackup20241231Vo : scopeList) {
            adminPatrolStatisticsBackup20241231Vo.setBelongType(param.getBelongType());
            if (riskNumMap != null && riskNumMap.containsKey(adminPatrolStatisticsBackup20241231Vo.getAreaId())) {
                AdminPatrolStatisticsBackup20241231Vo riskVo = riskNumMap.get(adminPatrolStatisticsBackup20241231Vo.getAreaId());
                adminPatrolStatisticsBackup20241231Vo.setLastPatrolTime(riskVo.getLastPatrolTime());
                adminPatrolStatisticsBackup20241231Vo.setLastUpdateTime(riskVo.getLastPatrolTime());
                adminPatrolStatisticsBackup20241231Vo.setRiskNum(riskVo.getRiskNum());
                adminPatrolStatisticsBackup20241231Vo.setToBeRectifiedNum(riskVo.getToBeRectifiedNum());
                adminPatrolStatisticsBackup20241231Vo.setToBeAccepted(riskVo.getToBeAccepted());
                adminPatrolStatisticsBackup20241231Vo.setRedAlertNum(riskVo.getRedAlertNum());
                adminPatrolStatisticsBackup20241231Vo.setStartEnforcementNum(riskVo.getStartEnforcementNum());
            }
            if (streetNumMap != null && streetNumMap.containsKey(adminPatrolStatisticsBackup20241231Vo.getAreaId())) {
                AreaStaffingStatisticsVo tempVo = streetNumMap.get(adminPatrolStatisticsBackup20241231Vo.getAreaId());
                adminPatrolStatisticsBackup20241231Vo.setHasStaffAreaNum(tempVo.getNum());
                adminPatrolStatisticsBackup20241231Vo.setHasStaffAreaNum17(tempVo.getNum17());
                adminPatrolStatisticsBackup20241231Vo.setHasStaffAreaNum18(tempVo.getNum18());
                adminPatrolStatisticsBackup20241231Vo.setSubAreaNum(tempVo.getTotalNum());
            }
            if (selfInspectionRateMap != null && selfInspectionRateMap.containsKey(String.valueOf(adminPatrolStatisticsBackup20241231Vo.getAreaId()))) {
                gradeV3CollectAreaModel = selfInspectionRateMap.get(String.valueOf(adminPatrolStatisticsBackup20241231Vo.getAreaId()));
                adminPatrolStatisticsBackup20241231Vo.setSelfInspectionRate(gradeV3CollectAreaModel == null ? null : gradeV3CollectAreaModel.getValue());
            } else if (selfInspectionRateMap != null && selfInspectionRateMap.containsKey(adminPatrolStatisticsBackup20241231Vo.getAreaId())) {
                gradeV3CollectAreaModel = selfInspectionRateMap.get(adminPatrolStatisticsBackup20241231Vo.getAreaId());
                adminPatrolStatisticsBackup20241231Vo.setSelfInspectionRate(gradeV3CollectAreaModel == null ? null : gradeV3CollectAreaModel.getValue());
            }
            if (rectificationRateMap != null && rectificationRateMap.containsKey(adminPatrolStatisticsBackup20241231Vo.getAreaId())) {
                AdminPatrolStatisticsBackup20241231Vo rectificationRate = rectificationRateMap.get(adminPatrolStatisticsBackup20241231Vo.getAreaId());
                adminPatrolStatisticsBackup20241231Vo.setRectificationRate1(rectificationRate.getRectificationRate1());
                adminPatrolStatisticsBackup20241231Vo.setRectificationRate2(rectificationRate.getRectificationRate2());
            }
            if (patroledCompanyMap == null || !patroledCompanyMap.containsKey(adminPatrolStatisticsBackup20241231Vo.getAreaId())) continue;
            AdminPatrolStatisticsBackup20241231Vo patroledCompany = patroledCompanyMap.get(adminPatrolStatisticsBackup20241231Vo.getAreaId());
            adminPatrolStatisticsBackup20241231Vo.setPatroledCompanyNum(patroledCompany.getPatroledCompanyNum());
            adminPatrolStatisticsBackup20241231Vo.setPatroledNormalCompanyNum(patroledCompany.getPatroledNormalCompanyNum());
            adminPatrolStatisticsBackup20241231Vo.setPatroledSuspensionCompanyNum(patroledCompany.getPatroledSuspensionCompanyNum());
        }
        return new JqGridData(scopeList, (JqGridParam)param);
    }

    @Override
    @Cacheable(value={"20241231:PATROL:STATISTICS:AREA:TOTAL"}, key="#param.getCacheKey()", unless="#result == null ||  #param.getNonCacheCondition()")
    public AdminPatrolStatisticsBackup20241231Vo getPatrolStatisticsTotal(AdminPatrolStatisticsBackup20241231Param param) {
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AreaModel area = this.getAreaById(param.getAreaId());
        if (area.getLevel() <= 1) {
            return this.getPatrolStatisticsTotalByMultiThread(param);
        }
        return this.getPatrolStatisticsTotalBySingleThread(param);
    }

    @Override
    public AdminPatrolStatisticsBackup20241231Vo getPatrolStatisticsTotalBySingleThread(AdminPatrolStatisticsBackup20241231Param param) {
        AdminPatrolStatisticsBackup20241231Vo rectificationRate;
        AdminPatrolStatisticsBackup20241231Vo patroledCompanyVo;
        AdminPatrolStatisticsBackup20241231Vo totalWithCompany;
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AreaModel area = this.getAreaById(param.getAreaId());
        param.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
        AdminPatrolStatisticsBackup20241231Vo vo = new AdminPatrolStatisticsBackup20241231Vo();
        vo.setAreaName(area.getName());
        vo.setAreaId(area.getId());
        vo.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
        AdminPatrolStatisticsBackup20241231Vo areaRiskVo = this.getPatrolStatisticsTotalWithRisk(param);
        if (areaRiskVo != null) {
            vo.setRectifiedNum(areaRiskVo.getRectifiedNum());
            vo.setRiskNum(areaRiskVo.getRiskNum());
            vo.setResolvedNum(areaRiskVo.getResolvedNum());
            vo.setToBeRectifiedNum(areaRiskVo.getToBeRectifiedNum());
            vo.setToBeAccepted(areaRiskVo.getToBeAccepted());
            vo.setRedAlertNum(areaRiskVo.getRedAlertNum());
            vo.setStartEnforcementNum(areaRiskVo.getStartEnforcementNum());
        }
        if (param.getBelongType() == null || !param.getBelongType().equals(CompanyBelongTypeEnum.SHI.getValue())) {
            AdminPatrolStatisticsBackup20241231Vo hasStaffingStreetTotalNum = this.getHasStaffingStreetTotalNum(param);
            vo.setHasStaffAreaNum(hasStaffingStreetTotalNum.getHasStaffAreaNum());
            vo.setHasStaffAreaNum17(hasStaffingStreetTotalNum.getHasStaffAreaNum17());
            vo.setHasStaffAreaNum18(hasStaffingStreetTotalNum.getHasStaffAreaNum18());
            vo.setSubAreaNum(hasStaffingStreetTotalNum.getSubAreaNum());
        }
        if ((totalWithCompany = this.getPatrolStatisticsTotalWithCompany(param)) != null) {
            vo.setCompanyNum(totalWithCompany.getCompanyNum());
            vo.setNormalCompanyNum(totalWithCompany.getNormalCompanyNum());
            vo.setSuspensionCompanyNum(totalWithCompany.getSuspensionCompanyNum());
            vo.setAllLT4AreaCompanyNum(totalWithCompany.getAllLT4AreaCompanyNum());
            vo.setAllCompanyNum(totalWithCompany.getAllCompanyNum());
            vo.setAllNormalCompanyNum(totalWithCompany.getAllNormalCompanyNum());
            vo.setAllSuspensionCompanyNum(totalWithCompany.getAllSuspensionCompanyNum());
        }
        if ((patroledCompanyVo = this.getPatrolStatisticsTotalWithPatroledCompany(param)) != null) {
            vo.setPatroledCompanyNum(patroledCompanyVo.getPatroledCompanyNum());
            vo.setPatroledNormalCompanyNum(patroledCompanyVo.getPatroledNormalCompanyNum());
            vo.setPatroledSuspensionCompanyNum(patroledCompanyVo.getPatroledSuspensionCompanyNum());
        }
        if ((rectificationRate = this.getPatrolStatisticsTotalWithRectificationRate(param)) != null) {
            vo.setRectificationRate1(rectificationRate.getRectificationRate1());
            vo.setRectificationRate2(rectificationRate.getRectificationRate2());
        }
        if (param.getSystemDeploymentSource() != null && param.getSystemDeploymentSource() == 0) {
            TmPatrolInfoServiceBackup2024Impl bean = (TmPatrolInfoServiceBackup2024Impl)SpringUtils.getBean(this.getClass());
            String selfInspectionRate = bean.getSelfInspectionRate(param);
            vo.setSelfInspectionRate(selfInspectionRate);
        }
        return vo;
    }

    public AdminPatrolStatisticsBackup20241231Vo getPatrolStatisticsTotalByMultiThread(AdminPatrolStatisticsBackup20241231Param param) {
        if (param.getAreaId() == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AreaModel area = this.getAreaById(param.getAreaId());
        param.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
        AdminPatrolStatisticsBackup20241231Vo vo = new AdminPatrolStatisticsBackup20241231Vo();
        vo.setAreaName(area.getName());
        vo.setAreaId(area.getId());
        vo.setAreaLevel(Integer.valueOf(area.getLevel().byteValue()));
        CountDownLatch countDownLatch = new CountDownLatch(6);
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                AdminPatrolStatisticsBackup20241231Vo areaRiskVo = this.getPatrolStatisticsTotalWithRisk(param);
                if (areaRiskVo != null) {
                    vo.setRectifiedNum(areaRiskVo.getRectifiedNum());
                    vo.setRiskNum(areaRiskVo.getRiskNum());
                    vo.setToBeRectifiedNum(areaRiskVo.getToBeRectifiedNum());
                    vo.setResolvedNum(areaRiskVo.getResolvedNum());
                    vo.setToBeAccepted(areaRiskVo.getToBeAccepted());
                    vo.setRedAlertNum(areaRiskVo.getRedAlertNum());
                    vo.setStartEnforcementNum(areaRiskVo.getStartEnforcementNum());
                }
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                AdminPatrolStatisticsBackup20241231Vo patroledCompanyVo = this.getPatrolStatisticsTotalWithPatroledCompany(param);
                if (patroledCompanyVo != null) {
                    vo.setPatroledCompanyNum(patroledCompanyVo.getPatroledCompanyNum());
                    vo.setPatroledNormalCompanyNum(patroledCompanyVo.getPatroledNormalCompanyNum());
                    vo.setPatroledSuspensionCompanyNum(patroledCompanyVo.getPatroledSuspensionCompanyNum());
                }
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                AdminPatrolStatisticsBackup20241231Vo totalWithCompany = this.getPatrolStatisticsTotalWithCompany(param);
                if (totalWithCompany != null) {
                    vo.setCompanyNum(totalWithCompany.getCompanyNum());
                    vo.setNormalCompanyNum(totalWithCompany.getNormalCompanyNum());
                    vo.setSuspensionCompanyNum(totalWithCompany.getSuspensionCompanyNum());
                    vo.setAllLT4AreaCompanyNum(totalWithCompany.getAllLT4AreaCompanyNum());
                    vo.setAllCompanyNum(totalWithCompany.getAllCompanyNum());
                    vo.setAllNormalCompanyNum(totalWithCompany.getAllNormalCompanyNum());
                    vo.setAllSuspensionCompanyNum(totalWithCompany.getAllSuspensionCompanyNum());
                }
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                AdminPatrolStatisticsBackup20241231Vo rectificationRate = this.getPatrolStatisticsTotalWithRectificationRate(param);
                if (rectificationRate != null) {
                    vo.setRectificationRate1(rectificationRate.getRectificationRate1());
                    vo.setRectificationRate2(rectificationRate.getRectificationRate2());
                }
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                if (param.getSystemDeploymentSource() != null && param.getSystemDeploymentSource() == 0) {
                    TmPatrolInfoServiceBackup2024Impl bean = (TmPatrolInfoServiceBackup2024Impl)SpringUtils.getBean(this.getClass());
                    String selfInspectionRate = bean.getSelfInspectionRate(param);
                    vo.setSelfInspectionRate(selfInspectionRate);
                }
            }
            finally {
                countDownLatch.countDown();
            }
        });
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                if (param.getBelongType() == null || !param.getBelongType().equals(CompanyBelongTypeEnum.SHI.getValue())) {
                    AdminPatrolStatisticsBackup20241231Vo hasStaffingStreetTotalNum = this.getHasStaffingStreetTotalNum(param);
                    vo.setHasStaffAreaNum(hasStaffingStreetTotalNum.getHasStaffAreaNum());
                    vo.setHasStaffAreaNum17(hasStaffingStreetTotalNum.getHasStaffAreaNum17());
                    vo.setHasStaffAreaNum18(hasStaffingStreetTotalNum.getHasStaffAreaNum18());
                    vo.setSubAreaNum(hasStaffingStreetTotalNum.getSubAreaNum());
                }
            }
            finally {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new ServiceException(e.getMessage());
        }
        return vo;
    }

    @Override
    @Cacheable(value={"20241231:PATROL:STATISTICS:SelfInspectionRate:TOTAL"}, key="#param.getCacheKey()", unless="#result == null || #param.getNonCacheCondition()")
    public String getSelfInspectionRate(AdminPatrolStatisticsBackup20241231Param param) {
        Boolean onlyThisLevel = param.getBelongType() == null ? null : Boolean.valueOf(!CompanyBelongTypeEnum.NO.getValue().equals(param.getBelongType()));
        return this.collectGradeCaseSelfInfoByAreaId(param.getAreaId(), param.getYear(), onlyThisLevel, param.getSystemDeploymentSource(), param.getIsFcyth());
    }

    @Override
    @Cacheable(value={"20241231:PATROL:STATISTICS:SelfInspectionRate:LIST"}, key="#param.getCacheKey()", unless=" #param.getNonCacheCondition()")
    public Map<Long, String> getSelfInspectionRateMap(AdminPatrolStatisticsBackup20241231Param param) {
        Boolean onlyThisLevel = param.getBelongType() == null ? null : Boolean.valueOf(!CompanyBelongTypeEnum.NO.getValue().equals(param.getBelongType()));
        return this.collectGradeCaseSelfInfoByParentId(param.getAreaId(), param.getYear(), onlyThisLevel, param.getSystemDeploymentSource(), param.getIsFcyth());
    }

    @Override
    public Map<Long, GradeV3CollectAreaModel> getStreetGradeCaseSelfInfo(AdminPatrolStatisticsBackup20241231Param param) {
        Boolean onlyThisLevel = param.getBelongType() == null ? null : Boolean.valueOf(!CompanyBelongTypeEnum.NO.getValue().equals(param.getBelongType()));
        List<GradeV3CollectAreaModel> gradeV3CollectAreaModelList = this.collectStreetGradeCaseSelfInfo(param.getAreaId(), param.getYear(), onlyThisLevel, param.getAreaIdList(), null, param.getIsFcyth());
        if (CollectionUtil.isEmpty(gradeV3CollectAreaModelList)) {
            return null;
        }
        return gradeV3CollectAreaModelList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
    }

    @Override
    public AdminPatrolStatisticsBackup20241231Vo getPatrolStatisticsTotalWithCompany(AdminPatrolStatisticsBackup20241231Param param) {
        AdminPatrolStatisticsBackup20241231Vo result = new AdminPatrolStatisticsBackup20241231Vo();
        int companyNum = 0;
        int normalCompanyNum = 0;
        int normalCompanyCurrNum = 0;
        int suspensionCompanyNum = 0;
        int allLT4AreaCompanyNum = 0;
        int allCompanyNum = 0;
        int allNormalCompanyNum = 0;
        int allSuspensionCompanyNum = 0;
        List<AdminPatrolStatisticsBackup20241231Vo> voList = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getPatrolStatisticsListWithCompany(param);
        for (AdminPatrolStatisticsBackup20241231Vo vo : voList) {
            companyNum += vo.getCompanyNum().intValue();
            normalCompanyNum += vo.getNormalCompanyNum().intValue();
            normalCompanyCurrNum += vo.getNormalCompanyCurrNum().intValue();
            suspensionCompanyNum += vo.getSuspensionCompanyNum().intValue();
            allLT4AreaCompanyNum += vo.getAllLT4AreaCompanyNum().intValue();
            allCompanyNum += vo.getAllCompanyNum().intValue();
            allNormalCompanyNum += vo.getAllNormalCompanyNum().intValue();
            allSuspensionCompanyNum += vo.getAllSuspensionCompanyNum().intValue();
        }
        result.setCompanyNum(Integer.valueOf(companyNum));
        result.setNormalCompanyNum(Integer.valueOf(normalCompanyNum));
        result.setNormalCompanyCurrNum(Integer.valueOf(normalCompanyCurrNum));
        result.setSuspensionCompanyNum(Integer.valueOf(suspensionCompanyNum));
        result.setAllLT4AreaCompanyNum(Integer.valueOf(allLT4AreaCompanyNum));
        result.setAllCompanyNum(Integer.valueOf(allCompanyNum));
        result.setAllNormalCompanyNum(Integer.valueOf(allNormalCompanyNum));
        result.setAllSuspensionCompanyNum(Integer.valueOf(allSuspensionCompanyNum));
        return result;
    }

    @Override
    public AdminPatrolStatisticsBackup20241231Vo getHasStaffingStreetTotalNum(AdminPatrolStatisticsBackup20241231Param param) {
        Map<Long, AreaStaffingStatisticsVo> streetNumMap = this.getHasStaffingStreetNum(param.getAreaId(), param.getAreaLevel(), param.getSystemDeploymentSource());
        int totalStreetNum = 0;
        int hasStaffingStreetNum = 0;
        int hasStaffingStreetNum17 = 0;
        int hasStaffingStreetNum18 = 0;
        if (streetNumMap.size() > 0) {
            Collection<AreaStaffingStatisticsVo> values = streetNumMap.values();
            for (AreaStaffingStatisticsVo areaStaffingStatisticsVo : values) {
                totalStreetNum += areaStaffingStatisticsVo.getTotalNum().intValue();
                hasStaffingStreetNum += areaStaffingStatisticsVo.getNum().intValue();
                hasStaffingStreetNum17 += areaStaffingStatisticsVo.getNum17().intValue();
                hasStaffingStreetNum18 += areaStaffingStatisticsVo.getNum18().intValue();
            }
        }
        AdminPatrolStatisticsBackup20241231Vo vo = new AdminPatrolStatisticsBackup20241231Vo();
        vo.setHasStaffAreaNum(Integer.valueOf(hasStaffingStreetNum));
        vo.setHasStaffAreaNum17(Integer.valueOf(hasStaffingStreetNum17));
        vo.setHasStaffAreaNum18(Integer.valueOf(hasStaffingStreetNum18));
        vo.setSubAreaNum(Integer.valueOf(totalStreetNum));
        return vo;
    }

    @Override
    public AdminPatrolStatisticsBackup20241231Vo getPatrolStatisticsTotalWithRisk(AdminPatrolStatisticsBackup20241231Param param) {
        AdminPatrolStatisticsBackup20241231Vo total = new AdminPatrolStatisticsBackup20241231Vo();
        int riskNum = 0;
        int toBeRectifiedNum = 0;
        int toBeAccepted = 0;
        int redAlertNum = 0;
        int resolvedNum = 0;
        int startEnforcement = 0;
        List<AdminPatrolStatisticsBackup20241231Vo> voList = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getPatrolStatisticsListWithRisk(param);
        for (AdminPatrolStatisticsBackup20241231Vo vo : voList) {
            riskNum += vo.getRiskNum().intValue();
            toBeRectifiedNum += vo.getToBeRectifiedNum().intValue();
            toBeAccepted += vo.getToBeAccepted().intValue();
            redAlertNum += vo.getRedAlertNum().intValue();
            resolvedNum += vo.getResolvedNum().intValue();
            startEnforcement += vo.getStartEnforcementNum().intValue();
        }
        total.setRiskNum(Integer.valueOf(riskNum));
        total.setToBeRectifiedNum(Integer.valueOf(toBeRectifiedNum));
        total.setToBeAccepted(Integer.valueOf(toBeAccepted));
        total.setRedAlertNum(Integer.valueOf(redAlertNum));
        total.setResolvedNum(Integer.valueOf(resolvedNum));
        total.setStartEnforcementNum(Integer.valueOf(startEnforcement));
        return total;
    }

    @Override
    public AdminPatrolStatisticsBackup20241231Vo getPatrolStatisticsTotalWithRectificationRate(AdminPatrolStatisticsBackup20241231Param param) {
        AdminPatrolStatisticsBackup20241231Vo total = new AdminPatrolStatisticsBackup20241231Vo();
        int rate1 = 0;
        int rate2 = 0;
        ITmPatrolInfoBackup2024Service self = (ITmPatrolInfoBackup2024Service)SpringUtils.getBean(ITmPatrolInfoBackup2024Service.class);
        List<AdminPatrolStatisticsBackup20241231Vo> voList = self.getPatrolStatisticsListWithRectificationRate(param);
        for (AdminPatrolStatisticsBackup20241231Vo vo : voList) {
            rate1 += vo.getRectificationRate1().intValue();
            rate2 += vo.getRectificationRate2().intValue();
        }
        total.setRectificationRate1(Integer.valueOf(rate1));
        total.setRectificationRate2(Integer.valueOf(rate2));
        return total;
    }

    @Override
    @Cacheable(value={"20241231:PATROL:STATISTICS:AREA:PatrolStatisticsListWithArea20241231"}, key="#param.areaId", unless="#result == null")
    public List<AdminPatrolStatisticsBackup20241231Vo> getPatrolStatisticsListWithArea(AdminPatrolStatisticsBackup20241231Param param) {
        return ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getPatrolStatisticsListWithArea(param);
    }

    @Override
    public List<AdminPatrolStatisticsBackup20241231Vo> getStreetPatrolStatisticsListWithArea(AdminPatrolStatisticsBackup20241231Param param) {
        return ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getStreetPatrolStatisticsListWithArea(param);
    }

    @Override
    @Cacheable(value={"20241231:PATROL:STATISTICS:AREA:RectificationRate"}, key="#param.getCacheKey()", unless="#result == null ||  #param.getNonCacheCondition()")
    public List<AdminPatrolStatisticsBackup20241231Vo> getPatrolStatisticsListWithRectificationRate(AdminPatrolStatisticsBackup20241231Param param) {
        return ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getPatrolStatisticsListWithRectificationRate(param);
    }

    @Override
    public AdminPatrolStatisticsBackup20241231Vo getPatrolStatisticsTotalWithPatroledCompany(AdminPatrolStatisticsBackup20241231Param param) {
        AdminPatrolStatisticsBackup20241231Vo total = new AdminPatrolStatisticsBackup20241231Vo();
        int patroledCompanyNum = 0;
        int patroledNormalCompanyNum = 0;
        int patroledSuspensionCompanyNum = 0;
        List<AdminPatrolStatisticsBackup20241231Vo> list = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getPatrolStatisticsListWithPatroledCompany(param);
        for (AdminPatrolStatisticsBackup20241231Vo vo : list) {
            patroledCompanyNum += vo.getPatroledCompanyNum().intValue();
            patroledNormalCompanyNum += vo.getPatroledNormalCompanyNum().intValue();
            patroledSuspensionCompanyNum += vo.getPatroledSuspensionCompanyNum().intValue();
        }
        total.setPatroledCompanyNum(Integer.valueOf(patroledCompanyNum));
        total.setPatroledNormalCompanyNum(Integer.valueOf(patroledNormalCompanyNum));
        total.setPatroledSuspensionCompanyNum(Integer.valueOf(patroledSuspensionCompanyNum));
        return total;
    }

    @Override
    public AreaModel getAreaById(Long areaId) {
        return ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getAreaById(areaId);
    }

    @Override
    public String collectGradeCaseSelfInfoByAreaId(Long areaId, Integer year, Boolean onlyThislevel, Byte systemDeploymentSource, Integer isFcyth) {
        if (areaId == null) {
            return "-";
        }
        AreaModel areaById = this.getAreaById(areaId);
        if (areaById == null) {
            return "-";
        }
        List<GradeV3CollectAreaModel> gradeV3CollectAreaModels = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).collectGradeCaseSelfInfoByAreaId(areaById, 1, year, onlyThislevel, systemDeploymentSource, isFcyth);
        if (CollectionUtils.isNotEmpty(gradeV3CollectAreaModels)) {
            GradeV3CollectAreaModel gradeV3CollectAreaModel = gradeV3CollectAreaModels.get(0);
            String value = gradeV3CollectAreaModel.getValue();
            return value;
        }
        return "-";
    }

    public Map<Long, String> collectGradeCaseSelfInfoByParentId(Long parentId, Integer year, Boolean onlyThislevel, Byte systemDeploymentSource, Integer isFcyth) {
        if (parentId == null) {
            return MapUtils.EMPTY_MAP;
        }
        AreaModel areaById = this.getAreaById(parentId);
        if (areaById == null) {
            return MapUtils.EMPTY_MAP;
        }
        GradeV3CollectAreaParam param = new GradeV3CollectAreaParam();
        param.setArea(areaById);
        param.setDataYear(Integer.valueOf(1));
        param.setGradeYear(year);
        param.setOnlyThislevel(onlyThislevel);
        param.setSystemDeploymentSource(systemDeploymentSource);
        param.setIsFcyth(isFcyth);
        List<GradeV3CollectAreaModel> gradeV3CollectAreaModels = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).collectGradeCaseSelfInfo(param);
        if (CollectionUtils.isNotEmpty(gradeV3CollectAreaModels)) {
            Map<Long, String> collect = gradeV3CollectAreaModels.stream().collect(Collectors.toMap(k -> k.getAreaId(), v -> v.getValue()));
            return collect;
        }
        return MapUtils.EMPTY_MAP;
    }

    public List<GradeV3CollectAreaModel> collectStreetGradeCaseSelfInfo(Long areaId, Integer year, Boolean onlyThislevel, List<Long> streetList, Byte systemDeploymentSource, Integer isFcyth) {
        if (areaId == null) {
            return Collections.emptyList();
        }
        AreaModel areaById = this.getAreaById(areaId);
        if (areaById == null) {
            return Collections.emptyList();
        }
        List<GradeV3CollectAreaModel> gradeV3CollectAreaModels = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).collectStreetGradeCaseSelfInfo(areaById, year, "", onlyThislevel, streetList, systemDeploymentSource, isFcyth);
        return gradeV3CollectAreaModels;
    }

    @Override
    public AdminPatrolStatisticsBackup20241231Vo getPatrolCoverData(AdminPatrolStatisticsBackup20241231Param param) {
        AdminPatrolStatisticsBackup20241231Vo totalWithCompany;
        AdminPatrolStatisticsBackup20241231Vo vo = new AdminPatrolStatisticsBackup20241231Vo();
        AdminPatrolStatisticsBackup20241231Vo patrolledCompanyVo = this.getPatrolStatisticsTotalWithPatroledCompany(param);
        if (patrolledCompanyVo != null) {
            vo.setPatroledCompanyNum(patrolledCompanyVo.getPatroledCompanyNum());
            vo.setPatroledNormalCompanyNum(patrolledCompanyVo.getPatroledNormalCompanyNum());
            vo.setPatroledSuspensionCompanyNum(patrolledCompanyVo.getPatroledSuspensionCompanyNum());
        }
        if ((totalWithCompany = this.getPatrolStatisticsTotalWithCompany(param)) != null) {
            vo.setCompanyNum(totalWithCompany.getCompanyNum());
            vo.setNormalCompanyNum(totalWithCompany.getNormalCompanyNum());
            vo.setNormalCompanyCurrNum(totalWithCompany.getNormalCompanyCurrNum());
            vo.setSuspensionCompanyNum(totalWithCompany.getSuspensionCompanyNum());
            vo.setAllLT4AreaCompanyNum(totalWithCompany.getAllLT4AreaCompanyNum());
            vo.setAllCompanyNum(totalWithCompany.getAllCompanyNum());
            vo.setAllNormalCompanyNum(totalWithCompany.getAllNormalCompanyNum());
            vo.setAllSuspensionCompanyNum(totalWithCompany.getAllSuspensionCompanyNum());
        }
        return vo;
    }

    @Override
    public List<AdminPatrolStatisticsVo> getStreetsPatrolCoverData(AdminPatrolStatisticsParam param) {
        ArrayList<AdminPatrolStatisticsVo> resultList = new ArrayList<AdminPatrolStatisticsVo>();
        List<AdminPatrolStatisticsVo> cNumList = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getStreetsPatrolStatisticsListWithCompany(param);
        if (!CollectionUtil.isEmpty(cNumList)) {
            if (param.getAllAreas().booleanValue() || param.getAreaLevel() == 2 || param.getBelongType() != null && param.getBelongType() == 2) {
                cNumList.forEach(item -> {
                    if (item.getAreaLevel() == 2) {
                        item.setAreaName(item.getAreaName().concat("\u672c\u7ea7"));
                    }
                });
            }
            resultList.addAll(cNumList);
        }
        List<AdminPatrolStatisticsVo> patrolledNumList = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).getStreetsPatrolStatisticsListWithPatrolledCompany(param);
        if (!CollectionUtil.isEmpty(resultList) && !CollectionUtil.isEmpty(patrolledNumList)) {
            resultList.forEach(result -> patrolledNumList.stream().filter(patrolledNum -> patrolledNum.getAreaId() != null && result.getAreaId() != null && patrolledNum.getAreaId().equals(result.getAreaId())).findFirst().ifPresent(patrolledNum -> {
                result.setPatroledCompanyNum(patrolledNum.getPatroledCompanyNum());
                result.setPatroledNormalCompanyNum(patrolledNum.getPatroledNormalCompanyNum());
                result.setPatroledSuspensionCompanyNum(patrolledNum.getPatroledSuspensionCompanyNum());
            }));
        }
        return resultList;
    }

    @Override
    public List<SelfCommitRateAreaModel> collectGradeCaseSelfInfo(SelfCommitRateSearchParam param) {
        return ((TmPatrolInfoBackup2024Mapper)this.baseMapper).collectGradeCaseSelfInfo1(param);
    }

    @Override
    public ReformRateStatisticVo reformRateTotalData(RiskSolveRateSearchParam param) {
        ReformRateStatisticVo result = new ReformRateStatisticVo();
        List<ReformRateStatisticVo> resultList = ((TmPatrolInfoBackup2024Mapper)this.baseMapper).reformRateStatisticListTotalData(param);
        if (CollectionUtils.isNotEmpty(resultList)) {
            result = resultList.get(0);
        }
        return result;
    }
}

