/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.provider.company;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffTypeEnum;
import cn.smarthse.modules.health.enums.certificate.OccHeaStaffTypeEnum;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import cn.smarthse.services.wanda.api.service.IWandaDeclareService;
import cn.smarthse.township.manage.converter.TownshipPatrolInfoToCompanyConverter;
import cn.smarthse.township.manage.converter.TownshipPatrolItemToCompanyConverter;
import cn.smarthse.township.manage.dao.reform.ReformItemBasicMapper;
import cn.smarthse.township.manage.entity.manage.TmPatrolInfo;
import cn.smarthse.township.manage.entity.manage.TmPatrolItem;
import cn.smarthse.township.manage.enums.manage.PatrolStatusEnums;
import cn.smarthse.township.manage.model.vo.company.CompanyPatrolDetailDataVo;
import cn.smarthse.township.manage.model.vo.company.CompanyPatrolIndexDataVo;
import cn.smarthse.township.manage.model.vo.company.CompanyPatrolItemVo;
import cn.smarthse.township.manage.model.vo.company.CompanyPatrolSystemDataVo;
import cn.smarthse.township.manage.model.vo.company.CompanyRiskNotificationDataVo;
import cn.smarthse.township.manage.model.vo.company.CompanyRiskNotificationItemVo;
import cn.smarthse.township.manage.model.vo.company.CompanyTownShipIndexVo;
import cn.smarthse.township.manage.provider.company.IPatrolToCompanyProviderService;
import cn.smarthse.township.manage.service.manage.ITmPatrolInfoService;
import cn.smarthse.township.manage.service.manage.ITmPatrolItemService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class PatrolToCompanyProviderServiceImpl
implements IPatrolToCompanyProviderService {
    private final ITmPatrolInfoService tmPatrolInfoService;
    private final ITmPatrolItemService tmPatrolItemService;
    private final TownshipPatrolInfoToCompanyConverter patrolInfoToCompanyConverter;
    private final TownshipPatrolItemToCompanyConverter patrolItemToCompanyConverter;
    private final ReformItemBasicMapper reformItemBasicMapper;
    @DubboReference(check=false)
    private IWandaDeclareService wandaDeclareService;
    @DubboReference
    private IPhcPhysicalCheckService phcPhysicalCheckService;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @DubboReference
    private ITsProjectSimpleService simpleService;
    @DubboReference
    private ILiteArchiveService archiveService;

    public Map<Integer, List<CompanyPatrolIndexDataVo>> getCompanyPatrolIndexData(Long cid) {
        List<CompanyPatrolIndexDataVo> patrolRecordVos = this.tmPatrolInfoService.getCompanyPatrolIndexData(cid);
        patrolRecordVos.forEach(i -> i.setCompanyPatrolOverdueInformationVo(this.reformItemBasicMapper.getOverdueInformation(i.getId())));
        Map<Integer, List<CompanyPatrolIndexDataVo>> rst = patrolRecordVos.stream().collect(Collectors.groupingBy(CompanyPatrolIndexDataVo::getYear));
        return rst;
    }

    public Map<Integer, List<CompanyPatrolIndexDataVo>> getCompanyPatrolAreaIndexData(Long cid, Long areaId, Integer areaLevel) {
        List<CompanyPatrolIndexDataVo> patrolRecordVos = this.tmPatrolInfoService.getCompanyPatrolAreaIndexData(cid, areaId, areaLevel);
        patrolRecordVos.forEach(i -> i.setCompanyPatrolOverdueInformationVo(this.reformItemBasicMapper.getOverdueInformation(i.getId())));
        return patrolRecordVos.stream().collect(Collectors.groupingBy(CompanyPatrolIndexDataVo::getYear));
    }

    public CompanyPatrolDetailDataVo getCompanyPatrolIDetailData(Long patrolId) {
        CompanyPatrolDetailDataVo rst = new CompanyPatrolDetailDataVo();
        TmPatrolInfo tmPatrolInfo = (TmPatrolInfo)this.tmPatrolInfoService.getById(patrolId);
        rst.setPatrolInfoVo(this.patrolInfoToCompanyConverter.EntityToCompanyPatrolInfoVo(tmPatrolInfo));
        QueryWrapper itemQueryWrapper = new QueryWrapper();
        itemQueryWrapper.eq((Object)"patrol_id", (Object)patrolId);
        TmPatrolItem tmPatrolItem = (TmPatrolItem)this.tmPatrolItemService.getOne((Wrapper)itemQueryWrapper);
        CompanyPatrolItemVo companyPatrolItemVo = this.patrolItemToCompanyConverter.EntityToVo(tmPatrolItem);
        ZjArchiveCountView currYearData = this.archiveService.getZjArchiveCountViewByCid(tmPatrolInfo.getCid());
        ZjArchiveCountView lastYearData = this.archiveService.getLastZjArchiveCountViewByCid(tmPatrolInfo.getCid());
        if (currYearData != null) {
            companyPatrolItemVo.setHseFileThree(currYearData.getThirdStateStr());
            companyPatrolItemVo.setHseFileCheck(currYearData.getCheckStateStr());
            companyPatrolItemVo.setHseFileManage(currYearData.getHseManageStateStr());
            companyPatrolItemVo.setHseFileStaffHealth(currYearData.getStaffStateStr());
            companyPatrolItemVo.setHseFileTrain(currYearData.getTrainStateStr());
            companyPatrolItemVo.setHseFileUnitHealth(currYearData.getPhysicalStateStr());
        }
        if (lastYearData != null) {
            companyPatrolItemVo.setHseFileThreeLast(lastYearData.getThirdStateStr());
            companyPatrolItemVo.setHseFileCheckLast(lastYearData.getCheckStateStr());
            companyPatrolItemVo.setHseFileManageLast(lastYearData.getHseManageStateStr());
            companyPatrolItemVo.setHseFileStaffHealthLast(lastYearData.getStaffStateStr());
            companyPatrolItemVo.setHseFileTrainLast(lastYearData.getTrainStateStr());
            companyPatrolItemVo.setHseFileUnitHealthLast(lastYearData.getPhysicalStateStr());
        }
        rst.setPatrolItemVo(companyPatrolItemVo);
        rst.setCompanyPatrolOverdueInformationVo(this.reformItemBasicMapper.getOverdueInformation(tmPatrolInfo.getId()));
        Long cid = tmPatrolInfo.getCid();
        CompanyPatrolSystemDataVo companyPatrolSystemDataVo = new CompanyPatrolSystemDataVo();
        WandaDeclare wandaDeclareInfo = this.wandaDeclareService.getLastOneWandaDeclareByCid(cid);
        if (Objects.nonNull(wandaDeclareInfo)) {
            companyPatrolSystemDataVo.setReportTimeStr(wandaDeclareInfo.getDeclareTime());
        }
        Date lastPhcCheckDateJobing = this.phcPhysicalCheckService.getLastPhcCheckDateJobing(cid);
        companyPatrolSystemDataVo.setPhysicalExamTimeStr(lastPhcCheckDateJobing);
        LocalDateTime latestCheckDate = this.checkPlanService.getLatestCheckDate(cid);
        companyPatrolSystemDataVo.setRegularInspectionTimeStr(latestCheckDate);
        Date mainDate = this.certificateStaffService.getCertificateValidate(cid, CertificateStaffTypeEnum.SaftyTrain.getId(), OccHeaStaffTypeEnum.MAIN.getCode());
        companyPatrolSystemDataVo.setPersonCertificateStr(mainDate);
        Date occDate = this.certificateStaffService.getCertificateValidate(cid, CertificateStaffTypeEnum.OccTrain.getId(), OccHeaStaffTypeEnum.OccHeaMan.getCode());
        companyPatrolSystemDataVo.setTrainingCertificateStr(occDate);
        JqGridParam param = new JqGridParam();
        param.setCid(cid);
        param.setPage(1);
        param.setRows(1);
        PageInfo tsProjectSimplePageInfo = this.simpleService.pageTsProjectSimple(param, null, null);
        if (tsProjectSimplePageInfo != null) {
            long total = tsProjectSimplePageInfo.getTotal();
            companyPatrolSystemDataVo.setTsProjectSimpleNum(String.valueOf(total));
        }
        rst.setCompanyPatrolSystemDataVo(companyPatrolSystemDataVo);
        return rst;
    }

    public CompanyRiskNotificationDataVo getCompanyRiskNotificationData(Long patrolId) {
        CompanyRiskNotificationDataVo rst = new CompanyRiskNotificationDataVo();
        TmPatrolInfo tmPatrolInfo = (TmPatrolInfo)this.tmPatrolInfoService.getById(patrolId);
        rst = this.patrolInfoToCompanyConverter.EntityToRiskNotificationDataVo(tmPatrolInfo);
        List voList = this.reformItemBasicMapper.getCompanyRiskNotificationItem(tmPatrolInfo.getCid(), patrolId).stream().sorted(Comparator.comparing(CompanyRiskNotificationItemVo::getFindTime).reversed()).collect(Collectors.toList());
        rst.setCompanyRiskNotificationItemVoList(voList);
        return rst;
    }

    @Deprecated
    public CompanyTownShipIndexVo getCompanyTownShipIndexData(Long cid) {
        CompanyTownShipIndexVo rst = new CompanyTownShipIndexVo();
        List<Object> patrolRecordVos = this.tmPatrolInfoService.getCompanyPatrolIndexData(cid);
        if (CollUtil.isNotEmpty(patrolRecordVos = patrolRecordVos.stream().filter(i -> i.getPatrolStatus() == 2).collect(Collectors.toList())) && patrolRecordVos.size() > 0) {
            rst.setPatrolTotalNums(Integer.valueOf(patrolRecordVos.size()));
            Map<Integer, List<CompanyPatrolIndexDataVo>> collect = patrolRecordVos.stream().collect(Collectors.groupingBy(CompanyPatrolIndexDataVo::getYear));
            int currentYear = LocalDate.now().getYear();
            if (CollUtil.isNotEmpty(collect) && collect.containsKey(currentYear)) {
                List<CompanyPatrolIndexDataVo> companyPatrolIndexDataVos = collect.get(currentYear);
                if (CollUtil.isNotEmpty(patrolRecordVos) && patrolRecordVos.size() > 0) {
                    rst.setPatrolNums(Integer.valueOf(companyPatrolIndexDataVos.size()));
                    Set set = companyPatrolIndexDataVos.stream().map(CompanyPatrolIndexDataVo::getPatrolStatus).collect(Collectors.toSet());
                    if (set.contains(PatrolStatusEnums.DONE.getCode())) {
                        rst.setPatrolStatusStr(PatrolStatusEnums.DONE.getName());
                        CompanyPatrolIndexDataVo companyPatrolIndexDataVo = companyPatrolIndexDataVos.stream().filter(i -> i.getPatrolStatus().equals(PatrolStatusEnums.DONE.getCode())).max(Comparator.comparing(CompanyPatrolIndexDataVo::getPatrolTime)).get();
                        rst.setPatrolPeopleAndTime(DesensitizationUtils.desensitized((CharSequence)companyPatrolIndexDataVo.getPatrolPeople(), (DesensitizationType)DesensitizationType.NAME) + "/" + companyPatrolIndexDataVo.getPatrolTimeStrByShortLine());
                    } else {
                        CompanyPatrolIndexDataVo companyPatrolIndexDataVo = companyPatrolIndexDataVos.stream().max(Comparator.comparing(CompanyPatrolIndexDataVo::getPatrolTime)).get();
                        rst.setPatrolStatusStr(PatrolStatusEnums.getName((Integer)companyPatrolIndexDataVo.getPatrolStatus()));
                        rst.setPatrolPeopleAndTime(DesensitizationUtils.desensitized((CharSequence)companyPatrolIndexDataVo.getPatrolPeople(), (DesensitizationType)DesensitizationType.NAME) + "/" + companyPatrolIndexDataVo.getPatrolTimeStrByShortLine());
                    }
                }
            }
        }
        return rst;
    }

    public CompanyTownShipIndexVo getTownshipAssistanceData(Long cid) {
        int currentYear = LocalDate.now().getYear();
        CompanyTownShipIndexVo town = new CompanyTownShipIndexVo();
        List patrolList = this.tmPatrolInfoService.getCompanyPatrolIndexData(cid).stream().filter(p -> Objects.equals(p.getPatrolStatus(), PatrolStatusEnums.DONE.getCode())).collect(Collectors.toList());
        if (CollUtil.isEmpty(patrolList)) {
            return town;
        }
        town.setPatrolTotalNums(Integer.valueOf(patrolList.size()));
        List yearPatrolList = patrolList.stream().collect(Collectors.groupingBy(CompanyPatrolIndexDataVo::getYear)).getOrDefault(currentYear, Collections.emptyList());
        if (CollUtil.isEmpty(yearPatrolList)) {
            return town;
        }
        town.setPatrolNums(Integer.valueOf(yearPatrolList.size()));
        yearPatrolList.stream().max(Comparator.comparing(CompanyPatrolIndexDataVo::getPatrolTime)).ifPresent(latest -> {
            boolean done = Objects.equals(latest.getPatrolStatus(), PatrolStatusEnums.DONE.getCode());
            town.setPatrolStatusStr(done ? PatrolStatusEnums.DONE.getName() : PatrolStatusEnums.getName((Integer)latest.getPatrolStatus()));
            town.setPatrolPeopleAndTime(DesensitizationUtils.desensitized((CharSequence)latest.getPatrolPeople(), (DesensitizationType)DesensitizationType.NAME) + "/" + latest.getPatrolTimeStrByShortLine());
        });
        return town;
    }

    @Generated
    public PatrolToCompanyProviderServiceImpl(ITmPatrolInfoService tmPatrolInfoService, ITmPatrolItemService tmPatrolItemService, TownshipPatrolInfoToCompanyConverter patrolInfoToCompanyConverter, TownshipPatrolItemToCompanyConverter patrolItemToCompanyConverter, ReformItemBasicMapper reformItemBasicMapper) {
        this.tmPatrolInfoService = tmPatrolInfoService;
        this.tmPatrolItemService = tmPatrolItemService;
        this.patrolInfoToCompanyConverter = patrolInfoToCompanyConverter;
        this.patrolItemToCompanyConverter = patrolItemToCompanyConverter;
        this.reformItemBasicMapper = reformItemBasicMapper;
    }
}

