/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.provider;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.township.manage.converter.TownshipPatrolInfoConverter;
import cn.smarthse.township.manage.dao.dynamic.bigdata.CompanyMapper;
import cn.smarthse.township.manage.model.param.AdminPatrolStatisticsAnnualIndicatorsParam;
import cn.smarthse.township.manage.model.param.AdminPatrolStatisticsParam;
import cn.smarthse.township.manage.model.param.SelfCommitRateSearchParam;
import cn.smarthse.township.manage.model.param.StreetCompanyStatisticsParam;
import cn.smarthse.township.manage.model.param.WorkFileHistoryPageParam;
import cn.smarthse.township.manage.model.vo.HomeData;
import cn.smarthse.township.manage.model.vo.admin.AdminHomeData;
import cn.smarthse.township.manage.model.vo.admin.AdminPatrolStatisticsAnnualIndicatorsVo;
import cn.smarthse.township.manage.model.vo.admin.AdminPatrolStatisticsVo;
import cn.smarthse.township.manage.model.vo.admin.AreaStaffingStatisticsVo;
import cn.smarthse.township.manage.model.vo.admin.EnterpriseRiskDistributionVo;
import cn.smarthse.township.manage.model.vo.admin.HomeSupervisionPatrolStatisticsData;
import cn.smarthse.township.manage.model.vo.admin.HomeSupervisionTownshipVo;
import cn.smarthse.township.manage.model.vo.admin.SelfCommitRateAreaModel;
import cn.smarthse.township.manage.model.vo.admin.StreetCompanyStatisticsTotalVo;
import cn.smarthse.township.manage.model.vo.admin.StreetCompanyStatisticslVo;
import cn.smarthse.township.manage.model.vo.admin.WorkFileHistoryStorageProgressVo;
import cn.smarthse.township.manage.model.vo.admin.WorkFileHistoryVo;
import cn.smarthse.township.manage.provider.admin.IPatrolStatisticsServiceProvider;
import cn.smarthse.township.manage.service.manage.ITmPatrolInfoService;
import cn.smarthse.township.manage.service.manage.ITownshipWorkFileService;
import cn.smarthse.township.manage.service.sys.ISysUserService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;

@DubboService
public class PatrolStatisticsServiceProviderImpl
implements IPatrolStatisticsServiceProvider {
    private final ITmPatrolInfoService tmPatrolInfoService;
    private final ISysUserService sysUserService;
    private final ITownshipWorkFileService townshipWorkFileService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @Autowired
    private CompanyMapper companyMapper;
    private final TownshipPatrolInfoConverter patrolInfoConverter;

    public JqGridData<AdminPatrolStatisticsVo> getPatrolStatisticsList(AdminPatrolStatisticsParam param) {
        return this.tmPatrolInfoService.getPatrolStatisticsList(param);
    }

    public JqGridData<AdminPatrolStatisticsVo> getStreetAreaPatrolStatisticsList(AdminPatrolStatisticsParam param) {
        return this.tmPatrolInfoService.getStreetAreaPatrolStatisticsList(param);
    }

    public JqGridData<AdminPatrolStatisticsVo> getStreetAreaPatrolStatisticsListExNull(AdminPatrolStatisticsParam param) {
        return this.tmPatrolInfoService.getStreetAreaPatrolStatisticsListExNull(param);
    }

    public AdminPatrolStatisticsVo getPatrolStatisticsTotal(AdminPatrolStatisticsParam param) {
        return this.tmPatrolInfoService.getPatrolStatisticsTotal(param);
    }

    public StreetCompanyStatisticsTotalVo getStreetCompanyStatisticsTotal(StreetCompanyStatisticsParam param) {
        return this.tmPatrolInfoService.getStreetCompanyStatisticsTotal(param);
    }

    public JqGridData<StreetCompanyStatisticslVo> getStreetCompanyStatisticsList(StreetCompanyStatisticsParam param) {
        return this.tmPatrolInfoService.getStreetCompanyStatisticsList(param);
    }

    public AdminPatrolStatisticsVo getStreetStaffNum(Long areaId) {
        return this.tmPatrolInfoService.getStreetStaffNum(areaId);
    }

    public List<AdminPatrolStatisticsVo> getRectificationForVisualization(AdminPatrolStatisticsParam param) {
        return this.tmPatrolInfoService.getRectificationForVisualization(param);
    }

    public List<AdminPatrolStatisticsVo> getPatrolRateForVisualization(AdminPatrolStatisticsParam param) {
        return this.tmPatrolInfoService.getPatrolRateForVisualization(param);
    }

    public List<AdminPatrolStatisticsAnnualIndicatorsVo> getPatrolRateForAnnualIndicators(AdminPatrolStatisticsAnnualIndicatorsParam param) {
        return this.tmPatrolInfoService.getPatrolRateForAnnualIndicators(param);
    }

    public EnterpriseRiskDistributionVo getEnterpriseRiskDistribution(AdminPatrolStatisticsParam param) {
        return this.tmPatrolInfoService.getEnterpriseRiskDistribution(param);
    }

    public String getLastPatrolDateByCid(Long cid) {
        Date date = this.tmPatrolInfoService.getLastPatrolDateByCid(cid);
        if (date == null) {
            return "";
        }
        return DateUtil.formatDate((LocalDateTime)DateUtil.getFromDate((Date)date), (String)"yyyy/MM/dd");
    }

    public Boolean isFinishedCurrYearPatrol(Long cid) {
        return this.tmPatrolInfoService.isFinishedCurrYearPatrol(cid);
    }

    public int getUnPatrolCompanyNum(Long areaId, Integer year) {
        return this.tmPatrolInfoService.getUnPatrolCompanyNum(areaId, year, null);
    }

    public Map getUnPatrolCompanyNumByAreaPid(Long areaId, Integer areaLevel) {
        return this.tmPatrolInfoService.getUnPatrolCompanyNumByAreaPid(areaId, areaLevel);
    }

    public List<AreaStaffingStatisticsVo> getAreaStaffingData(Long areaId, Integer areaLevel, Byte system) {
        return this.tmPatrolInfoService.getAreaStaffingData(areaId, areaLevel, system);
    }

    @Cacheable(value={"PATROL:getUnPatrolCompanyNum2=2h"}, key="#areaId +':'+ #year +':'+ #belongType", unless="#result == null")
    public AdminHomeData getUnPatrolCompanyNum2(Long areaId, int year, Integer belongType) {
        return this.patrolInfoConverter.toHomeData(this.tmPatrolInfoService.getUnPatrolCompanyNum2(areaId, year, belongType));
    }

    public AdminPatrolStatisticsVo getCompanyNumDataForHome(Long areaId, Integer areaLevel, Boolean isCurrent, Integer isFcyht) {
        AdminPatrolStatisticsParam param = new AdminPatrolStatisticsParam();
        param.setAreaId(areaId);
        param.setAreaLevel(areaLevel);
        param.setYear(Integer.valueOf(DateUtil.getYear()));
        param.setIsFcyth(isFcyht);
        if (isCurrent == null) {
            param.setBelongType(null);
        } else if (isCurrent.equals(true)) {
            param.setBelongType(Integer.valueOf(2));
        } else if (isCurrent.equals(false)) {
            param.setBelongType(Integer.valueOf(0));
        }
        if (areaLevel == 2) {
            if (isCurrent == null) {
                param.setBelongType(null);
            } else if (isCurrent.equals(true)) {
                param.setBelongType(Integer.valueOf(2));
            } else if (isCurrent.equals(false)) {
                param.setBelongType(Integer.valueOf(0));
            }
        }
        if (areaLevel == 3 || areaLevel == 4) {
            if (isCurrent == null) {
                param.setBelongType(null);
            } else if (isCurrent.equals(true)) {
                param.setBelongType(Integer.valueOf(0));
            } else if (isCurrent.equals(false)) {
                param.setBelongType(Integer.valueOf(2));
            }
        }
        AdminPatrolStatisticsVo result = this.tmPatrolInfoService.getPatrolStatisticsTotalWithCompany(param);
        AdminPatrolStatisticsVo patroledCompanyVo = this.tmPatrolInfoService.getPatrolStatisticsTotalWithPatroledCompany(param);
        if (patroledCompanyVo != null && result != null) {
            result.setPatroledCompanyNum(patroledCompanyVo.getPatroledCompanyNum());
            result.setPatroledNormalCompanyNum(patroledCompanyVo.getPatroledNormalCompanyNum());
            result.setPatroledSuspensionCompanyNum(patroledCompanyVo.getPatroledSuspensionCompanyNum());
        }
        return result;
    }

    public HomeSupervisionTownshipVo getHomeTownship(Long areaId, Integer areaLevel, Boolean isCurrent, int year) {
        if (Objects.isNull(areaId)) {
            throw new ServiceException("\u884c\u653f\u533a\u5212Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AreaModel area = this.sysAreaProvideService.getAreaById(areaId);
        if (Objects.isNull(area)) {
            throw new ServiceException("\u8be5\u533a\u57df\u4e0d\u5b58\u5728");
        }
        HomeData homeData = this.companyMapper.selectCompanyNumsByAreaId(areaId, area.getLevel());
        HomeSupervisionTownshipVo result = new HomeSupervisionTownshipVo();
        if (homeData != null) {
            result.setUnPatrolCompany1(homeData.getUnPatrolCompanyNum1());
            result.setUnPatrolCompany2(homeData.getUnPatrolCompanyNum2());
        }
        return result;
    }

    public void addWorkFile() {
        this.townshipWorkFileService.addWorkFile20240301();
    }

    public void addWorkFileForProvince() {
        this.townshipWorkFileService.addWorkFileForProvince20240301();
    }

    public void addWorkFileForCity() {
        this.townshipWorkFileService.addWorkFileForCity20240301();
    }

    public void addWorkFileForArea() {
        this.townshipWorkFileService.addWorkFileForArea20240301();
    }

    public void addWorkFileForStreet() {
        this.townshipWorkFileService.addWorkFileForStreet20240301();
    }

    public WorkFileHistoryVo getTotal(WorkFileHistoryPageParam param) {
        return this.townshipWorkFileService.getTotal(param);
    }

    public List<WorkFileHistoryVo> getList(WorkFileHistoryPageParam param) {
        ArrayList<WorkFileHistoryVo> result = new ArrayList<WorkFileHistoryVo>();
        List<WorkFileHistoryVo> list = this.townshipWorkFileService.getList(param);
        if (param.getAreaLevel() == 2 && param.getIncludeDirectCard() != null && param.getIncludeDirectCard() == 1) {
            WorkFileHistoryPageParam totalParam = new WorkFileHistoryPageParam();
            totalParam.setAreaId(param.getAreaId());
            totalParam.setBatchCode(param.getBatchCode());
            totalParam.setBelongType(Integer.valueOf(2));
            WorkFileHistoryVo total = this.getTotal(totalParam);
            total.setAreaName(total.getAreaName() + "\u672c\u7ea7");
            result.add(total);
        }
        result.addAll(list);
        return result;
    }

    public AdminPatrolStatisticsVo getPatrolCoverData(AdminPatrolStatisticsParam param) {
        return this.tmPatrolInfoService.getPatrolCoverData(param);
    }

    public List<AdminPatrolStatisticsVo> getStreetsPatrolCoverData(AdminPatrolStatisticsParam param) {
        return this.tmPatrolInfoService.getStreetsPatrolCoverData(param);
    }

    public WorkFileHistoryStorageProgressVo getWorkFileStorageProgress() {
        return this.townshipWorkFileService.getProgress();
    }

    public void delProgress() {
        this.townshipWorkFileService.delProgress();
    }

    public AdminPatrolStatisticsVo countCompanyNumForHome(Long areaId, Integer areaLevel, Integer belongType, Integer isFcyth) {
        AdminPatrolStatisticsParam param = new AdminPatrolStatisticsParam();
        param.setAreaId(areaId);
        param.setAreaLevel(areaLevel);
        param.setYear(Integer.valueOf(DateUtil.getYear()));
        param.setBelongType(belongType);
        param.setIsFcyth(isFcyth);
        return this.tmPatrolInfoService.countCompanyNumForHome(param);
    }

    public List<HomeSupervisionPatrolStatisticsData> listStreetCompanyPatrolStatisticsForHome(Long areaId, Integer level, Integer belongType, Integer isFcyth) {
        return this.companyMapper.listStreetCompanyPatrolStatisticsForHome(areaId, level, LocalDate.now().getYear(), belongType, isFcyth);
    }

    public List<SelfCommitRateAreaModel> collectGradeCaseSelfInfoByParentId(Long parentId, Integer areaLevel, Integer includeBelongType, Boolean cityLevel, Integer showType, Byte systemDeploymentSource, Integer isFcyth) {
        if (parentId == null) {
            return new ArrayList<SelfCommitRateAreaModel>();
        }
        SelfCommitRateSearchParam param = new SelfCommitRateSearchParam();
        param.setAreaId(parentId);
        param.setAreaLevel(areaLevel);
        param.setCityLevel(cityLevel);
        param.setIncludeBelongType(includeBelongType);
        param.setSystemDeploymentSource(systemDeploymentSource);
        param.setIsFcyth(isFcyth);
        if (showType != null) {
            if (showType == 1) {
                param.setAllStreets(Boolean.valueOf(true));
            }
            if (showType == 2) {
                param.setAllAreas(Boolean.valueOf(true));
            }
        }
        return this.tmPatrolInfoService.collectGradeCaseSelfInfo(param);
    }

    @Generated
    public PatrolStatisticsServiceProviderImpl(ITmPatrolInfoService tmPatrolInfoService, ISysUserService sysUserService, ITownshipWorkFileService townshipWorkFileService, TownshipPatrolInfoConverter patrolInfoConverter) {
        this.tmPatrolInfoService = tmPatrolInfoService;
        this.sysUserService = sysUserService;
        this.townshipWorkFileService = townshipWorkFileService;
        this.patrolInfoConverter = patrolInfoConverter;
    }
}

