/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.manage.irs;

import cn.hutool.crypto.digest.MD5;
import cn.hutool.http.HttpUtil;
import cn.smarthse.township.manage.bootstrap.properties.ZwddProperties;
import cn.smarthse.township.manage.manage.irs.model.CompanyLngLat;
import cn.smarthse.township.manage.manage.irs.model.SecretData;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CompanyLatLngManage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyLatLngManage.class);
    private final ZwddProperties zwddProperties;
    private SecretData secretData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompanyLngLat getRISLngLat(String unicode) {
        if (unicode == null || "".equals(unicode)) {
            return null;
        }
        HashMap paramMap = new HashMap();
        String url = this.zwddProperties.getDataSharing().getJwd().getUrl();
        String appKey = this.zwddProperties.getDataSharing().getJwd().getAppKey();
        String appSecret = this.zwddProperties.getDataSharing().getJwd().getAppSecret();
        long timestamp = System.currentTimeMillis();
        String requestTime = String.valueOf(timestamp);
        if (this.secretData == null || this.secretData.getRequestSecretEndTime() < timestamp) {
            CompanyLatLngManage companyLatLngManage = this;
            synchronized (companyLatLngManage) {
                this.secretData = this.refreshTokenByKey(appKey, appSecret, requestTime);
            }
        }
        if (this.secretData == null) {
            return null;
        }
        String sign = MD5.create().digestHex(appKey + this.secretData.getRequestSecret() + requestTime);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appKey", appKey);
        param.put("requestTime", requestTime);
        param.put("sign", sign);
        param.put("unicode", unicode);
        String result = HttpUtil.post((String)url, param);
        CompanyLngLat companyLngLat = new CompanyLngLat();
        companyLngLat.setUnifiedSocialCc(unicode);
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            JSONArray array = JSONArray.parseArray((String)jsonObject.getString("datas"), (JSONReader.Feature[])new JSONReader.Feature[0]);
            JSONObject obj = (JSONObject)array.get(0);
            log.debug("\u7ecf\u7eac\u5ea6\u4fe1\u606f\u67e5\u8be2\uff1aresult: {}", (Object)obj);
            companyLngLat.setIrsLat(obj.getString("latitude"));
            companyLngLat.setIrsLng(obj.getString("longitude"));
        }
        catch (Exception e) {
            log.error("\u7ecf\u7eac\u5ea6\u4fe1\u606f\u67e5\u8be2\uff0c\u51fa\u9519\uff0cunicode\uff1a{} - result:{}", (Object)unicode, (Object)result);
            return null;
        }
        return companyLngLat;
    }

    private SecretData refreshTokenByKey(String appKey, String appSecret, String requestTime) {
        SecretData secretData;
        HashMap<String, String> params = new HashMap<String, String>();
        String tokenUrl = "https://interface.zjzwfw.gov.cn/gateway/app/refreshTokenByKey.htm";
        String sign = MD5.create().digestHex(appKey + appSecret + requestTime);
        params.put("appKey", appKey);
        params.put("sign", sign);
        params.put("requestTime", requestTime);
        String result = HttpUtil.post((String)tokenUrl, params);
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            secretData = (SecretData)JSON.parseObject((String)jsonObject.getString("datas"), SecretData.class);
        }
        catch (Exception e) {
            log.error("\u7ecf\u7eac\u5ea6\u4fe1\u606f\u67e5\u8be2refreshTokenByKey\uff0c\u51fa\u9519\uff0cresult:{}", (Object)result);
            return null;
        }
        log.debug("\u7ecf\u7eac\u5ea6\u4fe1\u606f\u67e5\u8be2refreshTokenByKey\uff0csecretData\uff1a{}", (Object)secretData);
        return secretData;
    }

    @Generated
    public CompanyLatLngManage(ZwddProperties zwddProperties) {
        this.zwddProperties = zwddProperties;
    }
}

