/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.manage.impl;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.work.reform.param.ReformRecordAcceptanceParam;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.modules.health.vo.work.reform.RiskTypeVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.township.manage.bootstrap.security.ShiroUtil;
import cn.smarthse.township.manage.converter.TownshipPatrolInfoConverter;
import cn.smarthse.township.manage.dao.dynamic.bigdata.CompanyMapper;
import cn.smarthse.township.manage.dao.reform.ReformItemBasicMapper;
import cn.smarthse.township.manage.entity.manage.TmPatrolInfo;
import cn.smarthse.township.manage.manage.IReformManage;
import cn.smarthse.township.manage.model.param.ReformParam;
import cn.smarthse.township.manage.model.param.SaveReformRecordParam;
import cn.smarthse.township.manage.model.vo.CompanyPortraitVo;
import cn.smarthse.township.manage.model.vo.ReformDetailVo;
import cn.smarthse.township.manage.model.vo.ReformItemSource;
import cn.smarthse.township.manage.model.vo.ReformRecordDetailVo;
import cn.smarthse.township.manage.model.vo.ReformStasticsVo;
import cn.smarthse.township.manage.model.vo.ReformVo;
import cn.smarthse.township.manage.service.manage.ITmPatrolInfoService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReformManageImpl
implements IReformManage {
    @DubboReference(version="1.0.0", timeout=20000)
    private ISysAreaProvideService areaProvideService;
    @DubboReference
    private ISysFileProvideService fileProvideService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    private final ITmPatrolInfoService patrolInfoService;
    private final ReformItemBasicMapper baseMapper;
    private final CompanyMapper companyMapper;
    private final TownshipPatrolInfoConverter patrolInfoConverter;
    @Value(value="${sys.patrol-deadline}")
    private String deadline;

    @Override
    public List<ReformVo> getReformListByPatrolId(Long patrolId, Long areaId) {
        Byte level = this.getAreaLevel(areaId);
        return this.baseMapper.getReformList(patrolId, null, areaId, level);
    }

    @Override
    public List<ReformVo> getReformListByPatrolId2(Long patrolId, Long areaId) {
        Byte level = this.getAreaLevel(areaId);
        return this.baseMapper.getReformList(patrolId, ReformStatusEnum.DYS.getValue(), areaId, level);
    }

    @Override
    public List<ReformVo> getReformListByCid2(Long cid) {
        return this.baseMapper.getReformListByCid(cid, ReformStatusEnum.DYS.getValue());
    }

    @Override
    public List<ReformVo> getPastReformList(Long patrolId, Long areaId) {
        Byte level = this.getAreaLevel(areaId);
        return this.baseMapper.getPastReformList(patrolId, areaId, level);
    }

    @Override
    public List<ReformVo> getPastReformListByCid(Long patrolId, Long cid) {
        return this.baseMapper.getPastReformListByCid(patrolId, cid);
    }

    @Override
    public JqGridData<ReformVo> getReformListData(ReformParam param) {
        param.setAreaId(ShiroUtil.getAreaId());
        param.setLevel(this.getAreaLevel(param.getAreaId()));
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData(new PageInfo(this.baseMapper.getReformListData(param)), (JqGridParam)param);
    }

    @Override
    public JqGridData<ReformVo> getReformListDataV2(ReformParam param) {
        List<ReformVo> maxTimeList;
        param.setAreaId(ShiroUtil.getAreaId());
        param.setLevel(this.getAreaLevel(param.getAreaId()));
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ReformVo> list = this.baseMapper.getReformListDataV2(param);
        if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(maxTimeList = this.baseMapper.getMaxTime(list.stream().map(ReformVo::getReformId).collect(Collectors.toList())))) {
            Map<Long, ReformVo> map = maxTimeList.stream().collect(Collectors.toMap(ReformVo::getReformId, obj -> obj));
            list.forEach(record -> {
                record.setActualFinishTime(((ReformVo)map.get(record.getReformId())).getActualFinishTime());
                record.setRequireFinishTime(((ReformVo)map.get(record.getReformId())).getRequireFinishTime());
                record.setAcceptanceDate(((ReformVo)map.get(record.getReformId())).getAcceptanceDate());
            });
        }
        return new JqGridData(new PageInfo(list), (JqGridParam)param);
    }

    @Override
    public ReformDetailVo getReform(Long reformId) {
        if (reformId == null) {
            return null;
        }
        return this.baseMapper.getReform(reformId);
    }

    @Override
    public ReformDetailVo getReformV2(Long reformId) {
        if (reformId == null) {
            return null;
        }
        Long sourceId = reformId;
        ReformDetailVo exists = this.getReform(reformId);
        if (exists != null) {
            reformId = exists.getBasicId();
        }
        ReformDetailVo result = new ReformDetailVo();
        result.setReformItemSourceList(this.getReformItemSourceList(reformId));
        result.setReformRecordList(this.getReformRecordList(reformId));
        if (result.getReformItemSourceList() != null) {
            ReformItemSource source = result.getReformItemSourceList().stream().filter(r -> r.getReformId().equals(sourceId)).findFirst().get();
            BeanUtils.copyProperties((Object)source, (Object)result);
            if (!(source.getStatus() != ReformStatusEnum.WC.getValue() && source.getStatus() != ReformStatusEnum.WXZG.getValue() || DateUtils.getYear((Date)source.getFindTime()) != LocalDate.now().getYear() || CollectionUtils.isEmpty((Collection)result.getReformRecordList()))) {
                LocalDate acceptanceDate = result.getReformRecordList().stream().max(Comparator.comparing(ReformRecordDetailVo::getReformRecordId)).get().getAcceptanceDate();
                if (acceptanceDate != null && !acceptanceDate.isBefore(LocalDate.of(LocalDate.now().getYear(), 1, 1)) && !acceptanceDate.isAfter(LocalDate.of(LocalDate.now().getYear(), 3, 1))) {
                    result.setFindTimeStr("\u65e0\u9700\u63a8\u9001");
                    result.setFindTimeRemark(LocalDate.now().getYear() + "-" + this.deadline + "\u4e4b\u524d\u5316\u89e3\u7684\u98ce\u9669\u4e0d\u8fdb\u884c\u98ce\u9669\u63a8\u9001\uff01");
                } else {
                    result.setFindTimeStr(DateUtil.format((Date)result.getFindTime(), (String)"yyyy-MM-dd"));
                }
            } else {
                result.setFindTimeStr(DateUtil.format((Date)result.getFindTime(), (String)"yyyy-MM-dd"));
            }
            if (ReformSourceLiteEnum.TOWNSHIP_MANAGE.getValue().equals(result.getReformItemSource())) {
                result.setComany(this.patrolInfoConverter.EntityToVo((TmPatrolInfo)this.patrolInfoService.getById(((ReformItemSource)result.getReformItemSourceList().get(0)).getReformItemSourceId())));
            } else {
                result.setComany(this.companyMapper.getPatrolInfoVo(result.getCid()));
            }
        }
        return result;
    }

    List<ReformItemSource> getReformItemSourceList(Long basicId) {
        List<ReformItemSource> list = this.baseMapper.getReformItemSourceList(basicId);
        if (list == null) {
            return null;
        }
        Map<Integer, List<ReformItemSource>> map = list.stream().collect(Collectors.groupingBy(ReformItemSource::getReformItemSource));
        for (Integer reformItemSource : map.keySet()) {
            List<ReformItemSource> reformItemSources = map.get(reformItemSource);
            for (int i = 0; i < reformItemSources.size(); ++i) {
                reformItemSources.get(i).setBatchNum(Integer.valueOf(i + 1));
            }
        }
        return list;
    }

    @Override
    public ReformRecordDetailVo getReformRecord(Long reformRecordId) {
        if (reformRecordId == null) {
            return null;
        }
        ReformRecordDetailVo reformRecord = this.baseMapper.getReformRecord(reformRecordId);
        if (reformRecord != null) {
            reformRecord.setReformFinishedFileList(this.fileProvideService.getListByIds(reformRecord.getReformFinishedFiles()));
            reformRecord.setAcceptanceFileList(this.fileProvideService.getListByIds(reformRecord.getAcceptanceFiles()));
        }
        return reformRecord;
    }

    @Override
    public List<ReformRecordDetailVo> getReformRecordList(Long reformId) {
        if (reformId == null) {
            return null;
        }
        List<ReformRecordDetailVo> list = this.baseMapper.getReformRecordList(reformId);
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(record -> {
                record.setReformFinishedFileList(this.fileProvideService.getListByIds(record.getReformFinishedFiles()));
                record.setAcceptanceFileList(this.fileProvideService.getListByIds(record.getAcceptanceFiles()));
            });
        }
        return list;
    }

    @Override
    public ReformStasticsVo getReformStatisticsByCid(Long cid) {
        ReformStasticsVo rst = this.baseMapper.getReformStatisticsByCid(cid, this.getYeas());
        if (rst == null) {
            rst = new ReformStasticsVo();
        }
        rst.setReformRiskNum(this.baseMapper.getReformRiskNum(cid, this.getYeas()));
        return rst;
    }

    @Override
    public ReformStasticsVo getReformStatistics(Long patrolId) {
        return this.baseMapper.getReformStatistics(patrolId);
    }

    @Override
    public ReformStasticsVo getReformStatisticsByAreaId(Long areaId) {
        Byte level = this.getAreaLevel(areaId);
        return this.baseMapper.getReformStatisticsByAreaId(areaId, level, LocalDate.now().getYear());
    }

    @Override
    public ReformStasticsVo getHomeStatisticsByAreaId(Long areaId) {
        Byte level = this.getAreaLevel(areaId);
        return this.baseMapper.getHomeStatisticsByAreaId(areaId, level, this.getYeas());
    }

    @Override
    public void saveReformRecord(SaveReformRecordParam param) {
        Byte acceptanceResult = (byte)(param.getStatus().intValue() != ReformStatusEnum.TH.getValue().intValue() ? 1 : 0);
        ReformDetailVo result = this.baseMapper.getReform(param.getReformId());
        ReformRecordAcceptanceParam dtoParam = new ReformRecordAcceptanceParam();
        dtoParam.setReformItemId(result.getBasicId());
        dtoParam.setUserId(ShiroUtil.getLoginUserId());
        dtoParam.setFullName(ShiroUtil.getLoginUserNickname());
        dtoParam.setAcceptanceDirectorName(param.getAcceptanceDirectorName());
        dtoParam.setAcceptanceFiles(param.getAcceptanceFiles());
        dtoParam.setAcceptanceResultExplain(param.getSituationDescription());
        dtoParam.setAcceptanceResult(acceptanceResult);
        this.reformItemBasicService.reformRecordAcceptance(dtoParam);
    }

    @Override
    public CompanyPortraitVo getCompanyPortrait(Long id) {
        return this.baseMapper.selectKeyFactorPortraitReport(id);
    }

    @Override
    public ZjArchiveCountView getCompanyArchive(Long id) {
        return this.liteArchiveService.getZjArchiveCountViewByCid(id);
    }

    @Override
    public List<RiskTypeVo> getRiskTypeList(Long id) {
        if (id == null) {
            return null;
        }
        return this.reformItemBasicService.getRiskTypeListDataNew(id);
    }

    @Override
    public int getYeas() {
        return LocalDate.now().getYear();
    }

    private Byte getAreaLevel(Long areaId) {
        AreaModel area = this.areaProvideService.getAreaById(areaId);
        return area != null ? area.getLevel() : null;
    }

    @Generated
    public ReformManageImpl(ITmPatrolInfoService patrolInfoService, ReformItemBasicMapper baseMapper, CompanyMapper companyMapper, TownshipPatrolInfoConverter patrolInfoConverter) {
        this.patrolInfoService = patrolInfoService;
        this.baseMapper = baseMapper;
        this.companyMapper = companyMapper;
        this.patrolInfoConverter = patrolInfoConverter;
    }
}

