/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.manage.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.entity.CompanyProposedChange;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.StopDataSourceEnums;
import cn.smarthse.modules.datacentre.enums.StopStatusEnums;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.datacentre.enums.StopTypeForReasonEnums;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeClueLastParam;
import cn.smarthse.modules.datacentre.provider.ICompanyProposedChangeProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.bigdata.IBigDataLogProviderService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffTypeEnum;
import cn.smarthse.modules.health.enums.certificate.OccHeaStaffTypeEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.fcyth.service.IFcythTbcCompanyClueService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.modules.health.vo.summary.ReformAddParamXzxg;
import cn.smarthse.modules.health.vo.work.reform.ReformAddParam;
import cn.smarthse.modules.health.vo.work.reform.RiskTypeVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import cn.smarthse.services.wanda.api.service.IWandaDeclareService;
import cn.smarthse.township.manage.bootstrap.security.ShiroUtil;
import cn.smarthse.township.manage.converter.TownshipPatrolInfoConverter;
import cn.smarthse.township.manage.converter.TownshipPatrolItemConverter;
import cn.smarthse.township.manage.converter.TownshipReformConverter;
import cn.smarthse.township.manage.dao.manager.TmPatrolInfoMapper;
import cn.smarthse.township.manage.entity.manage.TmPatrolInfo;
import cn.smarthse.township.manage.entity.manage.TmPatrolItem;
import cn.smarthse.township.manage.enums.manage.PatrolStatusEnums;
import cn.smarthse.township.manage.manage.IPatrolManage;
import cn.smarthse.township.manage.manage.IReformManage;
import cn.smarthse.township.manage.model.param.AddReformListParam;
import cn.smarthse.township.manage.model.param.ChangeAreaOrStatesParam;
import cn.smarthse.township.manage.model.param.ChangeCompanyParam;
import cn.smarthse.township.manage.model.param.ChangeFcythClueParam;
import cn.smarthse.township.manage.model.param.ChangeLngAngLatParam;
import cn.smarthse.township.manage.model.param.CidParam;
import cn.smarthse.township.manage.model.param.CompanyChangePushParam;
import cn.smarthse.township.manage.model.param.CompanyListParam;
import cn.smarthse.township.manage.model.param.PatrolRecordParam;
import cn.smarthse.township.manage.model.param.UpdatePatrolInfoParam;
import cn.smarthse.township.manage.model.param.UpdatePatrolParam;
import cn.smarthse.township.manage.model.vo.CompanyDetailVo;
import cn.smarthse.township.manage.model.vo.CompanyInfoVo;
import cn.smarthse.township.manage.model.vo.CompanyListVo;
import cn.smarthse.township.manage.model.vo.CompanyPortraitVo;
import cn.smarthse.township.manage.model.vo.PatrolItemReferenceDataVo;
import cn.smarthse.township.manage.model.vo.PatrolNumVo;
import cn.smarthse.township.manage.model.vo.PatrolRecordVo;
import cn.smarthse.township.manage.model.vo.PatrolVo;
import cn.smarthse.township.manage.model.vo.ReformListVo;
import cn.smarthse.township.manage.model.vo.ReformStasticsVo;
import cn.smarthse.township.manage.model.vo.ReformVo;
import cn.smarthse.township.manage.service.manage.ITmPatrolInfoService;
import cn.smarthse.township.manage.service.manage.ITmPatrolItemService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import com.sx.log.util.LogUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PatrolManageImpl
implements IPatrolManage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PatrolManageImpl.class);
    @Autowired
    @Lazy
    private IPatrolManage self;
    @Autowired
    private TownshipPatrolInfoConverter patrolInfoConverter;
    @Autowired
    private TownshipPatrolItemConverter patrolItemConverter;
    @Autowired
    private TownshipReformConverter reformConverter;
    @Autowired
    private ITmPatrolInfoService patrolInfoService;
    @Autowired
    private ITmPatrolItemService patrolItemService;
    @Autowired
    private TmPatrolInfoMapper infoMapper;
    @Autowired
    private IReformManage reformManage;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    @DubboReference
    private ISysFileProvideService fileProvideService;
    @DubboReference
    private IReformItemBasicNewService itemBasicNewService;
    @DubboReference
    private ILiteArchiveService archiveService;
    @DubboReference
    private IWandaDeclareService wandaDeclareService;
    @DubboReference
    private IPhcPhysicalCheckService phcPhysicalCheckService;
    @DubboReference
    private IFcythTbcCompanyClueService fcythTbcCompanyClueService;
    @DubboReference
    ICertificateStaffDetailService certificateStaffService;
    @DubboReference
    ICheckPlanService checkPlanService;
    @DubboReference
    private ITsProjectSimpleService simpleService;
    @DubboReference
    private ICompanyGradeV3RecService gradeV3RecService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService hseService;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @DubboReference
    private IBigDataLogProviderService bigDataLogProviderService;
    @DubboReference
    private ICompanyProposedChangeProviderService companyProposedChangeProviderService;
    @Value(value="${bx.tokenUrl}")
    private String tokenUrl;
    @Value(value="${bx.callBackUrl}")
    private String callBackUrl;
    @Value(value="${bx.appId}")
    private String appId;
    @Value(value="${bx.appSecret}")
    private String appSecret;
    @Value(value="${bigLog.appCode}")
    private String appCode;

    @Override
    public List<PatrolNumVo> listPatrolNum(Long cid) {
        return this.patrolInfoService.listPatrolNum(cid);
    }

    @Override
    public List<PatrolRecordVo> listPatrolRecord(PatrolRecordParam param) {
        List<PatrolRecordVo> rst = this.patrolInfoService.listPatrolRecord(param);
        rst.stream().forEach(patrol -> patrol.setReformStasticsVo(this.reformManage.getReformStatistics(patrol.getId())));
        return rst;
    }

    @Override
    public PatrolVo getPatrol(Long id, Long areaId) {
        PatrolVo rst = new PatrolVo();
        TmPatrolInfo info = (TmPatrolInfo)this.patrolInfoService.getById(id);
        rst.setPatrolInfoVo(this.patrolInfoConverter.EntityToVo(info));
        rst.getPatrolInfoVo().setPatrolFileUrl(this.fileProvideService.getListByIds(info.getPatrolFile()));
        rst.getPatrolInfoVo().setUnitManageSignUrl(this.fileProvideService.getFileUrl(info.getUnitManageSign()));
        TmPatrolItem item = this.patrolItemService.getItemByPatrolId(id);
        if (info.getPatrolStatus() == PatrolStatusEnums.PATROLLING.getCode() || info.getPatrolStatus() == PatrolStatusEnums.NOT_STARTED.getCode()) {
            this.handleDefaultItemValue(item, info.getCid());
        }
        rst.setPatrolItemVo(this.patrolItemConverter.EntityToVo(item));
        rst.setReformStasticsVo(this.reformManage.getReformStatistics(id));
        ArrayList<ReformListVo> list = new ArrayList<ReformListVo>();
        List<ReformListVo> reformListVos = this.reformConverter.voToListVo(this.reformManage.getReformListByPatrolId(id, areaId));
        List<ReformListVo> pastReformListVos = this.reformConverter.voToListVo(this.reformManage.getPastReformListByCid(id, info.getCid()));
        reformListVos.stream().forEach(reformVo -> reformVo.setIsThisFind(Integer.valueOf(1)));
        list.addAll(reformListVos);
        list.addAll(pastReformListVos);
        rst.setReformListVo(list);
        return rst;
    }

    @Override
    @Transactional
    public Long addPatrol(CidParam param) {
        int year = Calendar.getInstance().get(1);
        Long cid = param.getCid();
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"cid", (Object)cid)).eq((Object)"year", (Object)year)).orderByDesc((Object)"create_date")).last("limit 1");
        TmPatrolInfo lastInfo = (TmPatrolInfo)this.patrolInfoService.getOne((Wrapper)wrapper);
        CompanyInfoVo companyInfo = this.infoMapper.selectCompanyInfo(cid);
        if (!Objects.equals(lastInfo.getPatrolStatus(), PatrolStatusEnums.DONE.getCode()) && !Objects.equals(lastInfo.getPatrolStatus(), PatrolStatusEnums.END.getCode())) {
            throw new ServiceException("\u8bf7\u5b8c\u6210[" + lastInfo.getPatrolName() + "]\u5e2e\u6276\u5de5\u4f5c\uff01");
        }
        TmPatrolInfo info = new TmPatrolInfo();
        Integer patrolTotalNum = this.patrolInfoService.getPatrolTotalNum(cid);
        info.setPatrolName("\u7b2c" + (patrolTotalNum + 1) + "\u6b21-" + companyInfo.getName() + "\u5e2e\u6276");
        info.setPatrolStatus(PatrolStatusEnums.PATROLLING.getCode());
        info.setCid(cid);
        info.setYear(Integer.valueOf(year));
        info.setPatrolPeople(ShiroUtil.getLoginUserNickname());
        info.setUserId(ShiroUtil.getLoginUserId());
        info.setAreaId(companyInfo.getAreaId());
        AreaModel areaInfo = this.areaProvideService.getAreaById(companyInfo.getAreaId());
        info.setAreaId1(areaInfo.getProvinceId());
        info.setAreaId2(areaInfo.getCityId());
        info.setAreaId3(areaInfo.getAreaId());
        info.setAreaId4(areaInfo.getStreetId());
        this.patrolInfoService.save(info);
        param.setPatrolId(info.getId());
        TmPatrolItem item = new TmPatrolItem();
        item.setPatrolId(info.getId());
        item.setCid(info.getCid());
        this.handleDefaultItemValue(item, cid);
        this.patrolItemService.save(item);
        return info.getId();
    }

    @Override
    @Transactional
    public Boolean updatePatrol(UpdatePatrolParam updateParam) {
        if (updateParam.getPatrolInfoParam() != null) {
            TmPatrolInfo info = this.patrolInfoConverter.updateParamToEntity(updateParam.getPatrolInfoParam());
            if (Objects.equals(info.getPatrolStatus(), PatrolStatusEnums.DONE.getCode()) || Objects.equals(info.getPatrolStatus(), PatrolStatusEnums.END.getCode())) {
                info.setPatrolTime(new Date());
                info.setYear(Integer.valueOf(Calendar.getInstance().get(1)));
            }
            AreaModel areaInfo = this.areaProvideService.getAreaById(info.getAreaId());
            info.setAreaId1(areaInfo.getProvinceId());
            info.setAreaId2(areaInfo.getCityId());
            info.setAreaId3(areaInfo.getAreaId());
            info.setAreaId4(areaInfo.getStreetId());
            boolean r1 = this.patrolInfoService.updateById(info);
            if (Objects.equals(info.getPatrolStatus(), PatrolStatusEnums.END.getCode()) && info.getStopType() != null) {
                this.infoMapper.updateCompanySupervise(info.getCid(), info.getStopType());
            }
        }
        if (updateParam.getPatrolItemParam() != null) {
            TmPatrolItem item = this.patrolItemConverter.updateParamToEntity(updateParam.getPatrolItemParam());
            boolean bl = this.patrolItemService.saveOrUpdate(item);
        }
        return null;
    }

    @Override
    public PatrolItemReferenceDataVo getItemReferenceData(Long cid) {
        ZjArchiveCountView currYearData = this.archiveService.getZjArchiveCountViewByCid(cid);
        ZjArchiveCountView lastYearData = this.archiveService.getLastZjArchiveCountViewByCid(cid);
        WandaDeclare wandaDeclareInfo = this.wandaDeclareService.getLastOneWandaDeclareByCid(cid);
        Date lastPhcCheckDateJobing = this.phcPhysicalCheckService.getLastPhcCheckDateJobing(cid);
        Date occDate = this.certificateStaffService.getCertificateValidate(cid, CertificateStaffTypeEnum.OccTrain.getId(), OccHeaStaffTypeEnum.OccHeaMan.getCode());
        Date mainDate = this.certificateStaffService.getCertificateValidate(cid, CertificateStaffTypeEnum.SaftyTrain.getId(), OccHeaStaffTypeEnum.MAIN.getCode());
        LocalDateTime latestCheckDate = this.checkPlanService.getLatestCheckDate(cid);
        JqGridParam param = new JqGridParam();
        param.setCid(cid);
        param.setPage(1);
        param.setRows(1);
        PageInfo tsProjectSimplePageInfo = this.simpleService.pageTsProjectSimple(param, null, null);
        long total = 0L;
        if (tsProjectSimplePageInfo != null) {
            total = tsProjectSimplePageInfo.getTotal();
        }
        PatrolItemReferenceDataVo vo = new PatrolItemReferenceDataVo();
        if (currYearData != null) {
            vo.setHseFileThree(currYearData.getThirdStateStr());
            vo.setHseFileCheck(currYearData.getCheckStateStr());
            vo.setHseFileManage(currYearData.getHseManageStateStr());
            vo.setHseFileStaffHealth(currYearData.getStaffStateStr());
            vo.setHseFileTrain(currYearData.getTrainStateStr());
            vo.setHseFileUnitHealth(currYearData.getPhysicalStateStr());
        }
        if (lastYearData != null) {
            vo.setHseFileThreeLast(lastYearData.getThirdStateStr());
            vo.setHseFileCheckLast(lastYearData.getCheckStateStr());
            vo.setHseFileManageLast(lastYearData.getHseManageStateStr());
            vo.setHseFileStaffHealthLast(lastYearData.getStaffStateStr());
            vo.setHseFileTrainLast(lastYearData.getTrainStateStr());
            vo.setHseFileUnitHealthLast(lastYearData.getPhysicalStateStr());
        }
        vo.setCheckDate(DateUtil.getDate((LocalDateTime)latestCheckDate));
        vo.setThreeNum(Integer.valueOf(Long.valueOf(total).intValue()));
        vo.setCid(cid);
        if (wandaDeclareInfo != null && wandaDeclareInfo.getDeclareTime() != null) {
            vo.setDeclareDate(wandaDeclareInfo.getDeclareTime());
        } else {
            CompanyBaseInfoModel companyById = this.hseService.getCompanyById(cid);
            if (companyById != null && companyById.getCreateDate() != null) {
                vo.setDeclareDate(companyById.getCreateDate());
            }
        }
        vo.setHealthDate(lastPhcCheckDateJobing);
        if (occDate == null) {
            vo.setTrainManageData(Integer.valueOf(0));
        } else if (occDate.getTime() < new Date().getTime()) {
            vo.setTrainManageData(Integer.valueOf(1));
        } else {
            vo.setTrainManageData(Integer.valueOf(2));
        }
        if (mainDate == null) {
            vo.setTrainMianData(Integer.valueOf(0));
        } else if (mainDate.getTime() < new Date().getTime()) {
            vo.setTrainMianData(Integer.valueOf(1));
        } else {
            vo.setTrainMianData(Integer.valueOf(2));
        }
        return vo;
    }

    @Override
    public List<ReformListVo> getReformListByPid(Long patrolId, Long cid) {
        TmPatrolItem item = this.patrolItemService.getItemByPatrolId(patrolId);
        List<ReformVo> pastList = this.reformManage.getPastReformListByCid(patrolId, cid);
        ArrayList<ReformListVo> list = new ArrayList<ReformListVo>();
        list.addAll(this.transformItem(item));
        list.addAll(this.reformConverter.voToListVo(pastList));
        return list;
    }

    @Override
    @Caching(evict={@CacheEvict(value={"homeData=1"}, key="#param.year +':'+ #param.areaId")})
    @Transactional
    public String commitReformAndPatrol(AddReformListParam param) {
        TmPatrolInfo info = (TmPatrolInfo)this.patrolInfoService.getById(param.getPatrolId());
        info.setPatrolStatus(PatrolStatusEnums.DONE.getCode());
        info.setUnitManageSign(param.getUnitManageSign());
        info.setGuidePeople(param.getGuidePeople());
        info.setPatrolPeople(ShiroUtil.getLoginUserNickname());
        info.setUserId(ShiroUtil.getLoginUserId());
        info.setYear(Integer.valueOf(Calendar.getInstance().get(1)));
        info.setPatrolTime(new Date());
        this.patrolInfoService.updateById(info);
        Date date = new Date();
        ArrayList addParamList = new ArrayList();
        List<ReformAddParamXzxg> reformAddParam = this.reformConverter.addParamToReformParam(param.getReformList());
        reformAddParam.stream().forEach(addParam -> {
            ReformAddParam basic = new ReformAddParam();
            basic.setCid(addParam.getCid());
            basic.setFinderName(ShiroUtil.getLoginUserNickname());
            basic.setFindTime(date);
            basic.setName(addParam.getName());
            basic.setReformItemSource(ReformSourceLiteEnum.TOWNSHIP_MANAGE.getValue());
            basic.setReformItemSourceId(addParam.getReformItemSourceId());
            basic.setGenerationSource(addParam.getReformGenerationSource());
            basic.setReformMeasure(addParam.getReformMeasure());
            basic.setDescription(addParam.getName());
            basic.setCreateBy(ShiroUtil.getLoginUserId());
            addParamList.add(basic);
        });
        this.itemBasicNewService.generateReform(addParamList);
        try {
            final String dataParam = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now());
            final String sign = DigestUtils.md5Hex((String)(this.appId + this.appSecret + dataParam));
            ObjectMapper mapper = new ObjectMapper();
            String jsonRequest = mapper.writeValueAsString((Object)new HashMap<String, String>(){
                {
                    this.put("appId", PatrolManageImpl.this.appId);
                    this.put("sign", sign);
                    this.put("requestTime", dataParam);
                }
            });
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(this.tokenUrl);
            StringEntity urlParam = new StringEntity(jsonRequest, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)urlParam);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            String bxTokenResponseStrEntity = EntityUtils.toString((HttpEntity)response.getEntity());
            String bxToken = mapper.readTree(bxTokenResponseStrEntity).get("data").asText();
            if (response.getStatusLine().getStatusCode() == 200 && bxTokenResponseStrEntity.contains("10200")) {
                response.close();
                HttpPost callBackPost = new HttpPost(this.callBackUrl);
                StringEntity cbParam = new StringEntity("{\"cid\":" + info.getCid() + "}", ContentType.APPLICATION_JSON);
                callBackPost.setHeader("token", bxToken);
                callBackPost.setEntity((HttpEntity)cbParam);
                CloseableHttpResponse callBackResponse = httpClient.execute((HttpUriRequest)callBackPost);
                String callBackMsg = EntityUtils.toString((HttpEntity)callBackResponse.getEntity());
                if (callBackResponse.getStatusLine().getStatusCode() != 200 || !callBackMsg.contains("10200")) {
                    log.error("\u6807\u73ba\u56de\u8c03\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)callBackMsg);
                }
                callBackResponse.close();
            } else {
                response.close();
                log.error("\u83b7\u53d6\u6807\u73batoken\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)response.getStatusLine());
            }
            httpClient.close();
        }
        catch (Exception e) {
            log.error("\u6807\u73ba\u56de\u8c03\u5931\u8d25\uff1a", (Throwable)e);
        }
        return null;
    }

    @Override
    @Transactional
    public Long createForClock(Long cid) {
        TmPatrolInfo info = this.getOrAddLastPatrolWithAreaAndYear(cid);
        if (info.getPatrolStatus() == PatrolStatusEnums.NOT_STARTED.getCode() || info.getPatrolStatus() == PatrolStatusEnums.PATROLLING.getCode()) {
            return info.getId();
        }
        if (info.getPatrolStatus() == PatrolStatusEnums.DONE.getCode() || info.getPatrolStatus() == PatrolStatusEnums.END.getCode()) {
            return this.addPatrol(new CidParam().setCid(cid));
        }
        return null;
    }

    @Override
    @Transactional
    public Boolean commitForClock(UpdatePatrolInfoParam param) {
        TmPatrolInfo info = this.patrolInfoConverter.updateParamToEntity(param);
        info.setPatrolTime(new Date());
        info.setPatrolStatus(PatrolStatusEnums.DONE.getCode());
        info.setDoneType(Integer.valueOf(1));
        AreaModel areaInfo = this.areaProvideService.getAreaById(info.getAreaId());
        info.setAreaId1(areaInfo.getProvinceId());
        info.setAreaId2(areaInfo.getCityId());
        info.setAreaId3(areaInfo.getAreaId());
        info.setAreaId4(areaInfo.getStreetId());
        boolean r1 = this.patrolInfoService.updateById(info);
        return r1;
    }

    @Override
    public JqGridData<CompanyListVo> listCompanyByAreaId(CompanyListParam param) throws InterruptedException {
        AreaModel area = this.areaProvideService.getAreaById(param.getAreaId());
        param.setLevel(area != null ? area.getLevel() : null);
        List<Object> allCompanyList = ((IPatrolManage)SpringUtils.getBean(IPatrolManage.class)).getAllCompanyByAreaId(param);
        if (!StringUtils.isEmpty((CharSequence)param.getKeyword())) {
            allCompanyList = allCompanyList.stream().filter(company -> company.getName() != null && company.getName().contains(param.getKeyword())).collect(Collectors.toList());
        }
        List<Object> beforePage = new ArrayList<CompanyListVo>(allCompanyList);
        if (param.getIsRiskOver() != null && param.getIsRiskOver() == 0) {
            beforePage = beforePage.stream().filter(company -> company.getBusinessState() == 1).collect(Collectors.toList());
            beforePage = beforePage.stream().filter(company -> company.getIsShowVictims() == null || company.getIsShowVictims() >= 3).collect(Collectors.toList());
            List<Long> batchCidWithPortrait = this.infoMapper.selectBatchCidWithPortrait(param.getAreaId());
            beforePage = beforePage.stream().filter(company -> batchCidWithPortrait.contains(company.getId())).collect(Collectors.toList());
        }
        if (param.getCompanyState() != null) {
            if (param.getCompanyState() == 1) {
                beforePage = beforePage.stream().filter(company -> company.getBusinessState() == 1).collect(Collectors.toList());
                if (param.getIsNeedPatrol() != null && param.getIsNeedPatrol() == 1) {
                    beforePage = beforePage.stream().filter(company -> company.getIsShowVictims() == null || company.getIsShowVictims() >= 3).collect(Collectors.toList());
                }
            } else if (param.getCompanyState() == 2) {
                beforePage = beforePage.stream().filter(company -> company.getBusinessState() == 2).collect(Collectors.toList());
            }
        }
        if (param.getStatus() != null) {
            List<Long> hadPatrolledCompany = this.infoMapper.selectBatchCompanyIdWithPatrol(param.getUserId(), param.getAreaId(), param.getYear());
            if (param.getStatus() == 1) {
                beforePage = beforePage.stream().filter(company -> !hadPatrolledCompany.contains(company.getId()) && (company.getIsShowVictims() == null || company.getIsShowVictims() >= 3)).collect(Collectors.toList());
            } else if (param.getStatus() == 2) {
                beforePage = beforePage.stream().filter(company -> hadPatrolledCompany.contains(company.getId())).collect(Collectors.toList());
            } else if (param.getStatus() == 3) {
                beforePage = beforePage.stream().filter(company -> null != company.getIsShowVictims() && (company.getIsShowVictims() == 1 || company.getIsShowVictims() == 2)).collect(Collectors.toList());
            }
        }
        if (param.getWarningStatus() != null) {
            List<Long> listCompanyIdForWarning = this.infoMapper.listCompanyIdForWarning(param.getAreaId(), param.getWarningStatus());
            beforePage = beforePage.stream().filter(company -> listCompanyIdForWarning.contains(company.getId())).collect(Collectors.toList());
        }
        if (param.getBelongType() != null) {
            beforePage = beforePage.stream().filter(company -> company.getBelongType() == param.getBelongType()).collect(Collectors.toList());
        }
        if (param.getIsFcyth() != null) {
            beforePage = beforePage.stream().filter(company -> company.getIsFcyth() == param.getIsFcyth()).collect(Collectors.toList());
        }
        for (CompanyListVo companyListVo : beforePage) {
            if (companyListVo.getBusinessState() == null || companyListVo.getBusinessState() != 2) continue;
            companyListVo.setPortraitNum(null);
            companyListVo.setRiskNum(null);
        }
        Integer pageTotal = beforePage.size() % param.getRows() == 0 ? beforePage.size() / param.getRows() : beforePage.size() / param.getRows() + 1;
        List list = beforePage.stream().skip((long)(param.getPage() - 1) * (long)param.getRows()).limit(param.getRows()).collect(Collectors.toList());
        CountDownLatch countDownLatch = new CountDownLatch(list.size() * 2);
        list.stream().forEach(company -> {
            this.threadPoolTaskExecutor.execute(() -> {
                company.setPatrolTotalNum(this.patrolInfoService.getPatrolTotalNum(company.getId()));
                company.setCurrYearPatrolNum(this.patrolInfoService.getPatrolNumByYear(company.getId()));
                company.setLastPatrolDate(this.patrolInfoService.getLastPatrolDateByCid(company.getId()));
                countDownLatch.countDown();
            });
            this.threadPoolTaskExecutor.execute(() -> {
                company.setLastReformData(this.reformManage.getReformStatisticsByCid(company.getId()));
                countDownLatch.countDown();
            });
        });
        countDownLatch.await();
        JqGridData jqGridData = new JqGridData();
        jqGridData.setTotal((long)pageTotal.intValue());
        jqGridData.setPage((long)param.getPage());
        jqGridData.setRecords((long)beforePage.size());
        jqGridData.setRows(list);
        return jqGridData;
    }

    @Override
    @Cacheable(value={"allCompanyData=15m"}, key="'userId:' + #param.userId + ':isRiskOver:' + #param.isRiskOver", unless="#result == null")
    public List<CompanyListVo> getAllCompanyByAreaId(CompanyListParam param) {
        List<CompanyListVo> companyList = this.infoMapper.selectBatchCompanyByArea(param);
        companyList.stream().forEach(company -> company.setTownshipStopType(this.getCompanyStopTypeByCid(company.getId())));
        return companyList;
    }

    @Override
    @Transactional
    public CompanyDetailVo getCompanyById(Long id) {
        CompanyDetailVo rst = new CompanyDetailVo();
        int year = Calendar.getInstance().get(1);
        TmPatrolInfo info = this.getOrAddLastPatrolWithAreaAndYear(id);
        if (info != null) {
            rst.setLastPatrolId(info.getId());
            rst.setLastPatrolName(info.getPatrolName());
            rst.setLastPatrolDate(this.patrolInfoService.getLastPatrolDateByCid(id));
            rst.setPatrolPeople(info.getPatrolPeople());
            rst.setPatrolTime(info.getPatrolTime());
            rst.setPatrolStatus(info.getPatrolStatus());
            rst.setStopType(info.getStopType());
            ReformStasticsVo thisReform = this.reformManage.getReformStatistics(info.getId());
            rst.setThisReformNum(thisReform.getReformRiskNum());
        }
        rst.setLastReformData(this.reformManage.getReformStatisticsByCid(id));
        rst.setPatrolNumData(this.listPatrolNum(id));
        CompanyInfoVo companyInfo = this.infoMapper.selectCompanyInfo(id);
        rst.setName(companyInfo.getName());
        rst.setBusinessState(companyInfo.getBusinessState());
        rst.setLat(companyInfo.getLat());
        rst.setLng(companyInfo.getLng());
        rst.setTownshipStopType(this.getCompanyStopTypeByCid(id));
        return rst;
    }

    @Override
    public CompanyPortraitVo getCompanyPortrait(Long id) {
        if (id == null) {
            return null;
        }
        CompanyPortraitVo rst = this.reformManage.getCompanyPortrait(id);
        if (null == rst) {
            rst = new CompanyPortraitVo();
        }
        CompanyInfoVo companyInfo = this.infoMapper.selectCompanyInfo(id);
        rst.setName(companyInfo.getName());
        rst.setAddress(companyInfo.getWorkAddress());
        return rst;
    }

    @Override
    public ZjArchiveCountView getCompanyArchive(Long id) {
        if (id == null) {
            return null;
        }
        return this.reformManage.getCompanyArchive(id);
    }

    private Integer getCompanyStopTypeByCid(Long cid) {
        Integer stopType = null;
        stopType = this.infoMapper.getCompanyStopTypeByCid(cid, StopDataSourceEnums.XZXG.getCode());
        if (stopType == null) {
            stopType = this.infoMapper.getCompanyStopTypeByCid(cid, StopDataSourceEnums.FWGJ.getCode());
        }
        if (stopType == null) {
            return 0;
        }
        return stopType;
    }

    @Override
    public CompanyInfoVo getCompanyBeforeChange(Long id) {
        return this.infoMapper.selectCompanyInfo(id);
    }

    @Override
    @Transactional
    public String changeCompanyInfo(ChangeCompanyParam param) {
        this.infoMapper.updateCompanyInfo(param);
        return null;
    }

    @Override
    @CacheEvict(value={"allCompanyData"}, key="'userId:' + #param.userId")
    @Transactional
    public String changeComAreaOrStates(ChangeAreaOrStatesParam param) {
        if (param == null || param.getChangeType() == null) {
            throw new RuntimeException("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570!");
        }
        CompanyInfoVo companyInfoVo = this.infoMapper.selectCompanyInfo(param.getId());
        TmPatrolInfo info = (TmPatrolInfo)this.patrolInfoService.getById(param.getPatrolId());
        CompanyChangePushParam changePushParam = new CompanyChangePushParam();
        changePushParam.setSourceId(param.getPatrolId().toString());
        changePushParam.setCid(param.getId());
        changePushParam.setContactName(param.getContactName());
        changePushParam.setContactTel(param.getContactTel());
        changePushParam.setReasonType(param.getReasonType());
        changePushParam.setFileIds(param.getFileIds());
        changePushParam.setStopAreaId(param.getAreaId());
        changePushParam.setUserId(param.getUserId());
        changePushParam.setRepeatCid(param.getRepeatCid());
        if (info.getUnitName() == null) {
            info.setUnitName(companyInfoVo.getName());
            info.setUnitStatus(companyInfoVo.getBusinessState());
            info.setManager(companyInfoVo.getMainLeaderName());
            info.setTel(companyInfoVo.getMainLeaderTel());
            info.setHseManager(companyInfoVo.getOccManagerName());
            info.setHesTel(companyInfoVo.getOccManagerTel());
            info.setAddress(companyInfoVo.getAreaName());
            info.setWorkAddress(companyInfoVo.getWorkAddress());
            info.setIndustryCode(companyInfoVo.getIndustryCategory() != null ? companyInfoVo.getIndustryCategory().toString() : null);
            info.setIndustryName(companyInfoVo.getIndustryCategoryName());
            info.setScaleCode(companyInfoVo.getScale() != null ? companyInfoVo.getScale().toString() : null);
            info.setEconomyCode(companyInfoVo.getRegisterType() != null ? companyInfoVo.getRegisterType().toString() : null);
            info.setEconomyName(companyInfoVo.getRegisterTypeName());
        }
        if (param.getChangeType() == 1) {
            Integer areaNum;
            if (param.getAreaId() == null) {
                throw new RuntimeException("\u8bf7\u9009\u62e9\u8fc1\u79fb\u540e\u7684\u533a\u57df!");
            }
            Integer stopType = null;
            Integer cityNum = this.infoMapper.countByCityId(companyInfoVo.getAreaId(), param.getAreaId());
            stopType = cityNum > 1 ? StopTypeEnums.CHANGECROSS.getCode() : ((areaNum = this.infoMapper.countByAreaId(companyInfoVo.getAreaId(), param.getAreaId())) > 1 ? StopTypeEnums.CHANGEWITHIN.getCode() : StopTypeEnums.CHANGEDISTRICTWITHIN.getCode());
            changePushParam.setStopType(stopType);
            this.self.pushCompanyChange(changePushParam);
            info.setStopType(stopType);
            info.setPatrolStatus(PatrolStatusEnums.END.getCode());
            info.setUserId(ShiroUtil.getLoginUserId());
            info.setPatrolTime(new Date());
            this.patrolInfoService.updateById(info);
        }
        if (param.getChangeType() == 2 && Objects.equals(param.getBusinessState(), CompanyBusinessState.CLOSE.getCode())) {
            changePushParam.setStopType(StopTypeEnums.CLOSE.getCode());
            this.self.pushCompanyChange(changePushParam);
            info.setPatrolStatus(PatrolStatusEnums.END.getCode());
            info.setStopType(StopTypeEnums.CLOSE.getCode());
            info.setUserId(ShiroUtil.getLoginUserId());
            info.setPatrolTime(new Date());
            this.patrolInfoService.updateById(info);
        }
        return null;
    }

    @Override
    public JqGridData<CompanyInfoVo> listCompanyForClose(CompanyListParam param) {
        AreaModel area = this.areaProvideService.getAreaById(param.getAreaId());
        param.setLevel(area != null ? area.getLevel() : null);
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CompanyInfoVo> list = this.infoMapper.listCompanyForClose(param);
        return new JqGridData((Page)list, (JqGridParam)param);
    }

    @Override
    @Transactional
    public String changeStatesForPause(ChangeAreaOrStatesParam param) {
        if (param.getChangeType() == 2) {
            CompanyInfoVo companyInfoVo = this.infoMapper.selectCompanyInfo(param.getId());
            if (Objects.equals(param.getBusinessState(), CompanyBusinessState.NORMAL.getCode())) {
                CompanyChangePushParam changePushParam = new CompanyChangePushParam();
                changePushParam.setSourceId(param.getPatrolId().toString());
                changePushParam.setCid(param.getId());
                changePushParam.setContactName(param.getContactName());
                changePushParam.setContactTel(param.getContactTel());
                changePushParam.setReasonType(param.getReasonType());
                changePushParam.setFileIds(param.getFileIds());
                changePushParam.setStopAreaId(param.getAreaId());
                changePushParam.setUserId(param.getUserId());
                changePushParam.setStopType(StopTypeEnums.NORMAL.getCode());
                this.self.pushCompanyChange(changePushParam);
            }
        }
        return null;
    }

    @Override
    @Transactional
    public String changeLngAndLat(ChangeLngAngLatParam param) {
        if (param.getNewLat() == null || param.getNewLng() == null) {
            throw new RuntimeException("\u5f53\u524d\u7ecf\u7eac\u5ea6\u6709\u8bef\uff0c\u8bf7\u6253\u5f00\u5b9a\u4f4d\u91cd\u8bd5");
        }
        if (param.getCid() == null) {
            throw new RuntimeException("\u4f01\u4e1aid\u4e3a\u7a7a\uff01");
        }
        param.setChangeInfoId(Long.valueOf(IdWorker.getId()));
        this.infoMapper.addLngChangeRecord(param, StopDataSourceEnums.XZXG.getCode());
        this.infoMapper.updateCompanyLngAndLat(param);
        TmPatrolInfo info = (TmPatrolInfo)this.patrolInfoService.getById(param.getPatrolId());
        if (info == null) {
            throw new ServiceException("\u63a5\u5bb3\u4eba\u6570\u5c0f\u4e8e3\u4eba\u5219\u4e0d\u5de1\u67e5\uff01");
        }
        info.setPatrolFile(param.getPatrolFile());
        this.patrolInfoService.updateById(info);
        return null;
    }

    @Override
    public void changeFcythClue(ChangeFcythClueParam param) {
        param.setOperateId(ShiroUtil.getLoginUserId());
        this.fcythTbcCompanyClueService.addTbcCompanyClueByXzxg(param.getCid(), param.getCommitName(), param.getCommitReason(), param.getCommitFile(), param.getOperateId());
    }

    @Transactional
    public TmPatrolInfo getOrAddLastPatrolWithAreaAndYear(Long cid) {
        int year = Calendar.getInstance().get(1);
        CompanyInfoVo companyInfo = this.infoMapper.selectCompanyInfo(cid);
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"cid", (Object)cid)).eq((Object)"year", (Object)year)).eq((Object)"area_id", (Object)companyInfo.getAreaId())).orderByDesc((Object)"create_date")).last("limit 1");
        TmPatrolInfo info = (TmPatrolInfo)this.patrolInfoService.getOne((Wrapper)wrapper);
        if (info == null) {
            Integer patrolTotalNum = this.patrolInfoService.getPatrolTotalNum(cid);
            info = new TmPatrolInfo();
            info.setPatrolName("\u7b2c" + (patrolTotalNum + 1) + "\u6b21-" + companyInfo.getName() + "\u5e2e\u6276");
            info.setPatrolStatus(PatrolStatusEnums.NOT_STARTED.getCode());
            info.setCid(cid);
            info.setYear(Integer.valueOf(year));
            info.setPatrolPeople(ShiroUtil.getLoginUserNickname());
            info.setUserId(ShiroUtil.getLoginUserId());
            info.setAreaId(companyInfo.getAreaId());
            AreaModel areaInfo = this.areaProvideService.getAreaById(companyInfo.getAreaId());
            info.setAreaId1(areaInfo.getProvinceId());
            info.setAreaId2(areaInfo.getCityId());
            info.setAreaId3(areaInfo.getAreaId());
            info.setAreaId4(areaInfo.getStreetId());
            this.patrolInfoService.save(info);
            info = (TmPatrolInfo)this.patrolInfoService.getById(info.getId());
            TmPatrolItem item = new TmPatrolItem();
            item.setPatrolId(info.getId());
            this.handleDefaultItemValue(item, cid);
            this.patrolItemService.save(item);
            String areaCode = Convert.toStr((Object)ShiroUtil.getAreaId()).substring(0, Math.min(Convert.toStr((Object)ShiroUtil.getAreaId()).length(), 9));
            LogUtils.workStart((String)Convert.toStr((Object)ShiroUtil.getLoginUserId()), (UserRoleEnum)UserRoleEnum.GOVERNMENT_STAFF_TYPE, (String)areaCode, (String)Convert.toStr((Object)info.getId()));
            String actionId = BigLogBusinessModuleEnum.module4_1.getValue().concat(String.valueOf(info.getId()));
            this.bigDataLogProviderService.handleBigDataLog(ActionTypeEnum.WORK_START_TYPE, UserRoleEnum.GOVERNMENT_STAFF_TYPE, actionId, ShiroUtil.getLoginUserId(), areaCode, this.appCode);
        }
        return info;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public Boolean pushCompanyChange(CompanyChangePushParam param) {
        CompanyProposedChange entity;
        CompanyInfoVo company = this.infoMapper.selectCompanyInfo(param.getCid());
        if (Objects.isNull(company)) {
            throw new ServiceException("\u8be5\u4f01\u4e1a\u4e0d\u5b58\u5728\u4e8e\u6d59\u91cc\u536b\u4f01");
        }
        Integer stopType = param.getStopType();
        Integer reasonType = param.getReasonType();
        String fileIds = param.getFileIds();
        Long stopAreaId = param.getStopAreaId();
        String repeatCid = param.getRepeatCid();
        LocalDateTime now = LocalDateTime.now();
        String sourceId = param.getSourceId();
        String contactName = param.getContactName();
        String contactTel = param.getContactTel();
        Boolean historicalData = false;
        Long userId = param.getUserId();
        Long cid = param.getCid();
        if (!(StopTypeEnums.CLOSE.getCode().equals(stopType) || StopTypeEnums.CHANGECROSS.getCode().equals(stopType) || StopTypeEnums.CHANGEWITHIN.getCode().equals(stopType) || StopTypeEnums.CHANGEDISTRICTWITHIN.getCode().equals(stopType) || StopTypeEnums.NORMAL.getCode().equals(stopType))) {
            throw new HealthException("stopType\u53c2\u6570\u975e\u6cd5");
        }
        CompanyProposedChangeClueLastParam clueLastParam = new CompanyProposedChangeClueLastParam();
        clueLastParam.setStopDataSource(StopDataSourceEnums.XZXG.getCode());
        clueLastParam.setCid(param.getCid());
        if (StopTypeEnums.CLOSE.getCode().equals(stopType) || StopTypeEnums.NORMAL.getCode().equals(stopType)) {
            clueLastParam.setStopTypeList(Arrays.asList(StopTypeEnums.CLOSE.getCode(), StopTypeEnums.NORMAL.getCode()));
        } else {
            clueLastParam.setStopTypeList(Arrays.asList(StopTypeEnums.CHANGECROSS.getCode(), StopTypeEnums.CHANGEWITHIN.getCode(), StopTypeEnums.CHANGEDISTRICTWITHIN.getCode()));
        }
        List clueList = this.companyProposedChangeProviderService.getClueList(clueLastParam);
        clueList = clueList.stream().filter(i -> StopStatusEnums.PENDING_CONFIRMATION.getCode().equals(i.getStatus()) || StopStatusEnums.PROCESS.getCode().equals(i.getStatus())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(clueList)) {
            Map<String, CompanyProposedChange> clueMap = clueList.stream().collect(Collectors.toMap(CompanyProposedChange::getSourceId, companyProposedChange -> companyProposedChange, (v1, v2) -> v2));
            entity = clueMap.get(sourceId);
            if (Objects.nonNull(entity)) {
                if (Objects.equals(entity.getSourceId(), sourceId)) {
                    if (!StopStatusEnums.PENDING_CONFIRMATION.getCode().equals(entity.getStatus())) throw new ServiceException(ResponseStateEnum.fail.getValue(), String.format("\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u7ebf\u7d22\u72b6\u6001\u662f %s", StopStatusEnums.getName((Integer)entity.getStatus())));
                    entity.setStopType(stopType);
                    entity.setStopAreaId(stopAreaId);
                    entity.setReasonType(reasonType);
                    entity.setFileIds(fileIds);
                    entity.setRepeatCid(repeatCid);
                    entity.setConfirmTime(null);
                    entity.setContactName(contactName);
                    entity.setContactTel(contactTel);
                    entity.setUpdateBy(userId);
                    entity.setUpdateDate(now);
                    entity.setHistoricalData(historicalData);
                } else if (StopTypeEnums.CLOSE.getCode().equals(stopType) || StopTypeEnums.NORMAL.getCode().equals(stopType)) {
                    if (!StopStatusEnums.PENDING_CONFIRMATION.getCode().equals(entity.getStatus())) throw new ServiceException(ResponseStateEnum.fail.getValue(), String.format("\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u7ebf\u7d22\u72b6\u6001\u662f %s\uff0c\u65e0\u6cd5\u65b0\u589e", StopStatusEnums.getName((Integer)entity.getStatus())));
                    entity = new CompanyProposedChange();
                    entity.setStopDataSource(StopDataSourceEnums.XZXG.getCode());
                    entity.setSourceId(sourceId);
                    entity.setCid(cid);
                    entity.setStopType(stopType);
                    entity.setStopAreaId(stopAreaId);
                    entity.setReasonType(reasonType);
                    entity.setFileIds(fileIds);
                    entity.setRepeatCid(repeatCid);
                    entity.setStatus(StopStatusEnums.PENDING_CONFIRMATION.getCode());
                    entity.setConfirmTime(null);
                    entity.setContactName(contactName);
                    entity.setContactTel(contactTel);
                    entity.setCreateBy(userId);
                    entity.setCreateDate(now);
                    entity.setUpdateBy(userId);
                    entity.setUpdateDate(now);
                    entity.setIsValid(Boolean.valueOf(true));
                    entity.setHistoricalData(historicalData);
                } else {
                    if (stopAreaId.equals(entity.getStopAreaId())) {
                        throw new ServiceException(ResponseStateEnum.fail.getValue(), String.format("\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u7ebf\u7d22\u72b6\u6001\u662f %s\uff0c\u53d8\u66f4\u5730\u5740\u76f8\u540c\uff0c\u65e0\u6cd5\u65b0\u589e", StopStatusEnums.getName((Integer)entity.getStatus())));
                    }
                    entity = new CompanyProposedChange();
                    entity.setStopDataSource(StopDataSourceEnums.XZXG.getCode());
                    entity.setSourceId(sourceId);
                    entity.setCid(cid);
                    entity.setStopType(stopType);
                    entity.setStopAreaId(stopAreaId);
                    entity.setReasonType(reasonType);
                    entity.setFileIds(fileIds);
                    entity.setRepeatCid(repeatCid);
                    entity.setStatus(StopStatusEnums.PENDING_CONFIRMATION.getCode());
                    entity.setConfirmTime(null);
                    entity.setContactName(contactName);
                    entity.setContactTel(contactTel);
                    entity.setCreateBy(userId);
                    entity.setCreateDate(now);
                    entity.setUpdateBy(userId);
                    entity.setUpdateDate(now);
                    entity.setIsValid(Boolean.valueOf(true));
                    entity.setHistoricalData(historicalData);
                }
            } else {
                if (StopTypeEnums.CLOSE.getCode().equals(stopType) || StopTypeEnums.NORMAL.getCode().equals(stopType)) {
                    for (CompanyProposedChange existing : clueList) {
                        if (!stopType.equals(existing.getStopType())) continue;
                        throw new ServiceException(ResponseStateEnum.fail.getValue(), "\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u65e0\u6cd5\u65b0\u589e");
                    }
                } else {
                    for (CompanyProposedChange existing : clueList) {
                        Integer existingStopType = existing.getStopType();
                        if (!StopTypeEnums.CHANGECROSS.getCode().equals(existingStopType) && !StopTypeEnums.CHANGEWITHIN.getCode().equals(existingStopType) && !StopTypeEnums.CHANGEDISTRICTWITHIN.getCode().equals(existingStopType) || !stopAreaId.equals(existing.getStopAreaId())) continue;
                        throw new ServiceException(ResponseStateEnum.fail.getValue(), "\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u53d8\u66f4\u5730\u5740\u76f8\u540c\uff0c\u65e0\u6cd5\u65b0\u589e");
                    }
                }
                entity = new CompanyProposedChange();
                entity.setStopDataSource(StopDataSourceEnums.XZXG.getCode());
                entity.setSourceId(sourceId);
                entity.setCid(cid);
                entity.setStopType(stopType);
                entity.setStopAreaId(stopAreaId);
                entity.setReasonType(reasonType);
                entity.setFileIds(fileIds);
                entity.setRepeatCid(repeatCid);
                entity.setStatus(StopStatusEnums.PENDING_CONFIRMATION.getCode());
                entity.setConfirmTime(null);
                entity.setContactName(contactName);
                entity.setContactTel(contactTel);
                entity.setCreateBy(userId);
                entity.setCreateDate(now);
                entity.setUpdateBy(userId);
                entity.setUpdateDate(now);
                entity.setIsValid(Boolean.valueOf(true));
                entity.setHistoricalData(historicalData);
            }
        } else {
            entity = new CompanyProposedChange();
            entity.setStopDataSource(StopDataSourceEnums.XZXG.getCode());
            entity.setSourceId(sourceId);
            entity.setCid(cid);
            entity.setStopType(stopType);
            entity.setStopAreaId(stopAreaId);
            entity.setReasonType(reasonType);
            entity.setFileIds(fileIds);
            entity.setRepeatCid(repeatCid);
            entity.setStatus(StopStatusEnums.PENDING_CONFIRMATION.getCode());
            entity.setConfirmTime(null);
            entity.setContactName(contactName);
            entity.setContactTel(contactTel);
            entity.setCreateBy(userId);
            entity.setCreateDate(now);
            entity.setUpdateBy(userId);
            entity.setUpdateDate(now);
            entity.setIsValid(Boolean.valueOf(true));
            entity.setHistoricalData(historicalData);
        }
        SysAreaV3OneVo stopArea = null;
        if (StopTypeEnums.CLOSE.getCode().equals(stopType)) {
            if (Objects.isNull(reasonType)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u539f\u56e0\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!(StopTypeForReasonEnums.ONE.getCode().equals(reasonType) || StopTypeForReasonEnums.TWO.getCode().equals(reasonType) || StopTypeForReasonEnums.THREE.getCode().equals(reasonType) || StopTypeForReasonEnums.FOUR.getCode().equals(reasonType))) {
                throw new HealthException("reasonType\u53c2\u6570\u975e\u6cd5");
            }
            if (StopTypeForReasonEnums.TWO.getCode().equals(reasonType)) {
                if (StrUtil.isBlank((CharSequence)repeatCid)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u91cd\u590d\u4f01\u4e1acid\u4e0d\u80fd\u4e3a\u7a7a");
                }
                List repeatCidList = StrUtil.split((CharSequence)repeatCid, (CharSequence)",");
                if (CollUtil.isEmpty((Collection)repeatCidList)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u91cd\u590d\u4f01\u4e1acid\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (StrUtil.isBlank((CharSequence)fileIds)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isNotBlank((CharSequence)fileIds)) {
                fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)",");
                if (CollUtil.isEmpty((Collection)fileIdList)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (fileIdList.size() > 3) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
                }
            }
            if (CompanyBusinessState.CLOSE.getCode().byteValue() == company.getBusinessState().intValue()) {
                entity.setStatus(StopStatusEnums.CONFIRMED.getCode());
                entity.setConfirmTime(LocalDateTime.now());
            }
        } else if (StopTypeEnums.CHANGECROSS.getCode().equals(stopType)) {
            if (Objects.isNull(stopAreaId)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)fileIds)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isNotBlank((CharSequence)fileIds)) {
                fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)",");
                if (CollUtil.isEmpty((Collection)fileIdList)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (fileIdList.size() > 3) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
                }
            }
            if (Objects.isNull(stopArea = this.areaProvideService.getAreaByIdV3(stopAreaId))) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u5b58\u5728");
            }
            if (stopAreaId != 0L && stopArea.getLevel() < 3) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u9700\u7cbe\u786e\u5230\u533a\u53bf\u7ea7\u522b");
            }
            area = this.areaProvideService.getAreaByIdV3(company.getAreaId());
            if (stopAreaId != 0L && Objects.equals(stopArea.getCityId(), area.getCityId())) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.CHANGECROSS.getName() + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u80fd\u662f\u539f\u5740\u7684\u672c\u5e02\u8303\u56f4\u5185");
            }
        } else if (StopTypeEnums.CHANGEWITHIN.getCode().equals(stopType)) {
            if (Objects.isNull(stopAreaId)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isNotBlank((CharSequence)fileIds) && CollUtil.isNotEmpty((Collection)(fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)","))) && fileIdList.size() > 3) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
            }
            stopArea = this.areaProvideService.getAreaByIdV3(stopAreaId);
            if (Objects.isNull(stopArea)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u5b58\u5728");
            }
            if (stopArea.getLevel() < 3) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u9700\u7cbe\u786e\u5230\u533a\u53bf\u7ea7\u522b");
            }
            area = this.areaProvideService.getAreaByIdV3(company.getAreaId());
            if (stopAreaId != 0L && !Objects.equals(stopArea.getCityId(), area.getCityId())) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.CHANGEWITHIN.getName() + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u5fc5\u987b\u662f\u539f\u5740\u7684\u672c\u5e02\u8303\u56f4\u5185");
            }
        } else if (StopTypeEnums.CHANGEDISTRICTWITHIN.getCode().equals(stopType)) {
            if (Objects.isNull(stopAreaId)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isNotBlank((CharSequence)fileIds) && CollUtil.isNotEmpty((Collection)(fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)","))) && fileIdList.size() > 3) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
            }
            stopArea = this.areaProvideService.getAreaByIdV3(stopAreaId);
            if (Objects.isNull(stopArea)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u5b58\u5728");
            }
            if (stopArea.getLevel() < 4) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u9700\u7cbe\u786e\u5230\u8857\u9053\u7ea7\u522b");
            }
        }
        try {
            entity.setBeforeAreaId(company.getAreaId());
            entity.setBeforeBusinessState(company.getBusinessState());
            if (StopTypeEnums.CLOSE.getCode().equals(stopType)) {
                entity.setStopBusinessState(CompanyBusinessState.CLOSE.getCode());
            } else if (StopTypeEnums.NORMAL.getCode().equals(stopType)) {
                entity.setStopBusinessState(CompanyBusinessState.NORMAL.getCode());
            }
            this.companyProposedChangeProviderService.saveOrUpdate(entity);
            return true;
        }
        catch (Exception e) {
            log.error("\u4e61\u9547\u534f\u7ba1-\u4e0a\u62a5\u7528\u4eba\u5355\u4f4d\u4fe1\u606f\u53d8\u66f4\u60c5\u51b5\u5931\u8d25\uff1a", (Throwable)e);
            return false;
        }
    }

    protected void handleDefaultItemValue(TmPatrolItem item, Long cid) {
        List<RiskTypeVo> riskTypeList = this.reformManage.getRiskTypeList(cid);
        if (CollectionUtils.isNotEmpty(riskTypeList)) {
            for (RiskTypeVo risk : riskTypeList) {
                String riskCode = risk.getRiskTypeCode();
                String riskStatus = risk.getRiskTypeStatus();
                switch (riskCode) {
                    case "declare_riskType": {
                        if (riskStatus.equals("\u6709\u98ce\u9669") || riskStatus.contains("\u672a\u5316\u89e3")) {
                            item.setIfExistsDeclare(Integer.valueOf(0));
                            item.setDeclareFlag(Integer.valueOf(1));
                            break;
                        }
                        item.setIfExistsDeclare(Integer.valueOf(1));
                        item.setDeclareFlag(Integer.valueOf(0));
                        break;
                    }
                    case "detection_riskType": {
                        if (riskStatus.equals("\u6709\u98ce\u9669") || riskStatus.contains("\u672a\u5316\u89e3")) {
                            item.setIfExistsCheck(Integer.valueOf(0));
                            item.setCheckFlag(Integer.valueOf(1));
                            break;
                        }
                        item.setIfExistsCheck(Integer.valueOf(1));
                        item.setCheckFlag(Integer.valueOf(0));
                        break;
                    }
                    case "physicalExamination_riskType": {
                        if (riskStatus.equals("\u6709\u98ce\u9669") || riskStatus.contains("\u672a\u5316\u89e3")) {
                            item.setIfExistsHealth(Integer.valueOf(0));
                            item.setHealthFlag(Integer.valueOf(1));
                            break;
                        }
                        item.setIfExistsHealth(Integer.valueOf(1));
                        item.setHealthFlag(Integer.valueOf(0));
                        break;
                    }
                    case "training_riskType": {
                        if (riskStatus.equals("\u6709\u98ce\u9669") || riskStatus.contains("\u672a\u5316\u89e3")) {
                            item.setIfExistsTrain(Integer.valueOf(0));
                            item.setTrainFlag(Integer.valueOf(1));
                            break;
                        }
                        item.setIfExistsTrain(Integer.valueOf(1));
                        item.setTrainFlag(Integer.valueOf(0));
                        break;
                    }
                    case "threeTime_riskType": {
                        if (riskStatus.equals("\u6709\u98ce\u9669") || riskStatus.contains("\u672a\u5316\u89e3")) {
                            item.setIfExistsThree(Integer.valueOf(0));
                            item.setThreeFlag(Integer.valueOf(1));
                            break;
                        }
                        item.setIfExistsThree(Integer.valueOf(1));
                        item.setThreeFlag(Integer.valueOf(0));
                        break;
                    }
                    case "protective_riskType": {
                        if (riskStatus.equals("\u6709\u98ce\u9669") || riskStatus.contains("\u672a\u5316\u89e3")) {
                            item.setIfExistsPpe(Integer.valueOf(0));
                            item.setPpeFlag(Integer.valueOf(1));
                            break;
                        }
                        item.setIfExistsPpe(Integer.valueOf(1));
                        item.setPpeFlag(Integer.valueOf(0));
                        break;
                    }
                    case "warningMark_riskType": {
                        if (riskStatus.equals("\u6709\u98ce\u9669") || riskStatus.contains("\u672a\u5316\u89e3")) {
                            item.setIfExistsWarning(Integer.valueOf(0));
                            item.setWarningFlag(Integer.valueOf(1));
                            break;
                        }
                        item.setIfExistsWarning(Integer.valueOf(1));
                        item.setWarningFlag(Integer.valueOf(0));
                        break;
                    }
                    case "healthArchive_riskType": {
                        if (riskStatus.equals("\u6709\u98ce\u9669") || riskStatus.contains("\u672a\u5316\u89e3")) {
                            item.setIfExistsHseFile(Integer.valueOf(0));
                            item.setHseFlag(Integer.valueOf(1));
                            break;
                        }
                        item.setIfExistsHseFile(Integer.valueOf(1));
                        item.setHseFlag(Integer.valueOf(0));
                    }
                }
            }
        }
    }

    private List<ReformListVo> transformItem(TmPatrolItem item) {
        if (item == null) {
            return null;
        }
        TmPatrolInfo info = (TmPatrolInfo)this.patrolInfoService.getById(item.getPatrolId());
        String patrolName = info.getPatrolName();
        Integer year = info.getYear();
        ArrayList<ReformListVo> list = new ArrayList<ReformListVo>();
        if (item.getIfExistsDeclare() == 0) {
            list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5", "\u767b\u5f55\u201c\u6d59\u6c5f\u653f\u52a1\u670d\u52a1\u7f51\u201d\uff08https://www.zjzwfw.gov.cn/\uff09\uff0c\u641c\u7d22\u201c\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\u201d\u540e\uff0c\u5b8c\u6210\u76f8\u5e94\u5de5\u4f5c\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.DECLARE.getValue()));
        }
        if (item.getIfExistsHealth() == 0) {
            list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5", "\u59d4\u6258\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0\u673a\u6784\u5f00\u5c55\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\uff0c\u5e76\u53ca\u65f6\u5c06\u68c0\u67e5\u7ed3\u679c\u53ca\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u673a\u6784\u7684\u5efa\u8bae\u4ee5\u4e66\u9762\u5f62\u5f0f\u5982\u5b9e\u544a\u77e5\u52b3\u52a8\u8005\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.TJ.getValue()));
        }
        if (item.getIfExistsCheck() == 0) {
            list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7", "\u59d4\u6258\u6709\u8d44\u8d28\u7684\u804c\u4e1a\u536b\u751f\u6280\u672f\u670d\u52a1\u673a\u6784\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u6216\u8bc4\u4ef7\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.DETECTION.getValue()));
        }
        if (item.getIfExistsTrain() == 0) {
            list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u4e3b\u8981\u8d1f\u8d23\u4eba\u4e0e\u7ba1\u7406\u4eba\u5458\u5747\u672a\u63a5\u53d7\u804c\u4e1a\u536b\u751f\u57f9\u8bad", "\u4f01\u4e1a\u4e3b\u8981\u8d1f\u8d23\u4eba\u548c\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458\u4f7f\u7528\u201c\u6d59\u91cc\u529e\u201dAPP\u6216\u201c\u6d59\u6c5f\u653f\u52a1\u670d\u52a1\u7f51\u201d\uff08\u5728\u6d4f\u89c8\u5668\u8f93\u5165\u7f51\u5740https://www.zjzwfw.gov.cn\uff09\uff0c\u4f7f\u7528\u4e2a\u4eba\u8d26\u53f7\u767b\u5f55\uff08\u4e5f\u53ef\u901a\u8fc7\u201c\u652f\u4ed8\u5b9d\u201d/\u201c\u5fae\u4fe1\u201d\u641c\u7d22\u201c\u6d59\u91cc\u529e\u201d\u5c0f\u7a0b\u5e8f\u5e76\u4f7f\u7528\u4e2a\u4eba\u8d26\u53f7\u767b\u5f55\uff09\uff0c\u641c\u7d22\u201c\u536b\u4f01\u5728\u7ebf\u201d\uff0c\u9009\u62e9\u201c\u5728\u7ebf\u57f9\u8bad\u201d\u62a5\u540d\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u5e76\u53d6\u8bc1\u3002\n\u4e5f\u53ef\u901a\u8fc7\u5176\u4ed6\u75be\u63a7\u4e3b\u7ba1\u90e8\u95e8\u8ba4\u53ef\u65b9\u5f0f\u83b7\u5f97\u7684\u57f9\u8bad\u8bc1\u4e66\uff0c\u4f46\u9700\u8981\u524d\u5f80\u201c\u6d59\u91cc\u536b\u4f01-\u7528\u4eba\u5355\u4f4d\u7aef\u201d\uff08https://ohonline.wsjkw.zj.gov.cn/login\uff09\u4e0a\u4f20\u57f9\u8bad\u8bc1\u4e66\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.TRAIN.getValue()));
        }
        if (item.getIfExistsPpe() != null && item.getIfExistsPpe() == 0) {
            list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u914d\u5907\u4e2a\u4eba\u9632\u62a4\u7528\u54c1", "\u4e3a\u52b3\u52a8\u8005\u63d0\u4f9b\u7b26\u5408\u56fd\u5bb6\u6807\u51c6\u6216\u8005\u884c\u4e1a\u6807\u51c6\u7684\u52b3\u52a8\u9632\u62a4\u7528\u54c1\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.PROTECTION.getValue()));
        }
        if (item.getIfExistsThree() != null && item.getIfExistsThree() == 0) {
            list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u5f00\u5c55\u5efa\u8bbe\u9879\u76ee\u201d\u4e09\u540c\u65f6\u201c", "\u4f9d\u636e\u300a\u5efa\u8bbe\u9879\u76ee\u804c\u4e1a\u75c5\u9632\u62a4\u8bbe\u65bd\u201c\u4e09\u540c\u65f6\u201d\u76d1\u7763\u7ba1\u7406\u529e\u6cd5\u300b\uff08\u539f\u56fd\u5bb6\u5b89\u5168\u751f\u4ea7\u76d1\u7763\u7ba1\u7406\u603b\u5c40\u4ee4\u7b2c90\u53f7\uff09\u7684\u8981\u6c42\u5f00\u5c55\u5efa\u8bbe\u9879\u76ee\u201c\u4e09\u540c\u65f6\u201d\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.THREE_TIME.getValue()));
        }
        if (item.getIfExistsWarning() != null && item.getIfExistsWarning() == 0) {
            list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u8bbe\u7f6e\u8b66\u793a\u6807\u8bc6", "\u6839\u636e\u300a\u5de5\u4f5c\u573a\u6240\u804c\u4e1a\u75c5\u5371\u5bb3\u8b66\u793a\u6807\u8bc6\u300b\uff08GBZ158\uff09\u548c\u300a\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u75c5\u5371\u5bb3\u544a\u77e5\u4e0e\u8b66\u793a\u6807\u8bc6\u7ba1\u7406\u89c4\u8303\u300b\uff08\u5b89\u76d1\u603b\u5385\u5b89\u5065[2014]111\u53f7\uff09\u7b49\u6807\u51c6\u89c4\u8303\u8981\u6c42\u8bbe\u7f6e\u8b66\u793a\u6807\u8bc6\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.WARNING_SIGNS.getValue()));
        }
        if (item.getIfExistsHseFile() != null && item.getIfExistsHseFile() == 0) {
            list.add(new ReformListVo(patrolName + "-" + year + "\u5e74\u5ea6-\u672a\u5efa\u7acb\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u6863\u6848", "\u53ef\u53c2\u8003\u201c\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u201d\uff08https://ohonline.wsjkw.zj.gov.cn/login\uff09-\u7528\u4eba\u5355\u4f4d\u7aef-\u6863\u6848\u7ba1\u7406\u6a21\u5757\u529f\u80fd\uff0c\u5efa\u7acb\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u6863\u6848\u3002", new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.ARCHIVES.getValue()));
        }
        return list;
    }

    @Generated
    public PatrolManageImpl(ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
    }
}

