/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.manage.impl;

import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.township.manage.bootstrap.security.ShiroUtil;
import cn.smarthse.township.manage.dao.dynamic.bigdata.CompanyMapper;
import cn.smarthse.township.manage.manage.IHomeManage;
import cn.smarthse.township.manage.manage.IReformManage;
import cn.smarthse.township.manage.model.vo.HomeData;
import cn.smarthse.township.manage.model.vo.HomeDataV2;
import cn.smarthse.township.manage.model.vo.ReformStasticsVo;
import cn.smarthse.township.manage.service.manage.ITmPatrolInfoService;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class HomeManageImpl
implements IHomeManage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HomeManageImpl.class);
    private final ITmPatrolInfoService patrolInfoService;
    private final IReformManage reformManage;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private final CompanyMapper companyMapper;
    @DubboReference
    private ICompanyGradeV3Service companyGradeV3Service;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    @Override
    @Cacheable(value={"homeData=15m"}, key="#year +':'+ #areaId", unless="#result == null")
    public HomeData getHomeData(Long areaId, int year) throws InterruptedException {
        HomeData result = new HomeData();
        CountDownLatch countDownLatch = new CountDownLatch(4);
        this.threadPoolTaskExecutor.execute(() -> {
            result.setSelfCheckPercent(((HomeManageImpl)SpringUtils.getBean(this.getClass())).getSelfCheckPercent(areaId, year));
            countDownLatch.countDown();
        });
        this.threadPoolTaskExecutor.execute(() -> {
            HomeData homeData = this.selectCompanyNumsByAreaId(areaId);
            if (homeData != null) {
                result.setCompanyNum(homeData.getCompanyNum());
                result.setCompanyNum1(homeData.getCompanyNum1());
                result.setCompanyNum2(homeData.getCompanyNum2());
            }
            countDownLatch.countDown();
        });
        this.threadPoolTaskExecutor.execute(() -> {
            result.setLastUpdateDate(this.patrolInfoService.getLastPatrolDate(ShiroUtil.getLoginUserId()));
            HomeData companyNum = this.patrolInfoService.getUnPatrolCompanyNum2(areaId, year, null);
            if (companyNum != null) {
                result.setUnPatrolCompanyNum(companyNum.getUnPatrolCompanyNum());
                result.setUnPatrolCompanyNum1(companyNum.getUnPatrolCompanyNum1());
                result.setUnPatrolCompanyNum2(companyNum.getUnPatrolCompanyNum2());
            }
            countDownLatch.countDown();
        });
        this.threadPoolTaskExecutor.execute(() -> {
            ReformStasticsVo statistics = this.reformManage.getReformStatisticsByAreaId(areaId);
            if (statistics != null) {
                result.setUnacceptRiskNum(statistics.getUnacceptRiskNum());
                result.setUnReformRiskNum(statistics.getUnReformRiskNum());
                result.setReformRiskNum(statistics.getReformRiskNum());
                result.setAcceptRiskNum(statistics.getAcceptRiskNum());
            }
            countDownLatch.countDown();
        });
        countDownLatch.await();
        result.setAcceptRiskPercent(result.getAcceptRiskNum(), result.getReformRiskNum(), result.getUnPatrolCompanyNum());
        return result;
    }

    @Override
    @Cacheable(value={"homeDataV2=15m"}, key="#year +':'+ #areaId", unless="#result == null")
    public HomeDataV2 getHomeDataV2(Long areaId, int year) {
        HomeDataV2 result = new HomeDataV2();
        CountDownLatch countDownLatch = new CountDownLatch(4);
        result.setLastUpdateDate(this.patrolInfoService.getLastPatrolDate(ShiroUtil.getLoginUserId()));
        HomeDataV2 patrolPercentData = this.getPatrolPercentData(areaId, year);
        if (patrolPercentData != null) {
            result.setPatrolCompanyNum1(patrolPercentData.getPatrolCompanyNum1());
            result.setPatrolCompanyNum2(patrolPercentData.getPatrolCompanyNum2());
            result.setCompanyNum1(patrolPercentData.getCompanyNum1());
        }
        this.threadPoolTaskExecutor.execute(() -> {
            result.setSelfCheckPercent(((HomeManageImpl)SpringUtils.getBean(this.getClass())).getSelfCheckPercent(areaId, year));
            countDownLatch.countDown();
        });
        this.threadPoolTaskExecutor.execute(() -> {
            HomeDataV2 homeDataV2;
            HomeData homeData = this.selectCompanyNumsByAreaId(areaId);
            if (homeData != null) {
                result.setCompanyNum(homeData.getCompanyNum());
            }
            if ((homeDataV2 = this.selectCompanyNumsForPortraitAndRisk(areaId)) != null) {
                result.setCompanyNum3(homeDataV2.getCompanyNum3());
            }
            countDownLatch.countDown();
        });
        this.threadPoolTaskExecutor.execute(() -> {
            HomeData companyNum = this.patrolInfoService.getUnPatrolCompanyNum2(areaId, year, null);
            if (companyNum != null) {
                result.setUnPatrolCompanyNum(companyNum.getUnPatrolCompanyNum());
                result.setUnPatrolCompanyNum1(companyNum.getUnPatrolCompanyNum1());
                result.setUnPatrolCompanyNum2(companyNum.getUnPatrolCompanyNum2());
            }
            countDownLatch.countDown();
        });
        this.threadPoolTaskExecutor.execute(() -> {
            ReformStasticsVo statistics = this.reformManage.getHomeStatisticsByAreaId(areaId);
            if (statistics != null) {
                result.setUnacceptRiskNum(statistics.getUnacceptRiskNum());
                result.setUnReformRiskNum(statistics.getUnReformRiskNum());
                result.setReformRiskNum(statistics.getReformRiskNum());
                result.setAcceptRiskNum(statistics.getAcceptRiskNum());
                result.setFourRiskNum(statistics.getFourRiskNum());
            }
            countDownLatch.countDown();
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        result.setAcceptRiskPercent(result.getAcceptRiskNum(), result.getFourRiskNum(), result.getUnPatrolCompanyNum());
        return result;
    }

    private HomeDataV2 getPatrolPercentData(Long areaId, int year) {
        if (Objects.isNull(areaId)) {
            throw new ServiceException("\u884c\u653f\u533a\u5212Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AreaModel area = this.sysAreaProvideService.getAreaById(areaId);
        if (Objects.isNull(area)) {
            throw new ServiceException("\u8be5\u533a\u57df\u4e0d\u5b58\u5728");
        }
        return this.companyMapper.getPatrolPercentData(areaId, area.getLevel(), year);
    }

    @Cacheable(value={"homeData=24"}, key="'selfCheckPercent:'+ #year +':'+ #areaId", unless="#result == null")
    public String getSelfCheckPercent(Long areaId, int year) {
        return this.companyGradeV3Service.collectGradeCaseSelfInfoByAreaId(areaId, Integer.valueOf(year), null, null, null);
    }

    HomeData selectCompanyNumsByAreaId(Long areaId) {
        if (Objects.isNull(areaId)) {
            throw new ServiceException("\u884c\u653f\u533a\u5212Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AreaModel area = this.sysAreaProvideService.getAreaById(areaId);
        if (Objects.isNull(area)) {
            throw new ServiceException("\u8be5\u533a\u57df\u4e0d\u5b58\u5728");
        }
        return this.companyMapper.selectCompanyNumsByAreaId(areaId, area.getLevel());
    }

    HomeDataV2 selectCompanyNumsForPortraitAndRisk(Long areaId) {
        if (Objects.isNull(areaId)) {
            throw new ServiceException("\u884c\u653f\u533a\u5212Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AreaModel area = this.sysAreaProvideService.getAreaById(areaId);
        if (Objects.isNull(area)) {
            throw new ServiceException("\u8be5\u533a\u57df\u4e0d\u5b58\u5728");
        }
        return this.companyMapper.selectCompanyNumsForPortraitAndRisk(areaId, area.getLevel());
    }

    @Generated
    public HomeManageImpl(ITmPatrolInfoService patrolInfoService, IReformManage reformManage, ThreadPoolTaskExecutor threadPoolTaskExecutor, CompanyMapper companyMapper) {
        this.patrolInfoService = patrolInfoService;
        this.reformManage = reformManage;
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
        this.companyMapper = companyMapper;
    }
}

