/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.framework.aspect;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.annotation.LogConstans;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.entity.sys.SysLog;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.township.manage.bootstrap.security.ShiroUtil;
import cn.smarthse.township.manage.service.sys.ISysLogService;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private final ThreadPoolTaskExecutor taskExecutor;
    private final ISysLogService logService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaService;

    @Pointcut(value=" @annotation(cn.smarthse.common.annotation.Log)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object afterCompletion(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Object proceed = joinPoint.proceed();
        this.addLog(method.getAnnotation(Log.class));
        return proceed;
    }

    private void addLog(Log logAnno) {
        if (logAnno != null) {
            byte type = logAnno.type();
            HttpServletRequest request = ServletUtils.getRequest();
            Long userId = ShiroUtil.getLoginUserId();
            SysLog syslog = new SysLog();
            syslog.setCid(ShiroUtil.getUserInfo() == null ? null : ShiroUtil.getUserInfo().getOid());
            syslog.setUsername(ShiroUtil.getLoginUsername());
            syslog.setFullname(ShiroUtil.getLoginUserNickname());
            syslog.setTitle(logAnno.title());
            syslog.setType(Byte.valueOf(type));
            syslog.setRequestMethod(request.getMethod());
            syslog.setRemoteIp(ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]));
            Map parameterMap = request.getParameterMap();
            syslog.setParams(StringUtils.substring(type == 1 || type == 26 ? null : (CollectionUtil.isNotEmpty((Map)parameterMap) ? JSONUtil.toJsonStr((Object)parameterMap) : ServletUtils.getBody((ServletRequest)request)), (int)0, (int)255));
            syslog.setRequestUri(ServletUtils.getRequestUri((HttpServletRequest)request));
            syslog.setUserAgent(ServletUtils.getUserAgent((HttpServletRequest)request));
            syslog.setLogSource(Byte.valueOf(LogConstans.TOWNSHIP.getValue().byteValue()));
            syslog.setCreateDate(new Date());
            syslog.setUpdateDate(new Date());
            syslog.setCreateBy(userId);
            syslog.setUpdateBy(userId);
            if (logAnno.type() == 1 || logAnno.type() == 11) {
                Long areaId = ShiroUtil.getAreaId();
                if (areaId != null) {
                    AreaModel area = this.sysAreaService.getAreaById(areaId);
                    SysArea sysArea = new SysArea();
                    BeanUtils.copyProperties((Object)area, (Object)sysArea);
                    syslog.setSysArea(sysArea);
                }
                syslog.setType(Byte.valueOf((byte)1));
            }
            try {
                if (this.taskExecutor != null) {
                    this.taskExecutor.execute(() -> this.logService.addLog(syslog));
                } else {
                    this.logService.addLog(syslog);
                }
            }
            catch (Exception e) {
                log.error("Exception: ", (Throwable)e);
            }
        }
    }

    @Generated
    public LogAspect(ThreadPoolTaskExecutor taskExecutor, ISysLogService logService) {
        this.taskExecutor = taskExecutor;
        this.logService = logService;
    }
}

