/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.controller.app;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.annotation.LogConstans;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.township.manage.bootstrap.security.JwtUtil;
import cn.smarthse.township.manage.bootstrap.security.ShiroUtil;
import cn.smarthse.township.manage.bootstrap.security.model.vo.LoginOrganizationUser;
import cn.smarthse.township.manage.model.param.ModifyPasswordParam;
import cn.smarthse.township.manage.service.sys.ISysUserService;
import lombok.Generated;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/user"})
@Validated
public class UserController
extends ControllerSupport {
    private final ISysUserService userService;

    @GetMapping(value={"/getUser"})
    public ResponseData<LoginOrganizationUser> getUser() {
        LoginOrganizationUser userInfo = ShiroUtil.getUserInfo();
        userInfo.setName(DesensitizationUtils.desensitized((CharSequence)userInfo.getName(), (DesensitizationType)DesensitizationType.NAME));
        userInfo.setTel(DesensitizationUtils.desensitized((CharSequence)userInfo.getTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
        return ResponseData.success((Object)userInfo);
    }

    @ApiEncrypt(request=true)
    @Log(title="\u4e61\u9547\u534f\u7ba1\u4fee\u6539\u5bc6\u7801", type=29, module=LogConstans.TOWNSHIP)
    @PostMapping(value={"/modifyPassword"})
    public ResponseData<String> modifyPassword(@Validated @RequestBody ModifyPasswordParam param) {
        this.logger.info("\u4e61\u9547\u534f\u7ba1\u4fee\u6539\u5bc6\u7801:username: {}", (Object)JwtUtil.getUsername());
        this.userService.modifyPassword(ShiroUtil.getLoginUserId(), param.getNewPassword());
        return ResponseData.success();
    }

    @Generated
    public UserController(ISysUserService userService) {
        this.userService = userService;
    }
}

