/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.controller.app;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.annotation.LogConstans;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.township.manage.bootstrap.security.ShiroUtil;
import cn.smarthse.township.manage.manage.IReformManage;
import cn.smarthse.township.manage.model.param.ReformParam;
import cn.smarthse.township.manage.model.param.SaveReformRecordParam;
import cn.smarthse.township.manage.model.vo.ReformDetailVo;
import cn.smarthse.township.manage.model.vo.ReformRecordDetailVo;
import cn.smarthse.township.manage.model.vo.ReformStasticsVo;
import cn.smarthse.township.manage.model.vo.ReformVo;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/reform"})
@Validated
public class ReformController
extends ControllerSupport {
    private final IReformManage reformManage;

    @GetMapping(value={"/getReformList"})
    public ResponseData<List<ReformVo>> getReformListByPatrolId(@NotNull(message="\u5de1\u67e5id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5de1\u67e5id\u4e0d\u80fd\u4e3a\u7a7a") Long patrolId) {
        return ResponseData.success(this.reformManage.getReformListByPatrolId(patrolId, ShiroUtil.getAreaId()));
    }

    @GetMapping(value={"/getReformList2"})
    public ResponseData<List<ReformVo>> getReformListByPatrolId2(@NotNull(message="\u5de1\u67e5id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5de1\u67e5id\u4e0d\u80fd\u4e3a\u7a7a") Long patrolId) {
        return ResponseData.success(this.reformManage.getReformListByPatrolId2(patrolId, ShiroUtil.getAreaId()));
    }

    @GetMapping(value={"/getReformListByCid2"})
    public ResponseData<List<ReformVo>> getReformListByCid2(@NotNull Long cid) {
        return ResponseData.success(this.reformManage.getReformListByCid2(cid));
    }

    @GetMapping(value={"/getPastReformList"})
    public ResponseData<List<ReformVo>> getPastReformList(@NotNull(message="\u5de1\u67e5id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5de1\u67e5id\u4e0d\u80fd\u4e3a\u7a7a") Long patrolId) {
        return ResponseData.success(this.reformManage.getPastReformList(patrolId, ShiroUtil.getAreaId()));
    }

    @GetMapping(value={"/getReformListDataV2"})
    public JqGridData<ReformVo> getReformListDataV2(ReformParam param) {
        return this.reformManage.getReformListDataV2(param);
    }

    @ApiEncrypt(response=true)
    @GetMapping(value={"/getReformV2"})
    public ResponseData<ReformDetailVo> getReformV2(@NotNull(message="\u98ce\u9669id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u98ce\u9669id\u4e0d\u80fd\u4e3a\u7a7a") Long reformId) {
        return ResponseData.success((Object)this.reformManage.getReformV2(reformId));
    }

    @GetMapping(value={"/getReformStatistics"})
    public ResponseData<ReformStasticsVo> getReformStatistics(@NotNull(message="cid\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="cid\u4e0d\u80fd\u4e3a\u7a7a") Long cid) {
        return ResponseData.success((Object)this.reformManage.getReformStatisticsByCid(cid));
    }

    @ApiEncrypt(request=true)
    @Log(title="\u4e61\u9547\u534f\u7ba1\uff1a\u98ce\u9669\u6574\u6539\u9a8c\u6536", module=LogConstans.TOWNSHIP)
    @RequestLimit(second=2, maxCount=1, expression="#param.reformId")
    @PostMapping(value={"/saveReformRecord"})
    public ResponseData<String> saveReformRecord(@RequestBody @Valid SaveReformRecordParam param) {
        this.reformManage.saveReformRecord(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/getYearList"})
    public static ResponseData<List<Integer>> getYearList() {
        ArrayList<Integer> yearList = new ArrayList<Integer>();
        for (int year = 2023; year <= LocalDate.now().getYear(); ++year) {
            yearList.add(year);
        }
        return ResponseData.success(yearList);
    }

    @Deprecated
    @GetMapping(value={"/getReformListData"})
    public JqGridData<ReformVo> getReformListData(ReformParam param) {
        return this.reformManage.getReformListData(param);
    }

    @Deprecated
    @GetMapping(value={"/getReform"})
    public ResponseData<ReformDetailVo> getReform(@NotNull(message="\u98ce\u9669id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u98ce\u9669id\u4e0d\u80fd\u4e3a\u7a7a") Long reformId) {
        return ResponseData.success((Object)this.reformManage.getReform(reformId));
    }

    @Deprecated
    @GetMapping(value={"/getReformRecordList"})
    public ResponseData<List<ReformRecordDetailVo>> getReformRecordList(@NotNull(message="\u98ce\u9669id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u98ce\u9669id\u4e0d\u80fd\u4e3a\u7a7a") Long reformId) {
        return ResponseData.success(this.reformManage.getReformRecordList(reformId));
    }

    @Deprecated
    @GetMapping(value={"/getReformRecord"})
    public ResponseData<ReformRecordDetailVo> getReformRecord(@NotNull(message="\u98ce\u9669\u6574\u6539\u9a8c\u6536\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u98ce\u9669\u6574\u6539\u9a8c\u6536\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a") Long reformRecordId) {
        return ResponseData.success((Object)this.reformManage.getReformRecord(reformRecordId));
    }

    @Generated
    public ReformController(IReformManage reformManage) {
        this.reformManage = reformManage;
    }
}

