/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.controller.app;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.township.manage.bootstrap.security.ShiroUtil;
import cn.smarthse.township.manage.manage.IPatrolManage;
import cn.smarthse.township.manage.model.param.AddReformListParam;
import cn.smarthse.township.manage.model.param.CidParam;
import cn.smarthse.township.manage.model.param.PatrolRecordParam;
import cn.smarthse.township.manage.model.param.UpdatePatrolInfoParam;
import cn.smarthse.township.manage.model.param.UpdatePatrolParam;
import cn.smarthse.township.manage.model.vo.PatrolItemReferenceDataVo;
import cn.smarthse.township.manage.model.vo.PatrolRecordVo;
import cn.smarthse.township.manage.model.vo.PatrolVo;
import cn.smarthse.township.manage.model.vo.ReformListVo;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Calendar;
import java.util.List;
import lombok.Generated;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/patrol"})
@Validated
public class PatrolController
extends ControllerSupport {
    private final IPatrolManage patrolManage;

    @GetMapping(value={"/listPatrolRecord"})
    public ResponseData<List<PatrolRecordVo>> listPatrolRecord(PatrolRecordParam param) {
        return ResponseData.success(this.patrolManage.listPatrolRecord(param));
    }

    @GetMapping(value={"/getPatrol"})
    public ResponseData<PatrolVo> getPatrol(Long id) {
        return ResponseData.success((Object)this.patrolManage.getPatrol(id, ShiroUtil.getAreaId()));
    }

    @PostMapping(value={"/addPatrol"})
    @BigLog(userRole=UserRoleEnum.GOVERNMENT_STAFF_TYPE, actionType=ActionTypeEnum.WORK_START_TYPE, businessModule=BigLogBusinessModuleEnum.module4_1, businessIdParamName="patrolId")
    public ResponseData<Long> addPatrol(HttpServletRequest request, @RequestBody CidParam param) {
        Long patrolId = this.patrolManage.addPatrol(param);
        request.setAttribute("patrolId", (Object)patrolId);
        return ResponseData.success((Object)patrolId);
    }

    @PostMapping(value={"/updatePatrol"})
    public ResponseData<Boolean> updatePatrol(@RequestBody UpdatePatrolParam updatePatrolParam) {
        if (updatePatrolParam.getPatrolInfoParam() != null) {
            updatePatrolParam.getPatrolInfoParam().setPatrolPeople(ShiroUtil.getLoginUserNickname());
        }
        return ResponseData.success((Object)this.patrolManage.updatePatrol(updatePatrolParam));
    }

    @GetMapping(value={"/getReformListByPid"})
    public ResponseData<List<ReformListVo>> getReformListByPid(Long patrolId, Long cid) {
        return ResponseData.success(this.patrolManage.getReformListByPid(patrolId, cid));
    }

    @BigLog(userRole=UserRoleEnum.GOVERNMENT_STAFF_TYPE, actionType=ActionTypeEnum.WORK_END_TYPE, businessModule=BigLogBusinessModuleEnum.module4_1, businessIdParamName="patrolId")
    @PostMapping(value={"/commitReformAndPatrol"})
    public ResponseData<String> commitReformAndPatrol(@RequestBody AddReformListParam param) {
        param.setAreaId(ShiroUtil.getAreaId());
        param.setYear(Integer.valueOf(Calendar.getInstance().get(1)));
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)this.patrolManage.commitReformAndPatrol(param));
    }

    @PostMapping(value={"/createForClock"})
    public ResponseData<Long> createForClock(@RequestBody CidParam param) {
        return ResponseData.success((Object)this.patrolManage.createForClock(param.getCid()));
    }

    @PostMapping(value={"/commitForClock"})
    public ResponseData<Boolean> commitForClock(@RequestBody UpdatePatrolInfoParam param) {
        return ResponseData.success((Object)this.patrolManage.commitForClock(param));
    }

    @GetMapping(value={"/getItemReferenceData"})
    public ResponseData<PatrolItemReferenceDataVo> getItemReferenceData(Long cid) {
        return ResponseData.success((Object)this.patrolManage.getItemReferenceData(cid));
    }

    @Generated
    public PatrolController(IPatrolManage patrolManage) {
        this.patrolManage = patrolManage;
    }
}

