/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.controller.app;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.township.manage.bootstrap.security.ShiroUtil;
import cn.smarthse.township.manage.bootstrap.security.model.vo.LoginOrganizationUser;
import cn.smarthse.township.manage.manage.IHomeManage;
import cn.smarthse.township.manage.model.vo.HomeData;
import cn.smarthse.township.manage.model.vo.HomeDataV2;
import java.time.LocalDate;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/home"})
public class HomeController
extends ControllerSupport {
    private final IHomeManage homeService;

    @GetMapping(value={"/getHomeData"})
    public ResponseData<HomeData> getHomeData() throws ExecutionException, InterruptedException {
        LoginOrganizationUser user = ShiroUtil.getUserInfo();
        HomeData result = this.homeService.getHomeData(ShiroUtil.getAreaId(), LocalDate.now().getYear());
        if (user != null && result != null) {
            result.setName(user.getName());
            result.setAddress(user.getAddress());
        }
        return ResponseData.success((Object)result);
    }

    @GetMapping(value={"/getHomeDataV2"})
    public ResponseData<HomeDataV2> getHomeDataV2() {
        LoginOrganizationUser user = ShiroUtil.getUserInfo();
        HomeDataV2 result = this.homeService.getHomeDataV2(ShiroUtil.getAreaId(), LocalDate.now().getYear());
        if (user != null && result != null) {
            result.setName(user.getName());
            result.setAddress(user.getAddress());
        }
        return ResponseData.success((Object)result);
    }

    @Generated
    public HomeController(IHomeManage homeService) {
        this.homeService = homeService;
    }
}

