/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.controller.app;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.township.manage.bootstrap.security.ShiroUtil;
import cn.smarthse.township.manage.manage.IPatrolManage;
import cn.smarthse.township.manage.model.param.ChangeAreaOrStatesParam;
import cn.smarthse.township.manage.model.param.ChangeCompanyParam;
import cn.smarthse.township.manage.model.param.ChangeFcythClueParam;
import cn.smarthse.township.manage.model.param.ChangeLngAngLatParam;
import cn.smarthse.township.manage.model.param.CompanyListParam;
import cn.smarthse.township.manage.model.vo.CompanyDetailVo;
import cn.smarthse.township.manage.model.vo.CompanyInfoVo;
import cn.smarthse.township.manage.model.vo.CompanyListVo;
import cn.smarthse.township.manage.model.vo.CompanyPortraitVo;
import java.util.Calendar;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/company"})
@Validated
public class CompanyController
extends ControllerSupport {
    private final IPatrolManage patrolManage;

    @GetMapping(value={"/listCompanyByAreaId"})
    public JqGridData<CompanyListVo> listCompanyByAreaId(CompanyListParam param) throws ExecutionException, InterruptedException {
        param.setAreaId(ShiroUtil.getAreaId());
        param.setYear(Integer.valueOf(Calendar.getInstance().get(1)));
        param.setUserId(ShiroUtil.getLoginUserId());
        param.setCompanyState(Integer.valueOf(param.getCompanyState() == null ? 0 : param.getCompanyState()));
        param.setListType(Integer.valueOf(param.getListType() == null ? 0 : param.getListType()));
        return this.patrolManage.listCompanyByAreaId(param);
    }

    @GetMapping(value={"/getCompanyById"})
    public ResponseData<CompanyDetailVo> getCompanyById(Long id) {
        return ResponseData.success((Object)this.patrolManage.getCompanyById(id));
    }

    @GetMapping(value={"/getCompanyPortrait"})
    public ResponseData<CompanyPortraitVo> getCompanyPortrait(Long id) {
        return ResponseData.success((Object)this.patrolManage.getCompanyPortrait(id));
    }

    @GetMapping(value={"/getCompanyArchive"})
    public ResponseData<ZjArchiveCountView> getCompanyArchive(Long id) {
        return ResponseData.success((Object)this.patrolManage.getCompanyArchive(id));
    }

    @GetMapping(value={"/getCompanyBeforeChange"})
    public ResponseData<CompanyInfoVo> getCompanyBeforeChange(Long id) {
        return ResponseData.success((Object)this.patrolManage.getCompanyBeforeChange(id));
    }

    @PostMapping(value={"/changeCompanyInfo"})
    public ResponseData<String> changeCompanyInfo(@RequestBody ChangeCompanyParam param) {
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)this.patrolManage.changeCompanyInfo(param));
    }

    @PostMapping(value={"/changeComAreaOrStates"})
    public ResponseData<String> changeComAreaOrStates(@RequestBody ChangeAreaOrStatesParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)this.patrolManage.changeComAreaOrStates(param));
    }

    @GetMapping(value={"/listCompanyForClose"})
    public ResponseData<JqGridData<CompanyInfoVo>> listCompanyForClose(CompanyListParam param) {
        param.setAreaId(ShiroUtil.getAreaId());
        return ResponseData.success(this.patrolManage.listCompanyForClose(param));
    }

    @PostMapping(value={"/changeLngAndLat"})
    public ResponseData<String> changeLngAndLat(@RequestBody ChangeLngAngLatParam param) {
        param.setOperateId(ShiroUtil.getLoginUserId());
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)this.patrolManage.changeLngAndLat(param));
    }

    @PostMapping(value={"/changeFcythClue"})
    public ResponseData<String> changeFcythClue(@RequestBody ChangeFcythClueParam param) {
        param.setCommitName(ShiroUtil.getLoginUsername());
        param.setOperateId(ShiroUtil.getLoginUserId());
        this.patrolManage.changeFcythClue(param);
        return ResponseData.success();
    }

    @Generated
    public CompanyController(IPatrolManage patrolManage) {
        this.patrolManage = patrolManage;
    }
}

