/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.controller.api;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import cn.hutool.http.HtmlUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.modules.uploader.FileUploadSimple;
import cn.smarthse.modules.uploader.UploadFileParameter;
import cn.smarthse.modules.uploader.UploadFilePathEnum;
import cn.smarthse.township.manage.bootstrap.properties.SysProperties;
import cn.smarthse.township.manage.bootstrap.security.JwtUtil;
import cn.smarthse.township.manage.bootstrap.security.ShiroUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/file"})
public class FileUploadController
extends ControllerSupport {
    @DubboReference
    private ISysFileProvideService sysFileService;
    private final OssClientBean ossClientBean;
    private final SysProperties sysProperties;
    private final Path tempDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);

    @Log(title="\u4e0a\u4f20\u9644\u4ef6", type=26)
    @CrossOrigin(origins={"*"})
    @ResponseBody
    @RequestMapping(value={"upload"}, method={RequestMethod.POST})
    public ResponseData<SysFileModel> upload(HttpServletRequest request, @RequestPart(value="file") MultipartFile fileData) throws IOException {
        String type = FileTypeUtil.getType((InputStream)fileData.getInputStream(), (boolean)true);
        if (!this.sysProperties.getSupportFileTypes().contains(type)) {
            return ResponseData.fail((String)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff01");
        }
        String hashCode = MD5.create().digestHex(fileData.getBytes());
        SysFileModel existSysFile = this.sysFileService.getFileByHash(hashCode);
        if (existSysFile != null) {
            return new ResponseData("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f(hash\u503c\u5b58\u5728)\uff01", (Object)existSysFile);
        }
        Object originalFilename = fileData.getOriginalFilename();
        List split = StrUtil.split((CharSequence)originalFilename, (CharSequence)".");
        if (split.size() != 2) {
            throw new ServiceException("\u6587\u4ef6\u540d\u4e0d\u53ef\u5305\u542b\u591a\u4e2a'.'\u7b26\u53f7\uff01");
        }
        String fileNameExExt = (String)split.get(0);
        if (StrUtil.isBlank((CharSequence)(fileNameExExt = HtmlUtil.cleanHtmlTag((String)HtmlUtil.filter((String)fileNameExExt))))) {
            throw new ServiceException("\u6587\u4ef6\u540d\u4e0d\u5408\u6cd5\uff01");
        }
        originalFilename = fileNameExExt + "." + (String)split.get(1);
        String uploadFile = UploadFileParameter.FILE_PATH + FileResourceEnum.TOWNSHIP_MANAGE.getCode() + File.separator + UploadFilePathEnum.Common.getPath() + File.separator + FileUploadSimple.getDataPath() + File.separator + String.valueOf(UUID.randomUUID()) + "-" + (String)originalFilename;
        String res = this.ossClientBean.OSSPutObject(uploadFile, (String)originalFilename, fileData.getInputStream());
        SysFileModel file = new SysFileModel();
        file.setCid(JwtUtil.getUserId());
        file.setResource(Integer.valueOf(FileResourceEnum.TOWNSHIP_MANAGE.getValue()));
        file.setFileName((String)originalFilename);
        file.setFileSize(String.valueOf(fileData.getSize()));
        file.setFileExt(type);
        file.setFileHash(hashCode);
        file.setCreatorIp(ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        file.setOssUrl(res);
        file = this.sysFileService.addSysFile(file, ShiroUtil.getLoginUserId());
        return new ResponseData((Object)file);
    }

    @RequestMapping(value={"getFileList"}, method={RequestMethod.POST})
    public ResponseData<List<SysFileModel>> getFileList(String fileIds) {
        this.logger.debug("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011-\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61\u96c6\u5408, fileIds={}", (Object)fileIds);
        ResponseData data = new ResponseData();
        if (StringUtils.isEmpty((CharSequence)fileIds)) {
            data.setMessage("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
            return data;
        }
        List list = this.sysFileService.getListByIds(fileIds);
        if (list != null && !list.isEmpty()) {
            data.setResult((Object)list);
            data.setMessage("\u901a\u8fc7id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61 \u6210\u529f\uff01");
        } else {
            data.setState(ResponseStateEnum.fail.getValue());
            data.setMessage("\u6ca1\u6709\u8be5id\u7684\u6587\u4ef6\uff01");
        }
        return data;
    }

    @CrossOrigin(origins={"*"})
    @ResponseBody
    @RequestMapping(value={"postSignature"}, method={RequestMethod.GET})
    public Map<String, String> postSignature() throws Exception {
        this.logger.debug("\u670d\u52a1\u5668\u7b7e\u540d\u76f4\u4f20oss");
        String uploadDir = "upload/" + FileResourceEnum.TOWNSHIP_MANAGE.getCode() + "/" + UploadFilePathEnum.Common.getPath() + "/" + FileUploadSimple.getDataPath() + "/";
        return this.ossClientBean.getPostSignature(uploadDir);
    }

    @Log(title="\u76f4\u4f20oss\u540e\u4fdd\u5b58sysFile", type=26)
    @ResponseBody
    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    public ResponseData<SysFileModel> add(String originalFilename, String origSize, String etagMd5, String fileUrl, String description, HttpServletRequest req) throws Exception {
        ResponseData data = new ResponseData();
        SysFileModel file = new SysFileModel();
        file.setCid(JwtUtil.getUserId());
        file.setResource(Integer.valueOf(FileResourceEnum.TOWNSHIP_MANAGE.getValue()));
        file.setFileName(originalFilename);
        file.setFileSize(origSize);
        file.setFileExt(FileUtil.getSuffix((String)originalFilename));
        file.setFileHash(etagMd5);
        file.setCreatorIp(ServletUtils.getClientIP((HttpServletRequest)req, (String[])new String[0]));
        file.setOssUrl(fileUrl);
        file.setCreateBy(ShiroUtil.getLoginUserId());
        file.setUpdateBy(file.getCreateBy());
        file = this.sysFileService.addSysFile(file, ShiroUtil.getLoginUserId());
        data.setResult((Object)file);
        return data;
    }

    @Generated
    public FileUploadController(OssClientBean ossClientBean, SysProperties sysProperties) {
        this.ossClientBean = ossClientBean;
        this.sysProperties = sysProperties;
    }
}

