/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.controller;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.annotation.LogConstans;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.township.manage.bootstrap.properties.ZwddProperties;
import cn.smarthse.township.manage.bootstrap.security.JwtUtil;
import cn.smarthse.township.manage.bootstrap.security.service.LoginService;
import cn.smarthse.township.manage.bootstrap.security.token.CasToken;
import cn.smarthse.township.manage.bootstrap.security.token.LoginData;
import cn.smarthse.township.manage.service.sys.ISysUserService;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.xxpt.gateway.shared.api.request.OapiGetJsapiTokenJsonRequest;
import com.alibaba.xxpt.gateway.shared.api.request.OapiGettokenJsonRequest;
import com.alibaba.xxpt.gateway.shared.api.request.OapiMoziEmployeeGetByMobileRequest;
import com.alibaba.xxpt.gateway.shared.api.request.OapiRpcOauth2DingtalkAppUserJsonRequest;
import com.alibaba.xxpt.gateway.shared.api.response.OapiGetJsapiTokenJsonResponse;
import com.alibaba.xxpt.gateway.shared.api.response.OapiGettokenJsonResponse;
import com.alibaba.xxpt.gateway.shared.api.response.OapiMoziEmployeeGetByMobileResponse;
import com.alibaba.xxpt.gateway.shared.api.response.OapiRpcOauth2DingtalkAppUserJsonResponse;
import com.alibaba.xxpt.gateway.shared.client.http.ExecutableClient;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentGetClient;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentPostClient;
import com.alibaba.xxpt.gateway.shared.client.http.api.OapiRequest;
import com.alibaba.xxpt.gateway.shared.client.http.api.OapiSpResultContent;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/zwdd"})
@Validated
public class ZwddLoginController
extends ControllerSupport {
    private final ISysUserService sysUserService;
    private final LoginService loginService;
    private final ZwddProperties zwddProperties;
    private final ExecutableClient executableClient;
    private final StringRedisTemplate stringRedisTemplate;
    private static final String access_token = "access_token";

    @PostMapping(value={"/get_jsapi_token.json"})
    public ResponseData<String> get_jsapi_token() {
        String accessToken = this.access_token();
        JSONObject jsonObject = JSONObject.parseObject((String)accessToken);
        if (jsonObject == null) {
            return ResponseData.fail((String)"\u83b7\u53d6accessToken\u5931\u8d25");
        }
        accessToken = jsonObject.getString("accessToken");
        IntelligentGetClient intelligentGetClient = this.executableClient.newIntelligentGetClient("/get_jsapi_token.json");
        OapiGetJsapiTokenJsonRequest oapiGetJsapiTokenJsonRequest = new OapiGetJsapiTokenJsonRequest();
        oapiGetJsapiTokenJsonRequest.setAccessToken(accessToken);
        OapiGetJsapiTokenJsonResponse apiResult = (OapiGetJsapiTokenJsonResponse)intelligentGetClient.get((OapiRequest)oapiGetJsapiTokenJsonRequest);
        this.logger.debug("get_jsapi_token.json: BizErrorCode\uff1a {}\uff0cCode\uff1a{}\uff0cMessage\uff1a{}", new Object[]{apiResult.getBizErrorCode(), apiResult.getCode(), apiResult.getMessage()});
        if (!apiResult.getSuccess().booleanValue()) {
            this.logger.error("get_jsapi_token.json: \u83b7\u53d6\u5931\u8d25: BizErrorCode={}, Code={}, Message={}", new Object[]{apiResult.getBizErrorCode(), apiResult.getCode(), apiResult.getMessage()});
            return ResponseData.fail((String)apiResult.getMessage());
        }
        OapiSpResultContent content = apiResult.getContent();
        if (content == null) {
            this.logger.error("get_jsapi_token.json: \u83b7\u53d6\u5185\u5bb9\u4e3a\u7a7a");
            return ResponseData.fail((String)"\u767b\u5f55\u5931\u8d25");
        }
        this.logger.debug("get_jsapi_token.json: Content\uff1a{}", (Object)JSONObject.toJSONString((Object)content, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        if (content.getData() == null) {
            return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)JSONObject.toJSONString((Object)content, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        }
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)content.getData());
    }

    @BigLog(userRole=UserRoleEnum.GOVERNMENT_STAFF_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module4)
    @Log(title="\u4e61\u9547\u534f\u7ba1\uff1a\u6d59\u653f\u9489\u5355\u70b9\u767b\u5f55", type=11, module=LogConstans.TOWNSHIP)
    @PostMapping(value={"/loginByAuthCode"})
    public ResponseData<LoginData> loginByAuthCode(@NotNull String auth_code) {
        String accessToken = this.access_token();
        if (accessToken == null) {
            return ResponseData.fail((String)"\u7f51\u7edc\u7e41\u5fd9\uff0c\u5efa\u8bae\u60a8\u91cd\u8bd5");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)accessToken);
        Long accountId = this.dingtalk_app_user(accessToken = jsonObject.getString("accessToken"), auth_code);
        if (accountId == null) {
            return ResponseData.fail((String)"\u7f51\u7edc\u7e41\u5fd9\uff0c\u5efa\u8bae\u60a8\u91cd\u8bd5\uff01");
        }
        CasToken casToken = new CasToken(accountId);
        LoginData result = this.loginService.loginByCas(casToken);
        return ResponseData.success((Object)result);
    }

    private String access_token() {
        if (Boolean.TRUE.equals(this.stringRedisTemplate.hasKey((Object)access_token))) {
            return (String)this.stringRedisTemplate.opsForValue().get((Object)access_token);
        }
        IntelligentGetClient intelligentGetClient = this.executableClient.newIntelligentGetClient("/gettoken.json");
        OapiGettokenJsonRequest oapiGettokenJsonRequest = new OapiGettokenJsonRequest();
        oapiGettokenJsonRequest.setAppkey(this.zwddProperties.getAccesskey());
        oapiGettokenJsonRequest.setAppsecret(this.zwddProperties.getSecretkey());
        OapiGettokenJsonResponse apiResult = (OapiGettokenJsonResponse)intelligentGetClient.get((OapiRequest)oapiGettokenJsonRequest);
        this.logger.debug("gettoken.json: BizErrorCode\uff1a{}\uff0cCode\uff1a{}\uff0cMessage\uff1a{}", new Object[]{apiResult.getBizErrorCode(), apiResult.getCode(), apiResult.getMessage()});
        if (!apiResult.getSuccess().booleanValue()) {
            this.logger.error("gettoken.json: \u83b7\u53d6access_token\u5931\u8d25: BizErrorCode={}, Code={}, Message={}", new Object[]{apiResult.getBizErrorCode(), apiResult.getCode(), apiResult.getMessage()});
            return null;
        }
        OapiSpResultContent content = apiResult.getContent();
        if (content == null || content.getData() == null) {
            this.logger.error("gettoken.json: \u83b7\u53d6access_token\u5185\u5bb9\u4e3a\u7a7a");
            return null;
        }
        this.logger.debug("gettoken: Content\uff1a{}", (Object)JSONObject.toJSONString((Object)content, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        this.stringRedisTemplate.opsForValue().set((Object)access_token, (Object)content.getData(), 3600L, TimeUnit.SECONDS);
        return content.getData();
    }

    public Long dingtalk_app_user(String access_token, String auth_code) {
        this.logger.debug("dingtalk_app_user: access_token:{}-auth_code:{}", (Object)access_token, (Object)auth_code);
        IntelligentPostClient intelligentPostClient = this.executableClient.newIntelligentPostClient("/rpc/oauth2/dingtalk_app_user.json");
        OapiRpcOauth2DingtalkAppUserJsonRequest oapiRpcOauth2DingtalkAppUserJsonRequest = new OapiRpcOauth2DingtalkAppUserJsonRequest();
        oapiRpcOauth2DingtalkAppUserJsonRequest.setAccess_token(access_token);
        oapiRpcOauth2DingtalkAppUserJsonRequest.setAuth_code(auth_code);
        OapiRpcOauth2DingtalkAppUserJsonResponse apiResult = (OapiRpcOauth2DingtalkAppUserJsonResponse)intelligentPostClient.post((OapiRequest)oapiRpcOauth2DingtalkAppUserJsonRequest);
        this.logger.debug("dingtalk_app_user\uff1aSuccess:{}\uff0cMessage:{}", (Object)apiResult.getSuccess(), (Object)apiResult.getMessage());
        this.logger.debug("dingtalk_app_user\uff1aContent:{}", (Object)apiResult.getContent());
        JSONObject jsonObject = JSONObject.parseObject((String)apiResult.getContent());
        String content = (String)jsonObject.getObject("content", String.class, new JSONReader.Feature[0]);
        JSONObject dataObject = JSONObject.parseObject((String)content);
        if (!((Boolean)dataObject.getObject("success", Boolean.class, new JSONReader.Feature[0])).booleanValue()) {
            return null;
        }
        String data = (String)dataObject.getObject("data", String.class, new JSONReader.Feature[0]);
        this.logger.debug("dingtalk_app_user\uff1adata:{}", (Object)data);
        return (Long)JSONObject.parseObject((String)data).getObject("accountId", Long.class, new JSONReader.Feature[0]);
    }

    @PostMapping(value={"/gettoken"})
    @Deprecated
    public ResponseData<String> gettoken() {
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)this.access_token());
    }

    @PostMapping(value={"/dingtalk_app_user"})
    @Deprecated
    public ResponseData<Long> dingtalk_app_user_old(String access_token, String auth_code) {
        this.logger.debug("dingtalk_app_user: access_token:{}-auth_code:{}", (Object)access_token, (Object)auth_code);
        IntelligentPostClient intelligentPostClient = this.executableClient.newIntelligentPostClient("/rpc/oauth2/dingtalk_app_user.json");
        OapiRpcOauth2DingtalkAppUserJsonRequest oapiRpcOauth2DingtalkAppUserJsonRequest = new OapiRpcOauth2DingtalkAppUserJsonRequest();
        oapiRpcOauth2DingtalkAppUserJsonRequest.setAccess_token(access_token);
        oapiRpcOauth2DingtalkAppUserJsonRequest.setAuth_code(auth_code);
        OapiRpcOauth2DingtalkAppUserJsonResponse apiResult = (OapiRpcOauth2DingtalkAppUserJsonResponse)intelligentPostClient.post((OapiRequest)oapiRpcOauth2DingtalkAppUserJsonRequest);
        this.logger.debug("dingtalk_app_user\uff1aSuccess:{}", (Object)apiResult.getSuccess());
        this.logger.debug("dingtalk_app_user\uff1aMessage:{}", (Object)apiResult.getMessage());
        this.logger.debug("dingtalk_app_user\uff1aContent:{}", (Object)apiResult.getContent());
        JSONObject jsonObject = JSONObject.parseObject((String)apiResult.getContent());
        String content = (String)jsonObject.getObject("content", String.class, new JSONReader.Feature[0]);
        JSONObject dataObject = JSONObject.parseObject((String)content);
        if (!((Boolean)dataObject.getObject("success", Boolean.class, new JSONReader.Feature[0])).booleanValue()) {
            return ResponseData.fail((String)"\u83b7\u53d6access_token\u5931\u8d25\uff01");
        }
        String data = (String)dataObject.getObject("data", String.class, new JSONReader.Feature[0]);
        this.logger.debug("dingtalk_app_user\uff1adata:{}", (Object)data);
        Long accountId = (Long)JSONObject.parseObject((String)data).getObject("accountId", Long.class, new JSONReader.Feature[0]);
        return ResponseData.success((Object)accountId);
    }

    @BigLog(userRole=UserRoleEnum.GOVERNMENT_STAFF_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module4)
    @Log(title="\u4e61\u9547\u534f\u7ba1\uff1a\u6d59\u653f\u9489\u5355\u70b9\u767b\u5f55", type=11)
    @PostMapping(value={"/login"})
    @Deprecated
    public ResponseData<LoginData> loginByZwdd(@NotNull Long accountId) {
        CasToken casToken = new CasToken(accountId);
        LoginData result = this.loginService.loginByCas(casToken);
        this.sysUserService.bindAccountId(result.getUser().getUserId(), accountId);
        return ResponseData.success((Object)result);
    }

    @Deprecated
    @PostMapping(value={"/isExistsAccountId"})
    public ResponseData<Integer> isExistsAccountId(@NotNull Long accountId) {
        return ResponseData.success((Object)(this.sysUserService.isExistsAccountId(accountId) ? 1 : 0));
    }

    @PostMapping(value={"/bindAccountId"})
    @Deprecated
    public ResponseData<String> bindAccountId(@NotNull Long accountId) {
        Long userId = JwtUtil.getUserId();
        if (userId == null) {
            return ResponseData.fail((String)"token\u4e3a\u7a7a\uff01");
        }
        this.logger.debug("\u7ed1\u5b9aaccountId\uff1auserId:{}-accountId:{}", (Object)userId, (Object)accountId);
        this.sysUserService.bindAccountId(userId, accountId);
        return ResponseData.success();
    }

    @PostMapping(value={"/get_by_mobiles"})
    @Deprecated
    public ResponseData<Long> get_by_mobiles(@NotNull String tel) {
        Long userId = JwtUtil.getUserId();
        if (userId == null) {
            return ResponseData.fail((String)"token\u4e3a\u7a7a\uff01");
        }
        IntelligentGetClient intelligentGetClient = this.executableClient.newIntelligentGetClient("/mozi/employee/get_by_mobile");
        OapiMoziEmployeeGetByMobileRequest oapiMoziEmployeeGetByMobileRequest = new OapiMoziEmployeeGetByMobileRequest();
        oapiMoziEmployeeGetByMobileRequest.setAreaCode("86");
        oapiMoziEmployeeGetByMobileRequest.setTenantId(this.zwddProperties.getTenantId());
        oapiMoziEmployeeGetByMobileRequest.setNamespace("local");
        oapiMoziEmployeeGetByMobileRequest.setMobile(tel);
        OapiMoziEmployeeGetByMobileResponse apiResult = (OapiMoziEmployeeGetByMobileResponse)intelligentGetClient.get((OapiRequest)oapiMoziEmployeeGetByMobileRequest);
        OapiSpResultContent content = apiResult.getContent();
        this.logger.debug("get_by_mobile:tel\uff1a{}-result\uff1a{}-code\uff1a{}-message\uff1a{}", new Object[]{tel, apiResult.getSuccess(), apiResult.getCode(), apiResult.getMessage()});
        this.logger.debug("get_by_mobile-data:tel\uff1a{}-code\uff1a{}-message\uff1a{}", new Object[]{tel, content.getResponseCode(), content.getResponseMessage()});
        this.logger.debug("get_by_mobile-data:tel\uff1a{}-data-{}", (Object)tel, (Object)content.getData());
        if (!content.getSuccess().booleanValue()) {
            return ResponseData.fail((String)"\u83b7\u53d6\u6d59\u653f\u9489accoundId\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        this.logger.debug("data:{}", (Object)content.getData());
        JSONObject dataObject = JSONObject.parseObject((String)content.getData());
        Long accountId = (Long)dataObject.getObject("accountId", Long.class, new JSONReader.Feature[0]);
        return ResponseData.success((Object)accountId);
    }

    @Generated
    public ZwddLoginController(ISysUserService sysUserService, LoginService loginService, ZwddProperties zwddProperties, ExecutableClient executableClient, StringRedisTemplate stringRedisTemplate) {
        this.sysUserService = sysUserService;
        this.loginService = loginService;
        this.zwddProperties = zwddProperties;
        this.executableClient = executableClient;
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

