/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.controller;

import cn.hutool.core.date.DateUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.modules.sys.model.DesensitizationShowClickRecordListParam;
import cn.smarthse.modules.sys.model.DesensitizationShowClickRecordParam;
import cn.smarthse.modules.sys.model.DesensitizationShowClickRecordVo;
import cn.smarthse.modules.sys.provider.IDesensitizationFieldProviderService;
import cn.smarthse.township.manage.bootstrap.security.ShiroUtil;
import com.github.pagehelper.PageInfo;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/sys/dsi"})
public class SysDesensitizationController
extends ControllerSupport {
    @DubboReference
    private IDesensitizationFieldProviderService desensitizationFieldProviderService;

    @ApiEncrypt(response=true)
    @PostMapping(value={"show"})
    public ResponseData<String> show(@NotBlank(message="code\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="code\u4e0d\u80fd\u4e3a\u7a7a") String code, @NotNull(message="id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="id\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        DesensitizationShowClickRecordParam param = new DesensitizationShowClickRecordParam();
        param.setSystemWideEnum(UserSystemWideEnum.ZLWQ);
        param.setCode(code);
        param.setOid(ShiroUtil.getUserInfo().getOid());
        param.setUserId(ShiroUtil.getLoginUserId());
        param.setUsername(ShiroUtil.getLoginUsername());
        param.setIpAddress(ServletUtils.getClientIP());
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)this.desensitizationFieldProviderService.executeQuery(id, param));
    }

    @PostMapping(value={"list"})
    public ResponseData<JqGridData<DesensitizationShowClickRecordVo>> list(@RequestBody @Validated DesensitizationShowClickRecordListParam param) {
        param.setSystemWide(UserSystemWideEnum.ZLWQ.getCode());
        if (Objects.nonNull(param.getBeginTime())) {
            param.setBeginTime((Date)DateUtil.beginOfDay((Date)param.getBeginTime()));
        }
        if (Objects.nonNull(param.getEndTime())) {
            param.setEndTime((Date)DateUtil.endOfDay((Date)param.getEndTime()));
        }
        PageInfo pageInfo = this.desensitizationFieldProviderService.selectRecordLogList(param);
        return ResponseData.success((Object)new JqGridData(pageInfo, (JqGridParam)param));
    }

    @Generated
    public SysDesensitizationController() {
    }
}

