/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.controller;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.annotation.LogConstans;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.township.manage.bootstrap.security.JwtUtil;
import cn.smarthse.township.manage.bootstrap.security.service.LoginService;
import cn.smarthse.township.manage.bootstrap.security.token.LoginData;
import cn.smarthse.township.manage.enums.sys.SysUserTypeEnum;
import cn.smarthse.township.manage.model.param.LoginByPasswordParam;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import jakarta.validation.constraints.NotBlank;
import lombok.Generated;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/login"})
@Validated
public class LoginController
extends ControllerSupport {
    private final LoginService loginService;

    @ApiEncrypt(request=true)
    @BigLog(userRole=UserRoleEnum.GOVERNMENT_STAFF_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module4)
    @Log(title="\u5bc6\u7801\u767b\u5f55", type=1, module=LogConstans.TOWNSHIP)
    @RequestLimit(maxCount=5, second=60, expression="#param.username")
    @PostMapping(value={"/password"})
    public ResponseData<LoginData> loginByPassword(@Validated @RequestBody LoginByPasswordParam param) {
        if (!this.loginService.checkVCode(param.getKey(), param.getVcode(), true)) {
            return ResponseData.fail((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        LoginData result = this.loginService.loginByPassword(param.getUsername(), param.getPassword(), SysUserTypeEnum.MANAGE.getValue());
        return ResponseData.success((Object)result);
    }

    @PostMapping(value={"/token/refresh"})
    public ResponseData<LoginData> tokenRefresh(@RequestParam String refreshToken) {
        return ResponseData.success((Object)this.loginService.tokenRefresh(refreshToken));
    }

    @PostMapping(value={"/sendVCode"})
    public ResponseData<String> sendVCode(@NotBlank(message="key\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="key\u4e0d\u80fd\u4e3a\u7a7a") String key) {
        return ResponseData.success((String)"\u6210\u529f", (Object)this.loginService.sendVCode(key));
    }

    @PostMapping(value={"/logout"})
    public ResponseData<String> logout() {
        this.loginService.logout(JwtUtil.getUserId());
        return ResponseData.success();
    }

    @Generated
    public LoginController(LoginService loginService) {
        this.loginService = loginService;
    }
}

