/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.bootstrap.security.service;

import cn.smarthse.township.manage.bootstrap.security.model.vo.LoginOrganizationUser;
import cn.smarthse.township.manage.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.township.manage.framework.Constant;
import cn.smarthse.township.manage.framework.RedisKey;
import cn.smarthse.township.manage.service.sys.ISysUserService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    private final ISysUserService userService;
    private final RedisTemplate<String, ShiroPrincipal> redisTemplate;

    public ShiroPrincipal getLoginUser(Long userId) {
        String loginUserKey = RedisKey.getLoginUserKey(userId);
        ShiroPrincipal principal = (ShiroPrincipal)this.redisTemplate.opsForValue().get((Object)RedisKey.getLoginUserKey(userId));
        if (principal == null) {
            principal = new ShiroPrincipal();
            LoginOrganizationUser user = this.userService.getUserById(userId);
            if (user == null) {
                throw new AuthenticationException("\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u6388\u6743\u5931\u8d25\uff01");
            }
            principal.setUser(user);
            this.redisTemplate.opsForValue().set((Object)loginUserKey, (Object)principal, Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
            return principal;
        }
        return principal;
    }

    public LoginOrganizationUser getByUsername(String username) {
        return this.userService.getUserByUsername(username);
    }

    public LoginOrganizationUser getByAccoundId(Long accoundId) {
        return this.userService.getByAccoundId(accoundId);
    }

    @Generated
    public TokenService(ISysUserService userService, RedisTemplate<String, ShiroPrincipal> redisTemplate) {
        this.userService = userService;
        this.redisTemplate = redisTemplate;
    }
}

