/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.bootstrap.security.service;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.LineCaptcha;
import cn.hutool.core.util.RandomUtil;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.township.manage.bootstrap.properties.JwtProperties;
import cn.smarthse.township.manage.bootstrap.security.JwtUtil;
import cn.smarthse.township.manage.bootstrap.security.ShiroUtil;
import cn.smarthse.township.manage.bootstrap.security.model.vo.LoginOrganizationUser;
import cn.smarthse.township.manage.bootstrap.security.token.CasToken;
import cn.smarthse.township.manage.bootstrap.security.token.LoginData;
import cn.smarthse.township.manage.bootstrap.security.token.PasswordToken;
import cn.smarthse.township.manage.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.township.manage.framework.Constant;
import cn.smarthse.township.manage.framework.RedisKey;
import cn.smarthse.township.manage.framework.utils.CommonsUtils;
import cn.smarthse.township.manage.service.sys.IEmailService;
import cn.smarthse.township.manage.service.sys.ISysUserService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class LoginService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginService.class);
    private final ISysUserService sysUserService;
    private final IEmailService emailService;
    private final StringRedisTemplate stringRedisTemplate;
    private final RedisTemplate<String, Object> redisTemplate;
    private final JwtProperties jwtProperties;

    private String generateVerificationCode() {
        return RandomUtil.randomNumbers((int)6);
    }

    public LoginData loginByPassword(String username, String password, Integer loginType) {
        try {
            Subject subject = SecurityUtils.getSubject();
            PasswordToken token = new PasswordToken(username, password, loginType);
            subject.login((AuthenticationToken)token);
            return this.returnLoginInitParam((ShiroPrincipal)subject.getPrincipal());
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        catch (IncorrectCredentialsException e) {
            throw new ServiceException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        catch (AuthenticationException e) {
            throw new ServiceException("\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u767b\u5f55\uff01");
        }
        catch (Exception e) {
            log.error("\u8d26\u53f7\u5bc6\u7801\u767b\u9646\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u7cfb\u7edf\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    public LoginData loginByCas(CasToken token) {
        try {
            Subject subject = SecurityUtils.getSubject();
            subject.login((AuthenticationToken)token);
            return this.returnLoginInitParam((ShiroPrincipal)subject.getPrincipal());
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        catch (IncorrectCredentialsException e) {
            throw new ServiceException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        catch (AuthenticationException e) {
            throw new ServiceException("\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u767b\u5f55\uff01");
        }
        catch (Exception e) {
            log.error("cas\u767b\u9646\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u7cfb\u7edf\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    private LoginData returnLoginInitParam(ShiroPrincipal principal) {
        Long userId = principal.getUserId();
        Integer userType = principal.getUser().getUserType();
        String username = principal.getUser().getUsername();
        String name = principal.getUser().getName();
        String ip = ServletUtils.getClientIP((HttpServletRequest)ServletUtils.getRequest(), (String[])new String[0]);
        String secret = this.jwtProperties.getSecret();
        String audience = this.jwtProperties.getAudience();
        String token = JwtUtil.createToken(username, userId, name, ip, secret, audience, Constant.TOKEN_EXPIRE_TIME);
        String refreshToken = JwtUtil.createToken(username, userId, userType, secret, audience, Constant.TOKEN_REFRESH_TIME);
        String redisKeyString = RedisKey.getLoginUserKey(userId);
        this.redisTemplate.opsForValue().set((Object)redisKeyString, (Object)principal, Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
        ShiroPrincipal principalDesensitization = ShiroUtil.getShiroPrincipalDesensitization(principal);
        return new LoginData(principalDesensitization, token, refreshToken);
    }

    public LoginData tokenRefresh(String refreshToken) {
        Long userId = JwtUtil.getUserId(refreshToken);
        String ip = ServletUtils.getRequest().getRemoteAddr();
        if (userId == null) {
            throw new ServiceException("refreshToken\u65e0\u6548\uff01");
        }
        LoginOrganizationUser user = this.sysUserService.getUserById(userId);
        if (user == null) {
            throw new ServiceException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff0ctoken\u5237\u65b0\u5931\u8d25\uff01");
        }
        String secret = this.jwtProperties.getSecret();
        String audience = this.jwtProperties.getAudience();
        if (!JwtUtil.verify(refreshToken, secret)) {
            throw new ServiceException("token\u5237\u65b0\u5931\u8d25\uff01");
        }
        String newToken = JwtUtil.createToken(user.getUsername(), user.getId(), user.getName(), ip, secret, audience, Constant.TOKEN_EXPIRE_TIME);
        String newRefreshToken = JwtUtil.createToken(user.getUsername(), user.getId(), user.getUserType(), secret, audience, Constant.TOKEN_REFRESH_TIME);
        return new LoginData(newToken, newRefreshToken);
    }

    @Deprecated
    private String getTokenSecret(LoginOrganizationUser user) {
        String secretKey = RedisKey.getTokenSecret(user.getId());
        String secret = (String)this.stringRedisTemplate.opsForValue().get((Object)secretKey);
        if (secret == null) {
            this.stringRedisTemplate.opsForValue().set((Object)secretKey, (Object)user.getPassword(), (long)Constant.TOKEN_SECRET_EXPIRE_TIME.intValue(), TimeUnit.DAYS);
            return user.getPassword();
        }
        return secret;
    }

    public boolean sendEmailCode(String email) {
        String code = this.generateVerificationCode();
        String text = String.format("\u3010\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf-\u4e61\u9547\u534f\u7ba1\u3011\u60a8\u7684\u9a8c\u8bc1\u7801\uff1a%s\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210\u9a8c\u8bc1\u3002\u5982\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u5ffd\u7565\u30025\u5206\u949f\u5185\u6709\u6548\uff01", code);
        this.emailService.sendVcodeEmail(email, text);
        String encryptCode = CommonsUtils.encryptPassword(code, email);
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getEmailCodeKey(email), (Object)encryptCode, (long)Constant.CODE_EXPIRE_TIME.intValue(), TimeUnit.MINUTES);
        return true;
    }

    public String sendVCode(String key) {
        LineCaptcha specCaptcha = CaptchaUtil.createLineCaptcha((int)130, (int)48, (int)4, (int)0);
        String code = specCaptcha.getCode().toLowerCase();
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getVCodeKey(key), (Object)code, (long)Constant.CODE_EXPIRE_TIME.intValue(), TimeUnit.MINUTES);
        return specCaptcha.getImageBase64Data();
    }

    public boolean checkEmailCode(String email, String code) {
        Object modifyCode = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getEmailCodeKey(email));
        if (Objects.isNull(modifyCode)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        String encryptCode = CommonsUtils.encryptPassword(String.valueOf(code), email);
        return Objects.equals(encryptCode, modifyCode.toString());
    }

    public boolean checkVCode(String key, String vcode, boolean isDelete) {
        Object vCodeCache = null;
        if (isDelete) {
            vCodeCache = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getVCodeKey(key));
            this.stringRedisTemplate.delete((Object)RedisKey.getVCodeKey(key));
        } else {
            vCodeCache = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getVCodeKey(key));
        }
        if (Objects.isNull(vCodeCache)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        return vcode != null && vcode.equalsIgnoreCase(vCodeCache.toString());
    }

    public void logout(Long userId) {
        this.redisTemplate.delete((Object)RedisKey.getLoginUserKey(userId));
        this.redisTemplate.delete((Object)RedisKey.getTokenSecret(userId));
        this.redisTemplate.delete((Object)RedisKey.getForbiddenKey(userId));
    }

    @Generated
    public LoginService(ISysUserService sysUserService, IEmailService emailService, StringRedisTemplate stringRedisTemplate, RedisTemplate<String, Object> redisTemplate, JwtProperties jwtProperties) {
        this.sysUserService = sysUserService;
        this.emailService = emailService;
        this.stringRedisTemplate = stringRedisTemplate;
        this.redisTemplate = redisTemplate;
        this.jwtProperties = jwtProperties;
    }
}

