/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.bootstrap.security.realms;

import cn.smarthse.township.manage.bootstrap.security.model.vo.LoginOrganizationUser;
import cn.smarthse.township.manage.bootstrap.security.service.TokenService;
import cn.smarthse.township.manage.bootstrap.security.token.CasToken;
import cn.smarthse.township.manage.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.township.manage.framework.Constant;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;

public class CasRealm
extends AuthorizingRealm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CasRealm.class);
    @Autowired
    @Lazy
    private TokenService tokenService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof CasToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        CasToken token = (CasToken)authenticationToken;
        log.info("{} - cas auth start...", (Object)token.getAccountId());
        LoginOrganizationUser user = this.tokenService.getByAccoundId(token.getAccountId());
        if (user == null) {
            throw new ServiceException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01\uff01");
        }
        if (user.getIsForbidden() == Constant.YES) {
            throw new DisabledAccountException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        if (user.getRole() == null) {
            throw new ServiceException("\u60a8\u6240\u5728\u533a\u57df\u6682\u672a\u5f00\u653e\u4e61\u9547\u534f\u7ba1\u5de1\u67e5\u7cfb\u7edf\uff01");
        }
        List roleList = Arrays.stream(user.getRole().split(",")).map(Long::parseLong).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(roleList) || !roleList.contains(16L)) {
            throw new ServiceException("\u60a8\u6240\u5728\u533a\u57df\u6682\u672a\u5f00\u653e\u4e61\u9547\u534f\u7ba1\u5de1\u67e5\u7cfb\u7edf\uff01");
        }
        user = this.tokenService.getByUsername(user.getUsername());
        String realmName = super.getName();
        return new SimpleAuthenticationInfo((Object)new ShiroPrincipal(user), (Object)"", realmName);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }
}

