/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.bootstrap.security;

import cn.hutool.json.JSONUtil;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.township.manage.bootstrap.security.model.vo.LoginOrganizationUser;
import cn.smarthse.township.manage.bootstrap.security.token.ShiroPrincipal;
import java.util.Set;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class ShiroUtil {
    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static ShiroPrincipal getShiroPrincipal() {
        Subject subject = ShiroUtil.getSubject();
        return (ShiroPrincipal)subject.getPrincipal();
    }

    public static ShiroPrincipal getShiroPrincipalDesensitization(ShiroPrincipal principal) {
        ShiroPrincipal principalDesensitization = (ShiroPrincipal)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)principal), ShiroPrincipal.class);
        principal.getUser().setUsername(DesensitizationUtils.desensitized((CharSequence)principal.getUser().getUsername(), (DesensitizationType)DesensitizationType.NAME));
        principal.getUser().setPassword(DesensitizationUtils.desensitized((CharSequence)principal.getUser().getPassword(), (DesensitizationType)DesensitizationType.PASSWORD));
        principal.getUser().setSalt(DesensitizationUtils.desensitized((CharSequence)principal.getUser().getSalt(), (DesensitizationType)DesensitizationType.CLEAR_TO_NULL));
        principal.getUser().setTel(DesensitizationUtils.desensitized((CharSequence)principal.getUser().getTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
        return principalDesensitization;
    }

    public static LoginOrganizationUser getUserInfo() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        if (principal != null) {
            return principal.getUser();
        }
        return null;
    }

    public static Long getAreaId() {
        LoginOrganizationUser user = ShiroUtil.getUserInfo();
        return user != null ? user.getAreaId() : null;
    }

    public static Long getLoginUserId() {
        LoginOrganizationUser user = ShiroUtil.getUserInfo();
        return user != null ? user.getId() : null;
    }

    public static String getLoginUsername() {
        LoginOrganizationUser user = ShiroUtil.getUserInfo();
        return user != null ? user.getUsername() : null;
    }

    public static String getLoginUserNickname() {
        LoginOrganizationUser user = ShiroUtil.getUserInfo();
        return user != null ? user.getName() : null;
    }

    public static Set<String> getPermissionSet() {
        return ShiroUtil.getShiroPrincipal().getPermissionsSet();
    }

    public static Set<String> getRoleSet() {
        return ShiroUtil.getShiroPrincipal().getRoleSet();
    }

    public static boolean hasPermission(String permissionCode) {
        return ShiroUtil.getPermissionSet().contains(permissionCode);
    }

    public static boolean hasRole(String roleCode) {
        return ShiroUtil.getRoleSet().contains(roleCode);
    }

    public static boolean isSuperAdmin() {
        return ShiroUtil.getShiroPrincipal().getRoleSet().contains("superadmin");
    }
}

