/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.bootstrap.security;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.township.manage.framework.Constant;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    private static String audience;

    public static String[] getAudience(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            List stringList = jwt.getAudience();
            return stringList.toArray(new String[stringList.size()]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getUsername() {
        try {
            DecodedJWT jwt = JWT.decode((String)JwtUtil.getToken());
            return jwt.getClaim("username").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getUsername(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("username").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getUserId(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("userId").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getUserId() {
        try {
            DecodedJWT jwt = JWT.decode((String)JwtUtil.getToken());
            return jwt.getClaim("userId").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getName(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("name").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getIP(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("ip").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getToken() {
        HttpServletRequest request = ServletUtils.getRequest();
        String token = request.getHeader(Constant.TOKEN_HEADER_NAME);
        if (StrUtil.isBlank((CharSequence)token)) {
            return request.getParameter(Constant.TOKEN_HEADER_NAME);
        }
        return token;
    }

    public static String getToken(HttpServletRequest request) {
        String token = request.getHeader(Constant.TOKEN_HEADER_NAME);
        if (StrUtil.isBlank((CharSequence)token)) {
            return request.getParameter(Constant.TOKEN_HEADER_NAME);
        }
        return token;
    }

    public static String createToken(String username, Long userId, Integer userType, String secret, String audience, Long time) {
        Date date = new Date(System.currentTimeMillis() + time);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim("userType", userType).withClaim("username", username).withClaim("userId", userId).withAudience(new String[]{audience}).withExpiresAt(date).sign(algorithm);
    }

    public static String createToken(String username, Long userId, String name, String ip, String secret, String audience, Long time) {
        Date date = new Date(System.currentTimeMillis() + time);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim("username", username).withClaim("userId", userId).withClaim("name", name).withClaim("ip", ip).withAudience(new String[]{audience}).withExpiresAt(date).sign(algorithm);
    }

    public static boolean verify(String token, String secret) {
        if (StringUtils.isBlank((CharSequence)secret)) {
            return false;
        }
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("username", JwtUtil.getUsername(token)).withClaim("userId", JwtUtil.getUserId(token)).withAudience(new String[]{audience}).build();
            verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static boolean verifyWithIp(String token, String secret, String currentIp) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("username", JwtUtil.getUsername(token)).withClaim("userId", JwtUtil.getUserId(token)).withClaim("ip", JwtUtil.getIP(token)).build();
            verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException exception) {
            return false;
        }
    }

    @Value(value="${jwt.audience}")
    public void setAudience(String audience) {
        System.out.println("\u6b63\u5728\u6ce8\u5165audience: " + audience);
        JwtUtil.audience = audience;
    }

    public static boolean verifyIp(String token, String remoteAddr) {
        String ip = JwtUtil.getIP(token);
        if (StringUtils.isBlank((CharSequence)remoteAddr) || StringUtils.isBlank((CharSequence)ip)) {
            return true;
        }
        return remoteAddr.equalsIgnoreCase(ip);
    }

    public static Boolean isTokenExpired(String token) {
        Date expiration = JwtUtil.getExpirationDateFromToken(token);
        return expiration == null || expiration.before(new Date());
    }

    private static Date getExpirationDateFromToken(String token) {
        try {
            return ((Claim)JWT.decode((String)token).getClaims().get("exp")).asDate();
        }
        catch (JWTDecodeException e) {
            return null;
        }
    }
}

